/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class AddOpImage
extends PointOpImage {
    private int s1bd = 1;
    private int s2bd = 1;
    private boolean areBinarySampleModels = false;

    public AddOpImage(RenderedImage source1, RenderedImage source2, Map config, ImageLayout layout) {
        super(source1, source2, layout, config, true);
        if (ImageUtil.isBinary(this.getSampleModel()) && ImageUtil.isBinary(source1.getSampleModel()) && ImageUtil.isBinary(source2.getSampleModel())) {
            this.areBinarySampleModels = true;
        } else {
            SampleModel sm;
            int numBandsDst;
            int numBands1 = source1.getSampleModel().getNumBands();
            int numBands2 = source2.getSampleModel().getNumBands();
            if (layout != null && layout.isValid(256) && (numBandsDst = (sm = layout.getSampleModel(null)).getNumBands()) > 1 && (numBands1 == 1 && numBands2 > 1 || numBands2 == 1 && numBands1 > 1)) {
                numBandsDst = Math.min(Math.max(numBands1, numBands2), numBandsDst);
                if (numBandsDst != this.sampleModel.getNumBands()) {
                    this.sampleModel = RasterFactory.createComponentSampleModel(sm, this.sampleModel.getTransferType(), this.sampleModel.getWidth(), this.sampleModel.getHeight(), numBandsDst);
                    if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                        this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, config);
                    }
                }
                this.s1bd = numBands1 == 1 ? 0 : 1;
                this.s2bd = numBands2 == 1 ? 0 : 1;
            }
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterAccessor d2;
        RasterAccessor s2;
        RasterAccessor s1;
        RasterFormatTag[] formatTags;
        if (this.areBinarySampleModels) {
            formatTags = this.getFormatTags();
            s1 = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
            s2 = new RasterAccessor(sources[1], destRect, formatTags[1], this.getSourceImage(1).getColorModel());
            d2 = new RasterAccessor(dest, destRect, formatTags[2], this.getColorModel());
            if (d2.isBinary()) {
                byte[] src1Bits = s1.getBinaryDataArray();
                byte[] src2Bits = s2.getBinaryDataArray();
                byte[] dstBits = d2.getBinaryDataArray();
                int length = dstBits.length;
                for (int i = 0; i < length; ++i) {
                    dstBits[i] = (byte)(src1Bits[i] | src2Bits[i]);
                }
                d2.copyBinaryDataToRaster();
                return;
            }
        }
        formatTags = this.getFormatTags();
        s1 = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        s2 = new RasterAccessor(sources[1], destRect, formatTags[1], this.getSourceImage(1).getColorModel());
        d2 = new RasterAccessor(dest, destRect, formatTags[2], this.getColorModel());
        switch (d2.getDataType()) {
            case 0: {
                this.computeRectByte(s1, s2, d2);
                break;
            }
            case 1: {
                this.computeRectUShort(s1, s2, d2);
                break;
            }
            case 2: {
                this.computeRectShort(s1, s2, d2);
                break;
            }
            case 3: {
                this.computeRectInt(s1, s2, d2);
                break;
            }
            case 4: {
                this.computeRectFloat(s1, s2, d2);
                break;
            }
            case 5: {
                this.computeRectDouble(s1, s2, d2);
            }
        }
        if (d2.needsClamping()) {
            d2.clampDataArrays();
        }
        d2.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        byte[][] s1Data = src1.getByteDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        byte[][] s2Data = src2.getByteDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        byte[][] dData = dst.getByteDataArrays();
        int b2 = 0;
        int s1b = 0;
        int s2b = 0;
        while (b2 < bands) {
            byte[] s1 = s1Data[s1b];
            byte[] s2 = s2Data[s2b];
            byte[] d2 = dData[b2];
            int s1LineOffset = s1BandOffsets[s1b];
            int s2LineOffset = s2BandOffsets[s2b];
            int dLineOffset = dBandOffsets[b2];
            for (int h2 = 0; h2 < dheight; ++h2) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                int sum = 0;
                for (int w = 0; w < dwidth; ++w) {
                    sum = (s1[s1PixelOffset] & 0xFF) + (s2[s2PixelOffset] & 0xFF);
                    d2[dPixelOffset] = (byte)((sum << 23 >> 31 | sum) & 0xFF);
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
            ++b2;
            s1b += this.s1bd;
            s2b += this.s2bd;
        }
    }

    private void computeRectUShort(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        short[][] s1Data = src1.getShortDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        short[][] s2Data = src2.getShortDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        int b2 = 0;
        int s1b = 0;
        int s2b = 0;
        while (b2 < bands) {
            short[] s1 = s1Data[s1b];
            short[] s2 = s2Data[s2b];
            short[] d2 = dData[b2];
            int s1LineOffset = s1BandOffsets[s1b];
            int s2LineOffset = s2BandOffsets[s2b];
            int dLineOffset = dBandOffsets[b2];
            for (int h2 = 0; h2 < dheight; ++h2) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                for (int w = 0; w < dwidth; ++w) {
                    d2[dPixelOffset] = ImageUtil.clampUShortPositive((s1[s1PixelOffset] & 0xFFFF) + (s2[s2PixelOffset] & 0xFFFF));
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
            ++b2;
            s1b += this.s1bd;
            s2b += this.s2bd;
        }
    }

    private void computeRectShort(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        short[][] s1Data = src1.getShortDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        short[][] s2Data = src2.getShortDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        int b2 = 0;
        int s1b = 0;
        int s2b = 0;
        while (b2 < bands) {
            short[] s1 = s1Data[s1b];
            short[] s2 = s2Data[s2b];
            short[] d2 = dData[b2];
            int s1LineOffset = s1BandOffsets[s1b];
            int s2LineOffset = s2BandOffsets[s2b];
            int dLineOffset = dBandOffsets[b2];
            for (int h2 = 0; h2 < dheight; ++h2) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                for (int w = 0; w < dwidth; ++w) {
                    d2[dPixelOffset] = ImageUtil.clampShort(s1[s1PixelOffset] + s2[s2PixelOffset]);
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
            ++b2;
            s1b += this.s1bd;
            s2b += this.s2bd;
        }
    }

    private void computeRectInt(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        int[][] s1Data = src1.getIntDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        int[][] s2Data = src2.getIntDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        int[][] dData = dst.getIntDataArrays();
        switch (this.sampleModel.getTransferType()) {
            case 0: {
                int b2 = 0;
                int s1b = 0;
                int s2b = 0;
                while (b2 < bands) {
                    int[] s1 = s1Data[s1b];
                    int[] s2 = s2Data[s2b];
                    int[] d2 = dData[b2];
                    int s1LineOffset = s1BandOffsets[s1b];
                    int s2LineOffset = s2BandOffsets[s2b];
                    int dLineOffset = dBandOffsets[b2];
                    for (int h2 = 0; h2 < dheight; ++h2) {
                        int s1PixelOffset = s1LineOffset;
                        int s2PixelOffset = s2LineOffset;
                        int dPixelOffset = dLineOffset;
                        s1LineOffset += s1LineStride;
                        s2LineOffset += s2LineStride;
                        dLineOffset += dLineStride;
                        int sum = 0;
                        for (int w = 0; w < dwidth; ++w) {
                            sum = (s1[s1PixelOffset] & 0xFF) + (s2[s2PixelOffset] & 0xFF);
                            d2[dPixelOffset] = (sum << 23 >> 31 | sum) & 0xFF;
                            s1PixelOffset += s1PixelStride;
                            s2PixelOffset += s2PixelStride;
                            dPixelOffset += dPixelStride;
                        }
                    }
                    ++b2;
                    s1b += this.s1bd;
                    s2b += this.s2bd;
                }
                break;
            }
            case 1: {
                int b3 = 0;
                int s1b = 0;
                int s2b = 0;
                while (b3 < bands) {
                    int[] s1 = s1Data[s1b];
                    int[] s2 = s2Data[s2b];
                    int[] d3 = dData[b3];
                    int s1LineOffset = s1BandOffsets[s1b];
                    int s2LineOffset = s2BandOffsets[s2b];
                    int dLineOffset = dBandOffsets[b3];
                    for (int h3 = 0; h3 < dheight; ++h3) {
                        int s1PixelOffset = s1LineOffset;
                        int s2PixelOffset = s2LineOffset;
                        int dPixelOffset = dLineOffset;
                        s1LineOffset += s1LineStride;
                        s2LineOffset += s2LineStride;
                        dLineOffset += dLineStride;
                        for (int w = 0; w < dwidth; ++w) {
                            d3[dPixelOffset] = ImageUtil.clampUShortPositive((s1[s1PixelOffset] & 0xFFFF) + (s2[s2PixelOffset] & 0xFFFF));
                            s1PixelOffset += s1PixelStride;
                            s2PixelOffset += s2PixelStride;
                            dPixelOffset += dPixelStride;
                        }
                    }
                    ++b3;
                    s1b += this.s1bd;
                    s2b += this.s2bd;
                }
                break;
            }
            case 2: {
                int b4 = 0;
                int s1b = 0;
                int s2b = 0;
                while (b4 < bands) {
                    int[] s1 = s1Data[s1b];
                    int[] s2 = s2Data[s2b];
                    int[] d4 = dData[b4];
                    int s1LineOffset = s1BandOffsets[s1b];
                    int s2LineOffset = s2BandOffsets[s2b];
                    int dLineOffset = dBandOffsets[b4];
                    for (int h4 = 0; h4 < dheight; ++h4) {
                        int s1PixelOffset = s1LineOffset;
                        int s2PixelOffset = s2LineOffset;
                        int dPixelOffset = dLineOffset;
                        s1LineOffset += s1LineStride;
                        s2LineOffset += s2LineStride;
                        dLineOffset += dLineStride;
                        for (int w = 0; w < dwidth; ++w) {
                            d4[dPixelOffset] = ImageUtil.clampShort(s1[s1PixelOffset] + s2[s2PixelOffset]);
                            s1PixelOffset += s1PixelStride;
                            s2PixelOffset += s2PixelStride;
                            dPixelOffset += dPixelStride;
                        }
                    }
                    ++b4;
                    s1b += this.s1bd;
                    s2b += this.s2bd;
                }
                break;
            }
            case 3: {
                int b5 = 0;
                int s1b = 0;
                int s2b = 0;
                while (b5 < bands) {
                    int[] s1 = s1Data[s1b];
                    int[] s2 = s2Data[s2b];
                    int[] d5 = dData[b5];
                    int s1LineOffset = s1BandOffsets[s1b];
                    int s2LineOffset = s2BandOffsets[s2b];
                    int dLineOffset = dBandOffsets[b5];
                    for (int h5 = 0; h5 < dheight; ++h5) {
                        int s1PixelOffset = s1LineOffset;
                        int s2PixelOffset = s2LineOffset;
                        int dPixelOffset = dLineOffset;
                        s1LineOffset += s1LineStride;
                        s2LineOffset += s2LineStride;
                        dLineOffset += dLineStride;
                        for (int w = 0; w < dwidth; ++w) {
                            d5[dPixelOffset] = ImageUtil.clampInt((long)s1[s1PixelOffset] + (long)s2[s2PixelOffset]);
                            s1PixelOffset += s1PixelStride;
                            s2PixelOffset += s2PixelStride;
                            dPixelOffset += dPixelStride;
                        }
                    }
                    ++b5;
                    s1b += this.s1bd;
                    s2b += this.s2bd;
                }
                break;
            }
        }
    }

    private void computeRectFloat(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        float[][] s1Data = src1.getFloatDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        float[][] s2Data = src2.getFloatDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        float[][] dData = dst.getFloatDataArrays();
        int b2 = 0;
        int s1b = 0;
        int s2b = 0;
        while (b2 < bands) {
            float[] s1 = s1Data[s1b];
            float[] s2 = s2Data[s2b];
            float[] d2 = dData[b2];
            int s1LineOffset = s1BandOffsets[s1b];
            int s2LineOffset = s2BandOffsets[s2b];
            int dLineOffset = dBandOffsets[b2];
            for (int h2 = 0; h2 < dheight; ++h2) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                for (int w = 0; w < dwidth; ++w) {
                    d2[dPixelOffset] = s1[s1PixelOffset] + s2[s2PixelOffset];
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
            ++b2;
            s1b += this.s1bd;
            s2b += this.s2bd;
        }
    }

    private void computeRectDouble(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        double[][] s1Data = src1.getDoubleDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        double[][] s2Data = src2.getDoubleDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        double[][] dData = dst.getDoubleDataArrays();
        int b2 = 0;
        int s1b = 0;
        int s2b = 0;
        while (b2 < bands) {
            double[] s1 = s1Data[s1b];
            double[] s2 = s2Data[s2b];
            double[] d2 = dData[b2];
            int s1LineOffset = s1BandOffsets[s1b];
            int s2LineOffset = s2BandOffsets[s2b];
            int dLineOffset = dBandOffsets[b2];
            for (int h2 = 0; h2 < dheight; ++h2) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                for (int w = 0; w < dwidth; ++w) {
                    d2[dPixelOffset] = s1[s1PixelOffset] + s2[s2PixelOffset];
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
            ++b2;
            s1b += this.s1bd;
            s2b += this.s2bd;
        }
    }
}

