/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonMatcher;
import dk.brics.automaton.SpecialOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Set;

public class RunAutomaton
implements Serializable {
    static final long serialVersionUID = 20001L;
    int size;
    boolean[] accept;
    int initial;
    int[] transitions;
    char[] points;
    int[] classmap;

    final void setAlphabet() {
        this.classmap = new int[65536];
        int n = 0;
        for (char c2 = '\u0000'; c2 <= '\uffff'; ++c2) {
            if (n + 1 >= this.points.length || c2 == this.points[n + 1]) {
                // empty if block
            }
            this.classmap[c2] = ++n;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("initial state: ").append(this.initial).append("\n");
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append("state " + i);
            if (this.accept[i]) {
                stringBuilder.append(" [accept]:\n");
            } else {
                stringBuilder.append(" [reject]:\n");
            }
            for (int j = 0; j < this.points.length; ++j) {
                int n = this.transitions[i * this.points.length + j];
                if (n == -1) continue;
                char c2 = this.points[j];
                char c3 = j + 1 < this.points.length ? (char)((char)(this.points[j + 1] - '\u0001')) : (char)'\uffff';
                stringBuilder.append(" ");
                Transition.appendCharString(c2, stringBuilder);
                if (c2 != c3) {
                    stringBuilder.append("-");
                    Transition.appendCharString(c3, stringBuilder);
                }
                stringBuilder.append(" -> ").append(n).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public int getSize() {
        return this.size;
    }

    public boolean isAccept(int n) {
        return this.accept[n];
    }

    public int getInitialState() {
        return this.initial;
    }

    public char[] getCharIntervals() {
        return (char[])this.points.clone();
    }

    int getCharClass(char c2) {
        return SpecialOperations.findIndex(c2, this.points);
    }

    private RunAutomaton() {
    }

    public RunAutomaton(Automaton automaton) {
        this(automaton, true);
    }

    public static RunAutomaton load(URL uRL) throws IOException, OptionalDataException, ClassCastException, ClassNotFoundException, InvalidClassException {
        return RunAutomaton.load(uRL.openStream());
    }

    public static RunAutomaton load(InputStream inputStream) throws IOException, OptionalDataException, ClassCastException, ClassNotFoundException, InvalidClassException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        return (RunAutomaton)objectInputStream.readObject();
    }

    public void store(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
    }

    public RunAutomaton(Automaton automaton, boolean bl) {
        automaton.determinize();
        this.points = automaton.getStartPoints();
        Set<State> set = automaton.getStates();
        Automaton.setStateNumbers(set);
        this.initial = automaton.initial.number;
        this.size = set.size();
        this.accept = new boolean[this.size];
        this.transitions = new int[this.size * this.points.length];
        for (int i = 0; i < this.size * this.points.length; ++i) {
            this.transitions[i] = -1;
        }
        for (State state : set) {
            int n = state.number;
            this.accept[n] = state.accept;
            for (int i = 0; i < this.points.length; ++i) {
                State state2 = state.step(this.points[i]);
                if (state2 == null) continue;
                this.transitions[n * this.points.length + i] = state2.number;
            }
        }
        if (bl) {
            this.setAlphabet();
        }
    }

    public int step(int n, char c2) {
        if (this.classmap == null) {
            return this.transitions[n * this.points.length + this.getCharClass(c2)];
        }
        return this.transitions[n * this.points.length + this.classmap[c2 - '\u0000']];
    }

    public boolean run(String string) {
        int n = this.initial;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if ((n = this.step(n, string.charAt(i))) != -1) continue;
            return false;
        }
        return this.accept[n];
    }

    public int run(String string, int n) {
        int n2 = this.initial;
        int n3 = string.length();
        int n4 = -1;
        int n5 = 0;
        while (n <= n3) {
            if (this.accept[n2]) {
                n4 = n5;
            }
            if (n == n3 || (n2 = this.step(n2, string.charAt(n))) == -1) break;
            ++n;
            ++n5;
        }
        return n4;
    }

    public AutomatonMatcher newMatcher(CharSequence charSequence) {
        return new AutomatonMatcher(charSequence, this);
    }

    public AutomatonMatcher newMatcher(CharSequence charSequence, int n, int n2) {
        return new AutomatonMatcher(charSequence.subSequence(n, n2), this);
    }
}

