/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.buffer;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.strtree.STRtree;

public class BufferOpImage
extends AreaOpImage {
    public static final int TILE_EXTENDER = 1;
    public static final int USHORT_MAX_VALUE = 65535;
    public static final boolean TILE_CACHED = true;
    public static final boolean ARRAY_CALC = true;
    private final STRtree spatialIndex = new STRtree();
    private boolean hasROI;
    private List<ROI> rois;
    private Range noData;
    private final boolean hasNoData;
    private boolean setBackground;
    private boolean[] booleanLookupTable;
    private byte destinationNoDataByte;
    private short destinationNoDataShort;
    private int destinationNoDataInt;
    private float destinationNoDataFloat;
    private double destinationNoDataDouble;
    private byte valueToCountB;
    private short valueToCountS;
    private int valueToCountI;
    private float valueToCountF;
    private double valueToCountD;
    private boolean counter;
    private Rectangle union;
    private int kWidth;
    private int kHeight;
    private boolean skipCalculations;
    private final double pixelArea;

    public BufferOpImage(RenderedImage source, ImageLayout layout, Map configuration, BorderExtender extender, int leftPadding, int rightPadding, int topPadding, int bottomPadding, List<ROI> rois, Range noData, double destinationNoDataDouble, Double valueToCount, double pixelArea) {
        super(source, layout, configuration, true, extender, leftPadding, rightPadding, topPadding, bottomPadding);
        int rangeType;
        this.kWidth = leftPadding + rightPadding + 1;
        this.kHeight = topPadding + bottomPadding + 1;
        this.rois = rois;
        this.noData = noData;
        this.hasROI = rois != null && !rois.isEmpty();
        this.hasNoData = noData != null;
        this.pixelArea = pixelArea;
        this.counter = valueToCount != null;
        this.valueToCountD = this.counter ? valueToCount : 0.0;
        SampleModel sm = this.getSampleModel();
        int dstDataType = sm.getDataType();
        if (this.hasNoData && dstDataType != (rangeType = noData.getDataType().getDataType()) && rangeType != 4 && rangeType != 5) {
            throw new IllegalArgumentException("Input Range must have the same data type of the final image");
        }
        this.skipCalculations = false;
        switch (dstDataType) {
            case 0: {
                this.destinationNoDataByte = (byte)((byte)destinationNoDataDouble & 0xFF);
                if (this.hasNoData) {
                    this.booleanLookupTable = new boolean[256];
                    for (int i = 0; i < this.booleanLookupTable.length; ++i) {
                        byte value = (byte)i;
                        this.booleanLookupTable[i] = noData.contains(value);
                    }
                }
                if (!this.counter) break;
                this.valueToCountB = valueToCount.byteValue();
                if (noData.contains(this.valueToCountB)) break;
                this.skipCalculations = true;
                break;
            }
            case 1: {
                this.destinationNoDataShort = (short)((short)destinationNoDataDouble & 0xFFFF);
                if (!this.counter) break;
                this.valueToCountS = valueToCount.shortValue();
                if (noData.contains(this.valueToCountS)) break;
                this.skipCalculations = true;
                break;
            }
            case 2: {
                this.destinationNoDataShort = (short)destinationNoDataDouble;
                if (!this.counter) break;
                this.valueToCountS = valueToCount.shortValue();
                if (noData.contains(this.valueToCountS)) break;
                this.skipCalculations = true;
                break;
            }
            case 3: {
                this.destinationNoDataInt = (int)destinationNoDataDouble;
                if (!this.counter) break;
                this.valueToCountI = valueToCount.intValue();
                if (noData.contains(this.valueToCountI)) break;
                this.skipCalculations = true;
                break;
            }
            case 4: {
                this.destinationNoDataFloat = (float)destinationNoDataDouble;
                if (!this.counter) break;
                this.valueToCountF = valueToCount.floatValue();
                if (noData.contains(this.valueToCountF)) break;
                this.skipCalculations = true;
                break;
            }
            case 5: {
                this.destinationNoDataDouble = destinationNoDataDouble;
                if (!this.counter || noData.contains(this.valueToCountD)) break;
                this.skipCalculations = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data Type");
            }
        }
        if (rois == null || rois.isEmpty()) {
            this.rois = new ArrayList<ROI>();
            ROIShape roi = new ROIShape(this.getBounds());
            this.rois.add(roi);
            this.union = new Rectangle(this.getBounds());
            double minX = this.union.getMinX();
            double maxX = this.union.getMaxX();
            double minY = this.union.getMinY();
            double maxY = this.union.getMaxY();
            Envelope env = new Envelope(minX, maxX, minY, maxY);
            this.spatialIndex.insert(env, (Object)roi);
        } else {
            this.union = new Rectangle(rois.get(0).getBounds());
            for (ROI roi : rois) {
                Rectangle rect = roi.getBounds();
                double minX = rect.getMinX();
                double maxX = rect.getMaxX();
                double minY = rect.getMinY();
                double maxY = rect.getMaxY();
                Envelope env = new Envelope(minX, maxX, minY, maxY);
                this.union = this.union.union(rect);
                this.spatialIndex.insert(env, (Object)roi);
            }
            this.rois = rois;
        }
        Coordinate p1 = new Coordinate(0.0, 0.0);
        Envelope searchEnv = new Envelope(p1);
        this.spatialIndex.query(searchEnv);
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        if (!this.hasROI || this.union.intersects(destRect) && !this.skipCalculations) {
            switch (dstAccessor.getDataType()) {
                case 0: {
                    this.byteLoop(source, srcRect, srcAccessor, dstAccessor);
                    break;
                }
                case 3: {
                    this.intLoop(source, srcRect, srcAccessor, dstAccessor);
                    break;
                }
                case 2: {
                    this.shortLoop(source, srcRect, srcAccessor, dstAccessor);
                    break;
                }
                case 1: {
                    this.ushortLoop(source, srcRect, srcAccessor, dstAccessor);
                    break;
                }
                case 4: {
                    this.floatLoop(source, srcRect, srcAccessor, dstAccessor);
                    break;
                }
                case 5: {
                    this.doubleLoop(source, srcRect, srcAccessor, dstAccessor);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
            if (dstAccessor.isDataCopy()) {
                dstAccessor.clampDataArrays();
                dstAccessor.copyDataToRaster();
            }
        } else if (this.setBackground) {
            int numBands = this.getNumBands();
            double[] background = new double[numBands];
            for (int i = 0; i < numBands; ++i) {
                background[i] = this.destinationNoDataDouble;
            }
            ImageUtil.fillBackground(dest, destRect, background);
        }
    }

    private void byteLoop(Raster ras, Rectangle srcRect, RasterAccessor src, RasterAccessor dst) {
        RandomIter iter = RandomIterFactory.create(ras, srcRect, true, true);
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        int dstX = dst.getX();
        int dstY = dst.getY();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int dstScanlineOffset = 0;
        if (this.hasNoData) {
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstScanlineOffset;
                int y0 = dstY + j;
                for (int i = 0; i < dwidth; ++i) {
                    byte[] dstData;
                    int k;
                    int x0 = dstX + i;
                    if (this.hasROI && !this.union.contains(x0, y0)) {
                        for (int k2 = 0; k2 < dnumBands; ++k2) {
                            byte[] dstData2 = dstDataArrays[k2];
                            dstData2[dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    boolean contains = true;
                    if (this.hasROI) {
                        contains = this.checkInROI(y0, x0);
                    }
                    if (!contains) {
                        for (k = 0; k < dnumBands; ++k) {
                            dstData = dstDataArrays[k];
                            dstData[dstPixelOffset + dstBandOffsets[k]] = this.destinationNoDataByte;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (k = 0; k < dnumBands; ++k) {
                        int data;
                        int v;
                        int u;
                        dstData = dstDataArrays[k];
                        int value = 0;
                        boolean isValidData = false;
                        int xStart = x0 - this.leftPadding;
                        int yStart = y0 - this.topPadding;
                        if (this.counter) {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSample(xStart + v, yStart + u, k) & 0xFF;
                                    byte dataB = (byte)data;
                                    if (!this.booleanLookupTable[data] || dataB != this.valueToCountB) continue;
                                    ++value;
                                    isValidData = this.booleanLookupTable[data];
                                }
                            }
                        } else {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSample(xStart + v, yStart + u, k) & 0xFF;
                                    if (!this.booleanLookupTable[data]) continue;
                                    value += data;
                                    isValidData = this.booleanLookupTable[data];
                                }
                            }
                        }
                        if ((value = (int)((double)value * this.pixelArea)) < 0) {
                            value = 0;
                        } else if (value > 255) {
                            value = 255;
                        } else if (!isValidData) {
                            value = this.destinationNoDataByte;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = (byte)value;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstScanlineOffset;
                int y0 = dstY + j;
                for (int i = 0; i < dwidth; ++i) {
                    byte[] dstData;
                    int k;
                    int x0 = dstX + i;
                    if (this.hasROI && !this.union.contains(x0, y0)) {
                        for (int k3 = 0; k3 < dnumBands; ++k3) {
                            byte[] dstData3 = dstDataArrays[k3];
                            dstData3[dstPixelOffset + dstBandOffsets[k3]] = this.destinationNoDataByte;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    boolean contains = true;
                    if (this.hasROI) {
                        contains = this.checkInROI(y0, x0);
                    }
                    if (!contains) {
                        for (k = 0; k < dnumBands; ++k) {
                            dstData = dstDataArrays[k];
                            dstData[dstPixelOffset + dstBandOffsets[k]] = this.destinationNoDataByte;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (k = 0; k < dnumBands; ++k) {
                        int data;
                        int v;
                        int u;
                        dstData = dstDataArrays[k];
                        int value = 0;
                        int xStart = x0 - this.leftPadding;
                        int yStart = y0 - this.topPadding;
                        if (this.counter) {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = (byte)(iter.getSample(xStart + v, yStart + u, k) & 0xFF);
                                    if (data != this.valueToCountB) continue;
                                    ++value;
                                }
                            }
                        } else {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSample(xStart + v, yStart + u, k) & 0xFF;
                                    value += data;
                                }
                            }
                        }
                        if ((value = (int)((double)value * this.pixelArea)) < 0) {
                            value = 0;
                        } else if (value > 255) {
                            value = 255;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = (byte)value;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    private void ushortLoop(Raster ras, Rectangle srcRect, RasterAccessor src, RasterAccessor dst) {
        RandomIter iter = RandomIterFactory.create(ras, srcRect, true, true);
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        int dstX = dst.getX();
        int dstY = dst.getY();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int dstScanlineOffset = 0;
        if (this.hasNoData) {
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstScanlineOffset;
                int y0 = dstY + j;
                for (int i = 0; i < dwidth; ++i) {
                    short[] dstData;
                    int k;
                    int x0 = dstX + i;
                    if (this.hasROI && !this.union.contains(x0, y0)) {
                        for (int k2 = 0; k2 < dnumBands; ++k2) {
                            short[] dstData2 = dstDataArrays[k2];
                            dstData2[dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    boolean contains = true;
                    if (this.hasROI) {
                        contains = this.checkInROI(y0, x0);
                    }
                    if (!contains) {
                        for (k = 0; k < dnumBands; ++k) {
                            dstData = dstDataArrays[k];
                            dstData[dstPixelOffset + dstBandOffsets[k]] = this.destinationNoDataShort;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (k = 0; k < dnumBands; ++k) {
                        boolean valid;
                        short dataS;
                        int data;
                        int v;
                        int u;
                        dstData = dstDataArrays[k];
                        int value = 0;
                        boolean isValidData = false;
                        int xStart = x0 - this.leftPadding;
                        int yStart = y0 - this.topPadding;
                        if (this.counter) {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSample(xStart + v, yStart + u, k) & 0xFFFF;
                                    dataS = (short)data;
                                    boolean bl = valid = !this.noData.contains(dataS);
                                    if (!valid || dataS != this.valueToCountS) continue;
                                    ++value;
                                    isValidData = valid;
                                }
                            }
                        } else {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSample(xStart + v, yStart + u, k) & 0xFFFF;
                                    dataS = (short)data;
                                    boolean bl = valid = !this.noData.contains(dataS);
                                    if (!valid) continue;
                                    value += data;
                                    isValidData = valid;
                                }
                            }
                        }
                        if ((value = (int)((double)value * this.pixelArea)) < 0) {
                            value = 0;
                        } else if (value > 65535) {
                            value = 65535;
                        } else if (!isValidData) {
                            value = this.destinationNoDataShort;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = (short)value;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstScanlineOffset;
                int y0 = dstY + j;
                for (int i = 0; i < dwidth; ++i) {
                    short[] dstData;
                    int k;
                    int x0 = dstX + i;
                    if (this.hasROI && !this.union.contains(x0, y0)) {
                        for (int k3 = 0; k3 < dnumBands; ++k3) {
                            short[] dstData3 = dstDataArrays[k3];
                            dstData3[dstPixelOffset + dstBandOffsets[k3]] = this.destinationNoDataShort;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    boolean contains = true;
                    if (this.hasROI) {
                        contains = this.checkInROI(y0, x0);
                    }
                    if (!contains) {
                        for (k = 0; k < dnumBands; ++k) {
                            dstData = dstDataArrays[k];
                            dstData[dstPixelOffset + dstBandOffsets[k]] = this.destinationNoDataShort;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (k = 0; k < dnumBands; ++k) {
                        int data;
                        int v;
                        int u;
                        dstData = dstDataArrays[k];
                        int value = 0;
                        int xStart = x0 - this.leftPadding;
                        int yStart = y0 - this.topPadding;
                        if (this.counter) {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = (short)(iter.getSample(xStart + v, yStart + u, k) & 0xFFFF);
                                    if (data != this.valueToCountS) continue;
                                    ++value;
                                }
                            }
                        } else {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSample(xStart + v, yStart + u, k) & 0xFFFF;
                                    value += data;
                                }
                            }
                        }
                        if ((value = (int)((double)value * this.pixelArea)) < 0) {
                            value = 0;
                        } else if (value > 65535) {
                            value = 65535;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = (short)value;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    private void shortLoop(Raster ras, Rectangle srcRect, RasterAccessor src, RasterAccessor dst) {
        RandomIter iter = RandomIterFactory.create(ras, srcRect, true, true);
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        int dstX = dst.getX();
        int dstY = dst.getY();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int dstScanlineOffset = 0;
        if (this.hasNoData) {
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstScanlineOffset;
                int y0 = dstY + j;
                for (int i = 0; i < dwidth; ++i) {
                    short[] dstData;
                    int k;
                    int x0 = dstX + i;
                    if (this.hasROI && !this.union.contains(x0, y0)) {
                        for (int k2 = 0; k2 < dnumBands; ++k2) {
                            short[] dstData2 = dstDataArrays[k2];
                            dstData2[dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    boolean contains = true;
                    if (this.hasROI) {
                        contains = this.checkInROI(y0, x0);
                    }
                    if (!contains) {
                        for (k = 0; k < dnumBands; ++k) {
                            dstData = dstDataArrays[k];
                            dstData[dstPixelOffset + dstBandOffsets[k]] = this.destinationNoDataShort;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (k = 0; k < dnumBands; ++k) {
                        boolean valid;
                        short data;
                        int v;
                        int u;
                        dstData = dstDataArrays[k];
                        int value = 0;
                        boolean isValidData = false;
                        int xStart = x0 - this.leftPadding;
                        int yStart = y0 - this.topPadding;
                        if (this.counter) {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = (short)iter.getSample(xStart + v, yStart + u, k);
                                    boolean bl = valid = !this.noData.contains(data);
                                    if (!valid || data != this.valueToCountS) continue;
                                    ++value;
                                    isValidData = valid;
                                }
                            }
                        } else {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = (short)iter.getSample(xStart + v, yStart + u, k);
                                    boolean bl = valid = !this.noData.contains(data);
                                    if (!valid) continue;
                                    value += data;
                                    isValidData = valid;
                                }
                            }
                        }
                        if ((value = (int)((double)value * this.pixelArea)) < Short.MIN_VALUE) {
                            value = Short.MIN_VALUE;
                        } else if (value > Short.MAX_VALUE) {
                            value = Short.MAX_VALUE;
                        } else if (!isValidData) {
                            value = this.destinationNoDataShort;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = (short)value;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstScanlineOffset;
                int y0 = dstY + j;
                for (int i = 0; i < dwidth; ++i) {
                    short[] dstData;
                    int k;
                    int x0 = dstX + i;
                    if (this.hasROI && !this.union.contains(x0, y0)) {
                        for (int k3 = 0; k3 < dnumBands; ++k3) {
                            short[] dstData3 = dstDataArrays[k3];
                            dstData3[dstPixelOffset + dstBandOffsets[k3]] = this.destinationNoDataShort;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    boolean contains = true;
                    if (this.hasROI) {
                        contains = this.checkInROI(y0, x0);
                    }
                    if (!contains) {
                        for (k = 0; k < dnumBands; ++k) {
                            dstData = dstDataArrays[k];
                            dstData[dstPixelOffset + dstBandOffsets[k]] = this.destinationNoDataShort;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (k = 0; k < dnumBands; ++k) {
                        int data;
                        int v;
                        int u;
                        dstData = dstDataArrays[k];
                        int value = 0;
                        int xStart = x0 - this.leftPadding;
                        int yStart = y0 - this.topPadding;
                        if (this.counter) {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = (short)iter.getSample(xStart + v, yStart + u, k);
                                    if (data != this.valueToCountS) continue;
                                    ++value;
                                }
                            }
                        } else {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSample(xStart + v, yStart + u, k);
                                    value += data;
                                }
                            }
                        }
                        if ((value = (int)((double)value * this.pixelArea)) < Short.MIN_VALUE) {
                            value = Short.MIN_VALUE;
                        } else if (value > Short.MAX_VALUE) {
                            value = Short.MAX_VALUE;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = (short)value;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    private void intLoop(Raster ras, Rectangle srcRect, RasterAccessor src, RasterAccessor dst) {
        RandomIter iter = RandomIterFactory.create(ras, srcRect, true, true);
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        int dstX = dst.getX();
        int dstY = dst.getY();
        int[][] dstDataArrays = dst.getIntDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int dstScanlineOffset = 0;
        if (this.hasNoData) {
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstScanlineOffset;
                int y0 = dstY + j;
                for (int i = 0; i < dwidth; ++i) {
                    int[] dstData;
                    int k;
                    int x0 = dstX + i;
                    if (this.hasROI && !this.union.contains(x0, y0)) {
                        for (int k2 = 0; k2 < dnumBands; ++k2) {
                            int[] dstData2 = dstDataArrays[k2];
                            dstData2[dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    boolean contains = true;
                    if (this.hasROI) {
                        contains = this.checkInROI(y0, x0);
                    }
                    if (!contains) {
                        for (k = 0; k < dnumBands; ++k) {
                            dstData = dstDataArrays[k];
                            dstData[dstPixelOffset + dstBandOffsets[k]] = this.destinationNoDataInt;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (k = 0; k < dnumBands; ++k) {
                        boolean valid;
                        int data;
                        int v;
                        int u;
                        dstData = dstDataArrays[k];
                        long value = 0L;
                        boolean isValidData = false;
                        int xStart = x0 - this.leftPadding;
                        int yStart = y0 - this.topPadding;
                        if (this.counter) {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSample(xStart + v, yStart + u, k);
                                    boolean bl = valid = !this.noData.contains(data);
                                    if (!valid || data != this.valueToCountI) continue;
                                    ++value;
                                    isValidData = valid;
                                }
                            }
                        } else {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSample(xStart + v, yStart + u, k);
                                    boolean bl = valid = !this.noData.contains(data);
                                    if (!valid) continue;
                                    value += (long)data;
                                    isValidData = valid;
                                }
                            }
                        }
                        if ((value = (long)((double)value * this.pixelArea)) < Integer.MIN_VALUE) {
                            value = Integer.MIN_VALUE;
                        } else if (value > Integer.MAX_VALUE) {
                            value = Integer.MAX_VALUE;
                        } else if (!isValidData) {
                            value = this.destinationNoDataInt;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = (int)value;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstScanlineOffset;
                int y0 = dstY + j;
                for (int i = 0; i < dwidth; ++i) {
                    int[] dstData;
                    int k;
                    int x0 = dstX + i;
                    if (this.hasROI && !this.union.contains(x0, y0)) {
                        for (int k3 = 0; k3 < dnumBands; ++k3) {
                            int[] dstData3 = dstDataArrays[k3];
                            dstData3[dstPixelOffset + dstBandOffsets[k3]] = this.destinationNoDataInt;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    boolean contains = true;
                    if (this.hasROI) {
                        contains = this.checkInROI(y0, x0);
                    }
                    if (!contains) {
                        for (k = 0; k < dnumBands; ++k) {
                            dstData = dstDataArrays[k];
                            dstData[dstPixelOffset + dstBandOffsets[k]] = this.destinationNoDataInt;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (k = 0; k < dnumBands; ++k) {
                        int data;
                        int v;
                        int u;
                        dstData = dstDataArrays[k];
                        long value = 0L;
                        int xStart = x0 - this.leftPadding;
                        int yStart = y0 - this.topPadding;
                        if (this.counter) {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSample(xStart + v, yStart + u, k);
                                    if (data != this.valueToCountI) continue;
                                    ++value;
                                }
                            }
                        } else {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSample(xStart + v, yStart + u, k);
                                    value += (long)data;
                                }
                            }
                        }
                        if ((value = (long)((double)value * this.pixelArea)) < Integer.MIN_VALUE) {
                            value = Integer.MIN_VALUE;
                        } else if (value > Integer.MAX_VALUE) {
                            value = Integer.MAX_VALUE;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = (int)value;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    private void floatLoop(Raster ras, Rectangle srcRect, RasterAccessor src, RasterAccessor dst) {
        RandomIter iter = RandomIterFactory.create(ras, srcRect, true, true);
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        int dstX = dst.getX();
        int dstY = dst.getY();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int dstScanlineOffset = 0;
        if (this.hasNoData) {
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstScanlineOffset;
                int y0 = dstY + j;
                for (int i = 0; i < dwidth; ++i) {
                    float[] dstData;
                    int k;
                    int x0 = dstX + i;
                    if (this.hasROI && !this.union.contains(x0, y0)) {
                        for (int k2 = 0; k2 < dnumBands; ++k2) {
                            float[] dstData2 = dstDataArrays[k2];
                            dstData2[dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    boolean contains = true;
                    if (this.hasROI) {
                        contains = this.checkInROI(y0, x0);
                    }
                    if (!contains) {
                        for (k = 0; k < dnumBands; ++k) {
                            dstData = dstDataArrays[k];
                            dstData[dstPixelOffset + dstBandOffsets[k]] = this.destinationNoDataFloat;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (k = 0; k < dnumBands; ++k) {
                        boolean valid;
                        float data;
                        int v;
                        int u;
                        dstData = dstDataArrays[k];
                        double value = 0.0;
                        boolean isValidData = false;
                        int xStart = x0 - this.leftPadding;
                        int yStart = y0 - this.topPadding;
                        if (this.counter) {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSampleFloat(xStart + v, yStart + u, k);
                                    boolean bl = valid = !this.noData.contains(data);
                                    if (!valid || data != this.valueToCountF) continue;
                                    value += 1.0;
                                    isValidData = valid;
                                }
                            }
                        } else {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSampleFloat(xStart + v, yStart + u, k);
                                    boolean bl = valid = !this.noData.contains(data);
                                    if (!valid) continue;
                                    value += (double)data;
                                    isValidData = valid;
                                }
                            }
                        }
                        if ((value *= this.pixelArea) < -3.4028234663852886E38) {
                            value = -3.4028234663852886E38;
                        } else if (value > 3.4028234663852886E38) {
                            value = 3.4028234663852886E38;
                        } else if (!isValidData) {
                            value = this.destinationNoDataFloat;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = (float)value;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstScanlineOffset;
                int y0 = dstY + j;
                for (int i = 0; i < dwidth; ++i) {
                    float[] dstData;
                    int k;
                    int x0 = dstX + i;
                    if (this.hasROI && !this.union.contains(x0, y0)) {
                        for (int k3 = 0; k3 < dnumBands; ++k3) {
                            float[] dstData3 = dstDataArrays[k3];
                            dstData3[dstPixelOffset + dstBandOffsets[k3]] = this.destinationNoDataFloat;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    boolean contains = true;
                    if (this.hasROI) {
                        contains = this.checkInROI(y0, x0);
                    }
                    if (!contains) {
                        for (k = 0; k < dnumBands; ++k) {
                            dstData = dstDataArrays[k];
                            dstData[dstPixelOffset + dstBandOffsets[k]] = this.destinationNoDataFloat;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (k = 0; k < dnumBands; ++k) {
                        float data;
                        int v;
                        int u;
                        dstData = dstDataArrays[k];
                        double value = 0.0;
                        int xStart = x0 - this.leftPadding;
                        int yStart = y0 - this.topPadding;
                        if (this.counter) {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSampleFloat(xStart + v, yStart + u, k);
                                    if (data != this.valueToCountF) continue;
                                    value += 1.0;
                                }
                            }
                        } else {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSampleFloat(xStart + v, yStart + u, k);
                                    value += (double)data;
                                }
                            }
                        }
                        if ((value *= this.pixelArea) < -3.4028234663852886E38) {
                            value = -3.4028234663852886E38;
                        } else if (value > 3.4028234663852886E38) {
                            value = 3.4028234663852886E38;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = (float)value;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    private void doubleLoop(Raster ras, Rectangle srcRect, RasterAccessor src, RasterAccessor dst) {
        RandomIter iter = RandomIterFactory.create(ras, srcRect, true, true);
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        int dstX = dst.getX();
        int dstY = dst.getY();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int dstScanlineOffset = 0;
        if (this.hasNoData) {
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstScanlineOffset;
                int y0 = dstY + j;
                for (int i = 0; i < dwidth; ++i) {
                    double[] dstData;
                    int k;
                    int x0 = dstX + i;
                    if (this.hasROI && !this.union.contains(x0, y0)) {
                        for (int k2 = 0; k2 < dnumBands; ++k2) {
                            double[] dstData2 = dstDataArrays[k2];
                            dstData2[dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    boolean contains = true;
                    if (this.hasROI) {
                        contains = this.checkInROI(y0, x0);
                    }
                    if (!contains) {
                        for (k = 0; k < dnumBands; ++k) {
                            dstData = dstDataArrays[k];
                            dstData[dstPixelOffset + dstBandOffsets[k]] = this.destinationNoDataDouble;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (k = 0; k < dnumBands; ++k) {
                        boolean valid;
                        double data;
                        int v;
                        int u;
                        dstData = dstDataArrays[k];
                        double value = 0.0;
                        boolean isValidData = false;
                        int xStart = x0 - this.leftPadding;
                        int yStart = y0 - this.topPadding;
                        if (this.counter) {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSampleDouble(xStart + v, yStart + u, k);
                                    boolean bl = valid = !this.noData.contains(data);
                                    if (!valid || data != this.valueToCountD) continue;
                                    value += 1.0;
                                    isValidData = valid;
                                }
                            }
                        } else {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSampleDouble(xStart + v, yStart + u, k);
                                    boolean bl = valid = !this.noData.contains(data);
                                    if (!valid) continue;
                                    value += data;
                                    isValidData = valid;
                                }
                            }
                        }
                        value *= this.pixelArea;
                        if (!isValidData) {
                            value = this.destinationNoDataDouble;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = value;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstScanlineOffset;
                int y0 = dstY + j;
                for (int i = 0; i < dwidth; ++i) {
                    double[] dstData;
                    int k;
                    int x0 = dstX + i;
                    if (this.hasROI && !this.union.contains(x0, y0)) {
                        for (int k3 = 0; k3 < dnumBands; ++k3) {
                            double[] dstData3 = dstDataArrays[k3];
                            dstData3[dstPixelOffset + dstBandOffsets[k3]] = this.destinationNoDataDouble;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    boolean contains = true;
                    if (this.hasROI) {
                        contains = this.checkInROI(y0, x0);
                    }
                    if (!contains) {
                        for (k = 0; k < dnumBands; ++k) {
                            dstData = dstDataArrays[k];
                            dstData[dstPixelOffset + dstBandOffsets[k]] = this.destinationNoDataDouble;
                        }
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (k = 0; k < dnumBands; ++k) {
                        double data;
                        int v;
                        int u;
                        dstData = dstDataArrays[k];
                        double value = 0.0;
                        int xStart = x0 - this.leftPadding;
                        int yStart = y0 - this.topPadding;
                        if (this.counter) {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSampleDouble(xStart + v, yStart + u, k);
                                    if (data != this.valueToCountD) continue;
                                    value += 1.0;
                                }
                            }
                        } else {
                            for (u = 0; u < this.kHeight; ++u) {
                                for (v = 0; v < this.kWidth; ++v) {
                                    data = iter.getSampleDouble(xStart + v, yStart + u, k);
                                    value += data;
                                }
                            }
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = value *= this.pixelArea;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkInROI(int y0, int x0) {
        Coordinate p1 = new Coordinate(x0, y0);
        Envelope searchEnv = new Envelope(p1);
        List roiList = this.spatialIndex.query(searchEnv);
        boolean contains = false;
        for (ROI roi : roiList) {
            BufferOpImage bufferOpImage = this;
            synchronized (bufferOpImage) {
                contains = roi.contains(x0, y0);
            }
            if (!contains) continue;
            break;
        }
        return contains;
    }
}

