/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.colorindexer;

import it.geosolutions.jaiext.colorindexer.ColorIndexer;
import it.geosolutions.jaiext.colorindexer.ColorMap;
import it.geosolutions.jaiext.colorindexer.ColorUtils;
import it.geosolutions.jaiext.colorindexer.SimpleColorIndexer;
import java.awt.image.IndexColorModel;

public class LRUColorIndexer
implements ColorIndexer {
    IndexColorModel icm;
    ColorIndexer delegate;
    ColorMap cm;
    LRUColors lru;
    int maxSize;

    public LRUColorIndexer(IndexColorModel icm, int maxSize) {
        this.icm = icm;
        this.delegate = new SimpleColorIndexer(icm);
        this.cm = new ColorMap(maxSize);
        this.lru = new LRUColors();
        this.maxSize = maxSize;
    }

    @Override
    public IndexColorModel toIndexColorModel() {
        return this.icm;
    }

    @Override
    public int getClosestIndex(int r, int g2, int b2, int a2) {
        int idx = this.cm.get(r, g2, b2, a2);
        if (idx == -1) {
            idx = this.delegate.getClosestIndex(r, g2, b2, a2);
            this.cm.put(r, g2, b2, a2, idx);
            if (this.cm.size() > this.maxSize) {
                ColorEntry ce = this.lru.removeLast();
                int red = ColorUtils.red(ce.color);
                int green = ColorUtils.green(ce.color);
                int blue = ColorUtils.blue(ce.color);
                int alpha = ColorUtils.alpha(ce.color);
                this.cm.remove(red, green, blue, alpha);
                ce.color = ColorUtils.color(r, g2, b2, a2);
                this.lru.add(ce);
            } else {
                int color = ColorUtils.color(r, g2, b2, a2);
                this.lru.add(new ColorEntry(color, null, null));
            }
        }
        return idx;
    }

    static final class LRUColors {
        ColorEntry first;
        ColorEntry last;

        LRUColors() {
        }

        ColorEntry removeLast() {
            if (this.last == null) {
                return null;
            }
            ColorEntry result = this.last;
            this.last = result.previous;
            if (this.last == null) {
                this.first = null;
            }
            return result;
        }

        void touch(int color) {
            if (this.last == null || this.last == this.first) {
                return;
            }
            ColorEntry result = null;
            ColorEntry entry = this.first;
            while (entry != null) {
                if (entry.color == color) {
                    result = entry;
                    break;
                }
                entry = entry.next;
            }
            if (result == this.last) {
                this.last = result.previous;
                result.previous.next = null;
                result.previous = null;
                result.next = this.first;
                this.first = result;
            } else if (result != this.first) {
                result.previous.next = result.next;
                result.previous = null;
                result.next = this.first;
                this.first = result;
            }
        }

        void add(ColorEntry ce) {
            if (this.first == null) {
                ce.next = null;
                ce.previous = null;
                this.first = this.last = ce;
            } else {
                ce.next = this.first;
                ce.next.previous = ce;
                ce.previous = null;
                this.first = ce;
            }
        }
    }

    static final class ColorEntry {
        int color;
        ColorEntry previous;
        ColorEntry next;

        public ColorEntry(int color, ColorEntry previous, ColorEntry next) {
            this.color = color;
            this.previous = previous;
            this.next = next;
        }
    }
}

