/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.colorindexer;

import it.geosolutions.jaiext.colorindexer.ColorIndexer;
import it.geosolutions.jaiext.colorindexer.ColorMap;
import it.geosolutions.jaiext.colorindexer.SimpleColorIndexer;
import java.awt.image.IndexColorModel;

public class MappedColorIndexer
implements ColorIndexer {
    byte[][] colors;
    ColorMap colorMap;
    int shift;
    SimpleColorIndexer delegate;

    public MappedColorIndexer(byte[][] colors, ColorMap colorMap, int shift) {
        this.colors = colors;
        this.shift = shift;
        this.colorMap = colorMap;
        this.delegate = new SimpleColorIndexer(colors);
    }

    @Override
    public IndexColorModel toIndexColorModel() {
        return this.delegate.toIndexColorModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClosestIndex(int r, int g2, int b2, int a2) {
        int sr = r;
        int sg = g2;
        int sb = b2;
        int sa = a2;
        if (this.shift > 0) {
            sr = r >> this.shift;
            sg = g2 >> this.shift;
            sb = b2 >> this.shift;
            sa = a2 >> this.shift;
        }
        if (a2 <= 5) {
            sr = 255;
            sg = 255;
            sb = 255;
            sa = 0;
        }
        ColorMap colorMap = this.colorMap;
        synchronized (colorMap) {
            int idx = this.colorMap.get(sr, sg, sb, sa);
            if (idx < 0) {
                idx = this.delegate.getClosestIndex(r, g2, b2, a2);
                this.colorMap.put(sr, sg, sb, sa, idx);
            }
            return idx;
        }
    }
}

