/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.warp;

import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.warp.WarpOpImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.Warp;
import javax.media.jai.iterator.RandomIter;

final class WarpNearestOpImage
extends WarpOpImage {
    private byte[][] byteLookupTable;

    public WarpNearestOpImage(RenderedImage source, Map<?, ?> config, ImageLayout layout, Warp warp, Interpolation interp, ROI sourceROI, Range noData, double[] bkg) {
        super(source, layout, config, false, null, interp, warp, bkg, sourceROI, noData);
        SampleModel sm;
        int srcDataType;
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel) {
            this.sampleModel = source.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = srcColorModel;
        }
        if ((srcDataType = (sm = source.getSampleModel()).getDataType()) == 0 && this.hasNoData) {
            int numBands = this.getNumBands();
            this.byteLookupTable = new byte[numBands][256];
            for (int b2 = 0; b2 < numBands; ++b2) {
                for (int i = 0; i < this.byteLookupTable[0].length; ++i) {
                    byte value = (byte)i;
                    this.byteLookupTable[b2][i] = this.noDataRange.contains(value) ? (byte)this.backgroundValues[b2] : value;
                }
            }
        }
    }

    @Override
    protected void computeRectByte(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iter = RandomIterFactory.create(src, src.getBounds(), true, true);
        int minX = src.getMinX();
        int maxX = src.getMaxX();
        int minY = src.getMinY();
        int maxY = src.getMaxY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        byte[][] data = dst.getByteDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = (byte)this.backgroundValues[b2];
                            }
                        }
                    } else {
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            data[b2][pixelOffset + bandOffsets[b2]] = (byte)(iter.getSample(sx, sy, b2) & 0xFF);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (byte)this.backgroundValues[b3];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (byte)this.backgroundValues[b3];
                            }
                        }
                    } else {
                        for (b3 = 0; b3 < dstBands; ++b3) {
                            data[b3][pixelOffset + bandOffsets[b3]] = (byte)(iter.getSample(sx, sy, b3) & 0xFF);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b4;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = (byte)this.backgroundValues[b4];
                            }
                        }
                    } else {
                        for (b4 = 0; b4 < dstBands; ++b4) {
                            data[b4][pixelOffset + bandOffsets[b4]] = this.byteLookupTable[b4][iter.getSample(sx, sy, b4)];
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (byte)this.backgroundValues[b5];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || !this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (byte)this.backgroundValues[b5];
                            }
                        }
                    } else {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            data[b5][pixelOffset + bandOffsets[b5]] = this.byteLookupTable[b5][iter.getSample(sx, sy, b5)];
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectUShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iter = RandomIterFactory.create(src, src.getBounds(), true, true);
        int minX = src.getMinX();
        int maxX = src.getMaxX();
        int minY = src.getMinY();
        int maxY = src.getMaxY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = (short)this.backgroundValues[b2];
                            }
                        }
                    } else {
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            data[b2][pixelOffset + bandOffsets[b2]] = (short)(iter.getSample(sx, sy, b2) & 0xFFFF);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (short)this.backgroundValues[b3];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || !this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (short)this.backgroundValues[b3];
                            }
                        }
                    } else {
                        for (b3 = 0; b3 < dstBands; ++b3) {
                            data[b3][pixelOffset + bandOffsets[b3]] = (short)(iter.getSample(sx, sy, b3) & 0xFFFF);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            short inputValue = 0;
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b4;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = (short)this.backgroundValues[b4];
                            }
                        }
                    } else {
                        for (b4 = 0; b4 < dstBands; ++b4) {
                            inputValue = (short)(iter.getSample(sx, sy, b4) & 0xFFFF);
                            data[b4][pixelOffset + bandOffsets[b4]] = this.noDataRange.contains(inputValue) ? (short)this.backgroundValues[b4] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            short inputValue = 0;
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (short)this.backgroundValues[b5];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (short)this.backgroundValues[b5];
                            }
                        }
                    } else {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            inputValue = (short)(iter.getSample(sx, sy, b5) & 0xFFFF);
                            data[b5][pixelOffset + bandOffsets[b5]] = this.noDataRange.contains(inputValue) ? (short)this.backgroundValues[b5] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iter = RandomIterFactory.create(src, src.getBounds(), true, true);
        int minX = src.getMinX();
        int maxX = src.getMaxX();
        int minY = src.getMinY();
        int maxY = src.getMaxY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = (short)this.backgroundValues[b2];
                            }
                        }
                    } else {
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            data[b2][pixelOffset + bandOffsets[b2]] = (short)iter.getSample(sx, sy, b2);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (short)this.backgroundValues[b3];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (short)this.backgroundValues[b3];
                            }
                        }
                    } else {
                        for (b3 = 0; b3 < dstBands; ++b3) {
                            data[b3][pixelOffset + bandOffsets[b3]] = (short)iter.getSample(sx, sy, b3);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            short inputValue = 0;
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b4;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = (short)this.backgroundValues[b4];
                            }
                        }
                    } else {
                        for (b4 = 0; b4 < dstBands; ++b4) {
                            inputValue = (short)iter.getSample(sx, sy, b4);
                            data[b4][pixelOffset + bandOffsets[b4]] = this.noDataRange.contains(inputValue) ? (short)this.backgroundValues[b4] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            short inputValue = 0;
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (short)this.backgroundValues[b5];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (short)this.backgroundValues[b5];
                            }
                        }
                    } else {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            inputValue = (short)iter.getSample(sx, sy, b5);
                            data[b5][pixelOffset + bandOffsets[b5]] = this.noDataRange.contains(inputValue) ? (short)this.backgroundValues[b5] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectInt(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iter = RandomIterFactory.create(src, src.getBounds(), true, true);
        int minX = src.getMinX();
        int maxX = src.getMaxX();
        int minY = src.getMinY();
        int maxY = src.getMaxY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        int[][] data = dst.getIntDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = (int)this.backgroundValues[b2];
                            }
                        }
                    } else {
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            data[b2][pixelOffset + bandOffsets[b2]] = iter.getSample(sx, sy, b2);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (int)this.backgroundValues[b3];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (int)this.backgroundValues[b3];
                            }
                        }
                    } else {
                        for (b3 = 0; b3 < dstBands; ++b3) {
                            data[b3][pixelOffset + bandOffsets[b3]] = iter.getSample(sx, sy, b3);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            int inputValue = 0;
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b4;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = (int)this.backgroundValues[b4];
                            }
                        }
                    } else {
                        for (b4 = 0; b4 < dstBands; ++b4) {
                            inputValue = iter.getSample(sx, sy, b4);
                            data[b4][pixelOffset + bandOffsets[b4]] = this.noDataRange.contains(inputValue) ? (int)this.backgroundValues[b4] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            int inputValue = 0;
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (int)this.backgroundValues[b5];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (int)this.backgroundValues[b5];
                            }
                        }
                    } else {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            inputValue = iter.getSample(sx, sy, b5);
                            data[b5][pixelOffset + bandOffsets[b5]] = this.noDataRange.contains(inputValue) ? (int)this.backgroundValues[b5] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectFloat(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iter = RandomIterFactory.create(src, src.getBounds(), true, true);
        int minX = src.getMinX();
        int maxX = src.getMaxX();
        int minY = src.getMinY();
        int maxY = src.getMaxY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        float[][] data = dst.getFloatDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = (float)this.backgroundValues[b2];
                            }
                        }
                    } else {
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            data[b2][pixelOffset + bandOffsets[b2]] = iter.getSampleFloat(sx, sy, b2);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (float)this.backgroundValues[b3];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (float)this.backgroundValues[b3];
                            }
                        }
                    } else {
                        for (b3 = 0; b3 < dstBands; ++b3) {
                            data[b3][pixelOffset + bandOffsets[b3]] = iter.getSampleFloat(sx, sy, b3);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            float inputValue = 0.0f;
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b4;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = (float)this.backgroundValues[b4];
                            }
                        }
                    } else {
                        for (b4 = 0; b4 < dstBands; ++b4) {
                            inputValue = iter.getSampleFloat(sx, sy, b4);
                            data[b4][pixelOffset + bandOffsets[b4]] = this.noDataRange.contains(inputValue) ? (float)this.backgroundValues[b4] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            float inputValue = 0.0f;
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (float)this.backgroundValues[b5];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (float)this.backgroundValues[b5];
                            }
                        }
                    } else {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            inputValue = iter.getSampleFloat(sx, sy, b5);
                            data[b5][pixelOffset + bandOffsets[b5]] = this.noDataRange.contains(inputValue) ? (float)this.backgroundValues[b5] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectDouble(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iter = RandomIterFactory.create(src, src.getBounds(), true, true);
        int minX = src.getMinX();
        int maxX = src.getMaxX();
        int minY = src.getMinY();
        int maxY = src.getMaxY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        double[][] data = dst.getDoubleDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = this.backgroundValues[b2];
                            }
                        }
                    } else {
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            data[b2][pixelOffset + bandOffsets[b2]] = iter.getSampleDouble(sx, sy, b2);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = this.backgroundValues[b3];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = this.backgroundValues[b3];
                            }
                        }
                    } else {
                        for (b3 = 0; b3 < dstBands; ++b3) {
                            data[b3][pixelOffset + bandOffsets[b3]] = iter.getSampleDouble(sx, sy, b3);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            double inputValue = 0.0;
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b4;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = this.backgroundValues[b4];
                            }
                        }
                    } else {
                        for (b4 = 0; b4 < dstBands; ++b4) {
                            inputValue = iter.getSampleDouble(sx, sy, b4);
                            data[b4][pixelOffset + bandOffsets[b4]] = this.noDataRange.contains(inputValue) ? this.backgroundValues[b4] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            double inputValue = 0.0;
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = this.backgroundValues[b5];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = this.backgroundValues[b5];
                            }
                        }
                    } else {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            inputValue = iter.getSampleDouble(sx, sy, b5);
                            data[b5][pixelOffset + bandOffsets[b5]] = this.noDataRange.contains(inputValue) ? this.backgroundValues[b5] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }
}

