/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.util.StringTokenizer;
import jj2000.j2k.ModuleSpec;

public class IntegerSpec
extends ModuleSpec {
    protected static int MAX_INT = Integer.MAX_VALUE;

    public IntegerSpec(int nt, int nc, byte type) {
        super(nt, nc, type);
    }

    public IntegerSpec(int nt, int nc, byte type, J2KImageWriteParamJava wp, String values, String defaultValue) {
        super(nt, nc, type);
        if (values == null) {
            try {
                this.setDefault(new Integer(defaultValue));
            }
            catch (NumberFormatException e2) {
                throw new IllegalArgumentException("Non recognized value for option -: " + defaultValue);
            }
            return;
        }
        StringTokenizer stk = new StringTokenizer(values);
        int curSpecType = 0;
        boolean[] tileSpec = null;
        boolean[] compSpec = null;
        block15: while (stk.hasMoreTokens()) {
            int i;
            Integer value;
            String word = stk.nextToken();
            switch (word.charAt(0)) {
                case 't': {
                    tileSpec = IntegerSpec.parseIdx(word, this.nTiles);
                    if (curSpecType == 1) {
                        curSpecType = 3;
                        continue block15;
                    }
                    curSpecType = 2;
                    continue block15;
                }
                case 'c': {
                    compSpec = IntegerSpec.parseIdx(word, this.nComp);
                    if (curSpecType == 2) {
                        curSpecType = 3;
                        continue block15;
                    }
                    curSpecType = 1;
                    continue block15;
                }
            }
            try {
                value = new Integer(word);
            }
            catch (NumberFormatException e3) {
                throw new IllegalArgumentException("Non recognized value for option -: " + word);
            }
            if (curSpecType == 0) {
                this.setDefault(value);
            } else if (curSpecType == 2) {
                for (i = tileSpec.length - 1; i >= 0; --i) {
                    if (!tileSpec[i]) continue;
                    this.setTileDef(i, value);
                }
            } else if (curSpecType == 1) {
                for (i = compSpec.length - 1; i >= 0; --i) {
                    if (!compSpec[i]) continue;
                    this.setCompDef(i, value);
                }
            } else {
                for (i = tileSpec.length - 1; i >= 0; --i) {
                    for (int j = compSpec.length - 1; j >= 0; --j) {
                        if (!tileSpec[i] || !compSpec[j]) continue;
                        this.setTileCompVal(i, j, value);
                    }
                }
            }
            curSpecType = 0;
            tileSpec = null;
            compSpec = null;
        }
        if (this.getDefault() == null) {
            int t;
            int ndefspec = 0;
            for (t = nt - 1; t >= 0; --t) {
                for (int c2 = nc - 1; c2 >= 0; --c2) {
                    if (this.specValType[t][c2] != 0) continue;
                    ++ndefspec;
                }
            }
            if (ndefspec != 0) {
                try {
                    this.setDefault(new Integer(defaultValue));
                }
                catch (NumberFormatException e4) {
                    throw new IllegalArgumentException("Non recognized value for option - : " + defaultValue);
                }
            } else {
                this.setDefault(this.getTileCompVal(0, 0));
                switch (this.specValType[0][0]) {
                    case 2: {
                        for (int c3 = nc - 1; c3 >= 0; --c3) {
                            if (this.specValType[0][c3] != 2) continue;
                            this.specValType[0][c3] = 0;
                        }
                        this.tileDef[0] = null;
                        break;
                    }
                    case 1: {
                        for (t = nt - 1; t >= 0; --t) {
                            if (this.specValType[t][0] != 1) continue;
                            this.specValType[t][0] = 0;
                        }
                        this.compDef[0] = null;
                        break;
                    }
                    case 3: {
                        this.specValType[0][0] = 0;
                        this.tileCompVal.put("t0c0", null);
                    }
                }
            }
        }
    }

    public int getMax() {
        int max = (Integer)this.def;
        for (int t = 0; t < this.nTiles; ++t) {
            for (int c2 = 0; c2 < this.nComp; ++c2) {
                int tmp = (Integer)this.getSpec(t, c2);
                if (max >= tmp) continue;
                max = tmp;
            }
        }
        return max;
    }

    public int getMin() {
        int min2 = (Integer)this.def;
        for (int t = 0; t < this.nTiles; ++t) {
            for (int c2 = 0; c2 < this.nComp; ++c2) {
                int tmp = (Integer)this.getSpec(t, c2);
                if (min2 <= tmp) continue;
                min2 = tmp;
            }
        }
        return min2;
    }

    public int getMaxInComp(int c2) {
        int max = 0;
        for (int t = 0; t < this.nTiles; ++t) {
            int tmp = (Integer)this.getSpec(t, c2);
            if (max >= tmp) continue;
            max = tmp;
        }
        return max;
    }

    public int getMinInComp(int c2) {
        int min2 = MAX_INT;
        for (int t = 0; t < this.nTiles; ++t) {
            int tmp = (Integer)this.getSpec(t, c2);
            if (min2 <= tmp) continue;
            min2 = tmp;
        }
        return min2;
    }

    public int getMaxInTile(int t) {
        int max = 0;
        for (int c2 = 0; c2 < this.nComp; ++c2) {
            int tmp = (Integer)this.getSpec(t, c2);
            if (max >= tmp) continue;
            max = tmp;
        }
        return max;
    }

    public int getMinInTile(int t) {
        int min2 = MAX_INT;
        for (int c2 = 0; c2 < this.nComp; ++c2) {
            int tmp = (Integer)this.getSpec(t, c2);
            if (min2 <= tmp) continue;
            min2 = tmp;
        }
        return min2;
    }
}

