/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.sat;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.sat.Literalizer;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.queues.CircularQueue;

public class SatDecorator
extends MiniSat {
    public ArrayList<MiniSat.Clause> dynClauses = new ArrayList();
    private final TIntObjectHashMap<Literalizer> lits = new TIntObjectHashMap();
    private final HashMap<Variable, List<Literalizer>> vars = new HashMap();
    private final IStateInt sat_trail_;
    private final CircularQueue<Variable> toCheck = new CircularQueue(16);
    private final TIntList early_deductions_ = new TIntArrayList();

    public SatDecorator(Model model) {
        this.sat_trail_ = model.getEnvironment().makeInt();
    }

    public void learnClause(int ... ps) {
        Arrays.sort(ps);
        switch (ps.length) {
            case 0: {
                this.ok_ = false;
                return;
            }
            case 1: {
                this.dynUncheckedEnqueue(ps[0]);
                this.ok_ = this.propagate() == CR_Undef;
                return;
            }
        }
        MiniSat.Clause cr = new MiniSat.Clause(ps);
        this.removeDominated(cr);
        this.dynClauses.add(cr);
        this.attachClause(cr);
    }

    private void removeDominated(MiniSat.Clause last) {
        for (int c2 = this.dynClauses.size() - 1; c2 >= 0; --c2) {
            int p;
            int l;
            MiniSat.Clause prev = this.dynClauses.get(c2);
            if (last.size() >= prev.size()) continue;
            int i = 0;
            int j = 0;
            while (i < last.size() && j < prev.size() && (l = last._g(i)) >= (p = prev._g(j))) {
                ++j;
                if (l != p) continue;
                ++i;
            }
            if (i != last.size() || j != prev.size()) continue;
            this.detachLearnt(c2);
        }
    }

    public void detachLearnt(int ci) {
        MiniSat.Clause cr = this.dynClauses.get(ci);
        this.detachClause(cr);
        this.dynClauses.remove(ci);
    }

    private void dynUncheckedEnqueue(int l) {
        this.touched_variables_.add(l);
    }

    public int nLearnt() {
        return this.dynClauses.size();
    }

    public ESat value(int svar) {
        switch (this.valueVar(svar)) {
            case lFalse: {
                return ESat.FALSE;
            }
            case lTrue: {
                return ESat.TRUE;
            }
        }
        return ESat.UNDEFINED;
    }

    public boolean propagateOneLiteral(int lit) {
        assert (this.ok_);
        this.touched_variables_.resetQuick();
        if (this.propagate() != CR_Undef) {
            return false;
        }
        if (this.valueLit(lit) == MiniSat.Boolean.lTrue) {
            this.pushTrailMarker();
            return true;
        }
        if (this.valueLit(lit) == MiniSat.Boolean.lFalse) {
            return false;
        }
        this.pushTrailMarker();
        assert (this.valueLit(lit) == MiniSat.Boolean.lUndef);
        this.assignment_.set(SatDecorator.var(lit), SatDecorator.makeBoolean(SatDecorator.sgn(lit)));
        this.trail_.add(lit);
        return this.propagate() == CR_Undef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bound(Variable cpvar, ICause cause) throws ContradictionException {
        try {
            if (this.sat_trail_.get() < this.trailMarker()) {
                this.cancelUntil(this.sat_trail_.get());
                assert (this.sat_trail_.get() == this.trailMarker());
            }
            this.toCheck.addFirst(cpvar);
            while (this.toCheck.size() > 0) {
                Variable cvar = this.toCheck.pollFirst();
                List<Literalizer> myLits = this.vars.get(cvar);
                for (int i = 0; i < myLits.size(); ++i) {
                    Literalizer ltz = myLits.get(i);
                    if (!ltz.canReact()) continue;
                    int lit = ltz.toLit();
                    if (this.propagateOneLiteral(lit)) {
                        this.sat_trail_.set(this.trailMarker());
                        for (int j = 0; j < this.touched_variables_.size(); ++j) {
                            lit = this.touched_variables_.get(j);
                            Literalizer lzr = this.lits.get(SatDecorator.var(lit));
                            if (lzr == null || !lzr.toEvent(lit, cause)) continue;
                            this.toCheck.addFirst(lzr.cvar());
                        }
                        continue;
                    }
                    ltz.toEvent(SatDecorator.neg(lit), cause);
                }
            }
        }
        finally {
            this.touched_variables_.resetQuick();
            this.toCheck.clear();
        }
    }

    public void storeEarlyDeductions() {
        for (int i = 0; i < this.touched_variables_.size(); ++i) {
            int lit = this.touched_variables_.get(i);
            this.early_deductions_.add(lit);
        }
        this.touched_variables_.resetQuick();
    }

    public void applyEarlyDeductions(ICause cause) throws ContradictionException {
        for (int i = 0; i < this.early_deductions_.size(); ++i) {
            int lit = this.early_deductions_.get(i);
            this.lits.get(SatDecorator.var(lit)).toEvent(lit, cause);
        }
    }

    @Override
    public void cancelUntil(int level) {
        super.cancelUntil(level);
    }

    public <V extends Variable> int bind(V bvar, Literalizer ltz, Consumer<V> actionOnNew) {
        Optional<Literalizer> opt;
        List tmp = this.vars.computeIfAbsent(bvar, k -> new ArrayList());
        if (tmp.isEmpty()) {
            actionOnNew.accept(bvar);
        }
        if (!(opt = tmp.stream().filter(l -> l.equals(ltz)).findFirst()).isPresent()) {
            int var = this.newVariable();
            ltz.svar(var);
            this.lits.put(var, ltz);
            tmp.add(ltz);
            opt = Optional.of(ltz);
        }
        return opt.get().svar();
    }

    public void synchro() {
        if (this.sat_trail_.get() < this.trailMarker()) {
            this.cancelUntil(this.sat_trail_.get());
            assert (this.sat_trail_.get() == this.trailMarker());
        }
    }

    public boolean clauseEntailed(ArrayList<MiniSat.Clause> clauses) {
        block0: for (MiniSat.Clause c2 : clauses) {
            for (int i = 0; i < c2.size(); ++i) {
                int lit = c2._g(i);
                Literalizer ltz = this.lits.get(SatDecorator.var(lit));
                if (ltz == null || this.lits.get(SatDecorator.var(lit)).check(SatDecorator.sgn(lit))) continue block0;
            }
            return false;
        }
        return true;
    }
}

