/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.chocosolver.cutoffseq.LubyCutoffStrategy;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.nary.sat.NogoodStealer;
import org.chocosolver.solver.constraints.real.RealConstraint;
import org.chocosolver.solver.exception.InvalidSolutionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.search.limits.FailCounter;
import org.chocosolver.solver.search.loop.lns.INeighborFactory;
import org.chocosolver.solver.search.loop.monitors.NogoodFromRestarts;
import org.chocosolver.solver.search.strategy.Search;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;

public class ParallelPortfolio {
    private final List<Model> models;
    private final boolean searchAutoConf;
    private NogoodStealer manager = NogoodStealer.NONE;
    private boolean isPrepared = false;
    private final HashMap<Model, Boolean> reliableness;
    private final AtomicBoolean solverTerminated = new AtomicBoolean(false);
    private final AtomicBoolean solutionFound = new AtomicBoolean(false);
    private final AtomicInteger solverRunning = new AtomicInteger(0);
    private Model finder;

    public ParallelPortfolio(boolean searchAutoConf) {
        this.models = new ArrayList<Model>();
        this.reliableness = new HashMap();
        this.searchAutoConf = searchAutoConf;
    }

    public ParallelPortfolio() {
        this(true);
    }

    public void stealNogoodsOnRestarts() {
        this.manager = new NogoodStealer();
    }

    public void addModel(Model model) {
        this.addModel(model, true);
    }

    public void addModel(Model model, boolean reliable) {
        this.models.add(model);
        this.reliableness.put(model, reliable);
    }

    public boolean solve() {
        this.getSolverTerminated().set(false);
        this.getSolutionFound().set(false);
        this.getSolverRunning().set(this.models.size());
        if (!this.isPrepared) {
            this.prepare();
        }
        ForkJoinPool forkJoinPool = new ForkJoinPool(this.models.size());
        try {
            ((ForkJoinTask)forkJoinPool.submit(() -> this.models.parallelStream().forEach(m3 -> {
                boolean so;
                if (!(this.getSolverTerminated().get() || (so = m3.getSolver().solve()) && this.finder != m3)) {
                    this.getSolverTerminated().set(so || this.reliableness.get(m3) != false || this.getSolverRunning().decrementAndGet() <= 0);
                }
            }))).get();
        }
        catch (InterruptedException | ExecutionException | SolverException e2) {
            this.getSolverRunning().decrementAndGet();
            if (e2.getCause() instanceof InvalidSolutionException) {
                InvalidSolutionException ex = (InvalidSolutionException)e2.getCause();
                if (this.reliableness.get(ex.getModel()).booleanValue()) {
                    throw (SolverException)e2.getCause();
                }
            }
            e2.printStackTrace();
        }
        forkJoinPool.shutdownNow();
        this.getSolverTerminated().set(false);
        if (this.getSolutionFound().get() && this.models.get(0).getResolutionPolicy() != ResolutionPolicy.SATISFACTION) {
            int bestAll = this.getBestModel().getSolver().getBestSolutionValue().intValue();
            for (Model m3 : this.models) {
                int mVal = m3.getSolver().getBestSolutionValue().intValue();
                if (m3.getResolutionPolicy() == ResolutionPolicy.MAXIMIZE) {
                    assert (mVal <= bestAll) : mVal + " > " + bestAll;
                    continue;
                }
                assert (m3.getResolutionPolicy() != ResolutionPolicy.MINIMIZE || mVal >= bestAll) : mVal + " < " + bestAll;
            }
        }
        return this.getSolutionFound().get();
    }

    public Model getBestModel() {
        return this.finder;
    }

    public List<Model> getModels() {
        return this.models;
    }

    public Stream<Solution> streamSolutions() {
        Spliterator<Solution> it = new Spliterator<Solution>(){

            @Override
            public boolean tryAdvance(Consumer<? super Solution> action) {
                if (ParallelPortfolio.this.solve()) {
                    action.accept(new Solution(ParallelPortfolio.this.getBestModel(), new Variable[0]).record());
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<Solution> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 4369;
            }
        };
        return StreamSupport.stream(it, false);
    }

    public void prepare() {
        this.isPrepared = true;
        this.check();
        for (int i = 0; i < this.models.size(); ++i) {
            Solver s2 = this.models.get(i).getSolver();
            s2.addStopCriterion(() -> this.getSolverTerminated().get());
            s2.plugMonitor(() -> this.updateFromSolution(s2.getModel()));
            if (!this.searchAutoConf) continue;
            this.configureModel(i);
        }
    }

    private synchronized void updateFromSolution(Model m3) {
        if (m3.getResolutionPolicy() == ResolutionPolicy.SATISFACTION) {
            this.finder = m3;
            this.getSolutionFound().set(true);
        } else {
            int solverVal = ((IntVar)m3.getObjective()).getValue();
            int bestVal = m3.getSolver().getObjectiveManager().getBestSolutionValue().intValue();
            if (m3.getResolutionPolicy() == ResolutionPolicy.MAXIMIZE) {
                assert (solverVal <= bestVal) : solverVal + ">" + bestVal;
            } else assert (m3.getResolutionPolicy() != ResolutionPolicy.MINIMIZE || solverVal >= bestVal) : solverVal + "<" + bestVal;
            if (solverVal == bestVal) {
                this.getSolutionFound().set(true);
                this.finder = m3;
                if (m3.getResolutionPolicy() == ResolutionPolicy.MAXIMIZE) {
                    this.models.forEach(s1 -> s1.getSolver().getObjectiveManager().updateBestLB(bestVal));
                } else {
                    this.models.forEach(s1 -> s1.getSolver().getObjectiveManager().updateBestUB(bestVal));
                }
            }
        }
    }

    private void configureModel(int workerID) {
        Model worker = this.getModels().get(workerID);
        Solver solver = worker.getSolver();
        ResolutionPolicy policy = worker.getResolutionPolicy();
        Variable[] varsX = solver.getSearch() != null && solver.getSearch().getVariables().length > 0 ? solver.getSearch().getVariables() : worker.getVars();
        IntVar[] ivars = new IntVar[varsX.length];
        SetVar[] svars = new SetVar[varsX.length];
        RealVar[] rvars = new RealVar[varsX.length];
        int ki = 0;
        int ks = 0;
        int kr = 0;
        for (Variable aVarsX : varsX) {
            if ((aVarsX.getTypeAndKind() & 8) > 0) {
                ivars[ki++] = (IntVar)aVarsX;
                continue;
            }
            if ((aVarsX.getTypeAndKind() & 0x20) > 0) {
                svars[ks++] = (SetVar)aVarsX;
                continue;
            }
            if ((aVarsX.getTypeAndKind() & 0x40) > 0) {
                rvars[kr++] = (RealVar)aVarsX;
                continue;
            }
            throw new UnsupportedOperationException("unrecognized variable kind " + aVarsX);
        }
        ivars = Arrays.copyOf(ivars, ki);
        svars = Arrays.copyOf(svars, ks);
        rvars = Arrays.copyOf(rvars, kr);
        boolean opt = policy != ResolutionPolicy.SATISFACTION;
        switch (workerID) {
            case 0: {
                solver.setSearch(Search.lastConflict(Search.VarH.DOMWDEG.make(solver, ivars, Search.ValH.BEST, Integer.MAX_VALUE, opt)));
                Search.Restarts.LUBY.declare(solver, 500, 0.0, 5000);
                if (!this.reliableness.containsKey(worker)) break;
                this.manager.add(worker);
                break;
            }
            case 1: {
                solver.setSearch(Search.lastConflict(Search.VarH.CHS.make(solver, ivars, Search.ValH.MIN, Integer.MAX_VALUE, opt)));
                Search.Restarts.LUBY.declare(solver, 500, 0.0, 5000);
                if (!this.reliableness.containsKey(worker)) break;
                this.manager.add(worker);
                break;
            }
            case 2: {
                solver.setSearch(Search.lastConflict(Search.VarH.INPUT.make(solver, ivars, Search.ValH.MIN, Integer.MAX_VALUE, opt)));
                if (!this.reliableness.containsKey(worker)) break;
                this.manager.add(worker);
                break;
            }
            case 3: {
                if (!opt) {
                    solver.setSearch(Search.lastConflict(Search.VarH.DOMWDEGR.make(solver, ivars, Search.ValH.MIN, Integer.MAX_VALUE, opt)));
                    Search.Restarts.LUBY.declare(solver, 500, 0.0, 5000);
                    break;
                }
                solver.setSearch(Search.lastConflict(Search.VarH.INPUT.make(solver, ivars, Search.ValH.MIN, Integer.MAX_VALUE, opt)));
                solver.setLNS(INeighborFactory.blackBox(ivars), new FailCounter(solver.getModel(), 1000L));
                if (!this.reliableness.containsKey(worker)) break;
                this.manager.add(worker);
                break;
            }
            case 4: {
                solver.setSearch(Search.lastConflict(Search.VarH.ABS.make(solver, ivars, Search.ValH.DEFAULT, Integer.MAX_VALUE, opt)));
                Search.Restarts.LUBY.declare(solver, 500, 0.0, 5000);
                break;
            }
            case 5: {
                solver.setSearch(Search.conflictOrderingSearch(Search.VarH.DOMWDEG.make(solver, ivars, Search.ValH.MIN, Integer.MAX_VALUE, opt)));
                Search.Restarts.LUBY.declare(solver, 500, 0.0, 5000);
                solver.setSearch(Search.lastConflict(solver.getSearch()));
                break;
            }
            case 6: {
                if (!opt) {
                    solver.setSearch(Search.VarH.DOMWDEG.make(solver, ivars, Search.ValH.MIN, Integer.MAX_VALUE, false));
                    break;
                }
                solver.setSearch(Search.lastConflict(Search.VarH.DOMWDEGR.make(solver, ivars, Search.ValH.MIN, Integer.MAX_VALUE, opt)));
                Search.Restarts.LUBY.declare(solver, 500, 0.0, 5000);
                break;
            }
            case 7: {
                solver.setSearch(Search.lastConflict(Search.VarH.CHS.make(solver, ivars, Search.ValH.MIN, Integer.MAX_VALUE, opt)));
                Search.Restarts.LUBY.declare(solver, 40, 0.0, 5000);
                if (!this.reliableness.containsKey(worker)) break;
                this.manager.add(worker);
                break;
            }
            default: {
                solver.setSearch(Search.lastConflict(Search.randomSearch(ivars, workerID)));
                if (policy != ResolutionPolicy.SATISFACTION) {
                    solver.setLNS(INeighborFactory.blackBox(ivars), new FailCounter(solver.getModel(), 1000L));
                }
                if (this.reliableness.containsKey(worker)) {
                    solver.plugMonitor(new NogoodFromRestarts(worker, this.manager));
                }
                solver.setRestarts(count -> solver.getFailCount() >= count, new LubyCutoffStrategy(500L), 5000);
            }
        }
        if (ks > 0) {
            solver.setSearch(solver.getSearch(), Search.setVarSearch(svars));
        }
        if (kr > 0) {
            solver.setSearch(solver.getSearch(), Search.realVarSearch(rvars));
        }
    }

    private void check() {
        if (this.models.size() == 0) {
            throw new SolverException("No model found in the ParallelPortfolio.");
        }
        if (this.models.get(0).getResolutionPolicy() != ResolutionPolicy.SATISFACTION) {
            Variable objective = this.models.get(0).getObjective();
            if (objective == null) {
                throw new UnsupportedOperationException("No objective has been defined");
            }
            if ((objective.getTypeAndKind() & 0x40) != 0) {
                for (Constraint c2 : this.models.get(0).getCstrs()) {
                    if (!(c2 instanceof RealConstraint)) continue;
                    throw new UnsupportedOperationException("Ibex is not multithread safe, ParallelPortfolio cannot be used");
                }
            }
        }
    }

    private synchronized AtomicBoolean getSolverTerminated() {
        return this.solverTerminated;
    }

    private synchronized AtomicBoolean getSolutionFound() {
        return this.solutionFound;
    }

    private synchronized AtomicInteger getSolverRunning() {
        return this.solverRunning;
    }
}

