/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;

public class Solution
implements ICause {
    private static final int NO_ENTRY = Integer.MAX_VALUE;
    private boolean empty;
    private TIntIntHashMap intmap;
    private TIntObjectHashMap<double[]> realmap;
    private TIntObjectHashMap<int[]> setmap;
    private final Model model;
    private Variable[] varsToStore;

    public Solution(Model model, Variable ... varsToStore) {
        this.varsToStore = varsToStore;
        this.empty = true;
        this.model = model;
    }

    public Solution record() {
        this.empty = false;
        boolean warn = false;
        if (this.varsToStore.length == 0) {
            this.varsToStore = this.model.getVars();
        }
        assert (this.varsToStore.length > 0);
        if (this.intmap != null) {
            this.intmap.clear();
        }
        if (this.realmap != null) {
            this.realmap.clear();
        }
        if (this.setmap != null) {
            this.setmap.clear();
        }
        for (Variable var : this.varsToStore) {
            if ((var.getTypeAndKind() & 7) == 2) continue;
            int kind = var.getTypeAndKind() & 0x3F8;
            if (var.isInstantiated()) {
                switch (kind) {
                    case 8: 
                    case 24: {
                        if (this.intmap == null) {
                            this.intmap = new TIntIntHashMap(16, 0.5f, Integer.MAX_VALUE, Integer.MAX_VALUE);
                        }
                        IntVar v = (IntVar)var;
                        this.intmap.put(v.getId(), v.getValue());
                        break;
                    }
                    case 64: {
                        if (this.realmap == null) {
                            this.realmap = new TIntObjectHashMap(16, 5.0f, Integer.MAX_VALUE);
                        }
                        RealVar r = (RealVar)var;
                        this.realmap.put(r.getId(), new double[]{r.getLB(), r.getUB()});
                        break;
                    }
                    case 32: {
                        if (this.setmap == null) {
                            this.setmap = new TIntObjectHashMap(16, 5.0f, Integer.MAX_VALUE);
                        }
                        SetVar s2 = (SetVar)var;
                        this.setmap.put(s2.getId(), s2.getValue().toArray());
                        break;
                    }
                }
                continue;
            }
            warn = true;
        }
        if (warn && this.varsToStore[0].getModel().getSettings().warnUser()) {
            this.model.getSolver().log().red().println("Some non decision variables are not instantiated in the current solution.");
        }
        return this;
    }

    public String toString() {
        if (this.empty) {
            return "Empty solution. No solution recorded yet";
        }
        StringBuilder st = new StringBuilder("Solution: ");
        block5: for (Variable var : this.varsToStore) {
            if ((var.getTypeAndKind() & 7) == 2) continue;
            int kind = var.getTypeAndKind() & 0x3F8;
            switch (kind) {
                case 8: 
                case 24: {
                    IntVar v = (IntVar)var;
                    st.append(v.getName()).append("=").append(this.intmap.get(v.getId())).append(", ");
                    continue block5;
                }
                case 64: {
                    RealVar r = (RealVar)var;
                    double[] bounds = this.realmap.get(r.getId());
                    st.append(r.getName()).append("=[").append(bounds[0]).append(",").append(bounds[1]).append("], ");
                    continue block5;
                }
                case 32: {
                    SetVar s2 = (SetVar)var;
                    st.append(s2.getName()).append("=").append(Arrays.toString(this.setmap.get(s2.getId()))).append(", ");
                    continue block5;
                }
            }
        }
        return st.toString();
    }

    public Solution copySolution() {
        Solution ret = new Solution(this.model, this.varsToStore);
        ret.empty = this.empty;
        if (this.intmap != null) {
            ret.intmap = new TIntIntHashMap(this.intmap);
        }
        if (this.realmap != null) {
            ret.realmap = new TIntObjectHashMap<double[]>(this.realmap);
        }
        if (this.setmap != null) {
            ret.setmap = new TIntObjectHashMap<int[]>(this.setmap);
        }
        return ret;
    }

    public int getIntVal(IntVar v) {
        if (this.empty) {
            throw new SolverException("Cannot access value of " + v + ": No solution has been recorded yet (empty solution). Make sure this.record() has been called.");
        }
        if (this.intmap != null && this.intmap.containsKey(v.getId())) {
            return this.intmap.get(v.getId());
        }
        if ((v.getTypeAndKind() & 7) == 2) {
            return v.getValue();
        }
        throw new SolverException("Cannot access value of " + v + ": This variable has not been declared to be recorded in the Solution object (see Solution constructor).");
    }

    public void setIntVal(IntVar var, int val) {
        this.empty = false;
        if (this.intmap == null) {
            this.intmap = new TIntIntHashMap(16, 0.5f, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        this.intmap.put(var.getId(), val);
    }

    public int[] getSetVal(SetVar s2) {
        if (this.empty) {
            throw new SolverException("Cannot access value of " + s2 + ": No solution has been recorded yet (empty solution). Make sure this.record() has been called.");
        }
        if (this.setmap != null && this.setmap.containsKey(s2.getId())) {
            return this.setmap.get(s2.getId());
        }
        if ((s2.getTypeAndKind() & 7) == 2) {
            return s2.getValue().toArray();
        }
        throw new SolverException("Cannot access value of " + s2 + ": This variable has not been declared to be recorded in the Solution object (see Solution constructor).");
    }

    public void setSetVal(SetVar var, int[] val) {
        this.empty = false;
        if (this.setmap == null) {
            this.setmap = new TIntObjectHashMap(16, 5.0f, Integer.MAX_VALUE);
        }
        this.setmap.put(var.getId(), val);
    }

    public double[] getRealBounds(RealVar r) {
        if (this.empty) {
            throw new SolverException("Cannot access value of " + r + ": No solution has been recorded yet (empty solution). Make sure this.record() has been called.");
        }
        if (this.realmap != null && this.realmap.containsKey(r.getId())) {
            return this.realmap.get(r.getId());
        }
        if ((r.getTypeAndKind() & 7) == 2) {
            return new double[]{r.getLB(), r.getUB()};
        }
        throw new SolverException("Cannot access value of " + r + ": This variable has not been declared to be recorded in the Solution object (see Solution constructor).");
    }

    public void setRealBounds(RealVar var, double[] val) {
        this.empty = false;
        if (this.realmap == null) {
            this.realmap = new TIntObjectHashMap(16, 5.0f, Integer.MAX_VALUE);
        }
        if (val.length != 2) {
            throw new SolverException("wrong array size");
        }
        this.realmap.put(var.getId(), val);
    }

    public void restore() throws ContradictionException {
        block5: for (Variable var : this.varsToStore) {
            if ((var.getTypeAndKind() & 7) == 2) continue;
            int kind = var.getTypeAndKind() & 0x3F8;
            switch (kind) {
                case 8: 
                case 24: {
                    IntVar v = (IntVar)var;
                    v.instantiateTo(this.intmap.get(v.getId()), this);
                    continue block5;
                }
                case 64: {
                    RealVar r = (RealVar)var;
                    double[] bounds = this.realmap.get(r.getId());
                    r.updateBounds(bounds[0], bounds[1], this);
                    continue block5;
                }
                case 32: {
                    SetVar s2 = (SetVar)var;
                    s2.instantiateTo(this.setmap.get(s2.getId()), this);
                    continue block5;
                }
            }
        }
        this.model.getSolver().propagate();
    }

    public boolean exists() {
        return !this.empty;
    }

    public List<IntVar> retrieveIntVars(boolean includeBoolVar) {
        ArrayList<IntVar> ivars = new ArrayList<IntVar>();
        for (int i = 0; i < this.varsToStore.length; ++i) {
            int kind = this.varsToStore[i].getTypeAndKind() & 0x3F8;
            if (kind != 8 && (!includeBoolVar || kind != 24)) continue;
            ivars.add((IntVar)this.varsToStore[i]);
        }
        return ivars;
    }

    public List<BoolVar> retrieveBoolVars() {
        ArrayList<BoolVar> bvars = new ArrayList<BoolVar>();
        boolean k = false;
        for (int i = 0; i < this.varsToStore.length; ++i) {
            if ((this.varsToStore[i].getTypeAndKind() & 0x3F8) != 24) continue;
            bvars.add((BoolVar)this.varsToStore[i]);
        }
        return bvars;
    }

    public List<SetVar> retrieveSetVars() {
        ArrayList<SetVar> svars = new ArrayList<SetVar>();
        for (int i = 0; i < this.varsToStore.length; ++i) {
            if ((this.varsToStore[i].getTypeAndKind() & 0x3F8) != 32) continue;
            svars.add((SetVar)this.varsToStore[i]);
        }
        return svars;
    }

    public List<RealVar> retrieveRealVars() {
        ArrayList<RealVar> rvars = new ArrayList<RealVar>();
        for (int i = 0; i < this.varsToStore.length; ++i) {
            if ((this.varsToStore[i].getTypeAndKind() & 0x3F8) != 64) continue;
            rvars.add((RealVar)this.varsToStore[i]);
        }
        return rvars;
    }
}

