/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.assignments.GraphDecisionOperator;
import org.chocosolver.solver.search.strategy.decision.GraphDecision;
import org.chocosolver.solver.search.strategy.selectors.values.graph.priority.GraphEdgesOnly;
import org.chocosolver.solver.search.strategy.selectors.values.graph.priority.GraphNodeOrEdgeSelector;
import org.chocosolver.solver.search.strategy.strategy.GraphStrategy;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class GraphCostBasedSearch
extends GraphStrategy {
    public static final int LEX = 0;
    public static final int MIN_P_DEGREE = 1;
    public static final int MAX_P_DEGREE = 2;
    public static final int MIN_M_DEGREE = 3;
    public static final int MAX_M_DEGREE = 4;
    public static final int MIN_DELTA_DEGREE = 5;
    public static final int MAX_DELTA_DEGREE = 6;
    public static final int MIN_COST = 7;
    public static final int MAX_COST = 8;
    private final int n;
    private int mode;
    private final int[][] costs;
    private GraphDecisionOperator decisionType;
    private int from;
    private int to;
    private int value;
    private boolean useLC;
    private int lastFrom = -1;
    private final GraphVar g;

    public GraphCostBasedSearch(GraphVar graphVar) {
        this(graphVar, (int[][])null);
    }

    public GraphCostBasedSearch(GraphVar graphVar, int[][] costMatrix) {
        super(new GraphVar[]{graphVar}, null, (GraphNodeOrEdgeSelector)new GraphEdgesOnly(), null, null, true);
        this.costs = costMatrix;
        this.g = graphVar;
        this.n = this.g.getNbMaxNodes();
    }

    public GraphCostBasedSearch configure(int policy) {
        return this.configure(policy, true);
    }

    public GraphCostBasedSearch configure(int policy, boolean enforce) {
        this.decisionType = enforce ? DecisionOperatorFactory.makeGraphEnforce() : DecisionOperatorFactory.makeGraphRemove();
        this.mode = policy;
        return this;
    }

    public GraphCostBasedSearch useLastConflict() {
        this.useLC = true;
        return this;
    }

    public GraphDecision getDecision() {
        if (this.g.isInstantiated()) {
            return null;
        }
        this.computeNextArc();
        GraphDecision<GraphVar> dec = this.g.getModel().getSolver().getDecisionPath().makeGraphEdgeDecision(this.g, this.decisionType, this.from, this.to);
        this.lastFrom = this.from;
        return dec;
    }

    private void computeNextArc() {
        this.to = -1;
        this.from = -1;
        if (this.useLC && this.lastFrom != -1) {
            this.evaluateNeighbors(this.lastFrom);
            if (this.to != -1) {
                return;
            }
        }
        for (int i = 0; i < this.n; ++i) {
            if (!this.evaluateNeighbors(i)) continue;
            return;
        }
        if (this.to == -1) {
            throw new UnsupportedOperationException();
        }
    }

    private boolean evaluateNeighbors(int i) {
        ISet set = this.g.getPotentialSuccessorsOf(i);
        if (set.size() == this.g.getMandatorySuccessorsOf(i).size()) {
            return false;
        }
        ISetIterator iSetIterator = set.iterator();
        while (iSetIterator.hasNext()) {
            int j = (Integer)iSetIterator.next();
            if (this.g.getMandatorySuccessorsOf(i).contains(j)) continue;
            int v = -1;
            switch (this.mode) {
                case 0: {
                    this.from = i;
                    this.to = j;
                    return true;
                }
                case 1: 
                case 2: {
                    v = this.g.getPotentialSuccessorsOf(i).size() + this.g.getPotentialPredecessorOf(j).size();
                    break;
                }
                case 3: 
                case 4: {
                    v = this.g.getMandatorySuccessorsOf(i).size() + this.g.getMandatoryPredecessorsOf(j).size();
                    break;
                }
                case 5: 
                case 6: {
                    v = this.g.getPotentialSuccessorsOf(i).size() + this.g.getPotentialPredecessorOf(j).size() - this.g.getMandatorySuccessorsOf(i).size() - this.g.getMandatoryPredecessorsOf(j).size();
                    break;
                }
                case 7: 
                case 8: {
                    v = this.costs[i][j];
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("mode " + this.mode + " does not exist");
                }
            }
            if (!this.select(v)) continue;
            this.value = v;
            this.from = i;
            this.to = j;
        }
        return false;
    }

    private boolean select(double v) {
        return this.from == -1 || v < (double)this.value && GraphCostBasedSearch.isMinOrIn(this.mode) || v > (double)this.value && !GraphCostBasedSearch.isMinOrIn(this.mode);
    }

    private static boolean isMinOrIn(int policy) {
        return policy % 2 == 1;
    }
}

