/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.graph.directed;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.DirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.view.delta.GraphUnionViewDeltaMonitor;
import org.chocosolver.solver.variables.view.graph.DirectedGraphView;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.graphs.GraphFactory;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class DirectedGraphUnionView
extends DirectedGraphView<DirectedGraphVar> {
    protected DirectedGraph lb;
    protected DirectedGraph ub;
    protected ISet nodesToEnforce;
    protected ISet[] edgesToEnforce;

    public DirectedGraphUnionView(String name, DirectedGraphVar ... graphs) {
        super(name, (Variable[])graphs);
        int i;
        DirectedGraph[] LBs = new DirectedGraph[graphs.length];
        DirectedGraph[] UBs = new DirectedGraph[graphs.length];
        for (i = 0; i < graphs.length; ++i) {
            LBs[i] = (DirectedGraph)graphs[i].getLB();
            UBs[i] = (DirectedGraph)graphs[i].getUB();
        }
        this.ub = GraphFactory.makeUnionGraph(this.getModel(), UBs);
        this.nodesToEnforce = SetFactory.makeStoredSet(SetType.BITSET, 0, this.getModel());
        this.edgesToEnforce = new ISet[this.getNbMaxNodes()];
        for (i = 0; i < this.getNbMaxNodes(); ++i) {
            this.edgesToEnforce[i] = SetFactory.makeStoredSet(SetType.BITSET, 0, this.getModel());
        }
        this.lb = new DirectedGraph(this.getModel(), this.nodesToEnforce, this.edgesToEnforce, LBs);
    }

    @Override
    protected boolean doRemoveNode(int node) throws ContradictionException {
        if (this.nodesToEnforce.contains(node)) {
            this.contradiction(this, "Try to remove mandatory node");
        }
        boolean b2 = false;
        for (DirectedGraphVar g2 : (DirectedGraphVar[])this.variables) {
            b2 |= g2.removeNode(node, this);
        }
        return b2;
    }

    @Override
    protected boolean doEnforceNode(int node) throws ContradictionException {
        int nb = 0;
        int idx = -1;
        for (int i = 0; i < ((DirectedGraphVar[])this.variables).length; ++i) {
            if (!((DirectedGraphVar[])this.variables)[i].getPotentialNodes().contains(node)) continue;
            idx = i;
            if (++nb > 1) break;
        }
        if (nb == 1) {
            ((DirectedGraphVar[])this.variables)[idx].enforceNode(node, this);
            return true;
        }
        this.nodesToEnforce.add(node);
        return false;
    }

    @Override
    protected boolean doRemoveEdge(int from, int to) throws ContradictionException {
        if (this.edgesToEnforce[from].contains(to)) {
            this.contradiction(this, "Try to remove mandatory edge");
        }
        boolean b2 = false;
        for (DirectedGraphVar g2 : (DirectedGraphVar[])this.variables) {
            b2 |= g2.removeEdge(from, to, this);
        }
        return b2;
    }

    @Override
    protected boolean doEnforceEdge(int from, int to) throws ContradictionException {
        int nb = 0;
        int idx = -1;
        for (int i = 0; i < ((DirectedGraphVar[])this.variables).length; ++i) {
            if (!((DirectedGraph)((DirectedGraphVar[])this.variables)[i].getUB()).containsEdge(from, to)) continue;
            idx = i;
            if (++nb > 1) break;
        }
        if (nb == 1) {
            ((DirectedGraphVar[])this.variables)[idx].enforceEdge(from, to, this);
            return true;
        }
        this.edgesToEnforce[from].add(to);
        return false;
    }

    @Override
    public void notify(IEventType event, int variableIdx) throws ContradictionException {
        int i;
        if ((event.getMask() & GraphEventType.REMOVE_NODE.getMask()) > 0) {
            ISetIterator iSetIterator = this.nodesToEnforce.iterator();
            while (iSetIterator.hasNext()) {
                i = (Integer)iSetIterator.next();
                if (!this.doEnforceNode(i)) continue;
                this.nodesToEnforce.remove(i);
                break;
            }
        }
        if ((event.getMask() & GraphEventType.REMOVE_EDGE.getMask()) > 0) {
            boolean b2 = false;
            for (i = 0; i < this.edgesToEnforce.length; ++i) {
                ISetIterator iSetIterator = this.edgesToEnforce[i].iterator();
                while (iSetIterator.hasNext()) {
                    int j = (Integer)iSetIterator.next();
                    if (!this.doEnforceEdge(i, j)) continue;
                    this.edgesToEnforce[i].remove(j);
                    b2 = true;
                    break;
                }
                if (b2) break;
            }
        }
        this.notifyPropagators(event, this);
    }

    @Override
    public DirectedGraph getLB() {
        return this.lb;
    }

    @Override
    public DirectedGraph getUB() {
        return this.ub;
    }

    @Override
    public int getNbMaxNodes() {
        return this.ub.getNbMaxNodes();
    }

    @Override
    public IGraphDeltaMonitor monitorDelta(ICause propagator) {
        IGraphDeltaMonitor[] deltaMonitors = new IGraphDeltaMonitor[((DirectedGraphVar[])this.variables).length];
        for (int i = 0; i < ((DirectedGraphVar[])this.variables).length; ++i) {
            deltaMonitors[i] = ((DirectedGraphVar[])this.variables)[i].monitorDelta(propagator);
        }
        return new GraphUnionViewDeltaMonitor(this, deltaMonitors);
    }
}

