/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;

public class StoredSparseSet {
    private int[] sparse;
    private int[] dense;
    private final IStateInt members;

    public StoredSparseSet(IEnvironment environment) {
        this.members = environment.makeInt(0);
        this.sparse = new int[16];
        this.dense = new int[16];
    }

    public boolean contains(int k) {
        if (k < this.sparse.length) {
            int a2 = this.sparse[k];
            return a2 < this.members.get() && this.dense[a2] == k;
        }
        return false;
    }

    public void add(int k) {
        this.ensureCapacity(k + 1);
        int a2 = this.sparse[k];
        int b2 = this.members.get();
        if (a2 >= b2 || this.dense[a2] != k) {
            this.sparse[k] = b2;
            this.dense[b2] = k;
            this.members.set(b2 + 1);
        }
    }

    private void ensureCapacity(int k) {
        if (k > this.sparse.length) {
            int[] tmp = this.sparse;
            int nsize = Math.max(k + 1, tmp.length * 3 / 2 + 1);
            this.sparse = new int[nsize];
            this.sparse = new int[nsize];
            System.arraycopy(tmp, 0, this.sparse, 0, tmp.length);
            tmp = this.dense;
            this.dense = new int[nsize];
            System.arraycopy(tmp, 0, this.dense, 0, tmp.length);
        }
    }
}

