/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Predicate;

public class ValueSortedMap<E> {
    private static final int NO_ENTRY = -1;
    TObjectIntHashMap<E> map = new TObjectIntHashMap(16, 0.5f, -1);
    TreeMap<Integer, E> rmap = new TreeMap();

    public void clear() {
        this.map.clear();
        this.rmap.clear();
    }

    public void put(E k, int v) {
        if (this.map.containsKey(k)) {
            this.replace(k, v);
        } else {
            this.map.put(k, v);
            this.rmap.put(v, k);
        }
    }

    public void replace(E k, int v) {
        int cValue = this.map.get(k);
        assert (cValue != -1);
        int amount = v - cValue;
        if (amount != 0) {
            this.map.adjustValue(k, amount);
            this.rmap.remove(cValue);
            this.rmap.put(v, k);
        }
        assert (this.rmap.get(this.map.get(k)) == k);
        assert (this.map.get(this.rmap.get(v)) == v);
    }

    public int getValue(E k) {
        return this.map.get(k);
    }

    public int getValueOrDefault(E k, int defaultValue) {
        int value = this.map.get(k);
        if (value == -1) {
            return defaultValue;
        }
        return value;
    }

    public int getLastValue() {
        return this.rmap.lastKey();
    }

    public int getLowerValue(int value) {
        Integer low = this.rmap.lowerKey(value);
        if (low == null) {
            low = -1;
        }
        return low;
    }

    public int pollLastValue() {
        Map.Entry<Integer, E> last = this.rmap.pollLastEntry();
        this.map.remove(last.getValue());
        return last.getKey();
    }

    public void remove(E k) {
        this.rmap.remove(this.map.remove(k));
    }

    public boolean removeIf(Predicate<? super E> filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        Iterator<E> each = this.map.keySet().iterator();
        while (each.hasNext()) {
            E e2 = each.next();
            if (!filter.test(e2)) continue;
            int value = this.map.get(e2);
            each.remove();
            this.rmap.remove(value);
            removed = true;
        }
        return removed;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

