/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.tree;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import org.chocosolver.util.objects.tree.Interval;

public class IntervalTree<T extends Interval>
implements Iterable<T> {
    private Node root;
    private final Node nil;
    private int size;

    public IntervalTree() {
        this.root = this.nil = new Node();
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.root.isNil();
    }

    public int size() {
        return this.size;
    }

    private Node search(T t) {
        return this.root.search(t);
    }

    public boolean contains(T t) {
        return !this.search(t).isNil();
    }

    public T get(int s2, int e2) {
        Node nod = this.root.search(s2, e2);
        if (!nod.isNil()) {
            return nod.interval();
        }
        return null;
    }

    public Optional<T> minimum() {
        Node n = this.root.minimumNode();
        return n.isNil() ? Optional.empty() : Optional.of(n.interval());
    }

    public Optional<T> maximum() {
        Node n = this.root.maximumNode();
        return n.isNil() ? Optional.empty() : Optional.of(n.interval());
    }

    @Override
    public Iterator<T> iterator() {
        return new TreeIterator(this.root);
    }

    public Iterator<T> overlappers(int start, int end) {
        return this.root.overlappers(start, end);
    }

    public void forAllBelow(int lb, Consumer<T> ex) {
        Node n = this.root.minimumNode();
        while (!n.isNil() && n.interval.overlaps(Integer.MIN_VALUE, lb + 1)) {
            ex.accept(n.interval);
            n = n.successor();
        }
    }

    public void forAllAbove(int ub, Consumer<T> ex) {
        Node n = this.root.maximumNode();
        while (!n.isNil() && n.interval.overlaps(ub - 1, Integer.MAX_VALUE)) {
            ex.accept(n.interval);
            n = n.predecessor();
        }
    }

    public boolean insert(T t) {
        int cmp;
        Node z = new Node(this, t);
        Node y = this.nil;
        Node x = this.root;
        while (!x.isNil()) {
            y = x;
            x.maxEnd = Math.max(x.maxEnd, z.maxEnd);
            cmp = z.compareTo(x);
            if (cmp == 0) {
                return false;
            }
            x = cmp < 0 ? x.left : x.right;
        }
        z.parent = y;
        if (y.isNil()) {
            this.root = z;
            this.root.blacken();
        } else {
            cmp = z.compareTo(y);
            if (cmp < 0) {
                y.left = z;
            } else {
                assert (cmp > 0);
                y.right = z;
            }
            z.left = this.nil;
            z.right = this.nil;
            z.redden();
            z.insertFixup();
        }
        ++this.size;
        return true;
    }

    public boolean delete(T t) {
        return this.search(t).delete();
    }

    private boolean isBST() {
        return this.root.isBST(null, null);
    }

    private boolean isBalanced() {
        int black = 0;
        Node x = this.root;
        while (!x.isNil()) {
            if (x.isBlack) {
                ++black;
            }
            x = x.left;
        }
        return this.root.isBalanced(black);
    }

    private boolean hasValidRedColoring() {
        return this.root.hasValidRedColoring();
    }

    private boolean hasConsistentMaxEnds() {
        return this.root.hasConsistentMaxEnds();
    }

    private static class OverlapperIterator
    implements Iterator<T> {
        private final Iterator<Node> nodeIter;
        final /* synthetic */ IntervalTree this$0;

        private OverlapperIterator(Node root, T t) {
            this.this$0 = var1_1;
            this.nodeIter = new OverlappingNodeIterator(var1_1, root, (Interval)t);
        }

        private OverlapperIterator(IntervalTree intervalTree, Node root, int start, int end) {
            this.this$0 = intervalTree;
            this.nodeIter = intervalTree.new OverlappingNodeIteratorBound(root, start, end);
        }

        @Override
        public boolean hasNext() {
            return this.nodeIter.hasNext();
        }

        @Override
        public T next() {
            return this.nodeIter.next().interval;
        }
    }

    private static class OverlappingNodeIterator
    implements Iterator<Node> {
        private Node next;
        private final T interval;
        final /* synthetic */ IntervalTree this$0;

        private OverlappingNodeIterator(Node root, T t) {
            this.this$0 = var1_1;
            this.interval = t;
            this.next = root.minimumOverlappingNode(this.interval);
        }

        @Override
        public boolean hasNext() {
            return !this.next.isNil();
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Interval tree has no more overlapping elements.");
            }
            Node rtrn = this.next;
            this.next = rtrn.nextOverlappingNode(this.interval);
            return rtrn;
        }
    }

    private class OverlappingNodeIteratorBound
    implements Iterator<Node> {
        private Node next;
        private final int start;
        private final int end;

        private OverlappingNodeIteratorBound(Node root, int start, int end) {
            this.start = start;
            this.end = end;
            this.next = root.minimumOverlappingNode(start, end);
        }

        @Override
        public boolean hasNext() {
            return !this.next.isNil();
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Interval tree has no more overlapping elements.");
            }
            Node rtrn = this.next;
            this.next = rtrn.nextOverlappingNode(this.start, this.end);
            return rtrn;
        }
    }

    private class TreeIterator
    implements Iterator<T> {
        private final TreeNodeIterator nodeIter;

        private TreeIterator(Node root) {
            this.nodeIter = new TreeNodeIterator(root);
        }

        @Override
        public boolean hasNext() {
            return this.nodeIter.hasNext();
        }

        @Override
        public T next() {
            return this.nodeIter.next().interval;
        }
    }

    private class TreeNodeIterator
    implements Iterator<Node> {
        private Node next;

        private TreeNodeIterator(Node root) {
            this.next = root.minimumNode();
        }

        @Override
        public boolean hasNext() {
            return !this.next.isNil();
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Interval tree has no more elements.");
            }
            Node rtrn = this.next;
            this.next = rtrn.successor();
            return rtrn;
        }
    }

    private class Node
    implements Interval {
        private T interval;
        private Node parent;
        private Node left;
        private Node right;
        private boolean isBlack;
        private int maxEnd;

        private Node() {
            this.parent = this;
            this.left = this;
            this.right = this;
            this.blacken();
        }

        public Node(T interval) {
            this.interval = interval;
            this.parent = ((IntervalTree)IntervalTree.this).nil;
            this.left = ((IntervalTree)IntervalTree.this).nil;
            this.right = ((IntervalTree)IntervalTree.this).nil;
            this.maxEnd = interval.end();
            this.redden();
        }

        public T interval() {
            return this.interval;
        }

        @Override
        public int start() {
            return this.interval.start();
        }

        @Override
        public int end() {
            return this.interval.end();
        }

        private Node search(T t) {
            Node n = this;
            while (!n.isNil() && t.compareTo(n) != 0) {
                n = t.compareTo(n) < 0 ? n.left : n.right;
            }
            return n;
        }

        private Node search(int s2, int e2) {
            int c2;
            Node n = this;
            while (!n.isNil() && (c2 = n.compareTo(s2, e2)) != 0) {
                n = c2 > 0 ? n.left : n.right;
            }
            return n;
        }

        private Node minimumNode() {
            Node n = this;
            while (!n.left.isNil()) {
                n = n.left;
            }
            return n;
        }

        private Node maximumNode() {
            Node n = this;
            while (!n.right.isNil()) {
                n = n.right;
            }
            return n;
        }

        private Node successor() {
            if (!this.right.isNil()) {
                return this.right.minimumNode();
            }
            Node x = this;
            Node y = this.parent;
            while (!y.isNil() && x == y.right) {
                x = y;
                y = y.parent;
            }
            return y;
        }

        private Node predecessor() {
            if (!this.left.isNil()) {
                return this.left.maximumNode();
            }
            Node x = this;
            Node y = this.parent;
            while (!y.isNil() && x == y.left) {
                x = y;
                y = y.parent;
            }
            return y;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Node minimumOverlappingNode(int start, int end) {
            Node result = IntervalTree.this.nil;
            Node n = this;
            if (n.isNil() || n.maxEnd <= start) return result;
            while (true) {
                if (n.overlaps(start, end)) {
                    result = n;
                    n = n.left;
                    if (!n.isNil() && n.maxEnd > start) continue;
                    return result;
                }
                Node left = n.left;
                if (!left.isNil() && left.maxEnd > start) {
                    n = left;
                    continue;
                }
                if (n.start() >= end || (n = n.right).isNil() || n.maxEnd <= start) return result;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Node minimumOverlappingNode(T t) {
            Node result = IntervalTree.this.nil;
            Node n = this;
            if (n.isNil() || n.maxEnd <= t.start()) return result;
            while (true) {
                if (n.overlaps((Interval)t)) {
                    result = n;
                    n = n.left;
                    if (!n.isNil() && n.maxEnd > t.start()) continue;
                    return result;
                }
                Node left = n.left;
                if (!left.isNil() && left.maxEnd > t.start()) {
                    n = left;
                    continue;
                }
                if (n.start() >= t.end() || (n = n.right).isNil() || n.maxEnd <= t.start()) return result;
            }
        }

        private Iterator<T> overlappers(int start, int end) {
            return new OverlapperIterator(IntervalTree.this, this, start, end);
        }

        private Node nextOverlappingNode(int start, int end) {
            Node x = this;
            Node rtrn = IntervalTree.this.nil;
            if (!this.right.isNil()) {
                rtrn = x.right.minimumOverlappingNode(start, end);
            }
            while (!x.parent.isNil() && rtrn.isNil()) {
                if (x.isLeftChild()) {
                    rtrn = x.parent.overlaps(start, end) ? x.parent : x.parent.right.minimumOverlappingNode(start, end);
                }
                x = x.parent;
            }
            return rtrn;
        }

        private Node nextOverlappingNode(T t) {
            Node x = this;
            Node rtrn = IntervalTree.this.nil;
            if (!this.right.isNil()) {
                rtrn = x.right.minimumOverlappingNode(t);
            }
            while (!x.parent.isNil() && rtrn.isNil()) {
                if (x.isLeftChild()) {
                    rtrn = x.parent.overlaps((Interval)t) ? x.parent : x.parent.right.minimumOverlappingNode(t);
                }
                x = x.parent;
            }
            return rtrn;
        }

        private boolean delete() {
            if (this.isNil()) {
                return false;
            }
            Node y = this;
            if (this.hasTwoChildren()) {
                y = this.successor();
                this.copyData(y);
                this.maxEndFixup();
            }
            Node x = y.left.isNil() ? y.right : y.left;
            x.parent = y.parent;
            if (y.isRoot()) {
                IntervalTree.this.root = x;
            } else if (y.isLeftChild()) {
                y.parent.left = x;
                y.maxEndFixup();
            } else {
                y.parent.right = x;
                y.maxEndFixup();
            }
            if (y.isBlack) {
                x.deleteFixup();
            }
            IntervalTree.this.size--;
            return true;
        }

        public boolean isRoot() {
            return !this.isNil() && this.parent.isNil();
        }

        public boolean isNil() {
            return this == IntervalTree.this.nil;
        }

        public boolean isLeftChild() {
            return this == this.parent.left;
        }

        public boolean isRightChild() {
            return this == this.parent.right;
        }

        public boolean hasNoChildren() {
            return this.left.isNil() && this.right.isNil();
        }

        public boolean hasTwoChildren() {
            return !this.left.isNil() && !this.right.isNil();
        }

        private void blacken() {
            this.isBlack = true;
        }

        private void redden() {
            this.isBlack = false;
        }

        public boolean isRed() {
            return !this.isBlack;
        }

        private Node grandparent() {
            return this.parent.parent;
        }

        private void resetMaxEnd() {
            int val = this.interval.end();
            if (!this.left.isNil()) {
                val = Math.max(val, this.left.maxEnd);
            }
            if (!this.right.isNil()) {
                val = Math.max(val, this.right.maxEnd);
            }
            this.maxEnd = val;
        }

        private void maxEndFixup() {
            Node n = this;
            n.resetMaxEnd();
            while (!n.parent.isNil()) {
                n = n.parent;
                n.resetMaxEnd();
            }
        }

        private void leftRotate() {
            Node y = this.right;
            this.right = y.left;
            if (!y.left.isNil()) {
                y.left.parent = this;
            }
            y.parent = this.parent;
            if (this.parent.isNil()) {
                IntervalTree.this.root = y;
            } else if (this.isLeftChild()) {
                this.parent.left = y;
            } else {
                this.parent.right = y;
            }
            y.left = this;
            this.parent = y;
            this.resetMaxEnd();
            y.resetMaxEnd();
        }

        private void rightRotate() {
            Node y = this.left;
            this.left = y.right;
            if (!y.right.isNil()) {
                y.right.parent = this;
            }
            y.parent = this.parent;
            if (this.parent.isNil()) {
                IntervalTree.this.root = y;
            } else if (this.isLeftChild()) {
                this.parent.left = y;
            } else {
                this.parent.right = y;
            }
            y.right = this;
            this.parent = y;
            this.resetMaxEnd();
            y.resetMaxEnd();
        }

        private void copyData(Node o) {
            this.interval = o.interval;
        }

        public String toString() {
            if (this.isNil()) {
                return "nil";
            }
            String color = this.isBlack ? "black" : "red";
            return "start = " + this.start() + "\nend = " + this.end() + "\nmaxEnd = " + this.maxEnd + "\ncolor = " + color;
        }

        private void insertFixup() {
            Node z = this;
            while (z.parent.isRed()) {
                Node y;
                if (z.parent.isLeftChild()) {
                    y = z.parent.parent.right;
                    if (y.isRed()) {
                        z.parent.blacken();
                        y.blacken();
                        z.grandparent().redden();
                        z = z.grandparent();
                        continue;
                    }
                    if (z.isRightChild()) {
                        z = z.parent;
                        z.leftRotate();
                    }
                    z.parent.blacken();
                    z.grandparent().redden();
                    z.grandparent().rightRotate();
                    continue;
                }
                y = z.grandparent().left;
                if (y.isRed()) {
                    z.parent.blacken();
                    y.blacken();
                    z.grandparent().redden();
                    z = z.grandparent();
                    continue;
                }
                if (z.isLeftChild()) {
                    z = z.parent;
                    z.rightRotate();
                }
                z.parent.blacken();
                z.grandparent().redden();
                z.grandparent().leftRotate();
            }
            IntervalTree.this.root.blacken();
        }

        private void deleteFixup() {
            Node x = this;
            while (!x.isRoot() && x.isBlack) {
                Node w;
                if (x.isLeftChild()) {
                    w = x.parent.right;
                    if (w.isRed()) {
                        w.blacken();
                        x.parent.redden();
                        x.parent.leftRotate();
                        w = x.parent.right;
                    }
                    if (w.left.isBlack && w.right.isBlack) {
                        w.redden();
                        x = x.parent;
                        continue;
                    }
                    if (w.right.isBlack) {
                        w.left.blacken();
                        w.redden();
                        w.rightRotate();
                        w = x.parent.right;
                    }
                    w.isBlack = x.parent.isBlack;
                    x.parent.blacken();
                    w.right.blacken();
                    x.parent.leftRotate();
                    x = IntervalTree.this.root;
                    continue;
                }
                w = x.parent.left;
                if (w.isRed()) {
                    w.blacken();
                    x.parent.redden();
                    x.parent.rightRotate();
                    w = x.parent.left;
                }
                if (w.left.isBlack && w.right.isBlack) {
                    w.redden();
                    x = x.parent;
                    continue;
                }
                if (w.left.isBlack) {
                    w.right.blacken();
                    w.redden();
                    w.leftRotate();
                    w = x.parent.left;
                }
                w.isBlack = x.parent.isBlack;
                x.parent.blacken();
                w.left.blacken();
                x.parent.rightRotate();
                x = IntervalTree.this.root;
            }
            x.blacken();
        }

        private boolean isBST(Node min2, Node max) {
            if (this.isNil()) {
                return true;
            }
            if (min2 != null && this.compareTo(min2) <= 0) {
                return false;
            }
            if (max != null && this.compareTo(max) >= 0) {
                return false;
            }
            return this.left.isBST(min2, this) && this.right.isBST(this, max);
        }

        private boolean isBalanced(int black) {
            if (this.isNil()) {
                return black == 0;
            }
            if (this.isBlack) {
                --black;
            }
            return this.left.isBalanced(black) && this.right.isBalanced(black);
        }

        private boolean hasValidRedColoring() {
            if (this.isNil()) {
                return true;
            }
            if (this.isBlack) {
                return this.left.hasValidRedColoring() && this.right.hasValidRedColoring();
            }
            return this.left.isBlack && this.right.isBlack && this.left.hasValidRedColoring() && this.right.hasValidRedColoring();
        }

        private boolean hasConsistentMaxEnds() {
            boolean consistent;
            if (this.isNil()) {
                return true;
            }
            if (this.hasNoChildren()) {
                return this.maxEnd == this.end();
            }
            boolean bl = consistent = this.maxEnd >= this.end();
            if (this.hasTwoChildren()) {
                return consistent && this.maxEnd >= this.left.maxEnd && this.maxEnd >= this.right.maxEnd && this.left.hasConsistentMaxEnds() && this.right.hasConsistentMaxEnds();
            }
            if (this.left.isNil()) {
                return consistent && this.maxEnd >= this.right.maxEnd && this.right.hasConsistentMaxEnds();
            }
            return consistent && this.maxEnd >= this.left.maxEnd && this.left.hasConsistentMaxEnds();
        }
    }
}

