/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.block;

import org.ejml.data.DSubmatrixD1;
import org.ejml.dense.block.InnerMultiplication_DDRB;
import org.ejml.dense.block.MatrixOps_DDRB;

public class MatrixMult_DDRB {
    public static void mult(int blockLength, DSubmatrixD1 A2, DSubmatrixD1 B, DSubmatrixD1 C2) {
        for (int i = A2.row0; i < A2.row1; i += blockLength) {
            int heightA = Math.min(blockLength, A2.row1 - i);
            for (int j = B.col0; j < B.col1; j += blockLength) {
                int widthB = Math.min(blockLength, B.col1 - j);
                int indexC = (i - A2.row0 + C2.row0) * C2.original.numCols + (j - B.col0 + C2.col0) * heightA;
                for (int k = A2.col0; k < A2.col1; k += blockLength) {
                    int widthA = Math.min(blockLength, A2.col1 - k);
                    int indexA = i * A2.original.numCols + k * heightA;
                    int indexB = (k - A2.col0 + B.row0) * B.original.numCols + j * widthA;
                    if (k == A2.col0) {
                        InnerMultiplication_DDRB.blockMultSet(A2.original.data, B.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                        continue;
                    }
                    InnerMultiplication_DDRB.blockMultPlus(A2.original.data, B.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                }
            }
        }
    }

    public static void multPlus(int blockLength, DSubmatrixD1 A2, DSubmatrixD1 B, DSubmatrixD1 C2) {
        for (int i = A2.row0; i < A2.row1; i += blockLength) {
            int heightA = Math.min(blockLength, A2.row1 - i);
            for (int j = B.col0; j < B.col1; j += blockLength) {
                int widthB = Math.min(blockLength, B.col1 - j);
                int indexC = (i - A2.row0 + C2.row0) * C2.original.numCols + (j - B.col0 + C2.col0) * heightA;
                for (int k = A2.col0; k < A2.col1; k += blockLength) {
                    int widthA = Math.min(blockLength, A2.col1 - k);
                    int indexA = i * A2.original.numCols + k * heightA;
                    int indexB = (k - A2.col0 + B.row0) * B.original.numCols + j * widthA;
                    InnerMultiplication_DDRB.blockMultPlus(A2.original.data, B.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                }
            }
        }
    }

    public static void multMinus(int blockLength, DSubmatrixD1 A2, DSubmatrixD1 B, DSubmatrixD1 C2) {
        MatrixMult_DDRB.checkInput(blockLength, A2, B, C2);
        for (int i = A2.row0; i < A2.row1; i += blockLength) {
            int heightA = Math.min(blockLength, A2.row1 - i);
            for (int j = B.col0; j < B.col1; j += blockLength) {
                int widthB = Math.min(blockLength, B.col1 - j);
                int indexC = (i - A2.row0 + C2.row0) * C2.original.numCols + (j - B.col0 + C2.col0) * heightA;
                for (int k = A2.col0; k < A2.col1; k += blockLength) {
                    int widthA = Math.min(blockLength, A2.col1 - k);
                    int indexA = i * A2.original.numCols + k * heightA;
                    int indexB = (k - A2.col0 + B.row0) * B.original.numCols + j * widthA;
                    InnerMultiplication_DDRB.blockMultMinus(A2.original.data, B.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                }
            }
        }
    }

    private static void checkInput(int blockLength, DSubmatrixD1 A2, DSubmatrixD1 B, DSubmatrixD1 C2) {
        int Arow = A2.getRows();
        int Acol = A2.getCols();
        int Brow = B.getRows();
        int Bcol = B.getCols();
        int Crow = C2.getRows();
        int Ccol = C2.getCols();
        if (Arow != Crow) {
            throw new RuntimeException("Mismatch A and C rows");
        }
        if (Bcol != Ccol) {
            throw new RuntimeException("Mismatch B and C columns");
        }
        if (Acol != Brow) {
            throw new RuntimeException("Mismatch A columns and B rows");
        }
        if (!MatrixOps_DDRB.blockAligned(blockLength, A2)) {
            throw new RuntimeException("Sub-Matrix A is not block aligned");
        }
        if (!MatrixOps_DDRB.blockAligned(blockLength, B)) {
            throw new RuntimeException("Sub-Matrix B is not block aligned");
        }
        if (!MatrixOps_DDRB.blockAligned(blockLength, C2)) {
            throw new RuntimeException("Sub-Matrix C is not block aligned");
        }
    }

    public static void multTransA(int blockLength, DSubmatrixD1 A2, DSubmatrixD1 B, DSubmatrixD1 C2) {
        for (int i = A2.col0; i < A2.col1; i += blockLength) {
            int widthA = Math.min(blockLength, A2.col1 - i);
            for (int j = B.col0; j < B.col1; j += blockLength) {
                int widthB = Math.min(blockLength, B.col1 - j);
                int indexC = (i - A2.col0 + C2.row0) * C2.original.numCols + (j - B.col0 + C2.col0) * widthA;
                for (int k = A2.row0; k < A2.row1; k += blockLength) {
                    int heightA = Math.min(blockLength, A2.row1 - k);
                    int indexA = k * A2.original.numCols + i * heightA;
                    int indexB = (k - A2.row0 + B.row0) * B.original.numCols + j * heightA;
                    if (k == A2.row0) {
                        InnerMultiplication_DDRB.blockMultSetTransA(A2.original.data, B.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                        continue;
                    }
                    InnerMultiplication_DDRB.blockMultPlusTransA(A2.original.data, B.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                }
            }
        }
    }

    public static void multPlusTransA(int blockLength, DSubmatrixD1 A2, DSubmatrixD1 B, DSubmatrixD1 C2) {
        for (int i = A2.col0; i < A2.col1; i += blockLength) {
            int widthA = Math.min(blockLength, A2.col1 - i);
            for (int j = B.col0; j < B.col1; j += blockLength) {
                int widthB = Math.min(blockLength, B.col1 - j);
                int indexC = (i - A2.col0 + C2.row0) * C2.original.numCols + (j - B.col0 + C2.col0) * widthA;
                for (int k = A2.row0; k < A2.row1; k += blockLength) {
                    int heightA = Math.min(blockLength, A2.row1 - k);
                    int indexA = k * A2.original.numCols + i * heightA;
                    int indexB = (k - A2.row0 + B.row0) * B.original.numCols + j * heightA;
                    InnerMultiplication_DDRB.blockMultPlusTransA(A2.original.data, B.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                }
            }
        }
    }

    public static void multMinusTransA(int blockLength, DSubmatrixD1 A2, DSubmatrixD1 B, DSubmatrixD1 C2) {
        for (int i = A2.col0; i < A2.col1; i += blockLength) {
            int widthA = Math.min(blockLength, A2.col1 - i);
            for (int j = B.col0; j < B.col1; j += blockLength) {
                int widthB = Math.min(blockLength, B.col1 - j);
                int indexC = (i - A2.col0 + C2.row0) * C2.original.numCols + (j - B.col0 + C2.col0) * widthA;
                for (int k = A2.row0; k < A2.row1; k += blockLength) {
                    int heightA = Math.min(blockLength, A2.row1 - k);
                    int indexA = k * A2.original.numCols + i * heightA;
                    int indexB = (k - A2.row0 + B.row0) * B.original.numCols + j * heightA;
                    InnerMultiplication_DDRB.blockMultMinusTransA(A2.original.data, B.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthB);
                }
            }
        }
    }

    public static void multTransB(int blockLength, DSubmatrixD1 A2, DSubmatrixD1 B, DSubmatrixD1 C2) {
        for (int i = A2.row0; i < A2.row1; i += blockLength) {
            int heightA = Math.min(blockLength, A2.row1 - i);
            for (int j = B.row0; j < B.row1; j += blockLength) {
                int widthC = Math.min(blockLength, B.row1 - j);
                int indexC = (i - A2.row0 + C2.row0) * C2.original.numCols + (j - B.row0 + C2.col0) * heightA;
                for (int k = A2.col0; k < A2.col1; k += blockLength) {
                    int widthA = Math.min(blockLength, A2.col1 - k);
                    int indexA = i * A2.original.numCols + k * heightA;
                    int indexB = j * B.original.numCols + (k - A2.col0 + B.col0) * widthC;
                    if (k == A2.col0) {
                        InnerMultiplication_DDRB.blockMultSetTransB(A2.original.data, B.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthC);
                        continue;
                    }
                    InnerMultiplication_DDRB.blockMultPlusTransB(A2.original.data, B.original.data, C2.original.data, indexA, indexB, indexC, heightA, widthA, widthC);
                }
            }
        }
    }
}

