/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.decomposition.qr;

import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.decomposition.qr.QrHelperFunctions_DDRM;
import org.ejml.interfaces.decomposition.QRDecomposition;

public class QRDecompositionHouseholder_DDRM
implements QRDecomposition<DMatrixRMaj> {
    protected DMatrixRMaj QR;
    protected double[] u;
    protected double[] v;
    protected int numCols;
    protected int numRows;
    protected int minLength;
    protected double[] dataQR;
    protected double[] gammas;
    protected double gamma;
    protected double tau;
    protected boolean error;

    public void setExpectedMaxSize(int numRows, int numCols) {
        this.error = false;
        this.numCols = numCols;
        this.numRows = numRows;
        this.minLength = Math.min(numRows, numCols);
        int maxLength = Math.max(numRows, numCols);
        if (this.QR == null) {
            this.QR = new DMatrixRMaj(numRows, numCols);
            this.u = new double[maxLength];
            this.v = new double[maxLength];
            this.gammas = new double[this.minLength];
        } else {
            this.QR.reshape(numRows, numCols, false);
        }
        this.dataQR = this.QR.data;
        if (this.u.length < maxLength) {
            this.u = new double[maxLength];
            this.v = new double[maxLength];
        }
        if (this.gammas.length < this.minLength) {
            this.gammas = new double[this.minLength];
        }
    }

    public DMatrixRMaj getQR() {
        return this.QR;
    }

    @Override
    public DMatrixRMaj getQ(DMatrixRMaj Q, boolean compact) {
        if (compact) {
            if (Q == null) {
                Q = CommonOps_DDRM.identity(this.numRows, this.minLength);
            } else {
                if (Q.numRows != this.numRows || Q.numCols != this.minLength) {
                    throw new IllegalArgumentException("Unexpected matrix dimension.");
                }
                CommonOps_DDRM.setIdentity(Q);
            }
        } else if (Q == null) {
            Q = CommonOps_DDRM.identity(this.numRows);
        } else {
            if (Q.numRows != this.numRows || Q.numCols != this.numRows) {
                throw new IllegalArgumentException("Unexpected matrix dimension.");
            }
            CommonOps_DDRM.setIdentity(Q);
        }
        for (int j = this.minLength - 1; j >= 0; --j) {
            this.u[j] = 1.0;
            for (int i = j + 1; i < this.numRows; ++i) {
                this.u[i] = this.QR.get(i, j);
            }
            QrHelperFunctions_DDRM.rank1UpdateMultR(Q, this.u, this.gammas[j], j, j, this.numRows, this.v);
        }
        return Q;
    }

    @Override
    public DMatrixRMaj getR(DMatrixRMaj R5, boolean compact) {
        int i;
        if (R5 == null) {
            R5 = compact ? new DMatrixRMaj(this.minLength, this.numCols) : new DMatrixRMaj(this.numRows, this.numCols);
        } else {
            if (compact ? R5.numCols != this.numCols || R5.numRows != this.minLength : R5.numCols != this.numCols || R5.numRows != this.numRows) {
                throw new IllegalArgumentException("Unexpected dimensions");
            }
            for (i = 0; i < R5.numRows; ++i) {
                int min2 = Math.min(i, R5.numCols);
                for (int j = 0; j < min2; ++j) {
                    R5.set(i, j, 0.0);
                }
            }
        }
        for (i = 0; i < this.minLength; ++i) {
            for (int j = i; j < this.numCols; ++j) {
                double val = this.QR.get(i, j);
                R5.set(i, j, val);
            }
        }
        return R5;
    }

    @Override
    public boolean decompose(DMatrixRMaj A2) {
        this.commonSetup(A2);
        for (int j = 0; j < this.minLength; ++j) {
            this.householder(j);
            this.updateA(j);
        }
        return !this.error;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    protected void householder(int j) {
        double d2;
        int i;
        int index = j + j * this.numCols;
        double max = 0.0;
        for (i = j; i < this.numRows; ++i) {
            this.u[i] = this.dataQR[index];
            d2 = this.u[i];
            if (d2 < 0.0) {
                d2 = -d2;
            }
            if (max < d2) {
                max = d2;
            }
            index += this.numCols;
        }
        if (max == 0.0) {
            this.gamma = 0.0;
            this.error = true;
        } else {
            this.tau = 0.0;
            for (i = j; i < this.numRows; ++i) {
                int n = i;
                this.u[n] = this.u[n] / max;
                d2 = this.u[i];
                this.tau += d2 * d2;
            }
            this.tau = Math.sqrt(this.tau);
            if (this.u[j] < 0.0) {
                this.tau = -this.tau;
            }
            double u_0 = this.u[j] + this.tau;
            this.gamma = u_0 / this.tau;
            int i2 = j + 1;
            while (i2 < this.numRows) {
                int n = i2++;
                this.u[n] = this.u[n] / u_0;
            }
            this.u[j] = 1.0;
            this.tau *= max;
        }
        this.gammas[j] = this.gamma;
    }

    protected void updateA(int w) {
        int i;
        for (i = w + 1; i < this.numCols; ++i) {
            this.v[i] = this.u[w] * this.dataQR[w * this.numCols + i];
        }
        for (int k = w + 1; k < this.numRows; ++k) {
            int indexQR = k * this.numCols + w + 1;
            int i2 = w + 1;
            while (i2 < this.numCols) {
                int n = i2++;
                this.v[n] = this.v[n] + this.u[k] * this.dataQR[indexQR++];
            }
        }
        i = w + 1;
        while (i < this.numCols) {
            int n = i++;
            this.v[n] = this.v[n] * this.gamma;
        }
        for (i = w; i < this.numRows; ++i) {
            double valU = this.u[i];
            int indexQR = i * this.numCols + w + 1;
            for (int j = w + 1; j < this.numCols; ++j) {
                int n = indexQR++;
                this.dataQR[n] = this.dataQR[n] - valU * this.v[j];
            }
        }
        if (w < this.numCols) {
            this.dataQR[w + w * this.numCols] = -this.tau;
        }
        for (i = w + 1; i < this.numRows; ++i) {
            this.dataQR[w + i * this.numCols] = this.u[i];
        }
    }

    protected void commonSetup(DMatrixRMaj A2) {
        this.setExpectedMaxSize(A2.numRows, A2.numCols);
        this.QR.set(A2);
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

