/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.FilenameUtils;
import org.flsgen.solver.LandscapeStructure;
import org.flsgen.solver.LandscapeStructureSolver;
import picocli.CommandLine;

@CommandLine.Command(name="structure", mixinStandardHelpOptions=true, description={"Generate a landscape structure satisfying a set of targets."})
public class CLI_LandscapeStructureSolver
implements Runnable {
    @CommandLine.Parameters(description={"JSON output file (or prefix for multiple structure generation) for solution -- Use \"-\" to write to STDOUT (only possible with one structure as input and single-solution generation)"}, index="0")
    String outputPrefix;
    @CommandLine.Parameters(description={"JSON input file(s) describing landscape targets -- Use \"-\" to read from STDIN (only possible with one structure as input) -- Use multiple space-separated paths to generate landscapes with different structures."}, index="1..*")
    String[] jsonPaths;
    @CommandLine.Option(names={"-n", "--nb-solutions"}, description={"Number of solutions to generate, if greater than one, use a prefix for JSON output file (default: 1)."}, defaultValue="1")
    int nbSolutions;
    @CommandLine.Option(names={"-s", "--search-strategy"}, description={"Search strategy to use in the Choco org.flsgen.solver (possible values: ${COMPLETION-CANDIDATES})."}, defaultValue="DEFAULT")
    SearchStrategy search;

    @Override
    public void run() {
        if (this.nbSolutions <= 0) {
            System.err.println("\u001b[31mNumber of solutions must be at least 1\u001b[0m");
            return;
        }
        if (this.nbSolutions > 1 && this.outputPrefix.equals("-")) {
            System.err.println("\u001b[31mSTDOUT solution output is only possible when nbSolutions = 1\u001b[0m");
            return;
        }
        try {
            int i;
            String[] targetNames = new String[this.jsonPaths.length];
            if (this.jsonPaths.length == 1 && this.jsonPaths[0].equals("-")) {
                targetNames[0] = "STDIN";
            } else {
                for (i = 0; i < this.jsonPaths.length; ++i) {
                    targetNames[i] = FilenameUtils.removeExtension(new File(this.jsonPaths[i]).getName());
                }
            }
            block13: for (i = 0; i < this.jsonPaths.length; ++i) {
                Reader reader = this.jsonPaths.length == 1 && this.jsonPaths[0].equals("-") ? new BufferedReader(new InputStreamReader(System.in)) : new FileReader(this.jsonPaths[i]);
                LandscapeStructureSolver lSolver = LandscapeStructureSolver.readFromJSON(reader);
                ((Reader)reader).close();
                lSolver.build();
                switch (this.search) {
                    case DEFAULT: {
                        lSolver.setDefaultSearch();
                        break;
                    }
                    case RANDOM: {
                        lSolver.setRandomSearch();
                        break;
                    }
                    case DOM_OVER_W_DEG: {
                        lSolver.setDomOverWDegSearch();
                        break;
                    }
                    case DOM_OVER_W_DEG_REF: {
                        lSolver.setDomOverWDegRefSearch();
                        break;
                    }
                    case MIN_DOM_LB: {
                        lSolver.setMinDomLBSearch();
                        break;
                    }
                    case MIN_DOM_UB: {
                        lSolver.setMinDomUBSearch();
                        break;
                    }
                    case ACTIVITY_BASED: {
                        lSolver.setActivityBasedSearch();
                        break;
                    }
                    case CONFLICT_HISTORY: {
                        lSolver.setConflictHistorySearch();
                        break;
                    }
                    default: {
                        lSolver.setDefaultSearch();
                    }
                }
                if (this.nbSolutions == 1) {
                    LandscapeStructure s2 = lSolver.findSolution();
                    if (s2 != null) {
                        System.err.println("\u001b[32mSolution found in " + lSolver.getModel().getSolver().getTimeCount() + " s" + "\u001b[0m");
                        if (this.outputPrefix.equals("-")) {
                            System.out.println(s2.toJSON());
                            continue;
                        }
                        FileWriter writer = new FileWriter(this.outputPrefix + "_" + targetNames[i] + ".json");
                        writer.write(s2.toJSON());
                        writer.close();
                        continue;
                    }
                    System.err.println("\u001b[31mNo possible solution\u001b[0m");
                    continue;
                }
                for (int n = 0; n < this.nbSolutions; ++n) {
                    LandscapeStructure s3 = lSolver.findSolution();
                    if (s3 != null) {
                        System.err.println("\u001b[32mSolution " + (n + 1) + " found (total solving time " + lSolver.getModel().getSolver().getTimeCount() + "s)" + "\u001b[0m");
                        FileWriter writer = new FileWriter(this.outputPrefix + "_" + targetNames[i] + "_" + (n + 1) + ".json");
                        writer.write(s3.toJSON());
                        writer.close();
                        continue;
                    }
                    if (n == 0) {
                        System.err.println("\u001b[31mNo possible solution\u001b[0m");
                        continue block13;
                    }
                    System.err.println("\u001b[31mNo more possible solutions\u001b[0m");
                    continue block13;
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static enum SearchStrategy {
        DEFAULT,
        RANDOM,
        DOM_OVER_W_DEG,
        DOM_OVER_W_DEG_REF,
        ACTIVITY_BASED,
        CONFLICT_HISTORY,
        MIN_DOM_UB,
        MIN_DOM_LB;

    }
}

