/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.geotools.data.Query;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class ListFeatureCollection
extends AbstractFeatureCollection
implements Collection<SimpleFeature> {
    protected List<SimpleFeature> list;
    protected ReferencedEnvelope bounds = null;

    public ListFeatureCollection(SimpleFeatureType schema) {
        this(schema, new ArrayList<SimpleFeature>());
    }

    public ListFeatureCollection(SimpleFeatureType schema, List<SimpleFeature> list) {
        super(schema);
        this.list = list;
    }

    public ListFeatureCollection(SimpleFeatureType schema, SimpleFeature[] array) {
        super(schema);
        this.list = new CopyOnWriteArrayList<SimpleFeature>(array);
    }

    public ListFeatureCollection(SimpleFeatureCollection copy) throws IOException {
        this((SimpleFeatureType)copy.getSchema());
        copy.accepts(new FeatureVisitor(){

            @Override
            public void visit(Feature feature) {
                ListFeatureCollection.this.list.add((SimpleFeature)feature);
            }
        }, null);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    protected Iterator<SimpleFeature> openIterator() {
        Iterator<SimpleFeature> it = this.list.iterator();
        return it;
    }

    @Override
    public boolean add(SimpleFeature f) {
        this.bounds = null;
        return this.list.add(f);
    }

    @Override
    public void clear() {
        this.list.clear();
        this.bounds = null;
    }

    public SimpleFeatureIterator features() {
        return new ListFeatureIterator(this.list);
    }

    public synchronized ReferencedEnvelope getBounds() {
        if (this.bounds == null) {
            this.bounds = this.calculateBounds();
        }
        return this.bounds;
    }

    protected ReferencedEnvelope calculateBounds() {
        ReferencedEnvelope extent = ReferencedEnvelope.create(this.getSchema().getCoordinateReferenceSystem());
        for (SimpleFeature feature : this.list) {
            ReferencedEnvelope bbox;
            if (feature == null || (bbox = ReferencedEnvelope.reference(feature.getBounds())) == null || bbox.isEmpty() || bbox.isNull()) continue;
            extent.expandToInclude(bbox);
        }
        return extent;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        CollectionFeatureSource temp = new CollectionFeatureSource((SimpleFeatureCollection)((Object)this));
        return temp.getFeatures(filter);
    }

    public SimpleFeatureCollection sort(SortBy order) {
        Query subQuery = new Query(this.getSchema().getTypeName());
        subQuery.setSortBy(new SortBy[]{order});
        CollectionFeatureSource temp = new CollectionFeatureSource((SimpleFeatureCollection)((Object)this));
        return temp.getFeatures(subQuery);
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.list.remove(o);
        if (removed) {
            this.bounds = null;
        }
        return removed;
    }

    @Override
    public boolean addAll(Collection<? extends SimpleFeature> c2) {
        boolean changed = false;
        for (SimpleFeature simpleFeature : c2) {
            boolean added = this.add(simpleFeature);
            if (changed || !added) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        this.bounds = null;
        return this.list.removeAll(c2);
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        this.bounds = null;
        return this.list.retainAll(c2);
    }

    private class ListFeatureIterator
    implements SimpleFeatureIterator {
        private Iterator<SimpleFeature> iter;

        public ListFeatureIterator(List<SimpleFeature> features) {
            this.iter = features.iterator();
        }

        public void close() {
            if (this.iter instanceof FeatureIterator) {
                ((FeatureIterator)this.iter).close();
            }
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public SimpleFeature next() throws NoSuchElementException {
            return this.iter.next();
        }
    }
}

