/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.metadata.iso.citation.ResponsiblePartyImpl;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.util.InternationalString;

public final class Citations {
    public static final Citation OGC;
    public static final Citation OPEN_GIS;
    public static final Citation ESRI;
    public static final Citation ORACLE;
    public static final Citation POSTGIS;
    public static final Citation GEOTOOLS;
    public static final Citation WMS;
    public static final Citation GEOTIFF;
    public static final Citation JAI;
    public static final Citation EPSG;
    public static final Citation AUTO;
    public static final Citation AUTO2;
    public static final Citation CRS;
    public static final Citation URN_OGC;
    public static final Citation HTTP_OGC;
    public static final Citation HTTP_URI_OGC;
    private static final Citation[] AUTHORITIES;

    private Citations() {
    }

    public static Citation fromName(String title) {
        for (int i = 0; i < AUTHORITIES.length; ++i) {
            Citation citation = AUTHORITIES[i];
            if (!Citations.titleMatches(citation, title)) continue;
            return citation;
        }
        return new CitationImpl(title);
    }

    public static boolean titleMatches(Citation c1, Citation c2) {
        InternationalString candidate = c2.getTitle();
        Iterator<? extends InternationalString> iterator = null;
        while (true) {
            String asString;
            if (Citations.titleMatches(c1, asString = candidate.toString(null))) {
                return true;
            }
            String asLocalized = candidate.toString();
            if (!Objects.equals(asLocalized, asString) && Citations.titleMatches(c1, asLocalized)) {
                return true;
            }
            if (iterator == null) {
                Collection<? extends InternationalString> titles = c2.getAlternateTitles();
                if (titles == null) break;
                iterator = titles.iterator();
            }
            if (!iterator.hasNext()) break;
            candidate = (InternationalString)iterator.next();
        }
        return false;
    }

    public static boolean titleMatches(Citation citation, String title) {
        title = title.trim();
        InternationalString candidate = citation.getTitle();
        Iterator<? extends InternationalString> iterator = null;
        while (true) {
            String asString;
            if ((asString = candidate.toString(null)).trim().equalsIgnoreCase(title)) {
                return true;
            }
            String asLocalized = candidate.toString();
            if (!Objects.equals(asLocalized, asString) && asLocalized.trim().equalsIgnoreCase(title)) {
                return true;
            }
            if (iterator == null) {
                Collection<? extends InternationalString> titles = citation.getAlternateTitles();
                if (titles == null) break;
                iterator = titles.iterator();
            }
            if (!iterator.hasNext()) break;
            candidate = (InternationalString)iterator.next();
        }
        return false;
    }

    public static boolean identifierMatches(Citation c1, Citation c2) {
        Iterator<? extends Identifier> iterator = c2.getIdentifiers().iterator();
        if (!iterator.hasNext()) {
            iterator = c1.getIdentifiers().iterator();
            if (!iterator.hasNext()) {
                return Citations.titleMatches(c1, c2);
            }
            c1 = c2;
            c2 = null;
        }
        do {
            String id;
            if (!Citations.identifierMatches(c1, id = iterator.next().getCode().trim())) continue;
            return true;
        } while (iterator.hasNext());
        return false;
    }

    public static boolean identifierMatches(Citation citation, String identifier) {
        identifier = identifier.trim();
        Collection<? extends Identifier> identifiers = citation.getIdentifiers();
        for (Identifier identifier2 : identifiers) {
            String code = identifier2.getCode().trim();
            if (!identifier.equalsIgnoreCase(code)) continue;
            return true;
        }
        if (identifiers.isEmpty()) {
            return Citations.titleMatches(citation, identifier);
        }
        return false;
    }

    public static String getIdentifier(Citation citation) {
        String identifier = null;
        for (Identifier identifier2 : citation.getIdentifiers()) {
            String candidate = identifier2.getCode().trim();
            int length = candidate.length();
            if (length == 0 || identifier != null && length >= identifier.length()) continue;
            identifier = candidate;
        }
        if (identifier == null) {
            identifier = String.valueOf(citation.getTitle());
        }
        return identifier;
    }

    static {
        CitationImpl c2 = new CitationImpl(ResponsiblePartyImpl.OGC);
        c2.getAlternateTitles().add(new SimpleInternationalString("OGC"));
        c2.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c2.freeze();
        OGC = c2;
        c2 = new CitationImpl(ResponsiblePartyImpl.OPEN_GIS);
        Collection<InternationalString> alt = c2.getAlternateTitles();
        alt.add(new SimpleInternationalString("OpenGIS"));
        alt.addAll(OGC.getAlternateTitles());
        c2.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c2.freeze();
        OPEN_GIS = c2;
        c2 = new CitationImpl(ResponsiblePartyImpl.ESRI);
        c2.addAuthority("ESRI", true);
        c2.freeze();
        ESRI = c2;
        c2 = new CitationImpl(ResponsiblePartyImpl.ORACLE);
        c2.freeze();
        ORACLE = c2;
        c2 = new CitationImpl(ResponsiblePartyImpl.POSTGIS);
        c2.freeze();
        POSTGIS = c2;
        c2 = new CitationImpl(ResponsiblePartyImpl.GEOTOOLS);
        c2.freeze();
        GEOTOOLS = c2;
        c2 = new CitationImpl("Web Map Service");
        Collection<InternationalString> titles = c2.getAlternateTitles();
        titles.add(new SimpleInternationalString("WMS"));
        titles.add(new SimpleInternationalString("WMS 1.3.0"));
        titles.add(new SimpleInternationalString("OGC 04-024"));
        titles.add(new SimpleInternationalString("ISO 19128"));
        Collection<ResponsibleParty> parties = c2.getCitedResponsibleParties();
        parties.add(ResponsiblePartyImpl.OGC);
        parties.add(ResponsiblePartyImpl.OGC(Role.PUBLISHER, OnLineResourceImpl.WMS));
        c2.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c2.freeze();
        WMS = c2;
        c2 = new CitationImpl(ResponsiblePartyImpl.GEOTIFF);
        c2.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c2.freeze();
        GEOTIFF = c2;
        c2 = new CitationImpl("Java Advanced Imaging");
        c2.getAlternateTitles().add(new SimpleInternationalString("JAI"));
        c2.getCitedResponsibleParties().add(ResponsiblePartyImpl.SUN_MICROSYSTEMS);
        c2.freeze();
        JAI = c2;
        c2 = new CitationImpl(ResponsiblePartyImpl.EPSG);
        c2.addAuthority("EPSG", true);
        c2.getPresentationForm().add(PresentationForm.TABLE_DIGITAL);
        c2.freeze();
        EPSG = c2;
        c2 = new CitationImpl("Automatic Projections");
        c2.addAuthority("AUTO", false);
        Collection<ResponsibleParty> parties2 = c2.getCitedResponsibleParties();
        parties2.add(ResponsiblePartyImpl.OGC);
        parties2.add(ResponsiblePartyImpl.OGC(Role.PUBLISHER, OnLineFunction.DOWNLOAD, "http://www.opengis.org/docs/01-068r3.pdf"));
        c2.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c2.freeze();
        AUTO = c2;
        c2 = new CitationImpl("Automatic Projections");
        c2.addAuthority("AUTO2", false);
        parties2 = c2.getCitedResponsibleParties();
        parties2.add(ResponsiblePartyImpl.OGC);
        parties2.add(ResponsiblePartyImpl.OGC(Role.PUBLISHER, OnLineResourceImpl.WMS));
        c2.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c2.freeze();
        AUTO2 = c2;
        c2 = new CitationImpl("Web Map Service CRS");
        c2.addAuthority("CRS", false);
        c2.getCitedResponsibleParties().addAll(AUTO2.getCitedResponsibleParties());
        c2.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c2.freeze();
        CRS = c2;
        c2 = new CitationImpl("URN in OGC namespace");
        c2.addAuthority("urn:ogc:def", false);
        c2.addAuthority("urn:x-ogc:def", false);
        c2.getCitedResponsibleParties().add(ResponsiblePartyImpl.OGC);
        c2.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c2.freeze();
        URN_OGC = c2;
        c2 = new CitationImpl("URL in OGC namespace");
        c2.addAuthority("http://www.opengis.net/gml", false);
        c2.getCitedResponsibleParties().add(ResponsiblePartyImpl.OGC);
        c2.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c2.freeze();
        HTTP_OGC = c2;
        c2 = new CitationImpl("HTTP URI in OGC namespace");
        c2.addAuthority("http://www.opengis.net/def", false);
        c2.getCitedResponsibleParties().add(ResponsiblePartyImpl.OGC);
        c2.getPresentationForm().add(PresentationForm.DOCUMENT_DIGITAL);
        c2.freeze();
        HTTP_URI_OGC = c2;
        AUTHORITIES = new Citation[]{OGC, OPEN_GIS, ESRI, ORACLE, GEOTOOLS, WMS, GEOTIFF, JAI, EPSG, AUTO, AUTO2, CRS};
    }
}

