/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import java.io.Serializable;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.SingularMatrixException;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.opengis.referencing.operation.Matrix;

public class Matrix1
implements XMatrix,
Serializable {
    private static final long serialVersionUID = -4829171016106097031L;
    public double m00;
    public static final int SIZE = 1;

    public Matrix1() {
        this.m00 = 1.0;
    }

    public Matrix1(double m00) {
        this.m00 = m00;
    }

    public Matrix1(Matrix matrix) {
        if (matrix.getNumRow() != 1 || matrix.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        this.m00 = matrix.getElement(0, 0);
    }

    @Override
    public final int getNumRow() {
        return 1;
    }

    @Override
    public final int getNumCol() {
        return 1;
    }

    @Override
    public final double getElement(int row, int col) {
        if (row == 0 && col == 0) {
            return this.m00;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final void setElement(int row, int col, double value) {
        if (row != 0 || col != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.m00 = value;
    }

    @Override
    public final void setZero() {
        this.m00 = 0.0;
    }

    @Override
    public final void setIdentity() {
        this.m00 = 1.0;
    }

    @Override
    public final boolean isIdentity() {
        return this.m00 == 1.0;
    }

    @Override
    public final boolean isIdentity(double tolerance) {
        return Math.abs(this.m00 - 1.0) <= Math.abs(tolerance);
    }

    @Override
    public final boolean isAffine() {
        return this.m00 == 1.0;
    }

    @Override
    public final void negate() {
        this.m00 = -this.m00;
    }

    @Override
    public void negate(Matrix matrix) {
        if (matrix.getNumRow() != 1 || matrix.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        this.m00 = -matrix.getElement(0, 0);
    }

    @Override
    public final void transpose() {
    }

    @Override
    public void transpose(Matrix matrix) {
        if (matrix.getNumRow() != 1 || matrix.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        this.m00 = matrix.getElement(0, 0);
    }

    @Override
    public final void invert() {
        if (this.m00 == 0.0) {
            throw new SingularMatrixException("1 dimensional m is singular");
        }
        this.m00 = 1.0 / this.m00;
    }

    @Override
    public void invert(Matrix matrix) throws SingularMatrixException {
        if (matrix.getNumRow() != 1 || matrix.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        if (matrix.getElement(0, 0) == 0.0) {
            throw new SingularMatrixException("1 dimensional matrix is singular");
        }
        this.m00 = 1.0 / matrix.getElement(0, 0);
    }

    @Override
    public final void multiply(Matrix matrix) {
        if (matrix.getNumRow() != 1 || matrix.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        this.m00 *= matrix.getElement(0, 0);
    }

    @Override
    public boolean equals(Matrix matrix, double tolerance) {
        return GeneralMatrix.epsilonEquals(this, matrix, tolerance);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            Matrix1 that = (Matrix1)object;
            return Double.doubleToLongBits(this.m00) == Double.doubleToLongBits(that.m00);
        }
        return false;
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.m00) ^ 0xBCFB568C01624679L);
    }

    public String toString() {
        return GeneralMatrix.toString(this);
    }

    @Override
    public Matrix1 clone() {
        try {
            return (Matrix1)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    @Override
    public void getRow(int row, double[] array) {
        if (array.length != 1) {
            throw new IllegalArgumentException("Call getRow received an array of length " + array.length + ".  The dimensions of the matrix is 1 by 1.");
        }
        if (row != 0) {
            throw new IllegalArgumentException("Specified element is out of bounds: (" + row + " , 0)");
        }
        array[0] = this.m00;
    }

    @Override
    public void setRow(int row, double ... values) {
        if (values.length != 1) {
            throw new IllegalArgumentException("Call setRow received an array of length " + values.length + ".  The dimensions of the matrix is 1 by 1.");
        }
        this.m00 = values[0];
    }

    @Override
    public void getColumn(int column, double[] array) {
        if (array.length != 1) {
            throw new IllegalArgumentException("Call getColumn received an array of length " + array.length + ".  The dimensions of the matrix is 1 by 1.");
        }
        if (column != 0) {
            throw new IllegalArgumentException("Specified element is out of bounds: (0 , " + column + ")");
        }
        array[0] = this.m00;
    }

    @Override
    public void setColumn(int column, double ... values) {
        if (values.length != 0) {
            throw new IllegalArgumentException("Call setColumn received an array of length " + values.length + ".  The dimensions of the matrix is 1 by 1.");
        }
        this.m00 = values[0];
    }

    @Override
    public void add(double scalar) {
        this.m00 += scalar;
    }

    @Override
    public void add(double scalar, XMatrix matrix) {
        if (matrix.getNumRow() != 1 || matrix.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        this.m00 = scalar + matrix.getElement(0, 0);
    }

    @Override
    public void add(XMatrix matrix) {
        if (matrix.getNumRow() != 1 || matrix.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        this.m00 += matrix.getElement(0, 0);
    }

    @Override
    public void add(XMatrix matrix1, XMatrix matrix2) {
        if (matrix1.getNumRow() != 1 || matrix1.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        if (matrix2.getNumRow() != 1 || matrix2.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        this.m00 = matrix1.getElement(0, 0) + matrix2.getElement(0, 0);
    }

    @Override
    public double determinate() {
        return this.m00;
    }

    @Override
    public void mul(double scalar) {
        this.m00 *= scalar;
    }

    @Override
    public void mul(double scalar, Matrix matrix) {
        if (matrix.getNumRow() != 1 || matrix.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        this.m00 = scalar * matrix.getElement(0, 0);
    }

    @Override
    public void mul(Matrix matrix) {
        if (matrix.getNumRow() != 1 || matrix.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        this.m00 *= matrix.getElement(0, 0);
    }

    @Override
    public void mul(Matrix matrix1, Matrix matrix2) {
        if (matrix1.getNumRow() != 1 || matrix1.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        if (matrix2.getNumRow() != 1 || matrix2.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        this.m00 = matrix1.getElement(0, 0) * matrix2.getElement(0, 0);
    }

    @Override
    public void sub(double scalar) {
        this.m00 -= scalar;
    }

    @Override
    public void sub(Matrix matrix) {
        if (matrix.getNumRow() != 1 || matrix.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        this.m00 -= matrix.getElement(0, 0);
    }

    @Override
    public void sub(double scalar, Matrix matrix) {
        if (matrix.getNumRow() != 1 || matrix.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        this.m00 = scalar - matrix.getElement(0, 0);
    }

    @Override
    public void sub(Matrix matrix1, Matrix matrix2) {
        if (matrix1.getNumRow() != 1 || matrix1.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        if (matrix2.getNumRow() != 1 || matrix2.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(70));
        }
        this.m00 = matrix1.getElement(0, 0) - matrix2.getElement(0, 0);
    }
}

