/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.LobData;
import org.hsqldb.types.Type;

class Like
implements Cloneable {
    private static final BinaryData maxByteValue = new BinaryData(new byte[]{-128}, false);
    private char[] cLike;
    private int[] wildCardType;
    private int iLen;
    private boolean isIgnoreCase;
    private int iFirstWildCard;
    private boolean isNull;
    int escapeChar;
    boolean hasCollation;
    static final int UNDERSCORE_CHAR = 1;
    static final int PERCENT_CHAR = 2;
    boolean isVariable = true;
    boolean isBinary = false;
    Type dataType;

    Like() {
    }

    void setParams(boolean bl) {
        this.hasCollation = bl;
    }

    void setIgnoreCase(boolean bl) {
        this.isIgnoreCase = bl;
    }

    private Object getStartsWith() {
        int n;
        if (this.iLen == 0) {
            return this.isBinary ? BinaryData.zeroLengthBinary : "";
        }
        StringBuffer stringBuffer = null;
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = null;
        if (this.isBinary) {
            hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
        } else {
            stringBuffer = new StringBuffer();
        }
        for (n = 0; n < this.iLen && this.wildCardType[n] == 0; ++n) {
            if (this.isBinary) {
                hsqlByteArrayOutputStream.writeByte(this.cLike[n]);
                continue;
            }
            stringBuffer.append(this.cLike[n]);
        }
        if (n == 0) {
            return null;
        }
        return this.isBinary ? new BinaryData(hsqlByteArrayOutputStream.toByteArray(), false) : stringBuffer.toString();
    }

    Boolean compare(Session session, Object object) {
        if (object == null) {
            return null;
        }
        if (this.isNull) {
            return null;
        }
        if (this.isIgnoreCase) {
            object = ((CharacterType)this.dataType).upper(session, object);
        }
        int n = this.getLength(session, object);
        if (object instanceof ClobData) {
            object = ((ClobData)object).getChars(session, 0L, (int)((ClobData)object).length(session));
        }
        return this.compareAt(session, object, 0, 0, this.iLen, n, this.cLike, this.wildCardType) ? Boolean.TRUE : Boolean.FALSE;
    }

    char getChar(Session session, Object object, int n) {
        char c2 = this.isBinary ? (char)((BlobData)object).getBytes()[n] : (object instanceof char[] ? ((char[])object)[n] : (object instanceof ClobData ? ((ClobData)object).getChars(session, n, 1)[0] : ((String)object).charAt(n)));
        return c2;
    }

    int getLength(SessionInterface sessionInterface, Object object) {
        int n = object instanceof LobData ? (int)((LobData)object).length(sessionInterface) : ((String)object).length();
        return n;
    }

    private boolean compareAt(Session session, Object object, int n, int n2, int n3, int n4, char[] cArray, int[] nArray) {
        while (n < n3) {
            switch (nArray[n]) {
                case 0: {
                    if (n2 < n4 && cArray[n] == this.getChar(session, object, n2++)) break;
                    return false;
                }
                case 1: {
                    if (n2++ < n4) break;
                    return false;
                }
                case 2: {
                    if (++n >= n3) {
                        return true;
                    }
                    while (n2 < n4) {
                        if (cArray[n] == this.getChar(session, object, n2) && this.compareAt(session, object, n, n2, n3, n4, cArray, nArray)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
            }
            ++n;
        }
        return n2 == n4;
    }

    void setPattern(Session session, Object object, Object object2, boolean bl) {
        int n;
        int n2;
        boolean bl2 = this.isNull = object == null;
        if (!bl) {
            this.escapeChar = -1;
        } else {
            if (object2 == null) {
                this.isNull = true;
                return;
            }
            n2 = this.getLength(session, object2);
            if (n2 != 1) {
                if (this.isBinary) {
                    throw Error.error(3412);
                }
                throw Error.error(3439);
            }
            this.escapeChar = this.getChar(session, object2, 0);
        }
        if (this.isNull) {
            return;
        }
        if (this.isIgnoreCase) {
            object = (String)((CharacterType)this.dataType).upper(null, object);
        }
        this.iLen = 0;
        this.iFirstWildCard = -1;
        n2 = this.getLength(session, object);
        this.cLike = new char[n2];
        this.wildCardType = new int[n2];
        boolean bl3 = false;
        boolean bl4 = false;
        for (n = 0; n < n2; ++n) {
            char c2 = this.getChar(session, object, n);
            if (!bl3) {
                if (this.escapeChar == c2) {
                    bl3 = true;
                    continue;
                }
                if (c2 == '_') {
                    this.wildCardType[this.iLen] = 1;
                    if (this.iFirstWildCard == -1) {
                        this.iFirstWildCard = this.iLen;
                    }
                } else if (c2 == '%') {
                    if (bl4) continue;
                    bl4 = true;
                    this.wildCardType[this.iLen] = 2;
                    if (this.iFirstWildCard == -1) {
                        this.iFirstWildCard = this.iLen;
                    }
                } else {
                    bl4 = false;
                }
            } else if (c2 == this.escapeChar || c2 == '_' || c2 == '%') {
                bl4 = false;
                bl3 = false;
            } else {
                throw Error.error(3458);
            }
            this.cLike[this.iLen++] = c2;
        }
        if (bl3) {
            throw Error.error(3458);
        }
        for (n = 0; n < this.iLen - 1; ++n) {
            if (this.wildCardType[n] != 2 || this.wildCardType[n + 1] != 1) continue;
            this.wildCardType[n] = 1;
            this.wildCardType[n + 1] = 2;
        }
    }

    boolean isEquivalentToUnknownPredicate() {
        return !this.isVariable && this.isNull;
    }

    boolean isEquivalentToEqualsPredicate() {
        return !this.isVariable && this.iFirstWildCard == -1;
    }

    boolean isEquivalentToNotNullPredicate() {
        if (this.isVariable || this.isNull || this.iFirstWildCard == -1) {
            return false;
        }
        for (int i = 0; i < this.wildCardType.length; ++i) {
            if (this.wildCardType[i] == 2) continue;
            return false;
        }
        return true;
    }

    int getFirstWildCardIndex() {
        return this.iFirstWildCard;
    }

    Object getRangeLow() {
        return this.getStartsWith();
    }

    Object getRangeHigh(Session session) {
        Object object = this.getStartsWith();
        if (object == null) {
            return null;
        }
        if (this.isBinary) {
            return new BinaryData(session, (BinaryData)object, maxByteValue);
        }
        return this.dataType.concat(session, object, "\uffff");
    }

    public String describe(Session session) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("[\n");
        stringBuffer.append("escapeChar=").append(this.escapeChar).append('\n');
        stringBuffer.append("isNull=").append(this.isNull).append('\n');
        stringBuffer.append("isIgnoreCase=").append(this.isIgnoreCase).append('\n');
        stringBuffer.append("iLen=").append(this.iLen).append('\n');
        stringBuffer.append("iFirstWildCard=").append(this.iFirstWildCard).append('\n');
        stringBuffer.append("cLike=");
        if (this.cLike != null) {
            stringBuffer.append(StringUtil.arrayToString(this.cLike));
        }
        stringBuffer.append('\n');
        stringBuffer.append("wildCardType=");
        if (this.wildCardType != null) {
            stringBuffer.append(StringUtil.arrayToString(this.wildCardType));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Like duplicate() {
        try {
            return (Like)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Error.runtimeError(201, "Expression");
        }
    }
}

