/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.IOException;
import java.io.Reader;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.types.ClobData;

public final class ClobInputStream
extends Reader {
    final ClobData clob;
    final long availableLength;
    long bufferOffset;
    long currentPosition;
    char[] buffer;
    boolean isClosed;
    int streamBlockSize;
    public final SessionInterface session;

    public ClobInputStream(SessionInterface sessionInterface, ClobData clobData, long l, long l2) {
        long l3 = clobData.length(sessionInterface);
        this.session = sessionInterface;
        this.clob = clobData;
        this.availableLength = l + Math.min(l2, l3 - l);
        this.currentPosition = l;
        this.streamBlockSize = sessionInterface.getStreamBlockSize();
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.buffer == null || this.currentPosition >= this.bufferOffset + (long)this.buffer.length) {
            try {
                this.checkClosed();
                this.readIntoBuffer();
            }
            catch (Exception exception) {
                throw JavaSystem.toIOException(exception);
            }
        }
        char c2 = this.buffer[(int)(this.currentPosition - this.bufferOffset)];
        ++this.currentPosition;
        return c2;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        this.checkClosed();
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.currentPosition + (long)n2 > this.availableLength) {
            n2 = (int)(this.availableLength - this.currentPosition);
        }
        for (int i = n; i < n + n2 && i < cArray.length; ++i) {
            cArray[i] = (char)this.read();
        }
        return n2;
    }

    @Override
    public long skip(long l) throws IOException {
        this.checkClosed();
        if (l <= 0L) {
            return 0L;
        }
        if (this.currentPosition + l > this.availableLength) {
            l = this.availableLength - this.currentPosition;
        }
        this.currentPosition += l;
        return l;
    }

    public int available() {
        long l = this.availableLength - this.currentPosition;
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException(Error.getMessage(1853));
        }
    }

    private void readIntoBuffer() {
        long l = this.availableLength - this.currentPosition;
        if (l <= 0L) {
            return;
        }
        if (l > (long)this.streamBlockSize) {
            l = this.streamBlockSize;
        }
        this.buffer = this.clob.getChars(this.session, this.currentPosition, (int)l);
        this.bufferOffset = this.currentPosition;
    }

    static boolean isInLimits(long l, long l2, long l3) {
        return l2 >= 0L && l3 >= 0L && l2 + l3 <= l;
    }
}

