/*
 * Decompiled with CFR 0.152.
 */
package org.huldra.math;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class BigInt
extends Number
implements Comparable<BigInt> {
    private static final long mask = 0xFFFFFFFFL;
    private int sign;
    private int len;
    private int[] dig;

    public BigInt(int sign, int[] v, int len) {
        this.assign(sign, v, len);
    }

    public BigInt(int sign, byte[] v, int vlen) {
        while (vlen > 1 && v[vlen - 1] == 0) {
            --vlen;
        }
        this.dig = new int[(vlen + 3) / 4];
        this.assign(sign, v, vlen);
    }

    public BigInt(int sign, int val) {
        this.dig = new int[1];
        this.uassign(sign, val);
    }

    public BigInt(int sign, long val) {
        this.dig = new int[2];
        this.uassign(sign, val);
    }

    public BigInt(int val) {
        this.dig = new int[1];
        this.assign(val);
    }

    public BigInt(long val) {
        this.dig = new int[2];
        this.assign(val);
    }

    public BigInt(String s2) {
        this.assign(s2);
    }

    public BigInt(char[] s2) {
        this.assign(s2);
    }

    private int parse(char[] s2, int from, int to) {
        int res = s2[from] - 48;
        while (++from < to) {
            res = res * 10 + s2[from] - 48;
        }
        return res;
    }

    private void mulAdd(int mul, int add) {
        int i;
        long carry = 0L;
        for (i = 0; i < this.len; ++i) {
            carry = (long)mul * ((long)this.dig[i] & 0xFFFFFFFFL) + carry;
            this.dig[i] = (int)carry;
            carry >>>= 32;
        }
        if (carry != 0L) {
            this.dig[this.len++] = (int)carry;
        }
        carry = ((long)this.dig[0] & 0xFFFFFFFFL) + (long)add;
        this.dig[0] = (int)carry;
        if (carry >>> 32 != 0L) {
            i = 1;
            while (i < this.len) {
                int n = i++;
                this.dig[n] = this.dig[n] + 1;
                if (this.dig[n] == 0) continue;
            }
            if (i == this.len) {
                this.dig[this.len++] = 1;
            }
        }
    }

    private void realloc() {
        int[] res = new int[this.dig.length * 2];
        System.arraycopy(this.dig, 0, res, 0, this.len);
        this.dig = res;
    }

    private void realloc(int newLen) {
        int[] res = new int[newLen];
        System.arraycopy(this.dig, 0, res, 0, this.len);
        this.dig = res;
    }

    public BigInt copy() {
        return new BigInt(this.sign, Arrays.copyOf(this.dig, this.len), this.len);
    }

    public void assign(BigInt other) {
        this.sign = other.sign;
        this.assign(other.dig, other.len);
    }

    private void assign(int[] v, int vlen) {
        if (vlen > this.dig.length) {
            this.dig = new int[vlen + 2];
        }
        this.len = vlen;
        System.arraycopy(v, 0, this.dig, 0, this.len);
    }

    public void assign(int sign, int[] v, int len) {
        this.sign = sign;
        this.len = len;
        this.dig = v;
    }

    public void assign(int sign, byte[] v, int vlen) {
        this.len = (vlen + 3) / 4;
        if (this.len > this.dig.length) {
            this.dig = new int[this.len + 2];
        }
        this.sign = sign;
        int tmp = vlen / 4;
        int j = 0;
        int i = 0;
        while (i < tmp) {
            this.dig[i] = v[j + 3] << 24 | (v[j + 2] & 0xFF) << 16 | (v[j + 1] & 0xFF) << 8 | v[j] & 0xFF;
            ++i;
            j += 4;
        }
        if (tmp != this.len) {
            tmp = v[j++] & 0xFF;
            if (j < vlen) {
                tmp |= (v[j++] & 0xFF) << 8;
                if (j < vlen) {
                    tmp |= (v[j] & 0xFF) << 16;
                }
            }
            this.dig[this.len - 1] = tmp;
        }
    }

    public void assign(String s2) {
        this.assign(s2.toCharArray());
    }

    public void assign(char[] s2) {
        int j;
        int alloc;
        this.sign = s2[0] == '-' ? -1 : 1;
        this.len = s2.length + (this.sign - 1 >> 1);
        int n = alloc = this.len < 10 ? 1 : (int)((long)this.len * 3402L >>> 10) + 32 >>> 5;
        if (this.dig == null || alloc > this.dig.length) {
            this.dig = new int[alloc];
        }
        if ((j = this.len % 9) == 0) {
            j = 9;
        }
        this.dig[0] = this.parse(s2, 0 - (this.sign - 1 >> 1), j -= this.sign - 1 >> 1);
        this.len = 1;
        while (j < s2.length) {
            this.mulAdd(1000000000, this.parse(s2, j, j += 9));
        }
    }

    public void uassign(int s2, int val) {
        this.sign = s2;
        this.len = 1;
        this.dig[0] = val;
    }

    public void uassign(int s2, long val) {
        this.sign = s2;
        this.len = 2;
        if (this.dig.length < 2) {
            this.realloc(2);
        }
        this.dig[0] = (int)(val & 0xFFFFFFFFL);
        this.dig[1] = (int)(val >>> 32);
        if (this.dig[1] == 0) {
            --this.len;
        }
    }

    public void uassign(int val) {
        this.uassign(1, val);
    }

    public void uassign(long val) {
        this.uassign(1, val);
    }

    public void assign(int val) {
        this.uassign(val < 0 ? -1 : 1, val < 0 ? -val : val);
    }

    public void assign(long val) {
        this.uassign(val < 0L ? -1 : 1, val < 0L ? -val : val);
    }

    public boolean isZero() {
        return this.len == 1 && this.dig[0] == 0;
    }

    private void setToZero() {
        this.dig[0] = 0;
        this.len = 1;
        this.sign = 1;
    }

    public int compareAbsTo(BigInt a2) {
        if (this.len > a2.len) {
            return 1;
        }
        if (this.len < a2.len) {
            return -1;
        }
        for (int i = this.len - 1; i >= 0; --i) {
            if (this.dig[i] == a2.dig[i]) continue;
            if (((long)this.dig[i] & 0xFFFFFFFFL) > ((long)a2.dig[i] & 0xFFFFFFFFL)) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    @Override
    public int compareTo(BigInt a2) {
        if (this.sign < 0) {
            if (a2.sign < 0 || a2.isZero()) {
                return -this.compareAbsTo(a2);
            }
            return -1;
        }
        if (a2.sign > 0 || a2.isZero()) {
            return this.compareAbsTo(a2);
        }
        return 1;
    }

    public boolean equals(BigInt a2) {
        if (this.len != a2.len) {
            return false;
        }
        if (this.isZero() && a2.isZero()) {
            return true;
        }
        if ((this.sign ^ a2.sign) < 0) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.dig[i] == a2.dig[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o instanceof BigInt) {
            return this.equals((BigInt)o);
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.len; ++i) {
            hash = (int)((long)(31 * hash) + ((long)this.dig[i] & 0xFFFFFFFFL));
        }
        return this.sign * hash;
    }

    @Override
    public byte byteValue() {
        return (byte)(this.sign * (this.dig[0] & 0x7F));
    }

    @Override
    public short shortValue() {
        return (short)(this.sign * (this.dig[0] & Short.MAX_VALUE));
    }

    @Override
    public int intValue() {
        return this.sign * (this.dig[0] & Integer.MAX_VALUE);
    }

    @Override
    public long longValue() {
        return this.len == 1 ? (long)this.sign * ((long)this.dig[0] & 0xFFFFFFFFL) : (long)this.sign * (((long)this.dig[1] & Integer.MAX_VALUE) << 32 | (long)this.dig[0] & 0xFFFFFFFFL);
    }

    @Override
    public float floatValue() {
        int s2 = Integer.numberOfLeadingZeros(this.dig[this.len - 1]);
        if (this.len == 1 && s2 >= 8) {
            return this.sign * this.dig[0];
        }
        int bits = this.dig[this.len - 1];
        bits = s2 <= 8 ? (bits >>>= 8 - s2) : bits << s2 - 8 | this.dig[this.len - 2] >>> 32 - (s2 - 8);
        bits = (int)((long)bits ^ 0x800000L);
        int exp = (int)((long)(32 - s2) + 32L * (long)(this.len - 1) - 1L + 127L & 0xFFL);
        bits |= exp << 23;
        return Float.intBitsToFloat(bits |= this.sign & Integer.MIN_VALUE);
    }

    @Override
    public double doubleValue() {
        if (this.len == 1) {
            return (long)this.sign * ((long)this.dig[0] & 0xFFFFFFFFL);
        }
        int s2 = Integer.numberOfLeadingZeros(this.dig[this.len - 1]);
        if (this.len == 2 && 32 - s2 + 32 <= 53) {
            return (long)this.sign * ((long)this.dig[1] << 32 | (long)this.dig[0] & 0xFFFFFFFFL);
        }
        long bits = (long)this.dig[this.len - 1] << 32 | (long)this.dig[this.len - 2] & 0xFFFFFFFFL;
        bits = s2 <= 11 ? (bits >>>= 11 - s2) : bits << s2 - 11 | (long)(this.dig[this.len - 3] >>> 32 - (s2 - 11));
        bits ^= 0x10000000000000L;
        long exp = (long)(32 - s2) + 32L * (long)(this.len - 1) - 1L + 1023L & 0x7FFL;
        bits |= exp << 52;
        return Double.longBitsToDouble(bits |= (long)this.sign & Long.MIN_VALUE);
    }

    private void uaddMag(int a2) {
        long tmp = ((long)this.dig[0] & 0xFFFFFFFFL) + ((long)a2 & 0xFFFFFFFFL);
        this.dig[0] = (int)tmp;
        if (tmp >>> 32 != 0L) {
            int i = 1;
            while (i < this.len) {
                int n = i++;
                this.dig[n] = this.dig[n] + 1;
                if (this.dig[n] == 0) continue;
            }
            if (i == this.len) {
                if (this.len == this.dig.length) {
                    this.realloc();
                }
                this.dig[this.len++] = 1;
            }
        }
    }

    private void usubMag(int s2) {
        long dif = ((long)this.dig[0] & 0xFFFFFFFFL) - ((long)s2 & 0xFFFFFFFFL);
        this.dig[0] = (int)dif;
        if (dif >> 32 != 0L) {
            int i = 1;
            while (this.dig[i] == 0) {
                int n = i++;
                this.dig[n] = this.dig[n] - 1;
            }
            int n = i;
            this.dig[n] = this.dig[n] - 1;
            if (this.dig[n] == 0 && i + 1 == this.len) {
                --this.len;
            }
        }
    }

    public void uadd(int a2) {
        if (this.sign < 0) {
            if (this.len > 1 || ((long)this.dig[0] & 0xFFFFFFFFL) > ((long)a2 & 0xFFFFFFFFL)) {
                this.usubMag(a2);
                return;
            }
            this.sign = 1;
            this.dig[0] = a2 - this.dig[0];
            return;
        }
        this.uaddMag(a2);
    }

    public void usub(int s2) {
        if (this.sign < 0) {
            this.uaddMag(s2);
            return;
        }
        if (this.len == 1 && ((long)this.dig[0] & 0xFFFFFFFFL) < ((long)s2 & 0xFFFFFFFFL)) {
            this.sign = -1;
            this.dig[0] = s2 - this.dig[0];
            return;
        }
        this.usubMag(s2);
    }

    public void umul(int mul) {
        if (mul == 0) {
            this.setToZero();
            return;
        }
        long carry = 0L;
        long m3 = (long)mul & 0xFFFFFFFFL;
        for (int i = 0; i < this.len; ++i) {
            carry = ((long)this.dig[i] & 0xFFFFFFFFL) * m3 + carry;
            this.dig[i] = (int)carry;
            carry >>>= 32;
        }
        if (carry != 0L) {
            if (this.len == this.dig.length) {
                this.realloc();
            }
            this.dig[this.len++] = (int)carry;
        }
    }

    public int udiv(int div) {
        if (div < 0) {
            return this.safeUdiv(div);
        }
        return this.unsafeUdiv(div);
    }

    private int unsafeUdiv(int div) {
        long d2 = (long)div & 0xFFFFFFFFL;
        long rem = 0L;
        for (int i = this.len - 1; i >= 0; --i) {
            rem <<= 32;
            this.dig[i] = (int)((rem += (long)this.dig[i] & 0xFFFFFFFFL) / d2);
            rem %= d2;
        }
        if (this.dig[this.len - 1] == 0 && this.len > 1) {
            --this.len;
        }
        if (this.len == 1 && this.dig[0] == 0) {
            this.sign = 1;
        }
        return (int)rem;
    }

    private int safeUdiv(int div) {
        long d2 = (long)div & 0xFFFFFFFFL;
        long hbit = Long.MIN_VALUE;
        long hq = Long.MAX_VALUE / d2;
        if (hq * d2 + d2 == Long.MIN_VALUE) {
            ++hq;
        }
        long hrem = Long.MIN_VALUE - hq * d2;
        long rem = 0L;
        for (int i = this.len - 1; i >= 0; --i) {
            rem = (rem << 32) + ((long)this.dig[i] & 0xFFFFFFFFL);
            long q = (hq & rem >> 63) + ((rem & Long.MAX_VALUE) + (hrem & rem >> 63)) / d2;
            rem -= q * d2;
            this.dig[i] = (int)q;
        }
        if (this.dig[this.len - 1] == 0 && this.len > 1) {
            --this.len;
        }
        if (this.len == 1 && this.dig[0] == 0) {
            this.sign = 1;
        }
        return (int)rem;
    }

    public void urem(int mod) {
        if (mod < 0) {
            this.safeUrem(mod);
        } else {
            this.unsafeUrem(mod);
        }
    }

    private void unsafeUrem(int mod) {
        long rem = 0L;
        long d2 = (long)mod & 0xFFFFFFFFL;
        for (int i = this.len - 1; i >= 0; --i) {
            rem <<= 32;
            rem = (rem + ((long)this.dig[i] & 0xFFFFFFFFL)) % d2;
        }
        this.len = 1;
        this.dig[0] = (int)rem;
        if (this.dig[0] == 0) {
            this.sign = 1;
        }
    }

    private void safeUrem(int mod) {
        long d2 = (long)mod & 0xFFFFFFFFL;
        long hbit = Long.MIN_VALUE;
        long hrem = Long.MAX_VALUE % d2;
        if (++hrem == d2) {
            hrem = 0L;
        }
        long rem = 0L;
        for (int i = this.len - 1; i >= 0; --i) {
            rem = (rem << 32) + ((long)this.dig[i] & 0xFFFFFFFFL);
            rem = ((rem & Long.MAX_VALUE) + (hrem & rem >> 63)) % d2;
        }
        this.len = 1;
        this.dig[0] = (int)rem;
        if (this.dig[0] == 0) {
            this.sign = 1;
        }
    }

    private void uaddMag(long a2) {
        if (this.dig.length <= 2) {
            this.realloc(3);
            this.len = 2;
        }
        long ah = a2 >>> 32;
        long al = a2 & 0xFFFFFFFFL;
        long carry = ((long)this.dig[0] & 0xFFFFFFFFL) + al;
        this.dig[0] = (int)carry;
        carry >>>= 32;
        carry = ((long)this.dig[1] & 0xFFFFFFFFL) + ah + carry;
        this.dig[1] = (int)carry;
        if (carry >> 32 != 0L) {
            int i = 2;
            while (i < this.len) {
                int n = i++;
                this.dig[n] = this.dig[n] + 1;
                if (this.dig[n] == 0) continue;
            }
            if (i == this.len) {
                if (this.len == this.dig.length) {
                    this.realloc();
                }
                this.dig[this.len++] = 1;
            }
        } else if (this.len == 2 && this.dig[1] == 0) {
            --this.len;
        }
    }

    private void usubMag(long s2) {
        long sh = s2 >>> 32;
        long sl = s2 & 0xFFFFFFFFL;
        long dif = ((long)this.dig[0] & 0xFFFFFFFFL) - sl;
        this.dig[0] = (int)dif;
        dif >>= 32;
        dif = ((long)this.dig[1] & 0xFFFFFFFFL) - sh + dif;
        this.dig[1] = (int)dif;
        if (dif >> 32 != 0L) {
            int i = 2;
            while (this.dig[i] == 0) {
                int n = i++;
                this.dig[n] = this.dig[n] - 1;
            }
            int n = i;
            this.dig[n] = this.dig[n] - 1;
            if (this.dig[n] == 0 && i + 1 == this.len) {
                --this.len;
            }
        }
        if (this.len == 2 && this.dig[1] == 0) {
            --this.len;
        }
    }

    public void uadd(long a2) {
        if (this.sign < 0) {
            long ah = a2 >>> 32;
            long al = a2 & 0xFFFFFFFFL;
            if (this.len > 2 || this.len == 2 && (((long)this.dig[1] & 0xFFFFFFFFL) > ah || ((long)this.dig[1] & 0xFFFFFFFFL) == ah && ((long)this.dig[0] & 0xFFFFFFFFL) >= al) || ah == 0L && ((long)this.dig[0] & 0xFFFFFFFFL) >= al) {
                this.usubMag(a2);
                return;
            }
            if (this.dig.length == 1) {
                this.realloc(2);
            }
            if (this.len == 1) {
                this.dig[this.len++] = 0;
            }
            long dif = al - ((long)this.dig[0] & 0xFFFFFFFFL);
            this.dig[0] = (int)dif;
            dif >>= 32;
            dif = ah - ((long)this.dig[1] & 0xFFFFFFFFL) + dif;
            this.dig[1] = (int)dif;
            if (dif == 0L) {
                --this.len;
            }
            this.sign = 1;
        } else {
            this.uaddMag(a2);
        }
    }

    public void usub(long a2) {
        if (this.sign > 0) {
            long ah = a2 >>> 32;
            long al = a2 & 0xFFFFFFFFL;
            if (this.len > 2 || this.len == 2 && (((long)this.dig[1] & 0xFFFFFFFFL) > ah || ((long)this.dig[1] & 0xFFFFFFFFL) == ah && ((long)this.dig[0] & 0xFFFFFFFFL) >= al) || ah == 0L && ((long)this.dig[0] & 0xFFFFFFFFL) >= al) {
                this.usubMag(a2);
                return;
            }
            if (this.dig.length == 1) {
                this.realloc(2);
            }
            if (this.len == 1) {
                this.dig[this.len++] = 0;
            }
            long dif = al - ((long)this.dig[0] & 0xFFFFFFFFL);
            this.dig[0] = (int)dif;
            dif >>= 32;
            dif = ah - ((long)this.dig[1] & 0xFFFFFFFFL) + dif;
            this.dig[1] = (int)dif;
            if (dif == 0L) {
                --this.len;
            }
            this.sign = -1;
        } else {
            this.uaddMag(a2);
        }
    }

    public void umul(long mul) {
        if (mul == 0L) {
            this.setToZero();
            return;
        }
        if (this.len + 2 >= this.dig.length) {
            this.realloc(2 * this.len + 1);
        }
        long mh = mul >>> 32;
        long ml = mul & 0xFFFFFFFFL;
        long carry = 0L;
        long next = 0L;
        for (int i = 0; i < this.len; ++i) {
            long tmp = ((long)this.dig[i] & 0xFFFFFFFFL) * ml;
            next = ((long)this.dig[i] & 0xFFFFFFFFL) * mh;
            this.dig[i] = (int)(tmp + (carry += next));
            carry = (tmp >>> 32) + (carry >>> 32) + ((tmp & 0xFFFFFFFFL) + (carry & 0xFFFFFFFFL) >>> 32);
        }
        this.dig[this.len++] = (int)(carry += next);
        this.dig[this.len++] = (int)(carry >>> 32);
        while (this.len > 1 && this.dig[this.len - 1] == 0) {
            --this.len;
        }
    }

    public long udiv(long div) {
        if (div == (div & 0xFFFFFFFFL)) {
            return (long)this.udiv((int)div) & 0xFFFFFFFFL;
        }
        if (this.len == 1) {
            long tmp = (long)this.dig[0] & 0xFFFFFFFFL;
            this.setToZero();
            return tmp;
        }
        int s2 = Integer.numberOfLeadingZeros((int)(div >>> 32));
        long dh = div >>> 32 - s2;
        long dl = div << s2 & 0xFFFFFFFFL;
        long hbit = Long.MIN_VALUE;
        long u2 = 0L;
        long u1 = this.dig[this.len - 1] >>> 32 - s2;
        long u0 = (long)(this.dig[this.len - 1] << s2 | this.dig[this.len - 2] >>> 32 - s2) & 0xFFFFFFFFL;
        if (s2 == 0) {
            u1 = 0L;
            u0 = (long)this.dig[this.len - 1] & 0xFFFFFFFFL;
        }
        for (int j = this.len - 2; j >= 0; --j) {
            u2 = u1;
            u1 = u0;
            u0 = s2 > 0 && j > 0 ? (long)(this.dig[j] << s2 | this.dig[j - 1] >>> 32 - s2) & 0xFFFFFFFFL : (long)(this.dig[j] << s2) & 0xFFFFFFFFL;
            long k = (u2 << 32) + u1;
            long qhat = (k >>> 1) / dh << 1;
            long t = k - qhat * dh;
            if (t + Long.MIN_VALUE >= dh + Long.MIN_VALUE) {
                ++qhat;
            }
            long rhat = k - qhat * dh;
            while (qhat + Long.MIN_VALUE >= -9223372032559808512L || qhat * dl + Long.MIN_VALUE > (rhat << 32) + u0 + Long.MIN_VALUE) {
                --qhat;
                if ((rhat += dh) + Long.MIN_VALUE < -9223372032559808512L) continue;
            }
            long p = qhat * dl;
            t = u0 - (p & 0xFFFFFFFFL);
            u0 = t & 0xFFFFFFFFL;
            k = (p >>> 32) - (t >> 32);
            p = qhat * dh;
            t = u1 - k - (p & 0xFFFFFFFFL);
            u1 = t & 0xFFFFFFFFL;
            k = (p >>> 32) - (t >> 32);
            t = u2 - k;
            u2 = t & 0xFFFFFFFFL;
            this.dig[j] = (int)qhat;
            if (t >= 0L) continue;
            int n = j;
            this.dig[n] = this.dig[n] - 1;
            t = u0 + dl;
            u0 = t & 0xFFFFFFFFL;
            t >>>= 32;
            t = u1 + dh + t;
            u1 = t & 0xFFFFFFFFL;
            u2 += (t >>>= 32) & 0xFFFFFFFFL;
        }
        --this.len;
        this.dig[this.len] = 0;
        if (this.len > 1 && this.dig[this.len - 1] == 0) {
            --this.len;
        }
        long tmp = u1 << 32 - s2 | u0 >>> s2;
        return s2 == 0 ? tmp : u2 << 64 - s2 | tmp;
    }

    public void urem(long mod) {
        long rem = this.udiv(mod);
        this.len = 2;
        this.dig[0] = (int)rem;
        if (rem == (rem & 0xFFFFFFFFL)) {
            --this.len;
            return;
        }
        this.dig[1] = (int)(rem >>> 32);
    }

    public void add(int add) {
        if (add < 0) {
            this.usub(-add);
        } else {
            this.uadd(add);
        }
    }

    public void sub(int sub) {
        if (sub < 0) {
            this.uadd(-sub);
        } else {
            this.usub(sub);
        }
    }

    public void mul(int mul) {
        if (this.isZero()) {
            return;
        }
        if (mul < 0) {
            this.sign = -this.sign;
            this.umul(-mul);
        } else {
            this.umul(mul);
        }
    }

    public int div(int div) {
        if (this.isZero()) {
            return 0;
        }
        if (div < 0) {
            this.sign = -this.sign;
            return -this.sign * this.udiv(-div);
        }
        return this.sign * this.udiv(div);
    }

    public void add(long add) {
        if (add < 0L) {
            this.usub(-add);
        } else {
            this.uadd(add);
        }
    }

    public void sub(long sub) {
        if (sub < 0L) {
            this.uadd(-sub);
        } else {
            this.usub(sub);
        }
    }

    public void mul(long mul) {
        if (this.isZero()) {
            return;
        }
        if (mul < 0L) {
            this.sign = -this.sign;
            this.umul(-mul);
        } else {
            this.umul(mul);
        }
    }

    public long div(long div) {
        if (this.isZero()) {
            return 0L;
        }
        if (div < 0L) {
            this.sign = -this.sign;
            return (long)(-this.sign) * this.udiv(-div);
        }
        return (long)this.sign * this.udiv(div);
    }

    private void addMag(int[] v, int vlen) {
        int i;
        int ulen = this.len;
        int[] u = this.dig;
        if (vlen < ulen) {
            u = v;
            v = this.dig;
            ulen = vlen;
            vlen = this.len;
        }
        if (vlen > this.dig.length) {
            this.realloc(vlen + 1);
        }
        long carry = 0L;
        for (i = 0; i < ulen; ++i) {
            carry = ((long)u[i] & 0xFFFFFFFFL) + ((long)v[i] & 0xFFFFFFFFL) + carry;
            this.dig[i] = (int)carry;
            carry >>>= 32;
        }
        if (vlen > this.len) {
            System.arraycopy(v, this.len, this.dig, this.len, vlen - this.len);
            this.len = vlen;
        }
        if (carry != 0L) {
            while (i < this.len) {
                int n = i++;
                this.dig[n] = this.dig[n] + 1;
                if (this.dig[n] == 0) continue;
            }
            if (i == this.len) {
                if (this.len == this.dig.length) {
                    this.realloc();
                }
                this.dig[this.len++] = 1;
            }
        }
    }

    private void subMag(int[] u, int ulen) {
        int i;
        int vlen = this.len;
        int[] v = this.dig;
        long dif = 0L;
        for (i = 0; i < ulen; ++i) {
            dif = ((long)v[i] & 0xFFFFFFFFL) - ((long)u[i] & 0xFFFFFFFFL) + dif;
            this.dig[i] = (int)dif;
            dif >>= 32;
        }
        if (dif != 0L) {
            while (this.dig[i] == 0) {
                int n = i++;
                this.dig[n] = this.dig[n] - 1;
            }
            int n = i;
            this.dig[n] = this.dig[n] - 1;
            if (this.dig[n] == 0 && i + 1 == this.len) {
                this.len = ulen;
            }
        }
        while (this.len > 1 && this.dig[this.len - 1] == 0) {
            --this.len;
        }
    }

    public void add(BigInt a2) {
        int i;
        if (this.sign == a2.sign) {
            this.addMag(a2.dig, a2.len);
            return;
        }
        if (this.compareAbsTo(a2) >= 0) {
            this.subMag(a2.dig, a2.len);
            return;
        }
        int[] v = a2.dig;
        int vlen = a2.len;
        if (this.dig.length < vlen) {
            this.realloc(vlen + 1);
        }
        this.sign = -this.sign;
        long dif = 0L;
        for (i = 0; i < this.len; ++i) {
            dif = ((long)v[i] & 0xFFFFFFFFL) - ((long)this.dig[i] & 0xFFFFFFFFL) + dif;
            this.dig[i] = (int)dif;
            dif >>= 32;
        }
        if (vlen > this.len) {
            System.arraycopy(v, this.len, this.dig, this.len, vlen - this.len);
            this.len = vlen;
        }
        if (dif != 0L) {
            while (i < vlen && this.dig[i] == 0) {
                int n = i++;
                this.dig[n] = this.dig[n] - 1;
            }
            int n = i;
            this.dig[n] = this.dig[n] - 1;
            if (this.dig[n] == 0 && i + 1 == this.len) {
                --this.len;
            }
        }
    }

    public void sub(BigInt a2) {
        int i;
        if (this.sign != a2.sign) {
            this.addMag(a2.dig, a2.len);
            return;
        }
        if (this.compareAbsTo(a2) >= 0) {
            this.subMag(a2.dig, a2.len);
            return;
        }
        int[] v = a2.dig;
        int vlen = a2.len;
        if (this.dig.length < vlen) {
            this.realloc(vlen + 1);
        }
        this.sign = -this.sign;
        long dif = 0L;
        for (i = 0; i < this.len; ++i) {
            dif = ((long)v[i] & 0xFFFFFFFFL) - ((long)this.dig[i] & 0xFFFFFFFFL) + dif;
            this.dig[i] = (int)dif;
            dif >>= 32;
        }
        if (vlen > this.len) {
            System.arraycopy(v, this.len, this.dig, this.len, vlen - this.len);
            this.len = vlen;
        }
        if (dif != 0L) {
            while (i < vlen && this.dig[i] == 0) {
                int n = i++;
                this.dig[n] = this.dig[n] - 1;
            }
            int n = i;
            this.dig[n] = this.dig[n] - 1;
            if (this.dig[n] == 0 && i + 1 == this.len) {
                --this.len;
            }
        }
    }

    public void mul(BigInt mul) {
        if (this.isZero()) {
            return;
        }
        if (mul.isZero()) {
            this.setToZero();
        } else if (mul.len <= 2 || this.len <= 2) {
            this.sign *= mul.sign;
            if (mul.len == 1) {
                this.umul(mul.dig[0]);
            } else if (this.len == 1) {
                int tmp = this.dig[0];
                this.assign(mul.dig, mul.len);
                this.umul(tmp);
            } else if (mul.len == 2) {
                this.umul((long)mul.dig[1] << 32 | (long)mul.dig[0] & 0xFFFFFFFFL);
            } else {
                long tmp = (long)this.dig[1] << 32 | (long)this.dig[0] & 0xFFFFFFFFL;
                this.assign(mul.dig, mul.len);
                this.umul(tmp);
            }
        } else if (this.len < 128 || mul.len < 128 || (long)this.len * (long)mul.len < 1000000L) {
            this.smallMul(mul);
        } else if (Math.max(this.len, mul.len) < 20000) {
            this.karatsuba(mul, false);
        } else {
            this.karatsuba(mul, true);
        }
    }

    public void smallMul(BigInt mul) {
        if (this.isZero()) {
            return;
        }
        if (mul.isZero()) {
            this.setToZero();
            return;
        }
        this.sign *= mul.sign;
        int ulen = this.len;
        int vlen = mul.len;
        int[] u = this.dig;
        int[] v = mul.dig;
        if (vlen < ulen) {
            u = v;
            v = this.dig;
            ulen = vlen;
            vlen = this.len;
        }
        int[] res = BigInt.naiveMul(u, ulen, v, vlen);
        this.dig = res;
        this.len = res.length;
        if (res[this.len - 1] == 0) {
            --this.len;
        }
    }

    public void karatsuba(BigInt mul) {
        this.karatsuba(mul, false);
    }

    public void karatsuba(BigInt mul, boolean parallel) {
        int i;
        if (mul.dig.length < this.len) {
            mul.realloc(this.len);
        } else if (this.dig.length < mul.len) {
            this.realloc(mul.len);
        }
        if (mul.len < this.len) {
            for (i = mul.len; i < this.len; ++i) {
                mul.dig[i] = 0;
            }
        }
        if (this.len < mul.len) {
            for (i = this.len; i < mul.len; ++i) {
                this.dig[i] = 0;
            }
        }
        int mlen = Math.max(this.len, mul.len);
        int[] res = null;
        if (!parallel) {
            res = BigInt.kmul(this.dig, mul.dig, 0, mlen);
        } else {
            ExecutorService pool = Executors.newFixedThreadPool(12);
            try {
                res = BigInt.pmul(this.dig, mul.dig, 0, mlen, 1, pool);
            }
            catch (Exception e2) {
                System.err.println(e2);
            }
            pool.shutdown();
        }
        this.len += mul.len;
        while (res[this.len - 1] == 0) {
            --this.len;
        }
        this.dig = res;
        this.sign *= mul.sign;
    }

    private static int[] naiveMul(int[] u, int ulen, int[] v, int vlen) {
        long tmp;
        int[] res = new int[ulen + vlen];
        long carry = 0L;
        long ui = (long)u[0] & 0xFFFFFFFFL;
        for (int j = 0; j < vlen; ++j) {
            tmp = ui * ((long)v[j] & 0xFFFFFFFFL) + carry;
            res[j] = (int)tmp;
            carry = tmp >>> 32;
        }
        res[vlen] = (int)carry;
        for (int i = 1; i < ulen; ++i) {
            ui = (long)u[i] & 0xFFFFFFFFL;
            carry = 0L;
            for (int j = 0; j < vlen; ++j) {
                tmp = ui * ((long)v[j] & 0xFFFFFFFFL) + ((long)res[i + j] & 0xFFFFFFFFL) + carry;
                res[i + j] = (int)tmp;
                carry = tmp >>> 32;
            }
            res[i + vlen] = (int)carry;
        }
        return res;
    }

    private static int[] kmul(int[] x, int[] y, int off, int n) {
        int i;
        int i2;
        if (n <= 32) {
            long tmp;
            int[] z = new int[2 * n];
            long carry = 0L;
            long xi = (long)x[off] & 0xFFFFFFFFL;
            for (int j = 0; j < n; ++j) {
                tmp = xi * ((long)y[off + j] & 0xFFFFFFFFL) + carry;
                z[j] = (int)tmp;
                carry = tmp >>> 32;
            }
            z[n] = (int)carry;
            for (int i3 = 1; i3 < n; ++i3) {
                xi = (long)x[off + i3] & 0xFFFFFFFFL;
                carry = 0L;
                for (int j = 0; j < n; ++j) {
                    tmp = xi * ((long)y[off + j] & 0xFFFFFFFFL) + ((long)z[i3 + j] & 0xFFFFFFFFL) + carry;
                    z[i3 + j] = (int)tmp;
                    carry = tmp >>> 32;
                }
                z[i3 + n] = (int)carry;
            }
            return z;
        }
        int b2 = n >>> 1;
        int[] z2 = BigInt.kmul(x, y, off + b2, n - b2);
        int[] z0 = BigInt.kmul(x, y, off, b2);
        int[] x2 = new int[n - b2 + 1];
        int[] y2 = new int[n - b2 + 1];
        long carry = 0L;
        for (i2 = 0; i2 < b2; ++i2) {
            carry = ((long)x[off + b2 + i2] & 0xFFFFFFFFL) + ((long)x[off + i2] & 0xFFFFFFFFL) + carry;
            x2[i2] = (int)carry;
            carry >>>= 32;
        }
        if ((n & 1) != 0) {
            x2[b2] = x[off + b2 + b2];
        }
        if (carry != 0L) {
            int n2 = b2;
            x2[n2] = x2[n2] + 1;
            if (x2[n2] == 0) {
                int n3 = b2 + 1;
                x2[n3] = x2[n3] + 1;
            }
        }
        carry = 0L;
        for (i2 = 0; i2 < b2; ++i2) {
            carry = ((long)y[off + b2 + i2] & 0xFFFFFFFFL) + ((long)y[off + i2] & 0xFFFFFFFFL) + carry;
            y2[i2] = (int)carry;
            carry >>>= 32;
        }
        if ((n & 1) != 0) {
            y2[b2] = y[off + b2 + b2];
        }
        if (carry != 0L) {
            int n4 = b2;
            y2[n4] = y2[n4] + 1;
            if (y2[n4] == 0) {
                int n5 = b2 + 1;
                y2[n5] = y2[n5] + 1;
            }
        }
        int[] z1 = BigInt.kmul(x2, y2, 0, n - b2 + (x2[n - b2] != 0 || y2[n - b2] != 0 ? 1 : 0));
        int[] z = new int[2 * n];
        System.arraycopy(z0, 0, z, 0, 2 * b2);
        System.arraycopy(z2, 0, z, b2 + b2, 2 * (n - b2));
        carry = 0L;
        for (i = 0; i < 2 * b2; ++i) {
            carry = ((long)z[i + b2] & 0xFFFFFFFFL) + ((long)z1[i] & 0xFFFFFFFFL) - ((long)z2[i] & 0xFFFFFFFFL) - ((long)z0[i] & 0xFFFFFFFFL) + carry;
            z[i + b2] = (int)carry;
            carry >>= 32;
        }
        while (i < 2 * (n - b2)) {
            carry = ((long)z[i + b2] & 0xFFFFFFFFL) + ((long)z1[i] & 0xFFFFFFFFL) - ((long)z2[i] & 0xFFFFFFFFL) + carry;
            z[i + b2] = (int)carry;
            carry >>= 32;
            ++i;
        }
        while (i < z1.length) {
            carry = ((long)z[i + b2] & 0xFFFFFFFFL) + ((long)z1[i] & 0xFFFFFFFFL) + carry;
            z[i + b2] = (int)carry;
            carry >>= 32;
            ++i;
        }
        if (carry != 0L) {
            while (true) {
                int n6 = i + b2;
                z[n6] = z[n6] + 1;
                if (z[n6] != 0) break;
                ++i;
            }
        }
        return z;
    }

    private static int[] pmul(final int[] x, final int[] y, final int off, final int n, final int lim, final ExecutorService pool) throws Exception {
        int i;
        int i2;
        final int b2 = n >>> 1;
        Future<int[]> left = pool.submit(new Callable<int[]>(){

            @Override
            public int[] call() throws Exception {
                return lim == 0 ? BigInt.kmul(x, y, off, b2) : BigInt.pmul(x, y, off, b2, lim - 1, pool);
            }
        });
        Future<int[]> right = pool.submit(new Callable<int[]>(){

            @Override
            public int[] call() throws Exception {
                return lim == 0 ? BigInt.kmul(x, y, off + b2, n - b2) : BigInt.pmul(x, y, off + b2, n - b2, lim - 1, pool);
            }
        });
        final int[] x2 = new int[n - b2 + 1];
        final int[] y2 = new int[n - b2 + 1];
        long carry = 0L;
        for (i2 = 0; i2 < b2; ++i2) {
            carry = ((long)x[off + b2 + i2] & 0xFFFFFFFFL) + ((long)x[off + i2] & 0xFFFFFFFFL) + carry;
            x2[i2] = (int)carry;
            carry >>>= 32;
        }
        if ((n & 1) != 0) {
            x2[b2] = x[off + b2 + b2];
        }
        if (carry != 0L) {
            int n2 = b2;
            x2[n2] = x2[n2] + 1;
            if (x2[n2] == 0) {
                int n3 = b2 + 1;
                x2[n3] = x2[n3] + 1;
            }
        }
        carry = 0L;
        for (i2 = 0; i2 < b2; ++i2) {
            carry = ((long)y[off + b2 + i2] & 0xFFFFFFFFL) + ((long)y[off + i2] & 0xFFFFFFFFL) + carry;
            y2[i2] = (int)carry;
            carry >>>= 32;
        }
        if ((n & 1) != 0) {
            y2[b2] = y[off + b2 + b2];
        }
        if (carry != 0L) {
            int n4 = b2;
            y2[n4] = y2[n4] + 1;
            if (y2[n4] == 0) {
                int n5 = b2 + 1;
                y2[n5] = y2[n5] + 1;
            }
        }
        Future<int[]> mid = pool.submit(new Callable<int[]>(){

            @Override
            public int[] call() throws Exception {
                return lim == 0 ? BigInt.kmul(x2, y2, 0, n - b2 + (x2[n - b2] != 0 || y2[n - b2] != 0 ? 1 : 0)) : BigInt.pmul(x2, y2, 0, n - b2 + (x2[n - b2] != 0 || y2[n - b2] != 0 ? 1 : 0), lim - 1, pool);
            }
        });
        int[] z = new int[2 * n];
        int[] z0 = left.get();
        System.arraycopy(z0, 0, z, 0, 2 * b2);
        int[] z2 = right.get();
        System.arraycopy(z2, 0, z, b2 + b2, 2 * (n - b2));
        int[] z1 = mid.get();
        carry = 0L;
        for (i = 0; i < 2 * b2; ++i) {
            carry = ((long)z[i + b2] & 0xFFFFFFFFL) + ((long)z1[i] & 0xFFFFFFFFL) - ((long)z2[i] & 0xFFFFFFFFL) - ((long)z0[i] & 0xFFFFFFFFL) + carry;
            z[i + b2] = (int)carry;
            carry >>= 32;
        }
        while (i < 2 * (n - b2)) {
            carry = ((long)z[i + b2] & 0xFFFFFFFFL) + ((long)z1[i] & 0xFFFFFFFFL) - ((long)z2[i] & 0xFFFFFFFFL) + carry;
            z[i + b2] = (int)carry;
            carry >>= 32;
            ++i;
        }
        while (i < z1.length) {
            carry = ((long)z[i + b2] & 0xFFFFFFFFL) + ((long)z1[i] & 0xFFFFFFFFL) + carry;
            z[i + b2] = (int)carry;
            carry >>= 32;
            ++i;
        }
        if (carry != 0L) {
            while (true) {
                int n6 = i + b2;
                z[n6] = z[n6] + 1;
                if (z[n6] != 0) break;
                ++i;
            }
        }
        return z;
    }

    public void div(BigInt div) {
        if (div.len == 1) {
            this.sign *= div.sign;
            this.udiv(div.dig[0]);
            return;
        }
        int tmp = this.compareAbsTo(div);
        if (tmp < 0) {
            this.setToZero();
            return;
        }
        if (tmp == 0) {
            this.uassign(1, this.sign * div.sign);
            return;
        }
        int[] q = new int[this.len - div.len + 1];
        if (this.len == this.dig.length) {
            this.realloc(this.len + 1);
        }
        this.div(this.dig, div.dig, this.len, div.len, q);
        this.dig = q;
        this.len = q.length;
        while (this.len > 1 && this.dig[this.len - 1] == 0) {
            --this.len;
        }
        this.sign *= div.sign;
    }

    public void rem(BigInt div) {
        if (div.len == 1) {
            this.urem(div.dig[0]);
            return;
        }
        int tmp = this.compareAbsTo(div);
        if (tmp < 0) {
            return;
        }
        if (tmp == 0) {
            this.setToZero();
            return;
        }
        int[] q = new int[this.len - div.len + 1];
        if (this.len == this.dig.length) {
            this.realloc(this.len + 1);
        }
        this.div(this.dig, div.dig, this.len, div.len, q);
        this.len = div.len;
        while (this.dig[this.len - 1] == 0) {
            --this.len;
        }
    }

    public BigInt divRem(BigInt div) {
        int tmp = this.sign;
        if (div.len == 1) {
            this.sign *= div.sign;
            return new BigInt(tmp, this.udiv(div.dig[0]));
        }
        tmp = this.compareAbsTo(div);
        if (tmp < 0) {
            BigInt cpy = new BigInt(this.sign, this.dig, this.len);
            this.dig = new int[2];
            this.len = 1;
            return cpy;
        }
        if (tmp == 0) {
            this.uassign(1, this.sign *= div.sign);
            return new BigInt(1, 0);
        }
        int[] q = new int[this.len - div.len + 1];
        if (this.len == this.dig.length) {
            this.realloc(this.len + 1);
        }
        this.div(this.dig, div.dig, this.len, div.len, q);
        int[] r = this.dig;
        this.dig = q;
        this.len = q.length;
        while (this.len > 1 && this.dig[this.len - 1] == 0) {
            --this.len;
        }
        for (tmp = div.len; tmp > 1 && r[tmp - 1] == 0; --tmp) {
        }
        this.sign *= div.sign;
        return new BigInt(this.sign / div.sign, r, tmp);
    }

    public void mod(BigInt div) {
        if (div.sign <= 0) {
            throw new ArithmeticException("BigInt: modulus not positive");
        }
        this.rem(div);
        if (this.sign < 0) {
            this.add(div);
        }
    }

    private void div(int[] u, int[] v, int m3, int n, int[] q) {
        int i;
        long b2 = 0x100000000L;
        int s2 = Integer.numberOfLeadingZeros(v[n - 1]);
        if (s2 > 0) {
            for (i = n - 1; i > 0; --i) {
                v[i] = v[i] << s2 | v[i - 1] >>> 32 - s2;
            }
            v[0] = v[0] << s2;
            u[m3] = u[m3 - 1] >>> 32 - s2;
            for (i = m3 - 1; i > 0; --i) {
                u[i] = u[i] << s2 | u[i - 1] >>> 32 - s2;
            }
            u[0] = u[0] << s2;
        }
        long dh = (long)v[n - 1] & 0xFFFFFFFFL;
        long dl = (long)v[n - 2] & 0xFFFFFFFFL;
        long hbit = Long.MIN_VALUE;
        for (int j = m3 - n; j >= 0; --j) {
            long k = (long)u[j + n] * 0x100000000L + ((long)u[j + n - 1] & 0xFFFFFFFFL);
            long qhat = (k >>> 1) / dh << 1;
            long t = k - qhat * dh;
            if (t + Long.MIN_VALUE >= dh + Long.MIN_VALUE) {
                ++qhat;
            }
            long rhat = k - qhat * dh;
            while (qhat + Long.MIN_VALUE >= -9223372032559808512L || qhat * dl + Long.MIN_VALUE > 0x100000000L * rhat + ((long)u[j + n - 2] & 0xFFFFFFFFL) + Long.MIN_VALUE) {
                --qhat;
                if ((rhat += dh) + Long.MIN_VALUE < -9223372032559808512L) continue;
            }
            k = 0L;
            for (i = 0; i < n; ++i) {
                long p = qhat * ((long)v[i] & 0xFFFFFFFFL);
                t = ((long)u[i + j] & 0xFFFFFFFFL) - k - (p & 0xFFFFFFFFL);
                u[i + j] = (int)t;
                k = (p >>> 32) - (t >> 32);
            }
            t = ((long)u[j + n] & 0xFFFFFFFFL) - k;
            u[j + n] = (int)t;
            q[j] = (int)qhat;
            if (t >= 0L) continue;
            q[j] = q[j] - 1;
            k = 0L;
            for (i = 0; i < n; ++i) {
                t = ((long)u[i + j] & 0xFFFFFFFFL) + ((long)v[i] & 0xFFFFFFFFL) + k;
                u[i + j] = (int)t;
                k = t >>> 32;
            }
            int n2 = j + n;
            u[n2] = u[n2] + (int)k;
        }
        if (s2 > 0) {
            for (i = 0; i < n - 1; ++i) {
                v[i] = v[i] >>> s2 | v[i + 1] << 32 - s2;
            }
            int n3 = n - 1;
            v[n3] = v[n3] >>> s2;
            for (i = 0; i < m3; ++i) {
                u[i] = u[i] >>> s2 | u[i + 1] << 32 - s2;
            }
            int n4 = m3;
            u[n4] = u[n4] >>> s2;
        }
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        int top = this.len * 10 + 1;
        char[] buf = new char[top];
        Arrays.fill(buf, '0');
        int[] cpy = Arrays.copyOf(this.dig, this.len);
        while (true) {
            int j = top;
            for (long tmp = this.toStringDiv(); tmp > 0L; tmp /= 10L) {
                int n = --top;
                buf[n] = (char)((long)buf[n] + tmp % 10L);
            }
            if (this.len == 1 && this.dig[0] == 0) break;
            top = j - 13;
        }
        if (this.sign < 0) {
            buf[--top] = 45;
        }
        this.len = cpy.length;
        System.arraycopy(cpy, 0, this.dig, 0, this.len);
        return new String(buf, top, buf.length - top);
    }

    private long toStringDiv() {
        int pow5 = 1220703125;
        int pow2 = 8192;
        int nextq = 0;
        long rem = 0L;
        for (int i = this.len - 1; i > 0; --i) {
            rem = (rem << 32) + ((long)this.dig[i] & 0xFFFFFFFFL);
            int q = (int)(rem / 1220703125L);
            rem %= 1220703125L;
            this.dig[i] = nextq | q >>> 13;
            nextq = q << 19;
        }
        rem = (rem << 32) + ((long)this.dig[0] & 0xFFFFFFFFL);
        int mod2 = this.dig[0] & 0x1FFF;
        this.dig[0] = nextq | (int)(rem / 1220703125L >>> 13);
        rem %= 1220703125L;
        long pow10 = 10000000000000L;
        if ((rem = (rem - 1220703125L * ((long)mod2 - rem) % 10000000000000L * 67L) % 10000000000000L) < 0L) {
            rem += 10000000000000L;
        }
        if (this.dig[this.len - 1] == 0 && this.len > 1 && this.dig[--this.len - 1] == 0 && this.len > 1) {
            --this.len;
        }
        return rem;
    }

    private void smallShiftLeft(int shift, int first) {
        int[] res = this.dig;
        if (this.dig[this.len - 1] << shift >>> shift != this.dig[this.len - 1]) {
            if (++this.len > this.dig.length) {
                res = new int[this.len + 1];
            } else {
                this.dig[this.len - 1] = 0;
            }
        }
        int nxt = this.len > this.dig.length ? 0 : this.dig[this.len - 1];
        for (int i = this.len - 1; i > first; --i) {
            int n = nxt << shift;
            nxt = this.dig[i - 1];
            res[i] = n | nxt >>> 32 - shift;
        }
        res[first] = nxt << shift;
        this.dig = res;
    }

    private void smallShiftRight(int shift) {
        int nxt = this.dig[0];
        for (int i = 0; i < this.len - 1; ++i) {
            int n = nxt >>> shift;
            nxt = this.dig[i + 1];
            this.dig[i] = n | nxt << 32 - shift;
        }
        int n = this.len - 1;
        this.dig[n] = this.dig[n] >>> shift;
        if (this.dig[n] == 0 && this.len > 1) {
            --this.len;
        }
    }

    private void bigShiftLeft(int shift) {
        if (this.len + shift > this.dig.length) {
            int[] res = new int[this.len + shift + 1];
            System.arraycopy(this.dig, 0, res, shift, this.len);
            this.dig = res;
        } else {
            System.arraycopy(this.dig, 0, this.dig, shift, this.len);
            for (int i = 0; i < shift; ++i) {
                this.dig[i] = 0;
            }
        }
        this.len += shift;
    }

    private void bigShiftRight(int shift) {
        System.arraycopy(this.dig, shift, this.dig, 0, this.len - shift);
        this.len -= shift;
    }

    public void shiftLeft(int shift) {
        int bigShift = shift >>> 5;
        int smallShift = shift & 0x1F;
        if (bigShift > 0) {
            this.bigShiftLeft(bigShift);
        }
        if (smallShift > 0) {
            this.smallShiftLeft(smallShift, bigShift);
        }
    }

    public void shiftRight(int shift) {
        int bigShift = shift >>> 5;
        int smallShift = shift & 0x1F;
        if (bigShift > 0) {
            this.bigShiftRight(bigShift);
        }
        if (smallShift > 0) {
            this.smallShiftRight(smallShift);
        }
    }

    public boolean testBit(int bit) {
        int j;
        int bigBit = bit >>> 5;
        int smallBit = bit & 0x1F;
        if (bigBit >= this.len) {
            return this.sign < 0;
        }
        if (this.sign > 0) {
            return (this.dig[bigBit] & 1 << smallBit) != 0;
        }
        for (j = 0; j <= bigBit && this.dig[j] == 0; ++j) {
        }
        if (j > bigBit) {
            return false;
        }
        if (j < bigBit) {
            return (this.dig[bigBit] & 1 << smallBit) == 0;
        }
        j = -this.dig[bigBit];
        return (j & 1 << smallBit) != 0;
    }

    public void setBit(int bit) {
        int bigBit = bit >>> 5;
        int smallBit = bit & 0x1F;
        if (this.sign > 0) {
            if (bigBit >= this.dig.length) {
                this.realloc(bigBit + 1);
                this.len = bigBit + 1;
            } else if (bigBit >= this.len) {
                while (this.len <= bigBit) {
                    this.dig[this.len] = 0;
                    ++this.len;
                }
            }
            int n = bigBit;
            this.dig[n] = this.dig[n] | 1 << smallBit;
        } else {
            int j;
            if (bigBit >= this.len) {
                return;
            }
            for (j = 0; j <= bigBit && this.dig[j] == 0; ++j) {
            }
            if (j > bigBit) {
                this.dig[bigBit] = -1 << smallBit;
                while (this.dig[j] == 0) {
                    this.dig[j] = -1;
                    ++j;
                }
                this.dig[j] = ~(-this.dig[j]);
                if (j == this.len - 1 && this.dig[this.len - 1] == 0) {
                    --this.len;
                }
                return;
            }
            if (j < bigBit) {
                int n = bigBit;
                this.dig[n] = this.dig[n] & ~(1 << smallBit);
                while (this.dig[this.len - 1] == 0) {
                    --this.len;
                }
                return;
            }
            int k = 1 << smallBit;
            if (k - (j = Integer.lowestOneBit(this.dig[j])) > 0) {
                int n = bigBit;
                this.dig[n] = this.dig[n] & ~k;
            } else {
                int n = bigBit;
                this.dig[n] = this.dig[n] ^ ((j << 1) - 1 ^ k - 1);
                int n2 = bigBit;
                this.dig[n2] = this.dig[n2] | k;
            }
        }
    }

    public void clearBit(int bit) {
        int bigBit = bit >>> 5;
        int smallBit = bit & 0x1F;
        if (this.sign > 0) {
            if (bigBit < this.len) {
                int n = bigBit;
                this.dig[n] = this.dig[n] & ~(1 << smallBit);
                while (this.dig[this.len - 1] == 0 && this.len > 1) {
                    --this.len;
                }
            }
        } else {
            int k;
            int j;
            if (bigBit >= this.dig.length) {
                this.realloc(bigBit + 1);
                this.len = bigBit + 1;
                int n = bigBit;
                this.dig[n] = this.dig[n] | 1 << smallBit;
                return;
            }
            if (bigBit >= this.len) {
                while (this.len <= bigBit) {
                    this.dig[this.len] = 0;
                    ++this.len;
                }
                int n = bigBit;
                this.dig[n] = this.dig[n] | 1 << smallBit;
                return;
            }
            for (j = 0; j <= bigBit && this.dig[j] == 0; ++j) {
            }
            if (j > bigBit) {
                return;
            }
            if (j < bigBit) {
                int n = bigBit;
                this.dig[n] = this.dig[n] | 1 << smallBit;
                return;
            }
            if ((j = Integer.lowestOneBit(this.dig[j])) - (k = 1 << smallBit) > 0) {
                return;
            }
            if (j - k < 0) {
                int n = bigBit;
                this.dig[n] = this.dig[n] | k;
                return;
            }
            j = this.dig[bigBit];
            if (j == (0xFFFFFFFF ^ k - 1)) {
                this.dig[bigBit] = 0;
                for (j = bigBit + 1; j < this.len && this.dig[j] == -1; ++j) {
                    this.dig[j] = 0;
                }
                if (j == this.dig.length) {
                    this.realloc(j + 2);
                }
                if (j == this.len) {
                    this.dig[this.len++] = 1;
                    return;
                }
                this.dig[j] = -(~this.dig[j]);
            } else {
                j = Integer.lowestOneBit(j ^ (0xFFFFFFFF ^ k - 1));
                int n = bigBit;
                this.dig[n] = this.dig[n] ^ (j | j - 1 ^ k - 1);
            }
        }
    }

    public void flipBit(int bit) {
        int bigBit = bit >>> 5;
        int smallBit = bit & 0x1F;
        if (bigBit >= this.dig.length) {
            this.realloc(bigBit + 1);
            this.len = bigBit + 1;
            int n = bigBit;
            this.dig[n] = this.dig[n] ^ 1 << smallBit;
        } else if (bigBit >= this.len) {
            while (this.len <= bigBit) {
                this.dig[this.len] = 0;
                ++this.len;
            }
            int n = bigBit;
            this.dig[n] = this.dig[n] ^ 1 << smallBit;
        } else if (this.sign > 0) {
            int n = bigBit;
            this.dig[n] = this.dig[n] ^ 1 << smallBit;
        } else {
            int j;
            for (j = 0; j <= bigBit && this.dig[j] == 0; ++j) {
            }
            if (j < bigBit) {
                int n = bigBit;
                this.dig[n] = this.dig[n] ^ 1 << smallBit;
            } else {
                int k;
                if (j > bigBit) {
                    this.dig[bigBit] = -1 << smallBit;
                    while (this.dig[j] == 0) {
                        this.dig[j] = -1;
                        ++j;
                    }
                    this.dig[j] = ~(-this.dig[j]);
                    if (j == this.len - 1 && this.dig[this.len - 1] == 0) {
                        --this.len;
                    }
                    return;
                }
                if ((j = Integer.lowestOneBit(this.dig[j])) - (k = 1 << smallBit) > 0) {
                    int n = bigBit;
                    this.dig[n] = this.dig[n] ^ ((j << 1) - 1 ^ k - 1);
                    return;
                }
                if (j - k < 0) {
                    int n = bigBit;
                    this.dig[n] = this.dig[n] ^ k;
                    return;
                }
                j = this.dig[bigBit];
                if (j == (0xFFFFFFFF ^ k - 1)) {
                    this.dig[bigBit] = 0;
                    for (j = bigBit + 1; j < this.len && this.dig[j] == -1; ++j) {
                        this.dig[j] = 0;
                    }
                    if (j == this.dig.length) {
                        this.realloc(j + 2);
                    }
                    if (j == this.len) {
                        this.dig[this.len++] = 1;
                        return;
                    }
                    this.dig[j] = -(~this.dig[j]);
                } else {
                    j = Integer.lowestOneBit(j ^ (0xFFFFFFFF ^ k - 1));
                    int n = bigBit;
                    this.dig[n] = this.dig[n] ^ (j | j - 1 ^ k - 1);
                }
            }
        }
        while (this.dig[this.len - 1] == 0 && this.len > 1) {
            --this.len;
        }
    }

    public void and(BigInt mask) {
        if (this.sign > 0) {
            if (mask.sign > 0) {
                if (mask.len < this.len) {
                    this.len = mask.len;
                }
                for (int i = 0; i < this.len; ++i) {
                    int n = i;
                    this.dig[n] = this.dig[n] & mask.dig[i];
                }
            } else {
                int j;
                int mlen = Math.min(this.len, mask.len);
                int a2 = this.dig[0];
                int b2 = mask.dig[0];
                for (j = 1; (a2 | b2) == 0 && j < mlen; ++j) {
                    a2 = this.dig[j];
                    b2 = mask.dig[j];
                }
                if (a2 != 0 && b2 == 0) {
                    this.dig[j - 1] = 0;
                    while (j < mlen && mask.dig[j] == 0) {
                        this.dig[j] = 0;
                        ++j;
                    }
                    if (j < mlen) {
                        int n = j;
                        this.dig[n] = this.dig[n] & -mask.dig[j];
                    } else if (j == this.len) {
                        this.len = 1;
                    }
                    ++j;
                } else if (a2 == 0) {
                    while (j < mlen && this.dig[j] == 0) {
                        ++j;
                    }
                } else {
                    int n = j - 1;
                    this.dig[n] = this.dig[n] & -b2;
                }
                while (j < mlen) {
                    int n = j;
                    this.dig[n] = this.dig[n] & ~mask.dig[j];
                    ++j;
                }
            }
            while (this.dig[this.len - 1] == 0 && this.len > 1) {
                --this.len;
            }
        } else {
            int mlen = Math.min(this.len, mask.len);
            if (mask.sign > 0) {
                int j;
                int a3 = this.dig[0];
                int b3 = mask.dig[0];
                for (j = 1; (a3 | b3) == 0 && j < mlen; ++j) {
                    a3 = this.dig[j];
                    b3 = mask.dig[j];
                }
                if (a3 != 0 && b3 == 0) {
                    this.dig[j - 1] = 0;
                    while (j < mlen && mask.dig[j] == 0) {
                        this.dig[j] = 0;
                        ++j;
                    }
                } else if (a3 == 0) {
                    while (j < mlen && this.dig[j] == 0) {
                        ++j;
                    }
                    if (j < mlen) {
                        this.dig[j] = -this.dig[j] & mask.dig[j];
                    }
                    ++j;
                } else {
                    this.dig[j - 1] = -a3 & b3;
                }
                while (j < mlen) {
                    this.dig[j] = ~this.dig[j] & mask.dig[j];
                    ++j;
                }
                if (mask.len > this.len) {
                    if (mask.len > this.dig.length) {
                        this.realloc(mask.len + 2);
                    }
                    System.arraycopy(mask.dig, this.len, this.dig, this.len, mask.len - this.len);
                }
                this.len = mask.len;
                this.sign = 1;
                while (this.dig[this.len - 1] == 0 && this.len > 1) {
                    --this.len;
                }
            } else {
                if (mask.len > this.len) {
                    if (mask.len > this.dig.length) {
                        this.realloc(mask.len + 2);
                    }
                    System.arraycopy(mask.dig, this.len, this.dig, this.len, mask.len - this.len);
                }
                int a4 = this.dig[0];
                int b4 = mask.dig[0];
                int j = 1;
                while ((a4 | b4) == 0) {
                    a4 = this.dig[j];
                    b4 = mask.dig[j];
                    ++j;
                }
                if (a4 != 0 && b4 == 0) {
                    this.dig[j - 1] = 0;
                    while (j < mlen && mask.dig[j] == 0) {
                        this.dig[j] = 0;
                        ++j;
                    }
                    if (j < mlen) {
                        this.dig[j] = -(~this.dig[j] & -mask.dig[j]);
                    }
                    ++j;
                } else if (a4 == 0) {
                    while (j < mlen && this.dig[j] == 0) {
                        ++j;
                    }
                    if (j < mlen) {
                        this.dig[j] = -(-this.dig[j] & ~mask.dig[j]);
                    }
                    ++j;
                } else {
                    this.dig[j - 1] = -(-a4 & -b4);
                }
                if (j <= mlen && this.dig[j - 1] == 0) {
                    if (j < mlen) {
                        this.dig[j] = -(~(this.dig[j] | mask.dig[j]));
                        while (++j < mlen && this.dig[j - 1] == 0) {
                            this.dig[j] = -(~(this.dig[j] | mask.dig[j]));
                        }
                    }
                    if (j == mlen && this.dig[j - 1] == 0) {
                        int blen = Math.max(this.len, mask.len);
                        while (j < blen && this.dig[j] == -1) {
                            this.dig[j++] = 0;
                        }
                        if (j >= blen) {
                            if (blen >= this.dig.length) {
                                this.realloc(blen + 2);
                            }
                            this.dig[blen] = 1;
                            this.len = blen + 1;
                            return;
                        }
                        this.dig[j] = -(~this.dig[j]);
                        ++j;
                    }
                }
                while (j < mlen) {
                    int n = j;
                    this.dig[n] = this.dig[n] | mask.dig[j];
                    ++j;
                }
                if (mask.len > this.len) {
                    this.len = mask.len;
                }
            }
        }
    }

    public void or(BigInt mask) {
        if (this.sign > 0) {
            if (mask.sign > 0) {
                if (mask.len > this.len) {
                    if (mask.len > this.dig.length) {
                        this.realloc(mask.len + 1);
                    }
                    System.arraycopy(mask.dig, this.len, this.dig, this.len, mask.len - this.len);
                    for (int i = 0; i < this.len; ++i) {
                        int n = i;
                        this.dig[n] = this.dig[n] | mask.dig[i];
                    }
                    this.len = mask.len;
                } else {
                    for (int i = 0; i < mask.len; ++i) {
                        int n = i;
                        this.dig[n] = this.dig[n] | mask.dig[i];
                    }
                }
            } else {
                int j;
                if (mask.len > this.dig.length) {
                    this.realloc(mask.len + 1);
                }
                if (mask.len > this.len) {
                    System.arraycopy(mask.dig, this.len, this.dig, this.len, mask.len - this.len);
                }
                int mLen = Math.min(mask.len, this.len);
                int a2 = this.dig[0];
                int b2 = mask.dig[0];
                for (j = 1; (a2 | b2) == 0 && j < mLen; ++j) {
                    a2 = this.dig[j];
                    b2 = mask.dig[j];
                }
                if (a2 != 0 && b2 == 0) {
                    this.dig[j - 1] = -a2;
                    while (mask.dig[j] == 0) {
                        int n = j++;
                        this.dig[n] = ~this.dig[n];
                    }
                    this.dig[j] = j < mLen ? ~(this.dig[j] | -mask.dig[j]) : ~(-this.dig[j]);
                    ++j;
                } else if (a2 == 0) {
                    this.dig[j - 1] = b2;
                    while (j < mLen && this.dig[j] == 0) {
                        this.dig[j] = mask.dig[j];
                        ++j;
                    }
                } else {
                    this.dig[j - 1] = -(a2 | -b2);
                }
                while (j < mLen) {
                    this.dig[j] = ~this.dig[j] & mask.dig[j];
                    ++j;
                }
                this.sign = -1;
                this.len = mask.len;
                while (this.dig[this.len - 1] == 0) {
                    --this.len;
                }
            }
        } else {
            int j;
            int mLen = Math.min(mask.len, this.len);
            int a3 = this.dig[0];
            int b3 = mask.dig[0];
            for (j = 1; (a3 | b3) == 0 && j < mLen; ++j) {
                a3 = this.dig[j];
                b3 = mask.dig[j];
            }
            if (mask.sign > 0) {
                if (a3 != 0 && b3 == 0) {
                    while (j < mLen && mask.dig[j] == 0) {
                        ++j;
                    }
                } else if (a3 == 0) {
                    this.dig[j - 1] = -b3;
                    while (j < mLen && this.dig[j] == 0) {
                        this.dig[j] = ~mask.dig[j];
                        ++j;
                    }
                    if (j < mLen) {
                        this.dig[j] = ~(-this.dig[j] | mask.dig[j]);
                    } else {
                        while (this.dig[j] == 0) {
                            this.dig[j] = -1;
                            ++j;
                        }
                        this.dig[j] = ~(-this.dig[j]);
                    }
                    ++j;
                } else {
                    this.dig[j - 1] = -(-a3 | b3);
                }
                while (j < mLen) {
                    int n = j;
                    this.dig[n] = this.dig[n] & ~mask.dig[j];
                    ++j;
                }
            } else {
                if (a3 != 0 && b3 == 0) {
                    while (j < mLen && mask.dig[j] == 0) {
                        ++j;
                    }
                    if (j < mLen) {
                        this.dig[j] = ~(~this.dig[j] | -mask.dig[j]);
                    }
                    ++j;
                } else if (a3 == 0) {
                    this.dig[j - 1] = b3;
                    while (j < mLen && this.dig[j] == 0) {
                        this.dig[j] = mask.dig[j];
                        ++j;
                    }
                    if (j < mLen) {
                        this.dig[j] = ~(-this.dig[j] | ~mask.dig[j]);
                    }
                    ++j;
                } else {
                    this.dig[j - 1] = -(-a3 | -b3);
                }
                while (j < mLen) {
                    int n = j;
                    this.dig[n] = this.dig[n] & mask.dig[j];
                    ++j;
                }
                this.len = mLen;
            }
            while (this.dig[this.len - 1] == 0) {
                --this.len;
            }
        }
    }

    public void xor(BigInt mask) {
        if (this.sign > 0) {
            if (mask.len > this.len) {
                if (mask.len > this.dig.length) {
                    this.realloc(mask.len + 2);
                }
                System.arraycopy(mask.dig, this.len, this.dig, this.len, mask.len - this.len);
            }
            int mlen = Math.min(this.len, mask.len);
            if (mask.sign > 0) {
                for (int i = 0; i < mlen; ++i) {
                    int n = i;
                    this.dig[n] = this.dig[n] ^ mask.dig[i];
                }
            } else {
                int j;
                int a2 = this.dig[0];
                int b2 = mask.dig[0];
                for (j = 1; (a2 | b2) == 0 && j < mlen; ++j) {
                    a2 = this.dig[j];
                    b2 = mask.dig[j];
                }
                if (a2 != 0 && b2 == 0) {
                    this.dig[j - 1] = -a2;
                    while (mask.dig[j] == 0) {
                        int n = j++;
                        this.dig[n] = ~this.dig[n];
                    }
                    this.dig[j] = j < this.len ? ~(this.dig[j] ^ -mask.dig[j]) : ~(-mask.dig[j]);
                    ++j;
                } else if (a2 == 0) {
                    this.dig[j - 1] = b2;
                } else {
                    this.dig[j - 1] = -(a2 ^ -b2);
                    while (j < mlen && this.dig[j - 1] == 0) {
                        this.dig[j] = -(this.dig[j] ^ ~mask.dig[j]);
                        ++j;
                    }
                    if (j >= mlen && this.dig[j - 1] == 0) {
                        int[] tmp = j < this.len ? this.dig : mask.dig;
                        int blen = Math.max(this.len, mask.len);
                        while (j < blen && tmp[j] == -1) {
                            this.dig[j] = 0;
                            ++j;
                        }
                        if (blen == this.dig.length) {
                            this.realloc(blen + 2);
                        }
                        if (j == blen) {
                            this.dig[blen] = 1;
                            this.len = blen + 1;
                        } else {
                            this.dig[j] = -(~tmp[j]);
                        }
                        ++j;
                    }
                }
                while (j < mlen) {
                    int n = j;
                    this.dig[n] = this.dig[n] ^ mask.dig[j];
                    ++j;
                }
                this.sign = -1;
            }
            if (mask.len > this.len) {
                this.len = mask.len;
            } else {
                while (this.dig[this.len - 1] == 0 && this.len > 1) {
                    --this.len;
                }
            }
        } else {
            int j;
            int b3;
            int a3;
            if (mask.len > this.len) {
                if (mask.len > this.dig.length) {
                    this.realloc(mask.len + 2);
                }
                System.arraycopy(mask.dig, this.len, this.dig, this.len, mask.len - this.len);
            }
            int mlen = Math.min(this.len, mask.len);
            if (mask.sign > 0) {
                a3 = this.dig[0];
                b3 = mask.dig[0];
                for (j = 1; (a3 | b3) == 0 && j < mlen; ++j) {
                    a3 = this.dig[j];
                    b3 = mask.dig[j];
                }
                if (a3 != 0 && b3 == 0) {
                    while (j < mlen && mask.dig[j] == 0) {
                        ++j;
                    }
                } else if (a3 == 0) {
                    this.dig[j - 1] = -b3;
                    while (j < mlen && this.dig[j] == 0) {
                        this.dig[j] = ~mask.dig[j];
                        ++j;
                    }
                    while (j < this.len && this.dig[j] == 0) {
                        this.dig[j++] = -1;
                    }
                    this.dig[j] = j < mlen ? ~(-this.dig[j] ^ mask.dig[j]) : ~(-this.dig[j]);
                    ++j;
                } else {
                    this.dig[j - 1] = -(-a3 ^ b3);
                }
                while (j < mlen) {
                    int n = j;
                    this.dig[n] = this.dig[n] ^ mask.dig[j];
                    ++j;
                }
            } else {
                a3 = this.dig[0];
                b3 = mask.dig[0];
                for (j = 1; (a3 | b3) == 0 && j < mlen; ++j) {
                    a3 = this.dig[j];
                    b3 = mask.dig[j];
                }
                if (a3 != 0 && b3 == 0) {
                    this.dig[j - 1] = -a3;
                    while (mask.dig[j] == 0) {
                        int n = j++;
                        this.dig[n] = ~this.dig[n];
                    }
                    this.dig[j] = j < this.len ? ~this.dig[j] ^ -mask.dig[j] : ~(-this.dig[j]);
                    ++j;
                } else if (a3 == 0) {
                    this.dig[j - 1] = -b3;
                    while (j < mask.len && this.dig[j] == 0) {
                        this.dig[j] = ~mask.dig[j];
                        ++j;
                    }
                    while (this.dig[j] == 0) {
                        this.dig[j++] = -1;
                    }
                    this.dig[j] = j < mask.len ? -this.dig[j] ^ ~mask.dig[j] : ~(-this.dig[j]);
                    ++j;
                } else {
                    this.dig[j - 1] = -a3 ^ -b3;
                }
                while (j < mlen) {
                    int n = j;
                    this.dig[n] = this.dig[n] ^ mask.dig[j];
                    ++j;
                }
                this.sign = 1;
            }
            if (mask.len > this.len) {
                this.len = mask.len;
            } else {
                while (this.dig[this.len - 1] == 0 && this.len > 1) {
                    --this.len;
                }
            }
        }
    }

    public void andNot(BigInt mask) {
        int j;
        int mlen = Math.min(this.len, mask.len);
        if (this.sign > 0) {
            if (mask.sign > 0) {
                for (int i = 0; i < mlen; ++i) {
                    int n = i;
                    this.dig[n] = this.dig[n] & ~mask.dig[i];
                }
            } else {
                for (j = 0; j < mlen && mask.dig[j] == 0; ++j) {
                }
                if (j < mlen) {
                    int n = j;
                    this.dig[n] = this.dig[n] & ~(-mask.dig[j]);
                    while (++j < mlen) {
                        int n2 = j;
                        this.dig[n2] = this.dig[n2] & mask.dig[j];
                    }
                }
                this.len = mlen;
            }
        } else {
            if (mask.len > this.len) {
                if (mask.len > this.dig.length) {
                    this.realloc(mask.len + 2);
                }
                System.arraycopy(mask.dig, this.len, this.dig, this.len, mask.len - this.len);
            }
            if (mask.sign > 0) {
                j = 0;
                while (this.dig[j] == 0) {
                    ++j;
                }
                if (j < mlen) {
                    this.dig[j] = -(-this.dig[j] & ~mask.dig[j]);
                    while (++j < mlen && this.dig[j - 1] == 0) {
                        this.dig[j] = -(~(this.dig[j] | mask.dig[j]));
                    }
                    if (j == mlen && this.dig[j - 1] == 0) {
                        int blen = Math.max(this.len, mask.len);
                        while (j < blen && this.dig[j] == -1) {
                            this.dig[j++] = 0;
                        }
                        if (j >= blen) {
                            if (blen >= this.dig.length) {
                                this.realloc(blen + 2);
                            }
                            this.dig[blen] = 1;
                            this.len = blen + 1;
                            return;
                        }
                        this.dig[j] = -(~this.dig[j]);
                        ++j;
                    }
                    while (j < mlen) {
                        int n = j;
                        this.dig[n] = this.dig[n] | mask.dig[j];
                        ++j;
                    }
                    if (mask.len > this.len) {
                        this.len = mask.len;
                    }
                }
            } else {
                int j2;
                int a2 = this.dig[0];
                int b2 = mask.dig[0];
                for (j2 = 1; j2 < mlen && (a2 | b2) == 0; ++j2) {
                    a2 = this.dig[j2];
                    b2 = mask.dig[j2];
                }
                if (a2 != 0 && b2 == 0) {
                    this.dig[j2 - 1] = -a2;
                    while (j2 < mask.len && mask.dig[j2] == 0) {
                        int n = j2++;
                        this.dig[n] = ~this.dig[n];
                    }
                    this.dig[j2] = j2 < this.len ? ~(this.dig[j2] | -mask.dig[j2]) : ~(-this.dig[j2]);
                    ++j2;
                } else if (a2 == 0) {
                    while (j2 < mlen && this.dig[j2] == 0) {
                        ++j2;
                    }
                    if (j2 < mlen) {
                        this.dig[j2] = -this.dig[j2] & mask.dig[j2];
                    }
                    ++j2;
                } else {
                    this.dig[j2 - 1] = -a2 & ~(-b2);
                }
                while (j2 < mlen) {
                    this.dig[j2] = ~this.dig[j2] & mask.dig[j2];
                    ++j2;
                }
                this.len = mask.len;
                this.sign = 1;
            }
        }
        while (this.dig[this.len - 1] == 0 && this.len > 1) {
            --this.len;
        }
    }

    public void not() {
        if (this.sign > 0) {
            this.sign = -1;
            this.uaddMag(1);
        } else {
            this.sign = 1;
            this.usubMag(1);
        }
    }
}

