/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.numeric;

import java.util.HashMap;
import java.util.Map;

public class NumberOperations {
    public static final float DEFAULT_FLOAT_TOL = 1.0E-4f;
    private static float floatTol = 1.0E-4f;
    public static final double DEFAULT_DOUBLE_TOL = (double)1.0E-8f;
    private static double doubleTol = 1.0E-8f;

    public static Number add(Number n1, Number n2) {
        return NumberOperations.calculate(OpType.ADD, n1, n2);
    }

    public static Number subtract(Number n1, Number n2) {
        return NumberOperations.calculate(OpType.SUBTRACT, n1, n2);
    }

    public static Number multiply(Number n1, Number n2) {
        return NumberOperations.calculate(OpType.MULTIPLY, n1, n2);
    }

    public static Number divide(Number n1, Number n2) {
        return NumberOperations.calculate(OpType.DIVIDE, n1, n2);
    }

    public static int compare(Number n1, Number n2) {
        return (int)Math.round(NumberOperations.calculate(OpType.COMPARE, n1, n2).doubleValue());
    }

    public static float getFloatTolerance() {
        return floatTol;
    }

    public static void setFloatTolerance(float tol) {
        floatTol = Math.abs(tol);
    }

    public static double getDoubleTolerance() {
        return doubleTol;
    }

    public static void setFloatTolerance(double tol) {
        doubleTol = Math.abs(tol);
    }

    private static Number calculate(OpType type, Number n1, Number n2) {
        Number result = null;
        ClassInfo ciIn = ClassInfo.get(NumberOperations.highestClass(n1, n2));
        ClassInfo ciOut = null;
        ciOut = type == OpType.COMPARE ? ClassInfo.INTEGER : ciIn;
        switch (ciIn) {
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                result = NumberOperations.integralCalculation(type, n1, n2);
                break;
            }
            case FLOAT: {
                result = NumberOperations.floatCalculation(type, n1, n2);
                break;
            }
            case DOUBLE: {
                result = NumberOperations.doubleCalculation(type, n1, n2);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized number class");
            }
        }
        return NumberOperations.newInstance(result, ciOut);
    }

    public static int intValue(Number number) {
        ClassInfo ci = ClassInfo.get(number.getClass());
        int value = 0;
        switch (ci) {
            case BYTE: {
                value = number.intValue() & 0xFF;
                break;
            }
            case SHORT: 
            case INTEGER: {
                value = number.intValue();
                break;
            }
            case LONG: {
                value = (int)Math.min(Math.max(number.longValue(), Integer.MIN_VALUE), Integer.MAX_VALUE);
                break;
            }
            case FLOAT: {
                Float f = (Float)number;
                if (f.isNaN()) {
                    value = 0;
                    break;
                }
                if (f.isInfinite()) {
                    value = f.equals(Float.valueOf(Float.NEGATIVE_INFINITY)) ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                    break;
                }
                value = (int)Math.max(Math.min(number.floatValue(), 2.1474836E9f), -2.1474836E9f);
                break;
            }
            case DOUBLE: {
                Double d2 = (Double)number;
                if (d2.isNaN()) {
                    value = 0;
                    break;
                }
                if (d2.isInfinite()) {
                    value = d2.equals(Double.NEGATIVE_INFINITY) ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                    break;
                }
                value = (int)Math.max(Math.min(number.doubleValue(), 2.147483647E9), -2.147483648E9);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized number class: " + number.getClass().getName());
            }
        }
        return value;
    }

    public static long longValue(Number number) {
        ClassInfo ci = ClassInfo.get(number.getClass());
        long value = 0L;
        switch (ci) {
            case BYTE: {
                value = number.intValue() & 0xFF;
                break;
            }
            case SHORT: 
            case INTEGER: 
            case LONG: {
                value = number.longValue();
                break;
            }
            case FLOAT: {
                Float f = (Float)number;
                if (f.isNaN()) {
                    value = 0L;
                    break;
                }
                if (f.isInfinite()) {
                    value = f.equals(Float.valueOf(Float.NEGATIVE_INFINITY)) ? Long.MIN_VALUE : Long.MAX_VALUE;
                    break;
                }
                value = (long)Math.max(Math.min(number.floatValue(), 9.223372E18f), -9.223372E18f);
                break;
            }
            case DOUBLE: {
                Double d2 = (Double)number;
                if (d2.isNaN()) {
                    value = 0L;
                    break;
                }
                if (d2.isInfinite()) {
                    value = d2.equals(Double.NEGATIVE_INFINITY) ? Long.MIN_VALUE : Long.MAX_VALUE;
                    break;
                }
                value = (long)Math.max(Math.min(number.doubleValue(), 9.223372036854776E18), -9.223372036854776E18);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized number class: " + number.getClass().getName());
            }
        }
        return value;
    }

    public static float floatValue(Number number) {
        ClassInfo ci = ClassInfo.get(number.getClass());
        float value = 0.0f;
        switch (ci) {
            case BYTE: {
                value = number.intValue() & 0xFF;
                break;
            }
            case SHORT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: {
                value = number.floatValue();
                break;
            }
            case DOUBLE: {
                Double d2 = (Double)number;
                if (d2.isNaN()) {
                    value = Float.NaN;
                    break;
                }
                if (d2.isInfinite()) {
                    value = d2.equals(Double.NEGATIVE_INFINITY) ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
                    break;
                }
                value = (float)Math.max(Math.min(number.doubleValue(), Double.POSITIVE_INFINITY), Double.NEGATIVE_INFINITY);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized number class: " + number.getClass().getName());
            }
        }
        return value;
    }

    public static double doubleValue(Number number) {
        ClassInfo ci = ClassInfo.get(number.getClass());
        switch (ci) {
            case BYTE: {
                return number.intValue() & 0xFF;
            }
        }
        return number.doubleValue();
    }

    public static Number copy(Number number) {
        return number == null ? (Number)null : (Number)NumberOperations.newInstance(number, number.getClass());
    }

    public static Number newInstance(Number number, Class<? extends Number> clazz) {
        ClassInfo ci = ClassInfo.get(clazz);
        return NumberOperations.newInstance(number, ci, false);
    }

    public static Number castNumber(Number number, Class<? extends Number> clazz) {
        ClassInfo ci = ClassInfo.get(clazz);
        return NumberOperations.newInstance(number, ci, true);
    }

    private static Number newInstance(Number number, ClassInfo ci) {
        return NumberOperations.newInstance(number, ci, false);
    }

    private static Number newInstance(Number number, ClassInfo ci, boolean canReturnInput) {
        Class<?> numberClass = number.getClass();
        switch (ci) {
            case BYTE: {
                if (number.getClass() == Byte.class) {
                    return canReturnInput ? (Number)number : (Number)number.byteValue();
                }
                return NumberOperations.newByte(number);
            }
            case SHORT: {
                if (numberClass == Short.class) {
                    return canReturnInput ? (Number)number : (Number)number.shortValue();
                }
                return NumberOperations.newShort(number);
            }
            case INTEGER: {
                if (numberClass == Integer.class) {
                    return canReturnInput ? (Number)number : (Number)number.intValue();
                }
                return NumberOperations.newInteger(number);
            }
            case LONG: {
                if (numberClass == Long.class) {
                    return canReturnInput ? (Number)number : (Number)number.longValue();
                }
                return NumberOperations.newLong(number);
            }
            case FLOAT: {
                if (numberClass == Float.class) {
                    return canReturnInput ? (Number)number : (Number)Float.valueOf(number.floatValue());
                }
                return NumberOperations.newFloat(number);
            }
            case DOUBLE: {
                if (numberClass == Double.class) {
                    return canReturnInput ? (Number)number : (Number)number.doubleValue();
                }
                return NumberOperations.newDouble(number);
            }
        }
        throw new IllegalArgumentException("Unrecognized ClassInfo arg: " + (Object)((Object)ci));
    }

    public static Class<? extends Number> highestClass(Number ... numbers) {
        int maxRank = -1;
        Class<?> result = null;
        for (Number n : numbers) {
            int rank = ClassInfo.get(n.getClass()).getRank();
            if (rank <= maxRank) continue;
            maxRank = rank;
            result = n.getClass();
        }
        return result;
    }

    public static Class<? extends Number> lowestClass(Number ... numbers) {
        int minRank = ClassInfo.DOUBLE.getRank() + 1;
        Class<?> result = null;
        for (Number n : numbers) {
            int rank = ClassInfo.get(n.getClass()).getRank();
            if (rank >= minRank) continue;
            minRank = rank;
            result = n.getClass();
        }
        return result;
    }

    private static Long integralCalculation(OpType type, Number n1, Number n2) {
        long result = 0L;
        long val1 = NumberOperations.longValue(n1);
        long val2 = NumberOperations.longValue(n2);
        switch (type) {
            case ADD: {
                result = val1 + val2;
                break;
            }
            case SUBTRACT: {
                result = val1 - val2;
                break;
            }
            case MULTIPLY: {
                result = val1 * val2;
                break;
            }
            case DIVIDE: {
                result = val1 / val2;
                break;
            }
            case COMPARE: {
                result = val1 < val2 ? -1 : (val1 > val2 ? 1 : 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid OpType: " + (Object)((Object)type));
            }
        }
        return result;
    }

    private static Float floatCalculation(OpType opType, Number n1, Number n2) {
        Float fn2;
        Float fn1;
        float result = 0.0f;
        if (opType == OpType.COMPARE) {
            return Float.valueOf(NumberOperations.floatComparison(n1, n2));
        }
        if (n1 instanceof Float && ((fn1 = (Float)n1).isInfinite() || fn1.isNaN())) {
            return Float.valueOf(Float.NaN);
        }
        if (n2 instanceof Float && ((fn2 = (Float)n1).isInfinite() || fn2.isNaN())) {
            return Float.valueOf(Float.NaN);
        }
        float val1 = NumberOperations.floatValue(n1);
        float val2 = NumberOperations.floatValue(n2);
        switch (opType) {
            case ADD: {
                result = val1 + val2;
                break;
            }
            case SUBTRACT: {
                result = val1 - val2;
                break;
            }
            case MULTIPLY: {
                result = val1 * val2;
                break;
            }
            case DIVIDE: {
                result = val1 / val2;
            }
        }
        return Float.valueOf(result);
    }

    private static int floatComparison(Number n1, Number n2) {
        float val1 = NumberOperations.floatValue(n1);
        float val2 = NumberOperations.floatValue(n2);
        if (Float.isInfinite(val1) || Float.isNaN(val1) || Float.isInfinite(val2) || Float.isNaN(val2)) {
            return Float.compare(val1, val2);
        }
        int result = Math.abs(val1 - val2) < floatTol ? 0 : (val1 < val2 ? -1 : 1);
        return result;
    }

    private static Double doubleCalculation(OpType opType, Number n1, Number n2) {
        Double dn2;
        Double dn1;
        double result = 0.0;
        if (opType == OpType.COMPARE) {
            return NumberOperations.doubleComparison(n1, n2);
        }
        if (n1 instanceof Double && ((dn1 = (Double)n1).isInfinite() || dn1.isNaN())) {
            return Double.NaN;
        }
        if (n2 instanceof Double && ((dn2 = (Double)n1).isInfinite() || dn2.isNaN())) {
            return Double.NaN;
        }
        double val1 = NumberOperations.doubleValue(n1);
        double val2 = NumberOperations.doubleValue(n2);
        switch (opType) {
            case ADD: {
                result = val1 + val2;
                break;
            }
            case SUBTRACT: {
                result = val1 - val2;
                break;
            }
            case MULTIPLY: {
                result = val1 * val2;
                break;
            }
            case DIVIDE: {
                result = val1 / val2;
            }
        }
        return result;
    }

    private static int doubleComparison(Number n1, Number n2) {
        double val1 = NumberOperations.doubleValue(n1);
        double val2 = NumberOperations.doubleValue(n2);
        if (Double.isInfinite(val1) || Double.isNaN(val1) || Double.isInfinite(val2) || Double.isNaN(val2)) {
            return Double.compare(val1, val2);
        }
        int result = Math.abs(val1 - val2) < doubleTol ? 0 : (val1 < val2 ? -1 : 1);
        return result;
    }

    private static Byte newByte(Number source) {
        long value = NumberOperations.longValue(source);
        if (value < 0L) {
            value = 0L;
        } else if (value > 255L) {
            value = 255L;
        }
        return (byte)value;
    }

    private static Short newShort(Number source) {
        long value = NumberOperations.longValue(source);
        if (value < -32768L) {
            value = -32768L;
        } else if (value > 32767L) {
            value = 32767L;
        }
        return (short)value;
    }

    private static Integer newInteger(Number source) {
        long value = NumberOperations.longValue(source);
        if (value < Integer.MIN_VALUE) {
            value = Integer.MIN_VALUE;
        } else if (value > Integer.MAX_VALUE) {
            value = Integer.MAX_VALUE;
        }
        return (int)value;
    }

    private static Long newLong(Number source) {
        long value = NumberOperations.longValue(source);
        return (int)value;
    }

    private static Float newFloat(Number source) {
        double value = NumberOperations.doubleValue(source);
        if (value < (double)1.4E-45f) {
            value = 1.4E-45f;
        } else if (value > 3.4028234663852886E38) {
            value = 3.4028234663852886E38;
        }
        return new Float((float)value);
    }

    private static Double newDouble(Number source) {
        double value = NumberOperations.doubleValue(source);
        return value;
    }

    private static enum OpType {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        COMPARE;

    }

    public static enum ClassInfo {
        BYTE(0, Byte.class, true),
        SHORT(1, Short.class, true),
        INTEGER(2, Integer.class, true),
        LONG(3, Long.class, true),
        FLOAT(4, Float.class, false),
        DOUBLE(5, Double.class, false);

        private static final Map<Class<? extends Number>, ClassInfo> lookup;
        private int rank;
        private Class<? extends Number> clazz;
        private boolean isIntegral;

        private ClassInfo(int rank, Class<? extends Number> clazz, boolean isIntegral) {
            this.rank = rank;
            this.clazz = clazz;
            this.isIntegral = isIntegral;
        }

        public int getRank() {
            return this.rank;
        }

        public Class<? extends Number> getNumberClass() {
            return this.clazz;
        }

        public boolean isIntegral() {
            return this.isIntegral;
        }

        public String toString() {
            return String.format("ClassInfo<%s>", this.clazz.getSimpleName());
        }

        public static ClassInfo get(Class<? extends Number> clazz) {
            return lookup.get(clazz);
        }

        static {
            lookup = new HashMap<Class<? extends Number>, ClassInfo>();
            for (ClassInfo cr : ClassInfo.values()) {
                lookup.put(cr.clazz, cr);
            }
        }
    }
}

