/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.swing;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.RenderedImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import org.jaitools.swing.ImageFrame;
import org.jaitools.swing.SimpleImagePane;

class ImagePane
extends SimpleImagePane
implements MouseListener,
MouseMotionListener {
    private ImageFrame frame;
    private RenderedImage displayImage;
    private RenderedImage dataImage;
    private RandomIter dataImageIter;
    private boolean integralImageDataType;
    private final Rectangle imageBounds;
    private int[] intData;
    private double[] doubleData;

    private void setMouseListener() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public ImagePane(ImageFrame frame, RenderedImage displayImg, RenderedImage dataImg) {
        this.setImage(displayImg);
        this.frame = frame;
        this.displayImage = displayImg;
        this.imageBounds = new Rectangle(this.displayImage.getMinX(), this.displayImage.getMinY(), this.displayImage.getWidth(), this.displayImage.getHeight());
        this.dataImage = dataImg == null ? displayImg : dataImg;
        switch (this.dataImage.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.integralImageDataType = true;
                this.intData = new int[this.dataImage.getSampleModel().getNumBands()];
                break;
            }
            case 4: 
            case 5: {
                this.integralImageDataType = false;
                this.doubleData = new double[this.dataImage.getSampleModel().getNumBands()];
            }
        }
        this.setMouseListener();
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
        if (this.dataImage != null) {
            Point imagePos = this.getImageCoords(ev.getPoint(), null);
            if (this.imageBounds.contains(imagePos)) {
                if (this.dataImageIter == null) {
                    this.dataImageIter = RandomIterFactory.create(this.dataImage, this.imageBounds);
                }
                if (this.integralImageDataType) {
                    this.dataImageIter.getPixel(imagePos.x, imagePos.y, this.intData);
                    this.frame.setCursorInfo(imagePos, this.intData);
                } else {
                    this.dataImageIter.getPixel(imagePos.x, imagePos.y, this.doubleData);
                    this.frame.setCursorInfo(imagePos, this.doubleData);
                }
            } else {
                this.frame.setStatusText("");
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent ev) {
        this.frame.setStatusText("");
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
    }
}

