/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.tour;

import java.util.ArrayList;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.GraphTests;
import org.jgrapht.alg.interfaces.HamiltonianCycleAlgorithm;
import org.jgrapht.graph.GraphWalk;

public class PalmerHamiltonianCycle<V, E>
implements HamiltonianCycleAlgorithm<V, E> {
    @Override
    public GraphPath<V, E> getTour(Graph<V, E> graph) {
        boolean changed;
        if (!GraphTests.hasOreProperty(graph)) {
            throw new IllegalArgumentException("Graph doesn't have Ore's property");
        }
        ArrayList<V> indexList = new ArrayList<V>(graph.vertexSet());
        int n = graph.vertexSet().size();
        int[] L = new int[n];
        int[] R5 = new int[n];
        for (int i = 0; i < n; ++i) {
            L[i] = (i - 1 + n) % n;
            R5[i] = (i + 1) % n;
        }
        block1: do {
            changed = false;
            int x = 0;
            do {
                if (graph.containsEdge(indexList.get(x), indexList.get(R5[x]))) continue;
                changed = true;
                int y = 0;
                do {
                    int u = x;
                    int v = R5[x];
                    int p = y;
                    int q = R5[y];
                    if (v == p || u == p || u == q || !graph.containsEdge(indexList.get(u), indexList.get(p)) || !graph.containsEdge(indexList.get(v), indexList.get(q))) continue;
                    R5[u] = L[u];
                    L[u] = p;
                    R5[v] = R5[v];
                    L[v] = q;
                    L[p] = L[p];
                    R5[p] = u;
                    L[q] = R5[q];
                    R5[q] = v;
                    int z = R5[u];
                    while (z != q) {
                        int tmp = R5[z];
                        R5[z] = L[z];
                        L[z] = tmp;
                        z = R5[z];
                    }
                    continue block1;
                } while ((y = R5[y]) != 0);
            } while ((x = R5[x]) != 0);
        } while (changed);
        ArrayList vertexList = new ArrayList(n);
        ArrayList<E> edgeList = new ArrayList<E>(n);
        int x = 0;
        do {
            vertexList.add(indexList.get(x));
            edgeList.add(graph.getEdge(indexList.get(x), indexList.get(R5[x])));
        } while ((x = R5[x]) != 0);
        vertexList.add(indexList.get(0));
        return new GraphWalk<V, E>(graph, indexList.get(0), indexList.get(0), vertexList, edgeList, edgeList.size());
    }
}

