/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.graph.IntrusiveEdge;
import org.jgrapht.util.TypeUtil;

public abstract class BaseIntrusiveEdgesSpecifics<V, E, IE extends IntrusiveEdge>
implements Serializable {
    private static final long serialVersionUID = -7498268216742485L;
    protected Map<E, IE> edgeMap;
    protected transient Set<E> unmodifiableEdgeSet = null;

    public BaseIntrusiveEdgesSpecifics(Map<E, IE> edgeMap) {
        this.edgeMap = Objects.requireNonNull(edgeMap);
    }

    public boolean containsEdge(E e2) {
        return this.edgeMap.containsKey(e2);
    }

    public Set<E> getEdgeSet() {
        if (this.unmodifiableEdgeSet == null) {
            this.unmodifiableEdgeSet = Collections.unmodifiableSet(this.edgeMap.keySet());
        }
        return this.unmodifiableEdgeSet;
    }

    public void remove(E e2) {
        this.edgeMap.remove(e2);
    }

    public V getEdgeSource(E e2) {
        IE ie = this.getIntrusiveEdge(e2);
        if (ie == null) {
            throw new IllegalArgumentException("no such edge in graph: " + e2.toString());
        }
        return (V)TypeUtil.uncheckedCast(((IntrusiveEdge)ie).source);
    }

    public V getEdgeTarget(E e2) {
        IE ie = this.getIntrusiveEdge(e2);
        if (ie == null) {
            throw new IllegalArgumentException("no such edge in graph: " + e2.toString());
        }
        return (V)TypeUtil.uncheckedCast(((IntrusiveEdge)ie).target);
    }

    public double getEdgeWeight(E e2) {
        return 1.0;
    }

    public void setEdgeWeight(E e2, double weight) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean add(E var1, V var2, V var3);

    protected abstract IE getIntrusiveEdge(E var1);
}

