/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.algorithm.HCoordinate;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.math.DD;

public class Triangle {
    public Coordinate p0;
    public Coordinate p1;
    public Coordinate p2;

    public static boolean isAcute(Coordinate a2, Coordinate b2, Coordinate c2) {
        if (!Angle.isAcute(a2, b2, c2)) {
            return false;
        }
        if (!Angle.isAcute(b2, c2, a2)) {
            return false;
        }
        return Angle.isAcute(c2, a2, b2);
    }

    public static HCoordinate perpendicularBisector(Coordinate a2, Coordinate b2) {
        double dx = b2.x - a2.x;
        double dy = b2.y - a2.y;
        HCoordinate l1 = new HCoordinate(a2.x + dx / 2.0, a2.y + dy / 2.0, 1.0);
        HCoordinate l2 = new HCoordinate(a2.x - dy + dx / 2.0, a2.y + dx + dy / 2.0, 1.0);
        return new HCoordinate(l1, l2);
    }

    public static Coordinate circumcentre(Coordinate a2, Coordinate b2, Coordinate c2) {
        double cx = c2.x;
        double cy = c2.y;
        double ax = a2.x - cx;
        double ay = a2.y - cy;
        double bx = b2.x - cx;
        double by = b2.y - cy;
        double denom = 2.0 * Triangle.det(ax, ay, bx, by);
        double numx = Triangle.det(ay, ax * ax + ay * ay, by, bx * bx + by * by);
        double numy = Triangle.det(ax, ax * ax + ay * ay, bx, bx * bx + by * by);
        double ccx = cx - numx / denom;
        double ccy = cy + numy / denom;
        return new Coordinate(ccx, ccy);
    }

    public static Coordinate circumcentreDD(Coordinate a2, Coordinate b2, Coordinate c2) {
        DD ax = DD.valueOf(a2.x).subtract(c2.x);
        DD ay = DD.valueOf(a2.y).subtract(c2.y);
        DD bx = DD.valueOf(b2.x).subtract(c2.x);
        DD by = DD.valueOf(b2.y).subtract(c2.y);
        DD denom = DD.determinant(ax, ay, bx, by).multiply(2.0);
        DD asqr = ax.sqr().add(ay.sqr());
        DD bsqr = bx.sqr().add(by.sqr());
        DD numx = DD.determinant(ay, asqr, by, bsqr);
        DD numy = DD.determinant(ax, asqr, bx, bsqr);
        double ccx = DD.valueOf(c2.x).subtract(numx.divide(denom)).doubleValue();
        double ccy = DD.valueOf(c2.y).add(numy.divide(denom)).doubleValue();
        return new Coordinate(ccx, ccy);
    }

    private static double det(double m00, double m01, double m10, double m11) {
        return m00 * m11 - m01 * m10;
    }

    public static Coordinate inCentre(Coordinate a2, Coordinate b2, Coordinate c2) {
        double len0 = b2.distance(c2);
        double len1 = a2.distance(c2);
        double len2 = a2.distance(b2);
        double circum = len0 + len1 + len2;
        double inCentreX = (len0 * a2.x + len1 * b2.x + len2 * c2.x) / circum;
        double inCentreY = (len0 * a2.y + len1 * b2.y + len2 * c2.y) / circum;
        return new Coordinate(inCentreX, inCentreY);
    }

    public static Coordinate centroid(Coordinate a2, Coordinate b2, Coordinate c2) {
        double x = (a2.x + b2.x + c2.x) / 3.0;
        double y = (a2.y + b2.y + c2.y) / 3.0;
        return new Coordinate(x, y);
    }

    public static double longestSideLength(Coordinate a2, Coordinate b2, Coordinate c2) {
        double lenAB = a2.distance(b2);
        double lenBC = b2.distance(c2);
        double lenCA = c2.distance(a2);
        double maxLen = lenAB;
        if (lenBC > maxLen) {
            maxLen = lenBC;
        }
        if (lenCA > maxLen) {
            maxLen = lenCA;
        }
        return maxLen;
    }

    public static Coordinate angleBisector(Coordinate a2, Coordinate b2, Coordinate c2) {
        double len0 = b2.distance(a2);
        double len2 = b2.distance(c2);
        double frac = len0 / (len0 + len2);
        double dx = c2.x - a2.x;
        double dy = c2.y - a2.y;
        Coordinate splitPt = new Coordinate(a2.x + frac * dx, a2.y + frac * dy);
        return splitPt;
    }

    public static double area(Coordinate a2, Coordinate b2, Coordinate c2) {
        return Math.abs(((c2.x - a2.x) * (b2.y - a2.y) - (b2.x - a2.x) * (c2.y - a2.y)) / 2.0);
    }

    public static double signedArea(Coordinate a2, Coordinate b2, Coordinate c2) {
        return ((c2.x - a2.x) * (b2.y - a2.y) - (b2.x - a2.x) * (c2.y - a2.y)) / 2.0;
    }

    public static double area3D(Coordinate a2, Coordinate b2, Coordinate c2) {
        double ux = b2.x - a2.x;
        double uy = b2.y - a2.y;
        double uz = b2.getZ() - a2.getZ();
        double vx = c2.x - a2.x;
        double vy = c2.y - a2.y;
        double vz = c2.getZ() - a2.getZ();
        double crossx = uy * vz - uz * vy;
        double crossy = uz * vx - ux * vz;
        double crossz = ux * vy - uy * vx;
        double absSq = crossx * crossx + crossy * crossy + crossz * crossz;
        double area3D = Math.sqrt(absSq) / 2.0;
        return area3D;
    }

    public static double interpolateZ(Coordinate p, Coordinate v0, Coordinate v1, Coordinate v2) {
        double x0 = v0.x;
        double y0 = v0.y;
        double a2 = v1.x - x0;
        double b2 = v2.x - x0;
        double c2 = v1.y - y0;
        double d2 = v2.y - y0;
        double det = a2 * d2 - b2 * c2;
        double dx = p.x - x0;
        double dy = p.y - y0;
        double t = (d2 * dx - b2 * dy) / det;
        double u = (-c2 * dx + a2 * dy) / det;
        double z = v0.getZ() + t * (v1.getZ() - v0.getZ()) + u * (v2.getZ() - v0.getZ());
        return z;
    }

    public Triangle(Coordinate p0, Coordinate p1, Coordinate p2) {
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
    }

    public Coordinate inCentre() {
        return Triangle.inCentre(this.p0, this.p1, this.p2);
    }

    public boolean isAcute() {
        return Triangle.isAcute(this.p0, this.p1, this.p2);
    }

    public Coordinate circumcentre() {
        return Triangle.circumcentre(this.p0, this.p1, this.p2);
    }

    public Coordinate centroid() {
        return Triangle.centroid(this.p0, this.p1, this.p2);
    }

    public double longestSideLength() {
        return Triangle.longestSideLength(this.p0, this.p1, this.p2);
    }

    public double area() {
        return Triangle.area(this.p0, this.p1, this.p2);
    }

    public double signedArea() {
        return Triangle.signedArea(this.p0, this.p1, this.p2);
    }

    public double area3D() {
        return Triangle.area3D(this.p0, this.p1, this.p2);
    }

    public double interpolateZ(Coordinate p) {
        if (p == null) {
            throw new IllegalArgumentException("Supplied point is null.");
        }
        return Triangle.interpolateZ(p, this.p0, this.p1, this.p2);
    }
}

