/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapstore.disk.persistent;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.terracotta.offheapstore.Segment;
import org.terracotta.offheapstore.concurrent.AbstractConcurrentOffHeapCache;
import org.terracotta.offheapstore.disk.persistent.Persistent;
import org.terracotta.offheapstore.pinning.PinnableSegment;
import org.terracotta.offheapstore.util.Factory;

public class AbstractPersistentConcurrentOffHeapCache<K, V>
extends AbstractConcurrentOffHeapCache<K, V>
implements Persistent {
    private static final int MAGIC = 1463898953;

    public AbstractPersistentConcurrentOffHeapCache(Factory<? extends PinnableSegment<K, V>> segmentFactory) {
        super(segmentFactory);
    }

    public AbstractPersistentConcurrentOffHeapCache(Factory<? extends PinnableSegment<K, V>> segmentFactory, int concurrency) {
        super(segmentFactory, concurrency);
    }

    @Override
    public void flush() throws IOException {
        for (Segment s2 : this.segments) {
            ((Persistent)((Object)s2)).flush();
        }
    }

    @Override
    public void persist(ObjectOutput output) throws IOException {
        output.writeInt(1463898953);
        output.writeInt(this.segments.length);
        for (Segment s2 : this.segments) {
            ((Persistent)((Object)s2)).persist(output);
        }
    }

    @Override
    public void close() throws IOException {
        for (Segment s2 : this.segments) {
            ((Persistent)((Object)s2)).close();
        }
    }

    @Override
    public void bootstrap(ObjectInput input) throws IOException {
        for (Segment s2 : this.segments) {
            ((Persistent)((Object)s2)).bootstrap(input);
        }
    }

    protected static int readSegmentCount(ObjectInput input) throws IOException {
        if (input.readInt() != 1463898953) {
            throw new IOException("Wrong magic number");
        }
        return input.readInt();
    }
}

