/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapstore.storage.allocator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.terracotta.offheapstore.paging.OffHeapStorageArea;
import org.terracotta.offheapstore.storage.allocator.Allocator;
import org.terracotta.offheapstore.util.FindbugsSuppressWarnings;
import org.terracotta.offheapstore.util.Validation;

public final class LongBestFitAllocator
implements Allocator {
    private static final boolean DEBUG = Boolean.getBoolean(LongBestFitAllocator.class.getName() + ".DEBUG");
    private static final boolean VALIDATING = Validation.shouldValidate(LongBestFitAllocator.class);
    private static final int SIZE_T_BITSIZE = 64;
    private static final int SIZE_T_SIZE = 8;
    private static final int MALLOC_ALIGNMENT = 16;
    private static final int CHUNK_ALIGN_MASK = 15;
    private static final int MCHUNK_SIZE = 32;
    private static final int CHUNK_OVERHEAD = 16;
    private static final long MIN_CHUNK_SIZE = 32L;
    private static final long MAX_REQUEST = 2147483520L;
    private static final long MIN_REQUEST = 15L;
    private static final long TOP_FOOT_SIZE = LongBestFitAllocator.alignOffset(LongBestFitAllocator.chunkToMem(0L)) + LongBestFitAllocator.padRequest(32L);
    private static final long MINIMAL_SIZE = Long.highestOneBit(TOP_FOOT_SIZE) << 1;
    private static final long TOP_FOOT_OFFSET = LongBestFitAllocator.memToChunk(0L) + TOP_FOOT_SIZE;
    private static final int PINUSE_BIT = 1;
    private static final int CINUSE_BIT = 2;
    private static final int FLAG4_BIT = 4;
    private static final int INUSE_BITS = 3;
    private static final int FLAG_BITS = 7;
    private static final int NSMALLBINS = 32;
    private static final int NTREEBINS = 32;
    private static final int SMALLBIN_SHIFT = 3;
    private static final int TREEBIN_SHIFT = 8;
    private static final int MIN_LARGE_SIZE = 256;
    private static final int MAX_SMALL_SIZE = 255;
    private static final int MAX_SMALL_REQUEST = 224;
    private final OffHeapStorageArea storage;
    private int smallMap;
    private int treeMap;
    private final long[] smallBins = new long[32];
    private final long[] treeBins = new long[32];
    private long designatedVictimSize = 0L;
    private long designatedVictim = -1L;
    private long topSize = 0L;
    private long top = 0L;
    private long occupied;

    public LongBestFitAllocator(OffHeapStorageArea storage) {
        this.storage = storage;
        this.clear();
    }

    @Override
    public void clear() {
        int i;
        this.top = 0L;
        this.topSize = -TOP_FOOT_SIZE;
        this.designatedVictim = -1L;
        this.designatedVictimSize = 0L;
        for (i = 0; i < this.treeBins.length; ++i) {
            this.treeBins[i] = -1L;
            this.clearTreeMap(i);
        }
        for (i = 0; i < this.smallBins.length; ++i) {
            this.smallBins[i] = -1L;
            this.clearSmallMap(i);
        }
        this.occupied = 0L;
    }

    @Override
    public void expand(long increase) {
        this.topSize += increase;
        this.head(this.top, this.topSize | 1L);
        if (this.topSize >= 0L) {
            this.checkTopChunk(this.top);
        }
    }

    @Override
    public long allocate(long size) {
        return this.dlmalloc(size);
    }

    @Override
    public void free(long address) {
        this.dlfree(address, true);
    }

    @Override
    public long occupied() {
        return this.occupied;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (DEBUG) {
            sb.append("\nChunks:").append(this.dump());
        }
        return sb.toString();
    }

    private String dump() {
        StringBuilder sb = new StringBuilder();
        long q = 0L;
        while (q != this.top) {
            if (this.isInUse(q)) {
                sb.append(" InUseChunk:&").append(q).append(':').append(this.chunkSize(q)).append('b');
            } else {
                sb.append(" FreeChunk:&").append(q).append(':').append(this.chunkSize(q)).append('b');
            }
            q = this.nextChunk(q);
        }
        sb.append(" TopChunk:&").append(this.top).append(':').append(this.topSize + TOP_FOOT_SIZE).append('b');
        return sb.toString();
    }

    private long dlmalloc(long bytes) {
        long nb;
        long l = nb = bytes < 15L ? 32L : LongBestFitAllocator.padRequest(bytes);
        if (bytes <= 224L) {
            int index = LongBestFitAllocator.smallBinIndex(nb);
            int smallBits = this.smallMap >>> index;
            if ((smallBits & 3) != 0) {
                return this.allocateFromSmallBin(index += ~smallBits & 1, nb);
            }
            if (nb > this.designatedVictimSize) {
                if (smallBits != 0) {
                    return this.splitFromSmallBin(Integer.numberOfTrailingZeros(smallBits << index), nb);
                }
                if (this.treeMap != 0) {
                    return this.splitSmallFromTree(nb);
                }
            }
        } else {
            long mem;
            if (bytes > 2147483520L) {
                return -1L;
            }
            if (this.treeMap != 0 && LongBestFitAllocator.okAddress(mem = this.splitFromTree(nb))) {
                return mem;
            }
        }
        if (nb <= this.designatedVictimSize) {
            return this.splitFromDesignatedVictim(nb);
        }
        if (nb < this.topSize) {
            return this.splitFromTop(nb);
        }
        return -1L;
    }

    private long allocateFromSmallBin(int index, long nb) {
        long h2 = this.smallBins[index];
        Validation.validate(!VALIDATING || this.chunkSize(h2) == (long)LongBestFitAllocator.smallBinIndexToSize(index));
        long f = this.forward(h2);
        long b2 = this.backward(h2);
        if (f == h2) {
            Validation.validate(!VALIDATING || b2 == h2);
            this.clearSmallMap(index);
            this.smallBins[index] = -1L;
        } else {
            this.smallBins[index] = f;
            this.backward(f, b2);
            this.forward(b2, f);
        }
        this.setInUseAndPreviousInUse(h2, LongBestFitAllocator.smallBinIndexToSize(index));
        long mem = LongBestFitAllocator.chunkToMem(h2);
        this.checkMallocedChunk(mem, nb);
        return mem;
    }

    private long splitFromSmallBin(int index, long nb) {
        long h2 = this.smallBins[index];
        Validation.validate(!VALIDATING || this.chunkSize(h2) == (long)LongBestFitAllocator.smallBinIndexToSize(index));
        long f = this.forward(h2);
        long b2 = this.backward(h2);
        if (f == h2) {
            Validation.validate(!VALIDATING || b2 == h2);
            this.clearSmallMap(index);
            this.smallBins[index] = -1L;
        } else {
            this.smallBins[index] = f;
            this.backward(f, b2);
            this.forward(b2, f);
        }
        long rsize = (long)LongBestFitAllocator.smallBinIndexToSize(index) - nb;
        if (rsize < 32L) {
            this.setInUseAndPreviousInUse(h2, LongBestFitAllocator.smallBinIndexToSize(index));
        } else {
            this.setSizeAndPreviousInUseOfInUseChunk(h2, nb);
            long r = h2 + nb;
            this.setSizeAndPreviousInUseOfFreeChunk(r, rsize);
            this.replaceDesignatedVictim(r, rsize);
        }
        long mem = LongBestFitAllocator.chunkToMem(h2);
        this.checkMallocedChunk(mem, nb);
        return mem;
    }

    private void replaceDesignatedVictim(long p, long s2) {
        long dvs = this.designatedVictimSize;
        if (dvs != 0L) {
            long dv = this.designatedVictim;
            Validation.validate(!VALIDATING || LongBestFitAllocator.isSmall(dvs));
            this.insertSmallChunk(dv, dvs);
        }
        this.designatedVictimSize = s2;
        this.designatedVictim = p;
    }

    private long splitSmallFromTree(long nb) {
        long t;
        int index = Integer.numberOfTrailingZeros(this.treeMap);
        long v = t = this.treeBins[index];
        long rsize = this.chunkSize(t) - nb;
        while ((t = this.leftmostChild(t)) != -1L) {
            long trem = this.chunkSize(t) - nb;
            if (trem < 0L || trem >= rsize) continue;
            rsize = trem;
            v = t;
        }
        if (LongBestFitAllocator.okAddress(v)) {
            long r = v + nb;
            Validation.validate(!VALIDATING || this.chunkSize(v) == rsize + nb);
            if (LongBestFitAllocator.okNext(v, r)) {
                this.unlinkLargeChunk(v);
                if (rsize < 32L) {
                    this.setInUseAndPreviousInUse(v, rsize + nb);
                } else {
                    this.setSizeAndPreviousInUseOfInUseChunk(v, nb);
                    this.setSizeAndPreviousInUseOfFreeChunk(r, rsize);
                    this.replaceDesignatedVictim(r, rsize);
                }
                long mem = LongBestFitAllocator.chunkToMem(v);
                this.checkMallocedChunk(mem, nb);
                return mem;
            }
            throw new AssertionError();
        }
        throw new AssertionError();
    }

    private long splitFromTree(long nb) {
        int leftbits;
        long v = -1L;
        long rsize = Long.MAX_VALUE & -nb;
        int index = LongBestFitAllocator.treeBinIndex(nb);
        long t = this.treeBins[index];
        if (t != -1L) {
            long sizebits = nb << LongBestFitAllocator.leftShiftForTreeIndex(index);
            long rst = -1L;
            while (true) {
                long trem;
                if ((trem = this.chunkSize(t) - nb) >= 0L && trem < rsize) {
                    v = t;
                    rsize = trem;
                    if (rsize == 0L) break;
                }
                long rt = this.child(t, 1);
                t = this.child(t, (int)(sizebits >>> 63));
                if (rt != -1L && rt != t) {
                    rst = rt;
                }
                if (t == -1L) {
                    t = rst;
                    break;
                }
                sizebits <<= 1;
            }
        }
        if (t == -1L && v == -1L && (leftbits = LongBestFitAllocator.leftBits(1 << index) & this.treeMap) != 0) {
            t = this.treeBins[Integer.numberOfTrailingZeros(leftbits)];
        }
        while (t != -1L) {
            long trem = this.chunkSize(t) - nb;
            if (trem >= 0L && trem < rsize) {
                rsize = trem;
                v = t;
            }
            t = this.leftmostChild(t);
        }
        long designatedVictimFit = this.designatedVictimSize - nb;
        if (v != -1L && (designatedVictimFit < 0L || rsize < designatedVictimFit)) {
            if (LongBestFitAllocator.okAddress(v)) {
                long r = v + nb;
                Validation.validate(!VALIDATING || this.chunkSize(v) == rsize + nb);
                if (LongBestFitAllocator.okNext(v, r)) {
                    this.unlinkLargeChunk(v);
                    if (rsize < 32L) {
                        this.setInUseAndPreviousInUse(v, rsize + nb);
                    } else {
                        this.setSizeAndPreviousInUseOfInUseChunk(v, nb);
                        this.setSizeAndPreviousInUseOfFreeChunk(r, rsize);
                        this.insertChunk(r, rsize);
                    }
                    return LongBestFitAllocator.chunkToMem(v);
                }
            } else {
                throw new AssertionError();
            }
        }
        return -1L;
    }

    private long splitFromDesignatedVictim(long nb) {
        long rsize = this.designatedVictimSize - nb;
        long p = this.designatedVictim;
        if (rsize >= 32L) {
            long r = this.designatedVictim = p + nb;
            this.designatedVictimSize = rsize;
            this.setSizeAndPreviousInUseOfFreeChunk(r, rsize);
            this.setSizeAndPreviousInUseOfInUseChunk(p, nb);
        } else {
            long dvs = this.designatedVictimSize;
            this.designatedVictimSize = 0L;
            this.designatedVictim = -1L;
            this.setInUseAndPreviousInUse(p, dvs);
        }
        long mem = LongBestFitAllocator.chunkToMem(p);
        this.checkMallocedChunk(mem, nb);
        return mem;
    }

    private long splitFromTop(long nb) {
        long rSize = this.topSize -= nb;
        long p = this.top;
        long r = this.top = p + nb;
        this.head(r, rSize | 1L);
        this.setSizeAndPreviousInUseOfInUseChunk(p, nb);
        long mem = LongBestFitAllocator.chunkToMem(p);
        this.checkTopChunk(this.top);
        this.checkMallocedChunk(mem, nb);
        return mem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dlfree(long mem, boolean shrink) {
        long p = LongBestFitAllocator.memToChunk(mem);
        if (!LongBestFitAllocator.okAddress(p) || !this.isInUse(p)) throw new IllegalArgumentException("Address " + mem + " has not been allocated");
        this.checkInUseChunk(p);
        long psize = this.chunkSize(p);
        this.occupied -= psize;
        long next = p + psize;
        if (!this.previousInUse(p)) {
            long previousSize = this.prevFoot(p);
            long previous = p - previousSize;
            psize += previousSize;
            p = previous;
            if (!LongBestFitAllocator.okAddress(previous)) throw new AssertionError();
            if (p != this.designatedVictim) {
                this.unlinkChunk(p, previousSize);
            } else if ((this.head(next) & 3L) == 3L) {
                this.designatedVictimSize = psize;
                this.setFreeWithPreviousInUse(p, psize, next);
                return;
            }
        }
        if (!LongBestFitAllocator.okNext(p, next) || !this.previousInUse(next)) throw new AssertionError((Object)("Problem with next chunk [" + p + "][" + next + ":previous-inuse=" + this.previousInUse(next) + "]"));
        if (!this.chunkInUse(next)) {
            if (next == this.top) {
                long tsize = this.topSize += psize;
                this.top = p;
                this.head(p, tsize | 1L);
                if (p == this.designatedVictim) {
                    this.designatedVictim = -1L;
                    this.designatedVictimSize = 0L;
                }
                if (!shrink) return;
                this.storage.release(p + TOP_FOOT_SIZE);
                return;
            }
            if (next == this.designatedVictim) {
                long dsize = this.designatedVictimSize += psize;
                this.designatedVictim = p;
                this.setSizeAndPreviousInUseOfFreeChunk(p, dsize);
                return;
            }
            long nsize = this.chunkSize(next);
            this.unlinkChunk(next, nsize);
            this.setSizeAndPreviousInUseOfFreeChunk(p, psize += nsize);
            if (p == this.designatedVictim) {
                this.designatedVictimSize = psize;
                return;
            }
        } else {
            this.setFreeWithPreviousInUse(p, psize, next);
        }
        if (LongBestFitAllocator.isSmall(psize)) {
            this.insertSmallChunk(p, psize);
            return;
        } else {
            this.insertLargeChunk(p, psize);
        }
    }

    private void insertChunk(long p, long s2) {
        if (LongBestFitAllocator.isSmall(s2)) {
            this.insertSmallChunk(p, s2);
        } else {
            this.insertLargeChunk(p, s2);
        }
    }

    private void insertSmallChunk(long p, long s2) {
        int index = LongBestFitAllocator.smallBinIndex(s2);
        long h2 = this.smallBins[index];
        if (!this.smallMapIsMarked(index)) {
            this.markSmallMap(index);
            this.smallBins[index] = p;
            this.forward(p, p);
            this.backward(p, p);
        } else if (LongBestFitAllocator.okAddress(h2)) {
            long b2 = this.backward(h2);
            this.forward(b2, p);
            this.forward(p, h2);
            this.backward(h2, p);
            this.backward(p, b2);
        } else {
            throw new AssertionError();
        }
        this.checkFreeChunk(p);
    }

    private void insertLargeChunk(long x, long s2) {
        block6: {
            int index = LongBestFitAllocator.treeBinIndex(s2);
            long h2 = this.treeBins[index];
            this.index(x, index);
            this.child(x, 0, -1L);
            this.child(x, 1, -1L);
            if (!this.treeMapIsMarked(index)) {
                this.markTreeMap(index);
                this.treeBins[index] = x;
                this.parent(x, -1L);
                this.forward(x, x);
                this.backward(x, x);
            } else {
                long t = h2;
                long k = s2 << LongBestFitAllocator.leftShiftForTreeIndex(index);
                while (this.chunkSize(t) != s2) {
                    int childIndex = (int)(k >>> 63 & 1L);
                    long child = this.child(t, childIndex);
                    k <<= 1;
                    if (LongBestFitAllocator.okAddress(child)) {
                        t = child;
                        continue;
                    }
                    this.child(t, childIndex, x);
                    this.parent(x, t);
                    this.forward(x, x);
                    this.backward(x, x);
                    break block6;
                }
                long f = this.forward(t);
                if (LongBestFitAllocator.okAddress(t) && LongBestFitAllocator.okAddress(f)) {
                    this.backward(f, x);
                    this.forward(t, x);
                    this.forward(x, f);
                    this.backward(x, t);
                    this.parent(x, -1L);
                } else {
                    throw new AssertionError();
                }
            }
        }
        this.checkFreeChunk(x);
    }

    private void unlinkChunk(long p, long s2) {
        if (LongBestFitAllocator.isSmall(s2)) {
            this.unlinkSmallChunk(p, s2);
        } else {
            this.unlinkLargeChunk(p);
        }
    }

    private void unlinkSmallChunk(long p, long s2) {
        long f = this.forward(p);
        long b2 = this.backward(p);
        int index = LongBestFitAllocator.smallBinIndex(s2);
        Validation.validate(!VALIDATING || this.chunkSize(p) == (long)LongBestFitAllocator.smallBinIndexToSize(index));
        if (f == p) {
            Validation.validate(!VALIDATING || b2 == p);
            this.clearSmallMap(index);
            this.smallBins[index] = -1L;
        } else if (LongBestFitAllocator.okAddress(this.smallBins[index])) {
            if (this.smallBins[index] == p) {
                this.smallBins[index] = f;
            }
            this.forward(b2, f);
            this.backward(f, b2);
        } else {
            throw new AssertionError();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unlinkLargeChunk(long x) {
        long c1;
        long r;
        long xp;
        block13: {
            int rpIndex;
            block14: {
                block12: {
                    xp = this.parent(x);
                    if (this.backward(x) == x) break block12;
                    long f = this.forward(x);
                    r = this.backward(x);
                    if (!LongBestFitAllocator.okAddress(f)) throw new AssertionError();
                    this.backward(f, r);
                    this.forward(r, f);
                    break block13;
                }
                rpIndex = 1;
                r = this.child(x, 1);
                if (r != -1L) break block14;
                rpIndex = 0;
                r = this.child(x, 0);
                if (r == -1L) break block13;
            }
            long rp = x;
            while (true) {
                if (this.child(r, 1) != -1L) {
                    rp = r;
                    rpIndex = 1;
                    r = this.child(r, 1);
                    continue;
                }
                if (this.child(r, 0) == -1L) break;
                rp = r;
                rpIndex = 0;
                r = this.child(r, 0);
            }
            if (!LongBestFitAllocator.okAddress(rp)) throw new AssertionError();
            this.child(rp, rpIndex, -1L);
        }
        int index = this.index(x);
        if (xp == -1L && this.treeBins[index] != x) return;
        long h2 = this.treeBins[index];
        if (x == h2) {
            this.treeBins[index] = r;
            if (this.treeBins[index] == -1L) {
                this.clearTreeMap(index);
            } else {
                this.parent(r, -1L);
            }
        } else {
            if (!LongBestFitAllocator.okAddress(xp)) throw new AssertionError();
            if (this.child(xp, 0) == x) {
                this.child(xp, 0, r);
            } else {
                this.child(xp, 1, r);
            }
        }
        if (r == -1L) return;
        if (!LongBestFitAllocator.okAddress(r)) throw new AssertionError();
        this.parent(r, xp);
        long c0 = this.child(x, 0);
        if (c0 != -1L) {
            if (!LongBestFitAllocator.okAddress(c0)) throw new AssertionError();
            this.child(r, 0, c0);
            this.parent(c0, r);
        }
        if ((c1 = this.child(x, 1)) == -1L) return;
        if (!LongBestFitAllocator.okAddress(c1)) throw new AssertionError();
        this.child(r, 1, c1);
        this.parent(c1, r);
    }

    private boolean chunkInUse(long p) {
        return (this.head(p) & 2L) != 0L;
    }

    private boolean previousInUse(long p) {
        return (this.head(p) & 1L) != 0L;
    }

    private boolean isInUse(long p) {
        return (this.head(p) & 3L) != 1L;
    }

    private long chunkSize(long p) {
        return this.head(p) & 0xFFFFFFFFFFFFFFF8L;
    }

    private void clearPreviousInUse(long p) {
        this.head(p, this.head(p) & 0xFFFFFFFFFFFFFFFEL);
    }

    private long nextChunk(long p) {
        return p + this.chunkSize(p);
    }

    private long prevChunk(long p) {
        return p - this.prevFoot(p);
    }

    private boolean nextPreviousInUse(long p) {
        return (this.head(this.nextChunk(p)) & 1L) != 0L;
    }

    private void setFoot(long p, long s2) {
        this.prevFoot(p + s2, s2);
    }

    private void setSizeAndPreviousInUseOfFreeChunk(long p, long s2) {
        this.head(p, s2 | 1L);
        this.setFoot(p, s2);
    }

    private void setFreeWithPreviousInUse(long p, long s2, long n) {
        this.clearPreviousInUse(n);
        this.setSizeAndPreviousInUseOfFreeChunk(p, s2);
    }

    private void setInUseAndPreviousInUse(long p, long s2) {
        this.setSizeAndPreviousInUseOfInUseChunk(p, s2);
        this.head(p + s2, this.head(p + s2) | 1L);
    }

    private void setSizeAndPreviousInUseOfInUseChunk(long p, long s2) {
        this.head(p, s2 | 1L | 2L);
        this.setFoot(p, s2);
        this.occupied += s2;
    }

    private long prevFoot(long p) {
        return this.storage.readLong(p);
    }

    private void prevFoot(long p, long value) {
        this.storage.writeLong(p, value);
    }

    private long head(long p) {
        return this.storage.readLong(p + 8L);
    }

    private void head(long p, long value) {
        this.storage.writeLong(p + 8L, value);
    }

    private long forward(long p) {
        return this.storage.readLong(p + 16L);
    }

    private void forward(long p, long value) {
        this.storage.writeLong(p + 16L, value);
    }

    private long backward(long p) {
        return this.storage.readLong(p + 24L);
    }

    private void backward(long p, long value) {
        this.storage.writeLong(p + 24L, value);
    }

    @FindbugsSuppressWarnings(value={"ICAST_INTEGER_MULTIPLY_CAST_TO_LONG"})
    private long child(long p, int index) {
        return this.storage.readLong(p + (long)((4 + index) * 8));
    }

    @FindbugsSuppressWarnings(value={"ICAST_INTEGER_MULTIPLY_CAST_TO_LONG"})
    private void child(long p, int index, long value) {
        this.storage.writeLong(p + (long)((4 + index) * 8), value);
    }

    private long parent(long p) {
        return this.storage.readLong(p + 48L);
    }

    private void parent(long p, long value) {
        this.storage.writeLong(p + 48L, value);
    }

    private int index(long p) {
        return this.storage.readInt(p + 56L);
    }

    private void index(long p, int value) {
        this.storage.writeInt(p + 56L, value);
    }

    private long leftmostChild(long x) {
        long left = this.child(x, 0);
        return left != -1L ? left : this.child(x, 1);
    }

    private static long padRequest(long req) {
        return req + 16L + 15L & 0xFFFFFFFFFFFFFFF0L;
    }

    private static long chunkToMem(long p) {
        return p + 16L;
    }

    private static long memToChunk(long p) {
        return p - 16L;
    }

    private static boolean okAddress(long a2) {
        return a2 >= 0L;
    }

    private static boolean okNext(long p, long n) {
        return p < n;
    }

    private static boolean isAligned(long a2) {
        return (a2 & 0xFL) == 0L;
    }

    private static long alignOffset(long a2) {
        return (a2 & 0xFL) == 0L ? 0L : 16L - (a2 & 0xFL) & 0xFL;
    }

    private static boolean isSmall(long s2) {
        return LongBestFitAllocator.smallBinIndex(s2) < 32;
    }

    private static int smallBinIndex(long s2) {
        return Integer.MAX_VALUE & (int)(s2 >>> 3);
    }

    private static int smallBinIndexToSize(int i) {
        return i << 3;
    }

    private static int treeBinIndex(long s2) {
        int x = Integer.MAX_VALUE & (int)(s2 >>> 8);
        if (x == 0) {
            return 0;
        }
        if (x > 65535) {
            return 31;
        }
        int k = 31 - Integer.numberOfLeadingZeros(x);
        return (k << 1) + (int)(s2 >>> k + 7 & 1L);
    }

    private void markSmallMap(int i) {
        this.smallMap |= 1 << i;
    }

    private void clearSmallMap(int i) {
        this.smallMap &= ~(1 << i);
    }

    private boolean smallMapIsMarked(int i) {
        return (this.smallMap & 1 << i) != 0;
    }

    private void markTreeMap(int i) {
        this.treeMap |= 1 << i;
    }

    private void clearTreeMap(int i) {
        this.treeMap &= ~(1 << i);
    }

    private boolean treeMapIsMarked(int i) {
        return (this.treeMap & 1 << i) != 0;
    }

    private static int leftShiftForTreeIndex(int i) {
        return i == 31 ? 0 : 63 - ((i >>> 1) + 8 - 2);
    }

    private static int minSizeForTreeIndex(int i) {
        return 1 << (i >>> 1) + 8 | (i & 1) << (i >>> 1) + 8 - 1;
    }

    private static int leftBits(int i) {
        return i << 1 | -(i << 1);
    }

    @Override
    public void validateAllocator() {
        int i;
        if (this.topSize < 0L) {
            return;
        }
        this.traverseAndCheck();
        for (i = 0; i < this.smallBins.length; ++i) {
            this.checkSmallBin(i);
        }
        for (i = 0; i < this.treeBins.length; ++i) {
            this.checkTreeBin(i);
        }
    }

    public long validateMallocedPointer(long m3) {
        long p = LongBestFitAllocator.memToChunk(m3);
        this.checkMallocedChunk(m3, this.chunkSize(p));
        if (this.findFreeChunk(p)) {
            throw new AssertionError();
        }
        return this.chunkSize(p);
    }

    private void checkAnyChunk(long p) {
        if (VALIDATING) {
            if (!LongBestFitAllocator.isAligned(LongBestFitAllocator.chunkToMem(p))) {
                throw new AssertionError((Object)("Chunk address [mem:" + p + "=>chunk:" + LongBestFitAllocator.chunkToMem(p) + "] is incorrectly aligned"));
            }
            if (!LongBestFitAllocator.okAddress(p)) {
                throw new AssertionError((Object)("Memory address " + p + " is invalid"));
            }
        }
    }

    private void checkTopChunk(long p) {
        if (VALIDATING) {
            long sz = this.head(p) & 0xFFFFFFFFFFFFFFFCL;
            if (!LongBestFitAllocator.isAligned(LongBestFitAllocator.chunkToMem(p))) {
                throw new AssertionError((Object)("Chunk address [mem:" + p + "=>chunk:" + LongBestFitAllocator.chunkToMem(p) + "] of top chunk is incorrectly aligned"));
            }
            if (!LongBestFitAllocator.okAddress(p)) {
                throw new AssertionError((Object)("Memory address " + p + " of top chunk is invalid"));
            }
            if (sz != this.topSize) {
                throw new AssertionError((Object)("Marked size top chunk " + sz + " is not equals to the recorded top size " + this.topSize));
            }
            if (sz <= 0L) {
                throw new AssertionError((Object)("Top chunk size " + sz + " is not positive"));
            }
            if (!this.previousInUse(p)) {
                throw new AssertionError((Object)"Chunk before top chunk is free - why has it not been merged in to the top chunk?");
            }
        }
    }

    private void checkInUseChunk(long p) {
        if (VALIDATING) {
            this.checkAnyChunk(p);
            if (!this.isInUse(p)) {
                throw new AssertionError((Object)("Chunk at " + p + " is not in use"));
            }
            if (!this.nextPreviousInUse(p)) {
                throw new AssertionError((Object)("Chunk after " + p + " does not see this chunk as in use"));
            }
            if (!this.previousInUse(p) && this.nextChunk(this.prevChunk(p)) != p) {
                throw new AssertionError((Object)("Previous chunk to " + p + " is marked free but has an incorrect next pointer"));
            }
        }
    }

    private void checkFreeChunk(long p) {
        if (VALIDATING) {
            long sz = this.chunkSize(p);
            long next = p + sz;
            this.checkAnyChunk(p);
            if (this.isInUse(p)) {
                throw new AssertionError((Object)("Free chunk " + p + " is not marked as free"));
            }
            if (this.nextPreviousInUse(p)) {
                throw new AssertionError((Object)("Next chunk after " + p + " has it marked as in use"));
            }
            if (p != this.designatedVictim && p != this.top) {
                if (sz < 32L) {
                    throw new AssertionError((Object)("Free chunk " + p + " is too small"));
                }
                if ((sz & 0xFL) != 0L) {
                    throw new AssertionError((Object)("Chunk size " + sz + " of " + p + " is not correctly aligned"));
                }
                if (!LongBestFitAllocator.isAligned(LongBestFitAllocator.chunkToMem(p))) {
                    throw new AssertionError((Object)("User pointer for chunk " + p + " is not correctly aligned"));
                }
                if (this.prevFoot(next) != sz) {
                    throw new AssertionError((Object)("Next chunk after " + p + " has an incorrect previous size"));
                }
                if (!this.previousInUse(p)) {
                    throw new AssertionError((Object)("Chunk before free chunk " + p + " is free - should have been merged"));
                }
                if (next != this.top && !this.isInUse(next)) {
                    throw new AssertionError((Object)("Chunk after free chunk " + p + " is free - should have been merged"));
                }
                if (this.backward(this.forward(p)) != p) {
                    throw new AssertionError((Object)("Free chunk " + p + " has invalid chain links"));
                }
                if (this.forward(this.backward(p)) != p) {
                    throw new AssertionError((Object)("Free chunk " + p + " has invalid chain links"));
                }
            }
        }
    }

    private void checkMallocedChunk(long mem, long s2) {
        if (VALIDATING) {
            long p = LongBestFitAllocator.memToChunk(mem);
            long sz = this.head(p) & 0xFFFFFFFFFFFFFFFCL;
            this.checkInUseChunk(p);
            if (sz < 32L) {
                throw new AssertionError((Object)("Allocated chunk " + p + " is too small"));
            }
            if ((sz & 0xFL) != 0L) {
                throw new AssertionError((Object)("Chunk size " + sz + " of " + p + " is not correctly aligned"));
            }
            if (sz < s2) {
                throw new AssertionError((Object)("Allocated chunk " + p + " is smaller than requested [" + sz + "<" + s2 + "]"));
            }
            if (sz > s2 + 32L) {
                throw new AssertionError((Object)("Allocated chunk " + p + " is too large (should have been split off) [" + sz + ">>" + s2 + "]"));
            }
        }
    }

    private void checkTree(long t) {
        long tsize;
        int index;
        long head = -1L;
        long u = t;
        int tindex = this.index(t);
        if (tindex != (index = LongBestFitAllocator.treeBinIndex(tsize = this.chunkSize(t)))) {
            throw new AssertionError((Object)("Tree node " + u + " has incorrect index [" + this.index(u) + "!=" + tindex + "]"));
        }
        if (tsize < 256L) {
            throw new AssertionError((Object)("Tree node " + u + " is too small to be in a tree [" + tsize + "<" + 256 + "]"));
        }
        if (tsize < (long)LongBestFitAllocator.minSizeForTreeIndex(index)) {
            throw new AssertionError((Object)("Tree node " + u + " is too small to be in this tree [" + tsize + "<" + LongBestFitAllocator.minSizeForTreeIndex(index) + "]"));
        }
        if (index != 31 && tsize >= (long)LongBestFitAllocator.minSizeForTreeIndex(index + 1)) {
            throw new AssertionError((Object)("Tree node " + u + " is too large to be in this tree [" + tsize + ">=" + LongBestFitAllocator.minSizeForTreeIndex(index + 1) + "]"));
        }
        do {
            this.checkAnyChunk(u);
            if (this.index(u) != tindex) {
                throw new AssertionError((Object)("Tree node " + u + " has incorrect index [" + this.index(u) + "!=" + tindex + "]"));
            }
            if (this.chunkSize(u) != tsize) {
                throw new AssertionError((Object)("Tree node " + u + " has an mismatching size [" + this.chunkSize(u) + "!=" + tsize + "]"));
            }
            if (this.isInUse(u)) {
                throw new AssertionError((Object)("Tree node " + u + " is in use"));
            }
            if (this.nextPreviousInUse(u)) {
                throw new AssertionError((Object)("Tree node " + u + " is marked as in use in the next chunk"));
            }
            if (this.backward(this.forward(u)) != u) {
                throw new AssertionError((Object)("Tree node " + u + " has incorrect chain links"));
            }
            if (this.forward(this.backward(u)) != u) {
                throw new AssertionError((Object)("Tree node " + u + " has incorrect chain links"));
            }
            if (this.parent(u) == -1L && u != this.treeBins[index]) {
                if (this.child(u, 0) != -1L) {
                    throw new AssertionError((Object)("Tree node " + u + " is chained from the tree but has a child " + this.child(u, 0)));
                }
                if (this.child(u, 1) != -1L) {
                    throw new AssertionError((Object)("Tree node " + u + " is chained from the tree but has a child" + this.child(u, 1)));
                }
                continue;
            }
            if (head != -1L) {
                throw new AssertionError((Object)("Tree node " + u + " is the second node in this chain with a parent [first was " + head + "]"));
            }
            head = u;
            if (this.treeBins[index] == u) {
                if (this.parent(u) != -1L) {
                    throw new AssertionError((Object)("Tree node " + u + " is the head of the tree but has a parent " + this.parent(u)));
                }
            } else {
                if (this.parent(u) == u) {
                    throw new AssertionError((Object)("Tree node " + u + " is its own parent"));
                }
                if (this.child(this.parent(u), 0) != u && this.child(this.parent(u), 1) != u) {
                    throw new AssertionError((Object)("Tree node " + u + " is not a child of its parent"));
                }
            }
            if (this.child(u, 0) != -1L) {
                if (this.parent(this.child(u, 0)) != u) {
                    throw new AssertionError((Object)("Tree node " + u + " is not the parent of its left child"));
                }
                if (this.child(u, 0) == u) {
                    throw new AssertionError((Object)("Tree node " + u + " is its own left child"));
                }
                this.checkTree(this.child(u, 0));
            }
            if (this.child(u, 1) != -1L) {
                if (this.parent(this.child(u, 1)) != u) {
                    throw new AssertionError((Object)("Tree node " + u + " is not the parent of its right child"));
                }
                if (this.child(u, 1) == u) {
                    throw new AssertionError((Object)("Tree node " + u + " is its own right child"));
                }
                this.checkTree(this.child(u, 1));
            }
            if (this.child(u, 0) != -1L && this.child(u, 1) != -1L && this.chunkSize(this.child(u, 0)) >= this.chunkSize(this.child(u, 1))) {
                throw new AssertionError((Object)("Tree node " + u + " has it's left child bigger than it's right child"));
            }
        } while ((u = this.forward(u)) != t);
        if (head == -1L) {
            throw new AssertionError((Object)"This tree level has no nodes with a parent");
        }
    }

    private void checkTreeBin(int index) {
        boolean empty;
        long tb = this.treeBins[index];
        boolean bl = empty = (this.treeMap & 1 << index) == 0;
        if (tb == -1L && !empty) {
            throw new AssertionError((Object)("Tree " + index + " is marked as occupied but has an invalid head pointer"));
        }
        if (!empty) {
            this.checkTree(tb);
        }
    }

    private void checkSmallBin(int index) {
        boolean empty;
        long h2 = this.smallBins[index];
        boolean bl = empty = (this.smallMap & 1 << index) == 0;
        if (h2 == -1L && !empty) {
            throw new AssertionError((Object)("Small bin chain " + index + " is marked as occupied but has an invalid head pointer"));
        }
        if (!empty) {
            long p = h2;
            do {
                long size = this.chunkSize(p);
                this.checkFreeChunk(p);
                if (LongBestFitAllocator.smallBinIndex(size) != index) {
                    throw new AssertionError((Object)("Chunk " + p + " is the wrong size to be in bin " + index));
                }
                if (this.backward(p) != p && this.chunkSize(this.backward(p)) != this.chunkSize(p)) {
                    throw new AssertionError((Object)("Chunk " + p + " is the linked to a chunk of the wrong size"));
                }
                this.checkInUseChunk(this.nextChunk(p));
            } while ((p = this.backward(p)) != h2);
        }
    }

    private long traverseAndCheck() {
        long sum = 0L;
        sum += this.topSize + TOP_FOOT_SIZE;
        long q = 0L;
        long lastq = 0L;
        if (!this.previousInUse(q)) {
            throw new AssertionError((Object)"Chunk before zeroth chunk is marked as free");
        }
        while (q != this.top) {
            sum += this.chunkSize(q);
            if (this.isInUse(q)) {
                if (this.findFreeChunk(q)) {
                    throw new AssertionError((Object)"Chunk marked as in-use appears in a free structure");
                }
                this.checkInUseChunk(q);
            } else {
                if (q != this.designatedVictim && !this.findFreeChunk(q)) {
                    throw new AssertionError((Object)"Chunk marked as free cannot be found in any free structure");
                }
                if (lastq != 0L && !this.isInUse(lastq)) {
                    throw new AssertionError((Object)"Chunk before free chunk is not in-use");
                }
                this.checkFreeChunk(q);
            }
            lastq = q;
            q = this.nextChunk(q);
        }
        return sum;
    }

    private boolean findFreeChunk(long x) {
        long size = this.chunkSize(x);
        if (LongBestFitAllocator.isSmall(size)) {
            int sidx = LongBestFitAllocator.smallBinIndex(size);
            long h2 = this.smallBins[sidx];
            if (this.smallMapIsMarked(sidx)) {
                long p = h2;
                do {
                    if (p != x) continue;
                    return true;
                } while ((p = this.forward(p)) != h2);
            }
        } else {
            int tidx = LongBestFitAllocator.treeBinIndex(size);
            if (this.treeMapIsMarked(tidx)) {
                long t = this.treeBins[tidx];
                long sizebits = size << LongBestFitAllocator.leftShiftForTreeIndex(tidx);
                while (t != -1L && this.chunkSize(t) != size) {
                    t = this.child(t, (int)(sizebits >>> 63 & 1L));
                    sizebits <<= 1;
                }
                if (t != -1L) {
                    long u = t;
                    do {
                        if (u != x) continue;
                        return true;
                    } while ((u = this.forward(u)) != t);
                }
            }
        }
        return false;
    }

    @Override
    public long getLastUsedPointer() {
        if (this.top <= 0L) {
            return -1L;
        }
        return LongBestFitAllocator.chunkToMem(this.prevChunk(this.top));
    }

    @Override
    public long getLastUsedAddress() {
        if (this.top <= 0L) {
            return 0L;
        }
        return this.top;
    }

    @Override
    public int getMinimalSize() {
        return (int)MINIMAL_SIZE;
    }

    @Override
    public long getMaximumAddress() {
        return Long.MAX_VALUE;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            private long current;
            {
                this.current = LongBestFitAllocator.this.isInUse(0L) || 0L >= LongBestFitAllocator.this.top ? 0L : LongBestFitAllocator.this.nextChunk(0L);
            }

            @Override
            public boolean hasNext() {
                return this.current < LongBestFitAllocator.this.top;
            }

            @Override
            public Long next() {
                if (this.current >= LongBestFitAllocator.this.top) {
                    throw new NoSuchElementException();
                }
                long result = this.current;
                long next = LongBestFitAllocator.this.nextChunk(this.current);
                this.current = next >= LongBestFitAllocator.this.top ? next : (LongBestFitAllocator.this.isInUse(next) ? next : LongBestFitAllocator.this.nextChunk(next));
                return LongBestFitAllocator.chunkToMem(result);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }
}

