/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import javax.measure.format.UnitFormat;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.AbstractQuantityFormat;
import tech.units.indriya.format.CommonFormatter;
import tech.units.indriya.format.FormatBehavior;
import tech.units.indriya.format.LocalUnitFormat;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.quantity.CompoundQuantity;
import tech.units.indriya.quantity.Quantities;

public class NumberDelimiterQuantityFormat
extends AbstractQuantityFormat {
    private static final NumberDelimiterQuantityFormat SIMPLE = new Builder().setNumberFormat(NumberFormat.getInstance(Locale.ROOT)).setUnitFormat(SimpleUnitFormat.getInstance()).build();
    private static final NumberDelimiterQuantityFormat LOCAL = new Builder().setNumberFormat(NumberFormat.getInstance()).setUnitFormat(LocalUnitFormat.getInstance()).setLocaleSensitive(true).build();
    private static final long serialVersionUID = 3546952599885869402L;
    private transient NumberFormat numberFormat;
    private transient UnitFormat unitFormat;
    private transient Unit primaryUnit;
    private String delimiter;
    private String mixDelimiter;
    private boolean localeSensitive;

    private NumberDelimiterQuantityFormat() {
    }

    public static NumberDelimiterQuantityFormat getInstance(FormatBehavior style) {
        switch (style) {
            case LOCALE_NEUTRAL: {
                return SIMPLE;
            }
            case LOCALE_SENSITIVE: {
                return LOCAL;
            }
        }
        return SIMPLE;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static NumberDelimiterQuantityFormat getInstance() {
        return NumberDelimiterQuantityFormat.getInstance(FormatBehavior.LOCALE_NEUTRAL);
    }

    public static NumberDelimiterQuantityFormat getInstance(NumberFormat numberFormat, UnitFormat unitFormat) {
        return new Builder().setNumberFormat(numberFormat).setUnitFormat(unitFormat).build();
    }

    @Override
    public Appendable format(Quantity<?> quantity, Appendable dest) throws IOException {
        int fract = 0;
        if (quantity != null && quantity.getValue() != null) {
            fract = NumberDelimiterQuantityFormat.getFractionDigitsCount(quantity.getValue().doubleValue());
        }
        if (fract > 1) {
            this.numberFormat.setMaximumFractionDigits(fract + 1);
        }
        dest.append(this.numberFormat.format(quantity.getValue()));
        if (quantity.getUnit().equals(AbstractUnit.ONE)) {
            return dest;
        }
        dest.append(this.delimiter);
        return this.unitFormat.format(quantity.getUnit(), dest);
    }

    @Override
    public Quantity<?> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException, MeasurementParseException {
        String str = csq.toString();
        int index = cursor.getIndex();
        if (this.mixDelimiter != null && !this.mixDelimiter.equals(this.delimiter)) {
            if (this.primaryUnit != null) {
                return CommonFormatter.parseCompoundAsPrimary(str, this.numberFormat, this.unitFormat, this.primaryUnit, this.delimiter, this.mixDelimiter, index);
            }
            return CommonFormatter.parseCompoundAsLeading(str, this.numberFormat, this.unitFormat, this.delimiter, this.mixDelimiter, index);
        }
        if (this.mixDelimiter != null && this.mixDelimiter.equals(this.delimiter)) {
            if (this.primaryUnit != null) {
                return CommonFormatter.parseCompoundAsPrimary(str, this.numberFormat, this.unitFormat, this.primaryUnit, this.delimiter, index);
            }
            return CommonFormatter.parseCompoundAsLeading(str, this.numberFormat, this.unitFormat, this.delimiter, index);
        }
        Number number = this.numberFormat.parse(str, cursor);
        if (number == null) {
            throw new IllegalArgumentException("Number cannot be parsed");
        }
        String[] parts = str.substring(index).split(this.delimiter);
        if (parts.length < 2) {
            throw new IllegalArgumentException("No Unit found");
        }
        Unit<?> unit = this.unitFormat.parse(parts[1]);
        return Quantities.getQuantity(number, unit);
    }

    @Override
    protected Quantity<?> parse(CharSequence csq, int index) throws IllegalArgumentException, MeasurementParseException {
        return this.parse(csq, new ParsePosition(index));
    }

    @Override
    public Quantity<?> parse(CharSequence csq) throws IllegalArgumentException, MeasurementParseException {
        return this.parse(csq, 0);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isLocaleSensitive() {
        return this.localeSensitive;
    }

    @Override
    protected StringBuffer formatCompound(CompoundQuantity<?> comp, StringBuffer dest) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (Quantity<?> q : comp.getQuantities()) {
            sb.append(this.format(q));
            if (i < comp.getQuantities().size() - 1) {
                sb.append(this.mixDelimiter != null ? this.mixDelimiter : " ");
            }
            ++i;
        }
        return sb;
    }

    public CompoundQuantity<?> parseCompound(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException, MeasurementParseException {
        String str = csq.toString();
        int index = cursor.getIndex();
        if (this.mixDelimiter != null && !this.mixDelimiter.equals(this.delimiter)) {
            return CommonFormatter.parseCompound(str, this.numberFormat, this.unitFormat, this.delimiter, this.mixDelimiter, index);
        }
        if (this.mixDelimiter != null && this.mixDelimiter.equals(this.delimiter)) {
            return CommonFormatter.parseCompound(str, this.numberFormat, this.unitFormat, this.delimiter, index);
        }
        Number number = this.numberFormat.parse(str, cursor);
        if (number == null) {
            throw new IllegalArgumentException("Number cannot be parsed");
        }
        String[] parts = str.substring(index).split(this.delimiter);
        if (parts.length < 2) {
            throw new IllegalArgumentException("No Unit found");
        }
        Unit<?> unit = this.unitFormat.parse(parts[1]);
        return CompoundQuantity.of(Quantities.getQuantity(number, unit));
    }

    protected CompoundQuantity<?> parseCompound(CharSequence csq, int index) throws IllegalArgumentException, MeasurementParseException {
        return this.parseCompound(csq, new ParsePosition(index));
    }

    public CompoundQuantity<?> parseCompound(CharSequence csq) throws IllegalArgumentException, MeasurementParseException {
        return this.parseCompound(csq, 0);
    }

    private static int getFractionDigitsCount(double d2) {
        if (d2 >= 1.0) {
            d2 -= (double)((long)d2);
        }
        if (d2 == 0.0) {
            return 0;
        }
        d2 *= 10.0;
        int count = 1;
        while (d2 - (double)((long)d2) != 0.0) {
            d2 *= 10.0;
            ++count;
        }
        return count;
    }

    public static class Builder {
        private transient NumberFormat numberFormat;
        private transient UnitFormat unitFormat;
        private transient Unit primaryUnit;
        private transient String delimiter = " ";
        private transient String mixedRadixDelimiter;
        private boolean localeSensitive;

        public Builder setNumberFormat(NumberFormat numberFormat) {
            if (numberFormat == null) {
                throw new NullPointerException();
            }
            this.numberFormat = numberFormat;
            return this;
        }

        public Builder setUnitFormat(UnitFormat unitFormat) {
            if (unitFormat == null) {
                throw new NullPointerException();
            }
            this.unitFormat = unitFormat;
            return this;
        }

        public Builder setPrimaryUnit(Unit primary) {
            if (this.unitFormat == null) {
                throw new NullPointerException();
            }
            this.primaryUnit = primary;
            return this;
        }

        public Builder setDelimiter(String delimiter) {
            if (delimiter == null) {
                throw new NullPointerException();
            }
            this.delimiter = delimiter;
            return this;
        }

        public Builder setRadixPartsDelimiter(String radixPartsDelimiter) {
            if (radixPartsDelimiter == null) {
                throw new NullPointerException();
            }
            this.mixedRadixDelimiter = radixPartsDelimiter;
            return this;
        }

        public Builder setLocaleSensitive(boolean localeSensitive) {
            this.localeSensitive = localeSensitive;
            return this;
        }

        public NumberDelimiterQuantityFormat build() {
            NumberDelimiterQuantityFormat quantityFormat = new NumberDelimiterQuantityFormat();
            quantityFormat.numberFormat = this.numberFormat;
            quantityFormat.unitFormat = this.unitFormat;
            quantityFormat.primaryUnit = this.primaryUnit;
            quantityFormat.delimiter = this.delimiter;
            quantityFormat.mixDelimiter = this.mixedRadixDelimiter;
            quantityFormat.localeSensitive = this.localeSensitive;
            return quantityFormat;
        }
    }
}

