/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.graphOperations.connectivity;

import java.util.BitSet;
import java.util.Iterator;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;

public class StrongConnectivityFinder {
    private final DirectedGraph graph;
    private final BitSet restriction;
    private final int n;
    private final int[] sccFirstNode;
    private final int[] nextNode;
    private final int[] nodeSCC;
    private int nbSCC;
    private final int[] stack;
    private final int[] p;
    private final int[] inf;
    private final int[] nodeOfDfsNum;
    private final int[] dfsNumOfNode;
    private final Iterator<Integer>[] iterator;
    private final BitSet inStack;

    public StrongConnectivityFinder(DirectedGraph graph) {
        this.graph = graph;
        this.n = graph.getNbMaxNodes();
        this.stack = new int[this.n];
        this.p = new int[this.n];
        this.inf = new int[this.n];
        this.nodeOfDfsNum = new int[this.n];
        this.dfsNumOfNode = new int[this.n];
        this.inStack = new BitSet(this.n);
        this.restriction = new BitSet(this.n);
        this.sccFirstNode = new int[this.n];
        this.nextNode = new int[this.n];
        this.nodeSCC = new int[this.n];
        this.nbSCC = 0;
        this.iterator = new Iterator[this.n];
    }

    public void findAllSCC() {
        ISet nodes = this.graph.getNodes();
        for (int i = 0; i < this.n; ++i) {
            this.restriction.set(i, nodes.contains(i));
        }
        this.findAllSCCOf(this.restriction);
    }

    public void findAllSCC(BitSet exception) {
        ISet nodes = this.graph.getNodes();
        int i = exception.nextClearBit(0);
        while (i >= 0 && i < this.n) {
            this.restriction.set(i, nodes.contains(i));
            i = exception.nextClearBit(i + 1);
        }
        this.findAllSCCOf(this.restriction);
    }

    public void findAllSCCOf(BitSet restriction) {
        this.inStack.clear();
        for (int i = 0; i < this.n; ++i) {
            this.dfsNumOfNode[i] = 0;
            this.inf[i] = this.n + 2;
            this.nextNode[i] = -1;
            this.sccFirstNode[i] = -1;
            this.nodeSCC[i] = -1;
        }
        this.nbSCC = 0;
        this.findSingletons(restriction);
        int first = restriction.nextSetBit(0);
        while (first >= 0) {
            this.findSCC(first, restriction, this.stack, this.p, this.inf, this.nodeOfDfsNum, this.dfsNumOfNode, this.inStack);
            first = restriction.nextSetBit(first);
        }
    }

    private void findSingletons(BitSet restriction) {
        ISet nodes = this.graph.getNodes();
        int i = restriction.nextSetBit(0);
        while (i >= 0) {
            if (nodes.contains(i) && this.graph.getPredecessorsOf(i).size() * this.graph.getSuccessorsOf(i).size() == 0) {
                this.nodeSCC[i] = this.nbSCC;
                this.sccFirstNode[this.nbSCC++] = i;
                restriction.clear(i);
            }
            i = restriction.nextSetBit(i + 1);
        }
    }

    private void findSCC(int start, BitSet restriction, int[] stack, int[] p, int[] inf, int[] nodeOfDfsNum, int[] dfsNumOfNode, BitSet inStack) {
        int y;
        int k;
        int nb = restriction.cardinality();
        if (nb == 1) {
            this.nodeSCC[start] = this.nbSCC;
            this.sccFirstNode[this.nbSCC++] = start;
            restriction.clear(start);
            return;
        }
        int stackIdx = 0;
        int i = k = 0;
        dfsNumOfNode[start] = k;
        nodeOfDfsNum[k] = start;
        stack[stackIdx++] = i;
        inStack.set(i);
        p[k] = k;
        this.iterator[k] = this.graph.getSuccessorsOf(start).iterator();
        while (true) {
            if (this.iterator[i].hasNext()) {
                int j = this.iterator[i].next();
                if (!restriction.get(j)) continue;
                if (dfsNumOfNode[j] == 0 && j != start) {
                    nodeOfDfsNum[++k] = j;
                    dfsNumOfNode[j] = k;
                    p[k] = i;
                    i = k;
                    this.iterator[i] = this.graph.getSuccessorsOf(j).iterator();
                    stack[stackIdx++] = i;
                    inStack.set(i);
                    inf[i] = i;
                    continue;
                }
                if (!inStack.get(dfsNumOfNode[j])) continue;
                inf[i] = Math.min(inf[i], dfsNumOfNode[j]);
                continue;
            }
            if (i == 0) break;
            if (inf[i] >= i) {
                int z;
                do {
                    z = stack[--stackIdx];
                    inStack.clear(z);
                    y = nodeOfDfsNum[z];
                    restriction.clear(y);
                    this.sccAdd(y);
                } while (z != i);
                ++this.nbSCC;
            }
            inf[p[i]] = Math.min(inf[p[i]], inf[i]);
            i = p[i];
        }
        if (inStack.cardinality() > 0) {
            do {
                y = nodeOfDfsNum[stack[--stackIdx]];
                restriction.clear(y);
                this.sccAdd(y);
            } while (y != start);
            ++this.nbSCC;
        }
    }

    private void sccAdd(int y) {
        this.nodeSCC[y] = this.nbSCC;
        this.nextNode[y] = this.sccFirstNode[this.nbSCC];
        this.sccFirstNode[this.nbSCC] = y;
    }

    public int getNbSCC() {
        return this.nbSCC;
    }

    public int[] getNodesSCC() {
        return this.nodeSCC;
    }

    public int getSCCFirstNode(int i) {
        return this.sccFirstNode[i];
    }

    public int getNextNode(int j) {
        return this.nextNode[j];
    }
}

