/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.objective;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.objective.AbstractIntObjManager;
import org.chocosolver.solver.objective.AbstractRealObjManager;
import org.chocosolver.solver.objective.IObjectiveManager;
import org.chocosolver.solver.objective.MaxIntObjManager;
import org.chocosolver.solver.objective.MaxRealObjManager;
import org.chocosolver.solver.objective.MinIntObjManager;
import org.chocosolver.solver.objective.MinRealObjManager;
import org.chocosolver.solver.objective.SATManager;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.Variable;

public final class ObjectiveFactory {
    private ObjectiveFactory() {
    }

    public static IObjectiveManager<Variable> SAT() {
        return SATManager.getInstance();
    }

    public static IObjectiveManager<IntVar> makeObjectiveManager(IntVar objective, ResolutionPolicy policy) {
        AbstractIntObjManager objman;
        switch (policy) {
            case MINIMIZE: {
                objman = new MinIntObjManager(objective);
                break;
            }
            case MAXIMIZE: {
                objman = new MaxIntObjManager(objective);
                break;
            }
            default: {
                throw new IllegalArgumentException("cant build integer objective manager :" + (Object)((Object)policy));
            }
        }
        objman.setStrictDynamicCut();
        return objman;
    }

    public static IObjectiveManager<RealVar> makeObjectiveManager(RealVar objective, ResolutionPolicy policy, double precision) {
        AbstractRealObjManager objman;
        switch (policy) {
            case MINIMIZE: {
                objman = new MinRealObjManager(objective, precision);
                break;
            }
            case MAXIMIZE: {
                objman = new MaxRealObjManager(objective, precision);
                break;
            }
            default: {
                throw new IllegalArgumentException("cant build real objective manager :" + (Object)((Object)policy));
            }
        }
        objman.setStrictDynamicCut();
        return objman;
    }

    public static <V> V copy(V object) {
        try {
            Class<?> c = object.getClass();
            Constructor<?> ct = c.getConstructor(c);
            return (V)ct.newInstance(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return object;
        }
    }
}

