## ----min_run_example, echo=TRUE-----------------------------------------------
library(runner)
x <- c(1, -5, 1, -3, NA, NA, NA, 1, -1, NA, -2, 3)

data.frame(
  x,
  default = min_run(x, na_rm = TRUE), 
  k_5     = min_run(x, k = 5, na_rm = TRUE),
  narm_f  = min_run(x, na_rm = FALSE))

## ----idx_run_example, echo=TRUE-----------------------------------------------
x <- c(-0.5910, 0.0266, -1.5166, -1.3627, 1.1785, -0.9342, 1.3236, 0.6249)
idx <- as.Date(c("1970-01-03", "1970-01-06", "1970-01-09", "1970-01-12", 
                 "1970-01-13", "1970-01-16", "1970-01-17", "1970-01-19"))

sum_run(x, k = 5, idx = idx)

## ----lag_run_example, echo=TRUE-----------------------------------------------
x <- c(-0.5910, 0.0266, -1.5166, -1.3627, 1.1785, -0.9342, 1.3236, 0.6249)
idx <- as.Date(c("1970-01-03", "1970-01-06", "1970-01-09", "1970-01-12", 
                 "1970-01-13", "1970-01-16", "1970-01-17", "1970-01-19"))

sum_run(x, k = 5, lag = 2, idx = idx)

## -----------------------------------------------------------------------------
x <- c("A", "B", "A", "A", "B", "B", "B", NA, "B", "B", "A", "B")
data.frame(
  x, 
  s0 = streak_run(x),
  s1 = streak_run(x, k = 4, na_rm = FALSE),
  s2 = streak_run(x, k = 4))

## -----------------------------------------------------------------------------
x <- c("W", "W", "L", "L", "L", "W", "L", "L")
idx <- as.Date(c("2019-01-03", "2019-01-06", "2019-01-09", "2019-01-12", 
                 "2019-01-13", "2019-01-16", "2019-01-17", "2019-01-19"))

data.frame(
  idx,
  x,
  streak_5d     = streak_run(x, k = 5, idx = idx),
  streak_5d_lag = streak_run(x, k = 5, lag = 1, idx = idx))

## -----------------------------------------------------------------------------
x <- c(-0.5910, 0.0266, -1.5166, -1.3627, 1.1785, -0.9342, 1.3236, 0.6249)
idx <- as.Date(c("1970-01-03", "1970-01-06", "1970-01-09", "1970-01-12", 
                 "1970-01-13", "1970-01-16", "1970-01-17", "1970-01-19"))

lag_run(x, lag = 3, idx = idx)

## -----------------------------------------------------------------------------
x <- c(NA, NA, "b", "b", "a", NA, NA, "a", "b", NA, "a", "b")
data.frame(x, 
           f1 = fill_run(x), 
           f2 = fill_run(x,run_for_first = TRUE), 
           f3 = fill_run(x, only_within = TRUE))

## -----------------------------------------------------------------------------
x <- c(T, T, T, F, NA, T, F, NA, T, F, T, F)
data.frame(
  x, 
  s0 = which_run(x, which = "first"),
  s1 = which_run(x, na_rm = FALSE, k = 5, which = "first"),
  s2 = which_run(x, k = 5, which = "last"))


