/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent.structure;

import dr.evolution.coalescent.IntervalType;
import dr.evolution.coalescent.structure.Event;
import dr.evolution.coalescent.structure.StructuredIntervalList;
import dr.evolution.colouring.BranchColouring;
import dr.evolution.colouring.TreeColouring;
import dr.evolution.tree.ColourChange;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Units;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ColouredTreeIntervals
implements StructuredIntervalList {
    int intervalCount;
    int sampleCount;
    List<Event> eventList = new ArrayList<Event>();
    int colourStateCount;
    int[][] lineageCount;
    Units.Type units;

    public ColouredTreeIntervals(Tree tree, TreeColouring treeColouring) {
        Object object;
        int n;
        this.colourStateCount = treeColouring.getColourCount();
        this.units = tree.getUnits();
        this.extractCoalescentEvents(tree, treeColouring, this.eventList);
        this.sampleCount = this.extractSampleEvents(tree, treeColouring, this.eventList);
        this.extractMigrationEvents(tree, treeColouring, this.eventList);
        Collections.sort(this.eventList);
        this.lineageCount = new int[this.eventList.size() + 1][this.colourStateCount];
        int n2 = tree.getExternalNodeCount();
        for (n = 0; n < n2; ++n) {
            object = tree.getExternalNode(n);
            double d = tree.getNodeHeight((NodeRef)object);
            int n3 = treeColouring.getNodeColour((NodeRef)object);
            if (d != 0.0) continue;
            int[] nArray = this.lineageCount[0];
            int n4 = n3;
            nArray[n4] = nArray[n4] + 1;
        }
        for (n = 0; n < this.eventList.size(); ++n) {
            object = this.eventList.get(n);
            for (int i = 0; i < this.colourStateCount; ++i) {
                this.lineageCount[n + 1][i] = this.lineageCount[n][i] + ((Event)object).lineageChanges[i];
                if (this.lineageCount[n + 1][i] >= 0) continue;
                throw new RuntimeException("lineageCount[" + (n + 1) + "][" + i + "] = " + this.lineageCount[n + 1][i] + ". This is wrong!");
            }
        }
        this.intervalCount = this.eventList.size();
    }

    @Override
    public int getPopulationCount() {
        return this.lineageCount[0].length;
    }

    @Override
    public int getIntervalCount() {
        return this.intervalCount;
    }

    @Override
    public double getStartTime() {
        return 0.0;
    }

    @Override
    public int getSampleCount() {
        return this.sampleCount;
    }

    @Override
    public double getInterval(int n) {
        if (n == 0) {
            return this.getEvent((int)n).time;
        }
        return this.getEvent((int)n).time - this.getEvent((int)(n - 1)).time;
    }

    @Override
    public double getIntervalTime(int n) {
        if (n == 0) {
            return this.getEvent((int)n).time;
        }
        return this.getEvent((int)(n - 1)).time;
    }

    @Override
    public void calculateIntervals() {
    }

    @Override
    public int getLineageCount(int n, int n2) {
        return this.lineageCount[n][n2];
    }

    @Override
    public int getLineageCount(int n) {
        int n2 = 0;
        for (int i = 0; i < this.colourStateCount; ++i) {
            n2 += this.lineageCount[n][i];
        }
        return n2;
    }

    @Override
    public int getCoalescentEvents(int n) {
        if (this.getEvent(n).getType() == IntervalType.COALESCENT) {
            return 1;
        }
        return 0;
    }

    @Override
    public IntervalType getIntervalType(int n) {
        return this.getEvent(n).getType();
    }

    @Override
    public double getTotalDuration() {
        return this.getEvent((int)this.getIntervalCount()).time;
    }

    @Override
    public boolean isBinaryCoalescent() {
        return true;
    }

    @Override
    public boolean isCoalescentOnly() {
        return false;
    }

    @Override
    public Units.Type getUnits() {
        return this.units;
    }

    @Override
    public void setUnits(Units.Type type) {
        this.units = type;
    }

    private void extractCoalescentEvents(Tree tree, TreeColouring treeColouring, List<Event> list) {
        int n = tree.getInternalNodeCount();
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef = tree.getInternalNode(i);
            double d = tree.getNodeHeight(nodeRef);
            int n2 = treeColouring.getNodeColour(nodeRef);
            list.add(Event.createCoalescentEvent(d, n2, treeColouring.getColourCount()));
        }
    }

    private int extractSampleEvents(Tree tree, TreeColouring treeColouring, List<Event> list) {
        int n = tree.getExternalNodeCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef = tree.getExternalNode(i);
            double d = tree.getNodeHeight(nodeRef);
            int n3 = treeColouring.getNodeColour(nodeRef);
            if (d == 0.0) continue;
            list.add(Event.createAddSampleEvent(d, n3, treeColouring.getColourCount()));
            ++n2;
        }
        return n2;
    }

    private void extractMigrationEvents(Tree tree, TreeColouring treeColouring, List<Event> list) {
        int n = tree.getNodeCount();
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef = tree.getNode(i);
            if (tree.isRoot(nodeRef)) continue;
            BranchColouring branchColouring = treeColouring.getBranchColouring(nodeRef);
            List<ColourChange> list2 = branchColouring.getColourChanges();
            int n2 = treeColouring.getNodeColour(nodeRef);
            for (ColourChange colourChange : list2) {
                double d = colourChange.getTime();
                int n3 = colourChange.getColourAbove();
                list.add(Event.createMigrationEvent(d, n2, n3, treeColouring.getColourCount()));
                n2 = n3;
            }
        }
    }

    @Override
    public final Event getEvent(int n) {
        return this.eventList.get(n);
    }
}

