/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.Arrays;
import java.util.List;

public class AntigenicDriftPrior
extends AbstractModelLikelihood
implements Citable {
    public static final String ANTIGENIC_DRIFT_PRIOR = "antigenicDriftPrior";
    private final int dimension;
    private final int count;
    private final Parameter offsetsParameter;
    private final MatrixParameter locationsParameter;
    private final Parameter regressionSlopeParameter;
    private final Parameter regressionPrecisionParameter;
    private double logLikelihood = 0.0;
    private double storedLogLikelihood = 0.0;
    private boolean likelihoodKnown = false;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String LOCATIONS = "locations";
        public static final String OFFSETS = "offsets";
        public static final String REGRESSION_SLOPE = "regressionSlope";
        public static final String REGRESSION_PRECISION = "regressionPrecision";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("locations", MatrixParameter.class), new ElementRule("offsets", Parameter.class), new ElementRule("regressionSlope", Parameter.class), new ElementRule("regressionPrecision", Parameter.class)};

        @Override
        public String getParserName() {
            return AntigenicDriftPrior.ANTIGENIC_DRIFT_PRIOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild(LOCATIONS);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(OFFSETS);
            Parameter parameter2 = (Parameter)xMLObject.getElementFirstChild(REGRESSION_SLOPE);
            Parameter parameter3 = (Parameter)xMLObject.getElementFirstChild(REGRESSION_PRECISION);
            AntigenicDriftPrior antigenicDriftPrior = new AntigenicDriftPrior(matrixParameter, parameter, parameter2, parameter3);
            return antigenicDriftPrior;
        }

        @Override
        public String getParserDescription() {
            return "Provides the likelihood of a vector of coordinates in some multidimensional 'antigenic' space based on an expected relationship with time.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return AntigenicDriftPrior.class;
        }
    };

    public AntigenicDriftPrior(MatrixParameter matrixParameter, Parameter parameter, Parameter parameter2, Parameter parameter3) {
        super(ANTIGENIC_DRIFT_PRIOR);
        this.locationsParameter = matrixParameter;
        this.addVariable(this.locationsParameter);
        this.offsetsParameter = parameter;
        this.addVariable(this.offsetsParameter);
        this.dimension = matrixParameter.getParameter(0).getDimension();
        this.count = matrixParameter.getParameterCount();
        this.regressionSlopeParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, 1));
        this.regressionPrecisionParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, 1));
        this.likelihoodKnown = false;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.locationsParameter || variable == this.offsetsParameter || variable == this.regressionSlopeParameter || variable == this.regressionPrecisionParameter) {
            this.likelihoodKnown = false;
        }
    }

    @Override
    protected void storeState() {
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        this.logLikelihood = this.storedLogLikelihood;
        this.likelihoodKnown = false;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.computeLogLikelihood();
        }
        return this.logLikelihood;
    }

    private double computeLogLikelihood() {
        double d = this.regressionPrecisionParameter.getParameterValue(0);
        double d2 = 0.5 * Math.log(d) * (double)this.count - 0.5 * d * this.sumOfSquaredResiduals();
        this.likelihoodKnown = true;
        return d2;
    }

    protected double sumOfSquaredResiduals() {
        double d = 0.0;
        for (int i = 0; i < this.count; ++i) {
            Parameter parameter = this.locationsParameter.getParameter(i);
            double d2 = this.offsetsParameter.getParameterValue(i);
            double d3 = this.regressionSlopeParameter.getParameterValue(0);
            double d4 = parameter.getParameterValue(0);
            double d5 = d2 * d3;
            d += (d4 - d5) * (d4 - d5);
            for (int j = 1; j < this.dimension; ++j) {
                d4 = parameter.getParameterValue(j);
                d += d4 * d4;
            }
        }
        return d;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "Bayesian Antigenic Cartography framework";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(CommonCitations.BEDFORD_2015_INTEGRATING);
    }
}

