/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.ConstantPopulation;
import dr.evolution.coalescent.ExponentialBSPGrowth;
import dr.evolution.tree.Tree;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.OldAbstractCoalescentLikelihood;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.math.MathUtils;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@Deprecated
public class BayesianSkylineLikelihood
extends OldAbstractCoalescentLikelihood
implements Citable {
    public static final int STEPWISE_TYPE = 0;
    public static final int LINEAR_TYPE = 1;
    public static final int EXPONENTIAL_TYPE = 2;
    private final Parameter popSizeParameter;
    private final Parameter groupSizeParameter;
    private final int type;
    public static Citation CITATION = new Citation(new Author[]{new Author("AJ", "Drummond"), new Author("A", "Rambaut"), new Author("B", "Shapiro"), new Author("OG", "Pybus")}, "Bayesian coalescent inference of past population dynamics from molecular sequences", 2005, "Mol Biol Evol", 22, 1185, 1192);

    public BayesianSkylineLikelihood(Tree tree, Parameter parameter, Parameter parameter2, int n) {
        super("generalizedSkyLineLikelihood");
        this.addKeyword("skyline");
        this.groupSizeParameter = parameter2;
        this.popSizeParameter = parameter;
        int n2 = tree.getExternalNodeCount() - 1;
        int n3 = parameter.getDimension();
        int n4 = parameter2.getDimension();
        this.type = n;
        if (n == 2) {
            if (n3 != n4 + 1) {
                throw new IllegalArgumentException("Dimension of population parameter must be one greater than dimension of group size parameter.");
            }
        } else if (n == 1) {
            if (n3 != n4 + 1) {
                throw new IllegalArgumentException("Dimension of population parameter must be one greater than dimension of group size parameter.");
            }
        } else if (n3 != n4) {
            throw new IllegalArgumentException("Dimension of population parameter and group size parameters should be the same.");
        }
        if (n4 > n2) {
            throw new IllegalArgumentException("There are more groups than coalescent nodes in the tree.");
        }
        int n5 = 0;
        for (int i = 0; i < this.getGroupCount(); ++i) {
            n5 += this.getGroupSize(i);
        }
        if (n5 != n2) {
            if (n5 == 0 || n5 == n4) {
                double[] dArray = new double[n4];
                double[] dArray2 = new double[n4];
                int n6 = n2 / n4;
                int n7 = n2 % n4;
                for (int i = 0; i < n4; ++i) {
                    if (i < n7) {
                        parameter2.setParameterValue(i, n6 + 1);
                    } else {
                        parameter2.setParameterValue(i, n6);
                    }
                    dArray[i] = Double.MAX_VALUE;
                    dArray2[i] = 1.0;
                }
                if (n == 2 || n == 1) {
                    dArray2[0] = 2.0;
                }
                parameter2.addBounds(new Parameter.DefaultBounds(dArray, dArray2));
            } else {
                throw new IllegalArgumentException("The sum of the initial group sizes does not match the number of coalescent events in the tree.");
            }
        }
        if ((n == 2 || n == 1) && parameter2.getParameterValue(0) < 2.0) {
            throw new IllegalArgumentException("For linear or exponential model first group size must be >= 2.");
        }
        this.tree = tree;
        if (tree instanceof TreeModel) {
            this.addModel((TreeModel)tree);
        }
        this.addVariable(parameter);
        this.addVariable(parameter2);
        this.setupIntervals();
        this.addStatistic(new GroupHeightStatistic());
    }

    @Override
    public double getLogLikelihood() {
        this.setupIntervals();
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        int[] nArray = this.getGroupSizes();
        double[] dArray = this.getGroupHeights();
        int n2 = 0;
        if (this.type == 2) {
            ExponentialBSPGrowth exponentialBSPGrowth = new ExponentialBSPGrowth(Units.Type.YEARS);
            for (int i = 0; i < this.intervalCount; ++i) {
                double d3 = this.popSizeParameter.getParameterValue(n);
                double d4 = this.popSizeParameter.getParameterValue(n + 1);
                double d5 = d2;
                double d6 = d2 + this.intervals[i];
                exponentialBSPGrowth.setup(d3, d4, d6 - d5);
                if (this.getIntervalType(i) == OldAbstractCoalescentLikelihood.CoalescentEventType.COALESCENT && ++n2 >= nArray[n]) {
                    ++n;
                    n2 = 0;
                }
                d += BayesianSkylineLikelihood.calculateIntervalLikelihood(exponentialBSPGrowth, this.intervals[i], d2, this.lineageCounts[i], this.getIntervalType(i));
                int n3 = this.getCoalescentEvents(i) - 1;
                for (int j = 0; j < n3; ++j) {
                    exponentialBSPGrowth.setup(d3, d3, d6 - d5);
                    d += BayesianSkylineLikelihood.calculateIntervalLikelihood(exponentialBSPGrowth, 0.0, d2, this.lineageCounts[i] - j - 1, OldAbstractCoalescentLikelihood.CoalescentEventType.COALESCENT);
                    if (++n2 < nArray[n]) continue;
                    ++n;
                    n2 = 0;
                }
                d2 += this.intervals[i];
            }
        } else {
            ConstantPopulation constantPopulation = new ConstantPopulation(Units.Type.YEARS);
            for (int i = 0; i < this.intervalCount; ++i) {
                double d7 = this.getPopSize(n, d2 + this.intervals[i] / 2.0, dArray);
                constantPopulation.setN0(d7);
                if (this.getIntervalType(i) == OldAbstractCoalescentLikelihood.CoalescentEventType.COALESCENT && ++n2 >= nArray[n]) {
                    ++n;
                    n2 = 0;
                }
                d += BayesianSkylineLikelihood.calculateIntervalLikelihood(constantPopulation, this.intervals[i], d2, this.lineageCounts[i], this.getIntervalType(i));
                int n4 = this.getCoalescentEvents(i) - 1;
                for (int j = 0; j < n4; ++j) {
                    constantPopulation.setN0(this.getPopSize(n, d2, dArray));
                    d += BayesianSkylineLikelihood.calculateIntervalLikelihood(constantPopulation, 0.0, d2, this.lineageCounts[i] - j - 1, OldAbstractCoalescentLikelihood.CoalescentEventType.COALESCENT);
                    if (++n2 < nArray[n]) continue;
                    ++n;
                    n2 = 0;
                }
                d2 += this.intervals[i];
            }
        }
        return d;
    }

    public final double getPopSize(int n, double d, double[] dArray) {
        if (this.type == 1) {
            double d2 = this.popSizeParameter.getParameterValue(n);
            double d3 = this.popSizeParameter.getParameterValue(n + 1);
            double d4 = 0.0;
            if (n > 0) {
                d4 = dArray[n - 1];
            }
            double d5 = dArray[n];
            double d6 = (d3 - d2) / (d5 - d4);
            double d7 = d6 * (d - d4) + d2;
            return d7;
        }
        return this.popSizeParameter.getParameterValue(n);
    }

    public final int[] getGroupSizes() {
        if ((this.type == 2 || this.type == 1) && this.groupSizeParameter.getParameterValue(0) < 2.0) {
            throw new IllegalArgumentException("For linear model first group size must be >= 2.");
        }
        int[] nArray = new int[this.groupSizeParameter.getDimension()];
        for (int i = 0; i < nArray.length; ++i) {
            double d = this.groupSizeParameter.getParameterValue(i);
            if (d != (double)Math.round(d)) {
                throw new RuntimeException("Group size " + i + " should be integer but found:" + d);
            }
            nArray[i] = (int)Math.round(d);
        }
        return nArray;
    }

    private int getGroupCount() {
        return this.groupSizeParameter.getDimension();
    }

    private int getGroupSize(int n) {
        double d = this.groupSizeParameter.getParameterValue(n);
        if (d != (double)Math.round(d)) {
            throw new RuntimeException("Group size " + n + " should be integer but found:" + d);
        }
        return (int)Math.round(d);
    }

    public final double[] getGroupHeights() {
        double[] dArray = new double[this.getGroupCount()];
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.intervalCount; ++i) {
            d += this.intervals[i];
            if (this.getIntervalType(i) != OldAbstractCoalescentLikelihood.CoalescentEventType.COALESCENT || ++n2 < this.getGroupSize(n)) continue;
            dArray[n] = d;
            ++n;
            n2 = 0;
        }
        dArray[this.getGroupCount() - 1] = d;
        return dArray;
    }

    private double getGroupHeight(int n) {
        return this.getGroupHeights()[n];
    }

    public final int getType() {
        return this.type;
    }

    public final Parameter getPopSizeParameter() {
        return this.popSizeParameter;
    }

    public final Parameter getGroupSizeParameter() {
        return this.groupSizeParameter;
    }

    public String getTitle() {
        String string = "Bayesian Skyline (" + (this.type == 0 ? "stepwise" : "linear") + ")\nGenerated " + new Date().toString() + " [seed=" + MathUtils.getSeed() + "]";
        return string;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Bayesian Skyline Coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }

    public class GroupHeightStatistic
    extends Statistic.Abstract {
        public GroupHeightStatistic() {
            super("groupHeight");
        }

        @Override
        public int getDimension() {
            return BayesianSkylineLikelihood.this.getGroupCount();
        }

        @Override
        public double getStatisticValue(int n) {
            return BayesianSkylineLikelihood.this.getGroupHeight(n);
        }
    }
}

