/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.math.matrixAlgebra.missingData.MissingOps;
import org.ejml.data.DenseMatrix64F;

public class NormalSufficientStatistics {
    private final DenseMatrix64F mean;
    private final DenseMatrix64F precision;
    private DenseMatrix64F variance = null;

    NormalSufficientStatistics(double[] dArray, int n, int n2, DenseMatrix64F denseMatrix64F, PrecisionType precisionType) {
        int n3 = (n2 + precisionType.getMatrixLength(n2)) * n;
        this.mean = MissingOps.wrap(dArray, n3, n2, 1);
        this.precision = DenseMatrix64F.wrap(n2, n2, precisionType.getScaledPrecision(dArray, n3, denseMatrix64F.data, n2));
    }

    NormalSufficientStatistics(double[] dArray, double[] dArray2, int n, int n2, DenseMatrix64F denseMatrix64F, PrecisionType precisionType) {
        int n3 = n2 * n;
        this.mean = MissingOps.wrap(dArray, n3, n2, 1);
        int n4 = n2 * n2 * n;
        this.precision = MissingOps.wrap(dArray2, n4, n2, n2);
    }

    public NormalSufficientStatistics(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        this.mean = denseMatrix64F;
        this.precision = denseMatrix64F2;
    }

    public NormalSufficientStatistics(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3) {
        this.mean = denseMatrix64F;
        this.precision = denseMatrix64F2;
        this.variance = denseMatrix64F3;
    }

    public double getMean(int n) {
        return this.mean.get(n);
    }

    public double getPrecision(int n, int n2) {
        return this.precision.unsafe_get(n, n2);
    }

    public double getVariance(int n, int n2) {
        this.computeVariance();
        return this.variance.unsafe_get(n, n2);
    }

    @Deprecated
    public DenseMatrix64F getRawPrecision() {
        return this.precision;
    }

    @Deprecated
    public DenseMatrix64F getRawMean() {
        return this.mean;
    }

    @Deprecated
    public DenseMatrix64F getRawVariance() {
        this.computeVariance();
        return this.variance;
    }

    public DenseMatrix64F getRawPrecisionCopy() {
        return this.precision.copy();
    }

    public DenseMatrix64F getRawMeanCopy() {
        return this.mean.copy();
    }

    public DenseMatrix64F getRawVarianceCopy() {
        this.computeVariance();
        return this.variance.copy();
    }

    private void computeVariance() {
        if (this.variance == null) {
            this.variance = new DenseMatrix64F(this.precision.numRows, this.precision.numCols);
            MissingOps.safeInvert2(this.precision, this.variance, false);
        }
    }

    public String toString() {
        return this.mean + " " + this.precision;
    }

    String toVectorizedString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(NormalSufficientStatistics.toVectorizedString(this.mean.getData())).append(" ").append(NormalSufficientStatistics.toVectorizedString(this.precision.getData()));
        if (this.variance != null) {
            stringBuilder.append(" ").append(NormalSufficientStatistics.toVectorizedString(this.variance.getData()));
        }
        return stringBuilder.toString();
    }

    public static String toVectorizedString(DenseMatrix64F denseMatrix64F) {
        return NormalSufficientStatistics.toVectorizedString(denseMatrix64F.getData());
    }

    private static String toVectorizedString(double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < dArray.length - 1; ++i) {
            stringBuilder.append(dArray[i]).append(" ");
        }
        stringBuilder.append(dArray[dArray.length - 1]);
        return stringBuilder.toString();
    }
}

