/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.OperatorUtils;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;

public class RandomWalkIntegerOperator
extends SimpleMCMCOperator {
    double logq;
    protected Variable parameter = null;
    protected int windowSize = 1;

    public RandomWalkIntegerOperator(Variable variable, int n, double d) {
        this.parameter = variable;
        this.windowSize = n;
        this.setWeight(d);
    }

    public Parameter getParameter() {
        return (Parameter)this.parameter;
    }

    public final int getWindowSize() {
        return this.windowSize;
    }

    @Override
    public double doOperation() {
        this.logq = 0.0;
        int n = MathUtils.nextInt(this.parameter.getSize());
        if (this.parameter instanceof Parameter) {
            int n2 = this.calculateNewValue(n);
            ((Parameter)this.parameter).setParameterValue(n, n2);
        } else if (this.parameter instanceof Variable) {
            int n3 = this.calculateNewValue(n);
            this.parameter.setValue(n, n3);
        }
        return this.logq;
    }

    protected int calculateNewValue(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.parameter instanceof Parameter) {
            n8 = (int)((Parameter)this.parameter).getParameterValue(n);
            n7 = (int)((Parameter)this.parameter).getBounds().getUpperLimit(n).doubleValue();
            n6 = (int)((Parameter)this.parameter).getBounds().getLowerLimit(n).doubleValue();
        } else if (this.parameter instanceof Variable) {
            n8 = (Integer)this.parameter.getValue(n);
            n7 = (Integer)this.parameter.getBounds().getUpperLimit(n);
            n6 = (Integer)this.parameter.getBounds().getLowerLimit(n);
        } else {
            throw new RuntimeException("The parameter (" + this.parameter.getId() + ") uses invalid class!");
        }
        if (n7 == n6) {
            return n7;
        }
        int n9 = n7 - n6;
        if (this.windowSize > n9) {
            this.windowSize = n9;
            System.err.println("The maximum window size should be smaller than the total number of possible integer values.");
        }
        if ((n5 = MathUtils.nextInt(2 * this.windowSize)) >= this.windowSize) {
            n4 = 1 + (n5 - this.windowSize);
            n3 = n8 + n4;
            if (n3 > n7) {
                n3 = 2 * n7 - n3;
            }
        } else {
            n3 = n8 - 1 - n5;
            if (n3 < n6) {
                n3 = 2 * n6 - n3;
            }
        }
        n4 = 0;
        int n10 = 0;
        if (n3 != n8) {
            ++n10;
            ++n4;
        }
        if ((n2 = n8 + this.windowSize) > n7 && 2 * n7 - n2 <= n3 && n3 != n7) {
            ++n10;
        }
        if ((n2 = n8 - this.windowSize) < n6 && 2 * n6 - n2 >= n3 && n3 != n6) {
            ++n10;
        }
        if ((n2 = n3 + this.windowSize) > n7 && 2 * n7 - n2 <= n8 && n8 != n7) {
            ++n4;
        }
        if ((n2 = n3 - this.windowSize) < n6 && 2 * n6 - n2 >= n8 && n8 != n6) {
            ++n4;
        }
        this.logq = Math.log(n4) - Math.log(n10);
        return n3;
    }

    @Override
    public String getOperatorName() {
        return "randomWalkInteger(" + this.parameter.getId() + ")";
    }

    public double getTargetAcceptanceProbability() {
        return 0.234;
    }

    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    public final String getPerformanceSuggestion() {
        double d = this.getAcceptanceProbability();
        double d2 = this.getTargetAcceptanceProbability();
        double d3 = 0.0;
        if (this.parameter instanceof Parameter) {
            d3 = ((Parameter)this.parameter).getParameterValue(0) * 2.0;
        } else if (this.parameter instanceof Variable) {
            d3 = (double)((Integer)this.parameter.getValue(0)).intValue() * 2.0;
        }
        long l = Math.round(OperatorUtils.optimizeWindowSize(this.windowSize, d3 * 2.0, d, d2));
        if (d < this.getMinimumGoodAcceptanceLevel()) {
            if (l <= 1L) {
                return "";
            }
            return "Try decreasing windowSize to about " + l;
        }
        if (d > this.getMaximumGoodAcceptanceLevel()) {
            return "Try increasing windowSize to about " + l;
        }
        return "";
    }

    public String toString() {
        return "randomWalkIntegerOperator(" + this.parameter.getId() + ", " + this.windowSize + ", " + this.getWeight() + ")";
    }
}

