/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value.aggregatefn;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.temptable.IRowView;
import com.amazon.sqlengine.executor.etree.temptable.TemporaryFile;
import com.amazon.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.amazon.sqlengine.executor.etree.value.aggregatefn.IAggregator;
import com.amazon.support.exceptions.ErrorException;

public class RowViewUpdateParameters
implements IAggregator.IUpdateParameters {
    private IRowView m_rowView;
    private TemporaryFile m_longDataStore = null;
    private IColumn[] m_columnMeta;
    private boolean[] m_isLongData;
    private boolean[] m_hasMoreData;
    private ETDataRequest[] m_dataRequests;

    public RowViewUpdateParameters(IRowView iRowView, IColumn[] iColumnArray, boolean[] blArray) {
        this.m_rowView = iRowView;
        this.m_columnMeta = iColumnArray;
        this.m_isLongData = blArray;
        int n = iColumnArray.length;
        if (0 < n) {
            this.m_hasMoreData = new boolean[n];
            this.m_dataRequests = new ETDataRequest[n];
        }
    }

    @Override
    public ISqlDataWrapper getData(int n) throws ErrorException {
        return this.getData(n, 0L, -1L);
    }

    @Override
    public ISqlDataWrapper getData(int n, long l, long l2) throws ErrorException {
        ETDataRequest eTDataRequest = this.m_dataRequests[n];
        if (null == eTDataRequest) {
            this.m_dataRequests[n] = eTDataRequest = new ETDataRequest(l, l2, this.m_columnMeta[n]);
        } else {
            eTDataRequest.setMaxBytes(l2);
            eTDataRequest.setOffset(l);
        }
        this.m_hasMoreData[n] = DataRetrievalUtil.retrieveFromRowView(n, this.m_isLongData[n], eTDataRequest, this.m_rowView, this.m_longDataStore);
        return eTDataRequest.getData();
    }

    @Override
    public IColumn getMetadata(int n) {
        return this.m_columnMeta[n];
    }

    @Override
    public boolean hasMoreData(int n) {
        return this.m_hasMoreData[n];
    }
}

