/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;
import cern.colt.matrix.tint.impl.WrapperIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntMult;
import cern.jet.math.tint.IntPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DiagonalIntMatrix2D
extends WrapperIntMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] elements;
    protected int dlength;
    protected int dindex;

    public DiagonalIntMatrix2D(int[][] nArray, int n) {
        this(nArray.length, nArray.length == 0 ? 0 : nArray[0].length, n);
        this.assign(nArray);
    }

    public DiagonalIntMatrix2D(int n, int n2, int n3) {
        int n4;
        int n5;
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        if (n3 < -n + 1 || n3 > n2 - 1) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        this.dindex = n3;
        this.dlength = n3 == 0 ? Math.min(n, n2) : (n3 > 0 ? (n >= n2 ? n2 - n3 : (n3 <= (n5 = n2 - n) ? n : n - (n3 - n5))) : (n >= n2 ? (-n3 <= (n4 = n - n2) ? n2 : n2 + n3 + n4) : n + n3));
        this.elements = new int[this.dlength];
    }

    public IntMatrix2D assign(IntFunction intFunction) {
        if (intFunction instanceof IntMult) {
            int n = ((IntMult)intFunction).multiplicator;
            if (n == 1) {
                return this;
            }
            if (n == 0) {
                return this.assign(0);
            }
            if (n != n) {
                return this.assign(n);
            }
            int n2 = this.dlength;
            while (--n2 >= 0) {
                int n3 = n2;
                this.elements[n3] = this.elements[n3] * n;
            }
        } else {
            int n = this.dlength;
            while (--n >= 0) {
                this.elements[n] = intFunction.apply(this.elements[n]);
            }
        }
        return this;
    }

    public IntMatrix2D assign(int n) {
        int n2 = this.dlength;
        while (--n2 >= 0) {
            this.elements[n2] = n;
        }
        return this;
    }

    public IntMatrix2D assign(final int[] nArray) {
        if (nArray.length != this.dlength) {
            throw new IllegalArgumentException("Must have same length: length=" + nArray.length + " dlength=" + this.dlength);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.dlength);
            Future[] futureArray = new Future[n];
            int n2 = this.dlength / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.dlength : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DiagonalIntMatrix2D.this.elements[i] = nArray[i];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.dlength;
            while (--n5 >= 0) {
                this.elements[n5] = nArray[n5];
            }
        }
        return this;
    }

    public IntMatrix2D assign(int[][] nArray) {
        int n;
        int n2;
        if (nArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + nArray.length + "rows()=" + this.rows());
        }
        if (this.dindex >= 0) {
            n2 = 0;
            n = this.dindex;
        } else {
            n2 = -this.dindex;
            n = 0;
        }
        for (int i = 0; i < this.dlength; ++i) {
            if (nArray[i].length != this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + nArray[n2].length + "columns()=" + this.columns());
            }
            this.elements[i] = nArray[n2++][n++];
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D) {
        if (intMatrix2D == this) {
            return this;
        }
        this.checkShape(intMatrix2D);
        if (intMatrix2D instanceof DiagonalIntMatrix2D) {
            DiagonalIntMatrix2D diagonalIntMatrix2D = (DiagonalIntMatrix2D)intMatrix2D;
            if (this.dindex != diagonalIntMatrix2D.dindex || this.dlength != diagonalIntMatrix2D.dlength) {
                throw new IllegalArgumentException("source is DiagonalIntMatrix2D with different diagonal stored.");
            }
            System.arraycopy(diagonalIntMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(intMatrix2D);
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D, final IntIntFunction intIntFunction) {
        this.checkShape(intMatrix2D);
        if (intMatrix2D instanceof DiagonalIntMatrix2D) {
            int n;
            DiagonalIntMatrix2D diagonalIntMatrix2D = (DiagonalIntMatrix2D)intMatrix2D;
            if (this.dindex != diagonalIntMatrix2D.dindex || this.dlength != diagonalIntMatrix2D.dlength) {
                throw new IllegalArgumentException("y is DiagonalIntMatrix2D with different diagonal stored.");
            }
            if (intIntFunction instanceof IntPlusMultSecond && (n = ((IntPlusMultSecond)intIntFunction).multiplicator) == 0) {
                return this;
            }
            final int[] nArray = diagonalIntMatrix2D.elements;
            int n2 = ConcurrencyUtils.getNumberOfThreads();
            if (n2 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n2 = Math.min(n2, this.dlength);
                Future[] futureArray = new Future[n2];
                int n3 = this.dlength / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n2 - 1 ? this.dlength : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (intIntFunction instanceof IntPlusMultSecond) {
                                int n = ((IntPlusMultSecond)intIntFunction).multiplicator;
                                if (n == 1) {
                                    for (int i = n4; i < n5; ++i) {
                                        int n2 = i;
                                        DiagonalIntMatrix2D.this.elements[n2] = DiagonalIntMatrix2D.this.elements[n2] + nArray[i];
                                    }
                                } else {
                                    for (int i = n4; i < n5; ++i) {
                                        DiagonalIntMatrix2D.this.elements[i] = DiagonalIntMatrix2D.this.elements[i] + n * nArray[i];
                                    }
                                }
                            } else if (intIntFunction == IntFunctions.mult) {
                                for (int i = n4; i < n5; ++i) {
                                    DiagonalIntMatrix2D.this.elements[i] = DiagonalIntMatrix2D.this.elements[i] * nArray[i];
                                }
                            } else if (intIntFunction == IntFunctions.div) {
                                for (int i = n4; i < n5; ++i) {
                                    DiagonalIntMatrix2D.this.elements[i] = DiagonalIntMatrix2D.this.elements[i] / nArray[i];
                                }
                            } else {
                                for (int i = n4; i < n5; ++i) {
                                    DiagonalIntMatrix2D.this.elements[i] = intIntFunction.apply(DiagonalIntMatrix2D.this.elements[i], nArray[i]);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else if (intIntFunction instanceof IntPlusMultSecond) {
                int n6 = ((IntPlusMultSecond)intIntFunction).multiplicator;
                if (n6 == 1) {
                    int n7 = this.dlength;
                    while (--n7 >= 0) {
                        int n8 = n7;
                        this.elements[n8] = this.elements[n8] + nArray[n7];
                    }
                } else {
                    int n9 = this.dlength;
                    while (--n9 >= 0) {
                        this.elements[n9] = this.elements[n9] + n6 * nArray[n9];
                    }
                }
            } else if (intIntFunction == IntFunctions.mult) {
                int n10 = this.dlength;
                while (--n10 >= 0) {
                    this.elements[n10] = this.elements[n10] * nArray[n10];
                }
            } else if (intIntFunction == IntFunctions.div) {
                int n11 = this.dlength;
                while (--n11 >= 0) {
                    this.elements[n11] = this.elements[n11] / nArray[n11];
                }
            } else {
                int n12 = this.dlength;
                while (--n12 >= 0) {
                    this.elements[n12] = intIntFunction.apply(this.elements[n12], nArray[n12]);
                }
            }
            return this;
        }
        return super.assign(intMatrix2D, intIntFunction);
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.dlength);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.dlength / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.dlength : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            if (DiagonalIntMatrix2D.this.elements[i] == 0) continue;
                            ++n;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                if (this.elements[i] == 0) continue;
                ++n;
            }
        }
        return n;
    }

    public int[] elements() {
        return this.elements;
    }

    public boolean equals(int n) {
        for (int i = 0; i < this.dlength; ++i) {
            int n2 = this.elements[i];
            int n3 = n - n2;
            if (n3 == 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof DiagonalIntMatrix2D) {
            DiagonalIntMatrix2D diagonalIntMatrix2D = (DiagonalIntMatrix2D)object;
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            int n = this.rows();
            int n2 = this.columns();
            if (n2 != diagonalIntMatrix2D.columns() || n != diagonalIntMatrix2D.rows()) {
                return false;
            }
            if (this.dindex != diagonalIntMatrix2D.dindex || this.dlength != diagonalIntMatrix2D.dlength) {
                return false;
            }
            int[] nArray = diagonalIntMatrix2D.elements;
            for (int i = 0; i < this.dlength; ++i) {
                int n3 = nArray[i];
                int n4 = this.elements[i];
                int n5 = n3 - n4;
                if (n5 == 0) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public IntMatrix2D forEachNonZero(IntIntIntFunction intIntIntFunction) {
        int n = this.dlength;
        while (--n >= 0) {
            int n2 = this.elements[n];
            if (n2 == 0) continue;
            this.elements[n] = intIntIntFunction.apply(n, n, n2);
        }
        return this;
    }

    public int diagonalLength() {
        return this.dlength;
    }

    public int diagonalIndex() {
        return this.dindex;
    }

    public int[] getMaxLocation() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n6;
            n5 = Math.min(n5, this.dlength);
            Future[] futureArray = new Future[n5];
            int[][] nArray = new int[n5][2];
            int n7 = this.dlength / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? this.dlength : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n = n8;
                        int n2 = DiagonalIntMatrix2D.this.elements[n];
                        for (int i = n8 + 1; i < n9; ++i) {
                            int n3 = DiagonalIntMatrix2D.this.elements[i];
                            if (n2 >= n3) continue;
                            n2 = n3;
                            n = i;
                        }
                        return new int[]{n2, n, n};
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    nArray[n6] = (int[])futureArray[n6].get();
                }
                n4 = nArray[0][0];
                n3 = nArray[0][1];
                for (n6 = 1; n6 < n5; ++n6) {
                    if (n4 >= nArray[n6][0]) continue;
                    n4 = nArray[n6][0];
                    n3 = nArray[n6][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 = this.elements[0];
            for (int i = 1; i < this.dlength; ++i) {
                int n10 = this.elements[i];
                if (n4 >= n10) continue;
                n4 = n10;
                n3 = i;
            }
        }
        if (this.dindex > 0) {
            n2 = n3;
            n = n3 + this.dindex;
        } else if (this.dindex < 0) {
            n2 = n3 - this.dindex;
            n = n3;
        } else {
            n2 = n3;
            n = n3;
        }
        return new int[]{n4, n2, n};
    }

    public int[] getMinLocation() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n6;
            n5 = Math.min(n5, this.dlength);
            Future[] futureArray = new Future[n5];
            int[][] nArray = new int[n5][2];
            int n7 = this.dlength / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? this.dlength : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n = n8;
                        int n2 = DiagonalIntMatrix2D.this.elements[n];
                        for (int i = n8 + 1; i < n9; ++i) {
                            int n3 = DiagonalIntMatrix2D.this.elements[i];
                            if (n2 <= n3) continue;
                            n2 = n3;
                            n = i;
                        }
                        return new int[]{n2, n, n};
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    nArray[n6] = (int[])futureArray[n6].get();
                }
                n4 = nArray[0][0];
                n3 = nArray[0][1];
                for (n6 = 1; n6 < n5; ++n6) {
                    if (n4 <= nArray[n6][0]) continue;
                    n4 = nArray[n6][0];
                    n3 = nArray[n6][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 = this.elements[0];
            for (int i = 1; i < this.dlength; ++i) {
                int n10 = this.elements[i];
                if (n4 <= n10) continue;
                n4 = n10;
                n3 = i;
            }
        }
        if (this.dindex > 0) {
            n2 = n3;
            n = n3 + this.dindex;
        } else if (this.dindex < 0) {
            n2 = n3 - this.dindex;
            n = n3;
        } else {
            n2 = n3;
            n = n3;
        }
        return new int[]{n4, n2, n};
    }

    public int getQuick(int n, int n2) {
        if (this.dindex >= 0) {
            if (n2 < this.dindex) {
                return 0;
            }
            if (n < this.dlength && n + this.dindex == n2) {
                return this.elements[n];
            }
            return 0;
        }
        if (n < -this.dindex) {
            return 0;
        }
        if (n2 < this.dlength && n + this.dindex == n2) {
            return this.elements[n2];
        }
        return 0;
    }

    public IntMatrix2D like(int n, int n2) {
        return new SparseIntMatrix2D(n, n2);
    }

    public IntMatrix1D like1D(int n) {
        return new SparseIntMatrix1D(n);
    }

    public void setQuick(int n, int n2, int n3) {
        if (this.dindex >= 0) {
            if (n2 >= this.dindex && n < this.dlength && n + this.dindex == n2) {
                this.elements[n] = n3;
            }
        } else if (n >= -this.dindex && n2 < this.dlength && n + this.dindex == n2) {
            this.elements[n2] = n3;
        }
    }

    public IntMatrix1D zMult(IntMatrix1D intMatrix1D, IntMatrix1D intMatrix1D2, int n, int n2, boolean bl) {
        boolean bl2;
        int n3 = this.rows;
        int n4 = this.columns;
        if (bl) {
            n3 = this.columns;
            n4 = this.rows;
        }
        boolean bl3 = bl2 = intMatrix1D2 == null;
        if (intMatrix1D2 == null) {
            intMatrix1D2 = new DenseIntMatrix1D(n3);
        }
        if (!(this.isNoView && intMatrix1D instanceof DenseIntMatrix1D && intMatrix1D2 instanceof DenseIntMatrix1D)) {
            return super.zMult(intMatrix1D, intMatrix1D2, n, n2, bl);
        }
        if ((long)n4 != intMatrix1D.size() || (long)n3 > intMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + intMatrix1D.toStringShort() + ", " + intMatrix1D2.toStringShort());
        }
        if (!bl2 && n2 != 1) {
            intMatrix1D2.assign(IntFunctions.mult(n2));
        }
        DenseIntMatrix1D denseIntMatrix1D = (DenseIntMatrix1D)intMatrix1D2;
        int[] nArray = denseIntMatrix1D.elements;
        int n5 = denseIntMatrix1D.stride();
        int n6 = (int)intMatrix1D2.index(0);
        DenseIntMatrix1D denseIntMatrix1D2 = (DenseIntMatrix1D)intMatrix1D;
        int[] nArray2 = denseIntMatrix1D2.elements;
        int n7 = denseIntMatrix1D2.stride();
        int n8 = (int)intMatrix1D.index(0);
        if (nArray2 == null || nArray == null) {
            throw new InternalError();
        }
        if (!bl) {
            if (this.dindex >= 0) {
                int n9 = this.dlength;
                while (--n9 >= 0) {
                    int n10 = n6 + n5 * n9;
                    nArray[n10] = nArray[n10] + n * this.elements[n9] * nArray2[this.dindex + n8 + n7 * n9];
                }
            } else {
                int n11 = this.dlength;
                while (--n11 >= 0) {
                    int n12 = -this.dindex + n6 + n5 * n11;
                    nArray[n12] = nArray[n12] + n * this.elements[n11] * nArray2[n8 + n7 * n11];
                }
            }
        } else if (this.dindex >= 0) {
            int n13 = this.dlength;
            while (--n13 >= 0) {
                int n14 = this.dindex + n6 + n5 * n13;
                nArray[n14] = nArray[n14] + n * this.elements[n13] * nArray2[n8 + n7 * n13];
            }
        } else {
            int n15 = this.dlength;
            while (--n15 >= 0) {
                int n16 = n6 + n5 * n15;
                nArray[n16] = nArray[n16] + n * this.elements[n15] * nArray2[-this.dindex + n8 + n7 * n15];
            }
        }
        return intMatrix1D2;
    }

    protected IntMatrix2D getContent() {
        return this;
    }
}

