/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.rng.RandomStream;

public class DigitalNet
extends PointSet {
    protected int b = 0;
    protected int numCols = 0;
    protected int numRows = 0;
    protected int outDigits = 0;
    private int[][] originalMat;
    protected int[][] genMat;
    protected int[][] digitalShift;
    protected double normFactor;
    protected double[] factor;
    private int[] primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67};
    private int[][] FaureFactor = new int[][]{{1}, {1, 2}, {2, 3, 1, 4}, {2, 3, 4, 5, 1, 6}, {3, 4, 7, 8, 2, 5, 6, 9, 1, 10}, {5, 8, 3, 4, 9, 10, 2, 6, 7, 11, 1, 12}, {5, 7, 10, 12, 3, 6, 11, 14, 4, 13, 2, 8, 9, 15, 1, 16}, {7, 8, 11, 12, 4, 5, 14, 15, 3, 6, 13, 16, 2, 9, 10, 17, 1, 18}, {5, 9, 14, 18, 7, 10, 13, 16, 4, 6, 17, 19, 3, 8, 15, 20, 2, 11, 12, 21, 1, 22}, {8, 11, 18, 21, 12, 17, 9, 13, 16, 20, 5, 6, 23, 24, 4, 7, 22, 25, 3, 10, 19, 26, 2, 14, 15, 27, 1, 28}, {12, 13, 18, 19, 11, 14, 17, 20, 7, 9, 22, 24, 4, 8, 23, 27, 5, 6, 25, 26, 3, 10, 21, 28, 2, 15, 16, 29, 1, 30}, {8, 14, 23, 29, 10, 11, 26, 27, 13, 17, 20, 24, 7, 16, 21, 30, 5, 15, 22, 32, 6, 31, 4, 9, 28, 33, 3, 12, 25, 34, 2, 18, 19, 35, 1, 36}, {16, 18, 23, 25, 11, 15, 26, 30, 12, 17, 24, 29, 9, 32, 13, 19, 22, 28, 6, 7, 34, 35, 5, 8, 33, 36, 4, 10, 31, 37, 3, 14, 27, 38, 2, 20, 21, 39, 1, 40}, {12, 18, 25, 31, 9, 19, 24, 34, 8, 16, 27, 35, 10, 13, 30, 33, 15, 20, 23, 28, 5, 17, 26, 38, 6, 7, 36, 37, 4, 11, 32, 39, 3, 14, 29, 40, 2, 21, 22, 41, 1, 42}, {13, 18, 29, 34, 11, 17, 30, 36, 10, 14, 33, 37, 7, 20, 27, 40, 9, 21, 26, 38, 15, 22, 25, 32, 6, 8, 39, 41, 5, 19, 28, 42, 4, 12, 35, 43, 3, 16, 31, 44, 2, 23, 24, 45, 1, 46}, {14, 19, 34, 39, 23, 30, 12, 22, 31, 41, 8, 11, 20, 24, 29, 33, 42, 45, 10, 16, 37, 43, 7, 15, 38, 46, 17, 25, 28, 36, 5, 21, 32, 48, 6, 9, 44, 47, 4, 13, 40, 49, 3, 18, 35, 50, 2, 26, 27, 51, 1, 52}, {25, 26, 33, 34, 18, 23, 36, 41, 14, 21, 38, 45, 24, 27, 32, 35, 11, 16, 43, 48, 9, 13, 46, 50, 8, 22, 37, 51, 7, 17, 42, 52, 19, 28, 31, 40, 6, 10, 49, 53, 5, 12, 47, 54, 4, 15, 44, 55, 3, 20, 39, 56, 2, 29, 30, 57, 1, 58}, {22, 25, 36, 39, 17, 18, 43, 44, 24, 28, 33, 37, 13, 14, 47, 48, 16, 19, 42, 45, 9, 27, 34, 52, 8, 23, 38, 53, 11, 50, 7, 26, 35, 54, 21, 29, 32, 40, 6, 10, 51, 55, 5, 12, 49, 56, 4, 15, 46, 57, 3, 20, 41, 58, 2, 30, 31, 59, 1, 60}, {18, 26, 41, 49, 14, 24, 43, 53, 12, 28, 39, 55, 29, 30, 37, 38, 10, 20, 47, 57, 16, 21, 46, 51, 8, 25, 42, 59, 13, 31, 36, 54, 9, 15, 52, 58, 7, 19, 48, 60, 23, 32, 35, 44, 5, 27, 40, 62, 6, 11, 56, 61, 4, 17, 50, 63, 3, 22, 45, 64, 2, 33, 34, 65, 1, 66}};

    public double getCoordinate(int n, int n2) {
        int[] nArray = new int[this.numCols];
        int[] nArray2 = new int[this.numCols];
        int n3 = this.intToDigitsGray(this.b, n, this.numCols, nArray, nArray2);
        double d = 0.0;
        if (this.digitalShift != null && this.dimShift < n2) {
            this.addRandomShift(this.dimShift, n2, this.shiftStream);
        }
        for (int i = 0; i < this.outDigits; ++i) {
            int n4 = this.digitalShift == null ? 0 : this.digitalShift[n2][i];
            if (i < this.numRows) {
                for (int j = 0; j < n3; ++j) {
                    n4 += this.genMat[n2 * this.numCols + j][i] * nArray2[j];
                }
            }
            d += (double)(n4 % this.b) * this.factor[i];
        }
        return d;
    }

    public PointSetIterator iterator() {
        return new DigitalNetIterator();
    }

    public double getCoordinateNoGray(int n, int n2) {
        int[] nArray = new int[this.numCols];
        int n3 = 0;
        int n4 = 0;
        while (n > 0) {
            ++n3;
            nArray[n4] = n % this.b;
            n /= this.b;
            ++n4;
        }
        if (this.digitalShift != null && this.dimShift < n2) {
            this.addRandomShift(this.dimShift, n2, this.shiftStream);
        }
        double d = 0.0;
        for (int i = 0; i < this.outDigits; ++i) {
            int n5 = this.digitalShift == null ? 0 : this.digitalShift[n2][i];
            if (i < this.numRows) {
                for (n4 = 0; n4 < n3; ++n4) {
                    n5 += this.genMat[n2 * this.numCols + n4][i] * nArray[n4];
                }
            }
            d += (double)(n5 % this.b) * this.factor[i];
        }
        return d;
    }

    public PointSetIterator iteratorNoGray() {
        return new DigitalNetIteratorNoGray();
    }

    public void addRandomShift(int n, int n2, RandomStream randomStream) {
        int n3;
        if (null == randomStream) {
            throw new IllegalArgumentException("\n   Calling addRandomShift with null stream");
        }
        if (0 == n2) {
            n2 = Math.max(1, this.dim);
        }
        if (this.digitalShift == null) {
            this.digitalShift = new int[n2][this.outDigits];
            this.capacityShift = n2;
        } else if (n2 > this.capacityShift) {
            for (n3 = Math.max(4, this.capacityShift); n2 > n3; n3 *= 2) {
            }
            int[][] nArray = new int[n3][this.outDigits];
            this.capacityShift = n3;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < this.outDigits; ++j) {
                    nArray[i][j] = this.digitalShift[i][j];
                }
            }
            this.digitalShift = nArray;
        }
        for (n3 = n; n3 < n2; ++n3) {
            for (int i = 0; i < this.outDigits; ++i) {
                this.digitalShift[n3][i] = randomStream.nextInt(0, this.b - 1);
            }
        }
        this.dimShift = n2;
        this.shiftStream = randomStream;
    }

    public void addRandomShift(RandomStream randomStream) {
        this.addRandomShift(0, this.dim, randomStream);
    }

    public void clearRandomShift() {
        super.clearRandomShift();
        this.digitalShift = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.b > 0) {
            stringBuffer.append("Base = ");
            stringBuffer.append(this.b);
            stringBuffer.append("\n");
        }
        stringBuffer.append("Num cols = ");
        stringBuffer.append(this.numCols);
        stringBuffer.append("\nNum rows = ");
        stringBuffer.append(this.numRows);
        stringBuffer.append("\noutDigits = ");
        stringBuffer.append(this.outDigits);
        return stringBuffer.toString();
    }

    private void printMat(int n, int[][][] nArray, String string) {
        for (int i = 0; i < n; ++i) {
            System.out.println("-------------------------------------\n" + string + "   dim = " + i);
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < this.numCols; ++k) {
                    System.out.print(nArray[i][j][k] + "  ");
                }
                System.out.println("");
            }
        }
        System.out.println("");
    }

    private void printMat0(int[][] nArray, String string) {
        System.out.println("-------------------------------------\n" + string);
        for (int i = 0; i < this.numCols; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                System.out.print(nArray[i][j] + "  ");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    private void leftMultiplyMat(int n, int[][] nArray) {
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int n2 = 0;
                for (int k = 0; k <= i; ++k) {
                    n2 += nArray[i][k] * this.originalMat[n * this.numCols + j][k];
                }
                this.genMat[n * this.numCols + j][i] = n2 % this.b;
            }
        }
    }

    private void leftMultiplyMatDiag(int n, int[][] nArray) {
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int n2 = nArray[i][i] * this.originalMat[n * this.numCols + j][i];
                this.genMat[n * this.numCols + j][i] = n2 % this.b;
            }
        }
    }

    private void rightMultiplyMat(int n, int[][] nArray) {
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int n2 = 0;
                for (int k = 0; k <= j; ++k) {
                    n2 += this.originalMat[n * this.numCols + k][i] * nArray[k][j];
                }
                this.genMat[n * this.numCols + j][i] = n2 % this.b;
            }
        }
    }

    private int getFaureIndex(String string, int n, int n2) {
        int n3;
        if (n >= this.b) {
            throw new IllegalArgumentException("\n   sb >= base in " + string);
        }
        if (n < 1) {
            throw new IllegalArgumentException("\n   sb = 0 in " + string);
        }
        if (n2 > 2 || n2 < 0) {
            throw new IllegalArgumentException("\n   lowerFlag not in {0, 1, 2} in " + string);
        }
        for (n3 = 0; n3 < this.primes.length && this.primes[n3] < this.b; ++n3) {
        }
        if (n3 >= this.primes.length) {
            throw new IllegalArgumentException("base too large in " + string);
        }
        if (this.b != this.primes[n3]) {
            throw new IllegalArgumentException("Faure factors are not implemented for this base in " + string);
        }
        return n3;
    }

    public void leftMatrixScramble(RandomStream randomStream) {
        int n;
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][][] nArray = new int[this.dim][this.numRows][this.numRows];
        for (n = 0; n < this.dim; ++n) {
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numRows; ++j) {
                    nArray[n][i][j] = j == i ? randomStream.nextInt(1, this.b - 1) : (j < i ? randomStream.nextInt(0, this.b - 1) : 0);
                }
            }
        }
        for (n = 0; n < this.dim; ++n) {
            this.leftMultiplyMat(n, nArray[n]);
        }
    }

    public void leftMatrixScrambleDiag(RandomStream randomStream) {
        int n;
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][][] nArray = new int[this.dim][this.numRows][this.numRows];
        for (n = 0; n < this.dim; ++n) {
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numRows; ++j) {
                    nArray[n][i][j] = j == i ? randomStream.nextInt(1, this.b - 1) : 0;
                }
            }
        }
        for (n = 0; n < this.dim; ++n) {
            this.leftMultiplyMatDiag(n, nArray[n]);
        }
    }

    private void LMSFaurePermut(String string, RandomStream randomStream, int n, int n2) {
        int n3;
        int n4 = this.getFaureIndex(string, n, n2);
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][][] nArray = new int[this.dim][this.numRows][this.numRows];
        for (n3 = 0; n3 < this.dim; ++n3) {
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numRows; ++j) {
                    int n5;
                    if (j == i) {
                        n5 = randomStream.nextInt(0, n - 1);
                        nArray[n3][i][j] = this.FaureFactor[n4][n5];
                        continue;
                    }
                    if (j < i) {
                        if (n2 == 2) {
                            nArray[n3][i][j] = randomStream.nextInt(0, this.b - 1);
                            continue;
                        }
                        if (n2 == 1) {
                            n5 = randomStream.nextInt(0, n - 1);
                            nArray[n3][i][j] = this.FaureFactor[n4][n5];
                            continue;
                        }
                        nArray[n3][i][j] = 0;
                        continue;
                    }
                    nArray[n3][i][j] = 0;
                }
            }
        }
        if (n2 == 0) {
            for (n3 = 0; n3 < this.dim; ++n3) {
                this.leftMultiplyMatDiag(n3, nArray[n3]);
            }
        } else {
            for (n3 = 0; n3 < this.dim; ++n3) {
                this.leftMultiplyMat(n3, nArray[n3]);
            }
        }
    }

    public void leftMatrixScrambleFaurePermut(RandomStream randomStream, int n) {
        this.LMSFaurePermut("leftMatrixScrambleFaurePermut", randomStream, n, 2);
    }

    public void leftMatrixScrambleRest(RandomStream randomStream, int n) {
        System.out.println("***WARNING: leftMatrixScrambleRest is deprecated: its name has been changed to\n            leftMatrixScrambleFaurePermut");
        this.leftMatrixScrambleFaurePermut(randomStream, n);
    }

    public void leftMatrixScrambleFaurePermutDiag(RandomStream randomStream, int n) {
        this.LMSFaurePermut("leftMatrixScrambleFaurePermutDiag", randomStream, n, 0);
    }

    public void leftMatrixScrambleFaurePermutAll(RandomStream randomStream, int n) {
        this.LMSFaurePermut("leftMatrixScrambleFaurePermutAll", randomStream, n, 1);
    }

    public void iBinomialMatrixScramble(RandomStream randomStream) {
        int n;
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][][] nArray = new int[this.dim][this.numRows][this.numRows];
        for (n = 0; n < this.dim; ++n) {
            int n2;
            int n3;
            int n4 = randomStream.nextInt(1, this.b - 1);
            for (n3 = 0; n3 < this.numRows; ++n3) {
                nArray[n][n3][n3] = n4;
                for (n2 = n3 + 1; n2 < this.numRows; ++n2) {
                    nArray[n][n3][n2] = 0;
                }
            }
            for (n3 = 1; n3 < this.numRows; ++n3) {
                int n5 = randomStream.nextInt(0, this.b - 1);
                n2 = 0;
                while (n3 + n2 < this.numRows) {
                    nArray[n][n3 + n2][n2] = n5;
                    ++n2;
                }
            }
        }
        for (n = 0; n < this.dim; ++n) {
            this.leftMultiplyMat(n, nArray[n]);
        }
    }

    private void iBMSFaurePermut(String string, RandomStream randomStream, int n, int n2) {
        int n3;
        int n4 = this.getFaureIndex(string, n, n2);
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][][] nArray = new int[this.dim][this.numRows][this.numRows];
        for (n3 = 0; n3 < this.dim; ++n3) {
            int n5;
            int n6;
            int n7 = randomStream.nextInt(0, n - 1);
            int n8 = this.FaureFactor[n4][n7];
            for (n6 = 0; n6 < this.numRows; ++n6) {
                nArray[n3][n6][n6] = n8;
                for (n5 = n6 + 1; n5 < this.numRows; ++n5) {
                    nArray[n3][n6][n5] = 0;
                }
            }
            for (n6 = 1; n6 < this.numRows; ++n6) {
                int n9;
                if (n2 == 2) {
                    n9 = randomStream.nextInt(0, this.b - 1);
                } else if (n2 == 1) {
                    n7 = randomStream.nextInt(0, n - 1);
                    n9 = this.FaureFactor[n4][n7];
                } else {
                    n9 = 0;
                }
                n5 = 0;
                while (n6 + n5 < this.numRows) {
                    nArray[n3][n6 + n5][n5] = n9;
                    ++n5;
                }
            }
        }
        if (n2 > 0) {
            for (n3 = 0; n3 < this.dim; ++n3) {
                this.leftMultiplyMat(n3, nArray[n3]);
            }
        } else {
            for (n3 = 0; n3 < this.dim; ++n3) {
                this.leftMultiplyMatDiag(n3, nArray[n3]);
            }
        }
    }

    public void iBinomialMatrixScrambleFaurePermut(RandomStream randomStream, int n) {
        this.iBMSFaurePermut("iBinomialMatrixScrambleFaurePermut", randomStream, n, 2);
    }

    public void iBinomialMatrixScrambleFaurePermutDiag(RandomStream randomStream, int n) {
        this.iBMSFaurePermut("iBinomialMatrixScrambleFaurePermutDiag", randomStream, n, 0);
    }

    public void iBinomialMatrixScrambleFaurePermutAll(RandomStream randomStream, int n) {
        this.iBMSFaurePermut("iBinomialMatrixScrambleFaurePermutAll", randomStream, n, 1);
    }

    public void stripedMatrixScramble(RandomStream randomStream) {
        int n;
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][][] nArray = new int[this.dim][this.numRows][this.numRows];
        for (n = 0; n < this.dim; ++n) {
            for (int i = 0; i < this.numRows; ++i) {
                int n2;
                int n3 = randomStream.nextInt(1, this.b - 1);
                for (n2 = 0; n2 < i; ++n2) {
                    nArray[n][n2][i] = 0;
                }
                for (n2 = i; n2 < this.numRows; ++n2) {
                    nArray[n][n2][i] = n3;
                }
            }
        }
        for (n = 0; n < this.dim; ++n) {
            this.leftMultiplyMat(n, nArray[n]);
        }
    }

    public void stripedMatrixScrambleFaurePermutAll(RandomStream randomStream, int n) {
        int n2;
        int n3 = this.getFaureIndex("stripedMatrixScrambleFaurePermutAll", n, 1);
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][][] nArray = new int[this.dim][this.numRows][this.numRows];
        for (n2 = 0; n2 < this.dim; ++n2) {
            for (int i = 0; i < this.numRows; ++i) {
                int n4;
                int n5 = randomStream.nextInt(0, n - 1);
                int n6 = this.FaureFactor[n3][n5];
                for (n4 = 0; n4 < i; ++n4) {
                    nArray[n2][n4][i] = 0;
                }
                for (n4 = i; n4 < this.numRows; ++n4) {
                    nArray[n2][n4][i] = n6;
                }
            }
        }
        for (n2 = 0; n2 < this.dim; ++n2) {
            this.leftMultiplyMat(n2, nArray[n2]);
        }
    }

    public void rightMatrixScramble(RandomStream randomStream) {
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][] nArray = new int[this.numCols][this.numCols];
        for (int i = 0; i < this.numCols; ++i) {
            int n;
            for (n = 0; n < i; ++n) {
                nArray[n][i] = randomStream.nextInt(0, this.b - 1);
            }
            nArray[i][i] = randomStream.nextInt(1, this.b - 1);
            for (n = i + 1; n < this.numCols; ++n) {
                nArray[n][i] = 0;
            }
        }
        for (int i = 0; i < this.dim; ++i) {
            this.rightMultiplyMat(i, nArray);
        }
    }

    public void unrandomize() {
        this.resetGeneratorMatrices();
        this.digitalShift = null;
    }

    public void resetGeneratorMatrices() {
        if (this.originalMat != null) {
            this.genMat = this.originalMat;
            this.originalMat = null;
        }
    }

    public void eraseOriginalGeneratorMatrices() {
        this.originalMat = null;
    }

    public void printGeneratorMatrices(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.println("dim = " + (i + 1) + "\n");
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < this.numCols; ++k) {
                    System.out.print(this.genMat[i * this.numCols + k][j] + "  ");
                }
                System.out.println("");
            }
            System.out.println("----------------------------------");
        }
    }

    protected int intToDigitsGray(int n, int n2, int n3, int[] nArray, int[] nArray2) {
        if (n2 == 0) {
            return 0;
        }
        int n4 = 0;
        int n5 = 0;
        while (n2 > 0) {
            ++n4;
            nArray[n5] = n2 % n;
            n2 /= n;
            ++n5;
        }
        nArray2[n4 - 1] = nArray[n4 - 1];
        for (n5 = 0; n5 < n4 - 1; ++n5) {
            int n6 = nArray[n5] - nArray[n5 + 1];
            nArray2[n5] = n6 < 0 ? n6 + n : n6;
        }
        for (n5 = n4; n5 < n3; ++n5) {
            nArray[n5] = 0;
            nArray2[n5] = 0;
        }
        return n4;
    }

    protected class DigitalNetIteratorNoGray
    extends DigitalNetIterator {
        public void setCurPointIndex(int n) {
            if (n == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = n;
            this.curCoordIndex = 0;
            if (DigitalNet.this.dimShift < this.dimS) {
                DigitalNet.this.addRandomShift(DigitalNet.this.dimShift, this.dimS, DigitalNet.this.shiftStream);
            }
            this.idigits = DigitalNet.this.intToDigitsGray(DigitalNet.this.b, n, DigitalNet.this.numCols, this.bdigit, this.gdigit);
            for (int i = 0; i < this.dimS; ++i) {
                for (int j = 0; j < DigitalNet.this.outDigits; ++j) {
                    int n2 = DigitalNet.this.digitalShift == null ? 0 : DigitalNet.this.digitalShift[i][j];
                    if (j < DigitalNet.this.numRows) {
                        for (int k = 0; k < this.idigits; ++k) {
                            n2 += DigitalNet.this.genMat[i * DigitalNet.this.numCols + k][j] * this.bdigit[k];
                        }
                    }
                    this.cachedCurPoint[i * DigitalNet.this.outDigits + j] = n2 % DigitalNet.this.b;
                }
            }
        }

        public int resetToNextPoint() {
            ++this.curPointIndex;
            this.curCoordIndex = 0;
            if (this.curPointIndex >= DigitalNet.this.numPoints) {
                return this.curPointIndex;
            }
            int n = 0;
            while (this.bdigit[n] == DigitalNet.this.b - 1) {
                this.bdigit[n] = 0;
                ++n;
            }
            int n2 = n;
            this.bdigit[n2] = this.bdigit[n2] + 1;
            int n3 = DigitalNet.this.numRows;
            if (DigitalNet.this.outDigits < DigitalNet.this.numRows) {
                n3 = DigitalNet.this.outDigits;
            }
            for (int i = 0; i < this.dimS; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k <= n; ++k) {
                        int n4 = i * DigitalNet.this.outDigits + j;
                        this.cachedCurPoint[n4] = this.cachedCurPoint[n4] + DigitalNet.this.genMat[i * DigitalNet.this.numCols + k][j];
                    }
                    int n5 = i * DigitalNet.this.outDigits + j;
                    this.cachedCurPoint[n5] = this.cachedCurPoint[n5] % DigitalNet.this.b;
                }
            }
            return this.curPointIndex;
        }
    }

    protected class DigitalNetIterator
    extends PointSet.DefaultPointSetIterator {
        protected int idigits;
        protected int[] bdigit;
        protected int[] gdigit;
        protected int dimS;
        protected int[] cachedCurPoint;

        public DigitalNetIterator() {
            super(DigitalNet.this);
            this.EpsilonHalf = 0.5 / Math.pow(DigitalNet.this.b, DigitalNet.this.outDigits);
            this.bdigit = new int[DigitalNet.this.numCols];
            this.gdigit = new int[DigitalNet.this.numCols];
            this.dimS = DigitalNet.this.dim;
            this.cachedCurPoint = new int[(DigitalNet.this.dim + 1) * DigitalNet.this.outDigits];
            this.init();
        }

        public void init() {
            this.resetCurPointIndex();
        }

        public double nextDouble() {
            return this.nextCoordinate() + this.EpsilonHalf;
        }

        public double nextCoordinate() {
            if (this.curPointIndex >= DigitalNet.this.numPoints || this.curCoordIndex >= this.dimS) {
                this.outOfBounds();
            }
            int n = DigitalNet.this.outDigits * this.curCoordIndex++;
            double d = 0.0;
            for (int i = 0; i < DigitalNet.this.outDigits; ++i) {
                d += (double)this.cachedCurPoint[n + i] * DigitalNet.this.factor[i];
            }
            return d;
        }

        public void resetCurPointIndex() {
            int n;
            if (DigitalNet.this.digitalShift == null) {
                for (n = 0; n < this.cachedCurPoint.length; ++n) {
                    this.cachedCurPoint[n] = 0;
                }
            } else {
                if (DigitalNet.this.dimShift < this.dimS) {
                    DigitalNet.this.addRandomShift(DigitalNet.this.dimShift, this.dimS, DigitalNet.this.shiftStream);
                }
                for (n = 0; n < this.dimS; ++n) {
                    for (int i = 0; i < DigitalNet.this.outDigits; ++i) {
                        this.cachedCurPoint[n * DigitalNet.this.outDigits + i] = DigitalNet.this.digitalShift[n][i];
                    }
                }
            }
            for (n = 0; n < DigitalNet.this.numCols; ++n) {
                this.bdigit[n] = 0;
            }
            for (n = 0; n < DigitalNet.this.numCols; ++n) {
                this.gdigit[n] = 0;
            }
            this.curPointIndex = 0;
            this.curCoordIndex = 0;
            this.idigits = 0;
        }

        public void setCurPointIndex(int n) {
            if (n == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = n;
            this.curCoordIndex = 0;
            if (DigitalNet.this.digitalShift != null && DigitalNet.this.dimShift < this.dimS) {
                DigitalNet.this.addRandomShift(DigitalNet.this.dimShift, this.dimS, DigitalNet.this.shiftStream);
            }
            this.idigits = DigitalNet.this.intToDigitsGray(DigitalNet.this.b, n, DigitalNet.this.numCols, this.bdigit, this.gdigit);
            for (int i = 0; i < this.dimS; ++i) {
                for (int j = 0; j < DigitalNet.this.outDigits; ++j) {
                    int n2 = DigitalNet.this.digitalShift == null ? 0 : DigitalNet.this.digitalShift[i][j];
                    if (j < DigitalNet.this.numRows) {
                        for (int k = 0; k < this.idigits; ++k) {
                            n2 += DigitalNet.this.genMat[i * DigitalNet.this.numCols + k][j] * this.gdigit[k];
                        }
                    }
                    this.cachedCurPoint[i * DigitalNet.this.outDigits + j] = n2 % DigitalNet.this.b;
                }
            }
        }

        public int resetToNextPoint() {
            ++this.curPointIndex;
            this.curCoordIndex = 0;
            if (this.curPointIndex >= DigitalNet.this.numPoints) {
                return this.curPointIndex;
            }
            int n = 0;
            while (this.gdigit[n] == DigitalNet.this.b - 1) {
                this.gdigit[n] = 0;
                ++n;
            }
            int n2 = n;
            this.gdigit[n2] = this.gdigit[n2] + 1;
            int n3 = DigitalNet.this.numRows;
            if (DigitalNet.this.outDigits < DigitalNet.this.numRows) {
                n3 = DigitalNet.this.outDigits;
            }
            for (int i = 0; i < this.dimS; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n4 = i * DigitalNet.this.outDigits + j;
                    this.cachedCurPoint[n4] = this.cachedCurPoint[n4] + DigitalNet.this.genMat[i * DigitalNet.this.numCols + n][j];
                    int n5 = i * DigitalNet.this.outDigits + j;
                    this.cachedCurPoint[n5] = this.cachedCurPoint[n5] % DigitalNet.this.b;
                }
            }
            return this.curPointIndex;
        }
    }
}

