/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.VQ;

import java.util.ArrayList;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Debug;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.Pair;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class Cluster {
    protected Prototype centroid;
    protected PrototypeSet set;
    protected double label;

    public void setCentroid(Prototype centroid) {
        this.centroid = centroid;
    }

    public void setLabel(double label) {
        this.label = label;
    }

    public void setSet(PrototypeSet set) {
        this.set = set;
    }

    public double getLabel() {
        return this.label;
    }

    public PrototypeSet getPrototypeSet() {
        return this.set;
    }

    public void add(Prototype t) {
        this.set.add(t);
    }

    public Prototype get(int i) {
        return (Prototype)this.set.get(i);
    }

    public Cluster(Prototype centroid, PrototypeSet set) {
        this.centroid = centroid;
        this.set = set;
        this.label = centroid.label();
    }

    public Cluster(PrototypeSet set, Prototype centroid) {
        this.centroid = centroid;
        this.set = set;
        this.label = centroid.label();
    }

    public Prototype center() {
        return this.centroid;
    }

    public Prototype getCentroid() {
        return this.centroid;
    }

    public double fitness() {
        double acca = 0.0;
        for (Prototype pa : this.set) {
            acca += Distance.dSquared(pa, this.centroid);
        }
        return acca;
    }

    public Prototype avg() {
        return this.set.avg();
    }

    public int size() {
        return this.set.size();
    }

    protected Pair<Cluster, Cluster> partititonWhoseCentersAre(Prototype center1, Prototype center2) {
        PrototypeSet one = new PrototypeSet();
        PrototypeSet two = new PrototypeSet();
        PrototypeSet centerSet = new PrototypeSet();
        centerSet.add(center1);
        centerSet.add(center2);
        Debug.endsIf(center1 == center2, "Centers are the same, it is not allowed.");
        for (Prototype p : this.set) {
            Prototype q = centerSet.nearestTo(p);
            if (q == center1) {
                one.add(p);
                continue;
            }
            if (q == center2) {
                two.add(p);
                continue;
            }
            if (q == null) {
                Debug.goout("q is null");
                continue;
            }
            Debug.goout("partitionWhoseCentersAre gone wrong wrong wrong!");
        }
        Cluster c1 = new Cluster(one, center1);
        Cluster c2 = new Cluster(two, center2);
        return new Pair<Cluster, Cluster>(c1, c2);
    }

    protected double distorsion(Prototype center) {
        double acc = 0.0;
        for (Prototype p : this.set) {
            acc += Distance.d(p, center);
        }
        return acc / (double)this.set.size();
    }

    protected static double distorsion(Pair<Prototype, Prototype> centers, Pair<Cluster, Cluster> part) {
        double d1 = part.first().distorsion(centers.first());
        double d2 = part.second().distorsion(centers.second());
        return d1 + d2;
    }

    public Pair<Cluster, Cluster> _2LBGPartition(double epsilon) {
        int size = this.set.size();
        int last = size - 1;
        double D1 = Double.POSITIVE_INFINITY;
        ArrayList<Integer> r = null;
        r = RandomGenerator.generateDifferentRandomIntegers(0, last, 2);
        Prototype p1 = (Prototype)this.set.get(r.get(0));
        Prototype p2 = (Prototype)this.set.get(r.get(1));
        Pair<Prototype, Prototype> Y = new Pair<Prototype, Prototype>(p1, p2);
        boolean termination = false;
        Pair<Cluster, Cluster> partition = null;
        boolean it = false;
        do {
            Pair<Cluster, Cluster> P;
            double Dm;
            double value;
            if ((value = Math.abs(D1 - (Dm = Cluster.distorsion(Y, P = this.partititonWhoseCentersAre(Y.first(), Y.second())))) / Dm) <= epsilon) {
                termination = true;
                partition = P;
                continue;
            }
            D1 = Dm;
            Prototype newCenter1 = P.first().avg();
            Prototype newCenter2 = P.second().avg();
            Y = new Pair<Prototype, Prototype>(newCenter1, newCenter2);
        } while (!termination);
        return partition;
    }

    public Pair<Prototype, Prototype> centersOfLBGCLuster(double epsilon) {
        Pair<Cluster, Cluster> c = this._2LBGPartition(epsilon);
        return new Pair<Prototype, Prototype>(c.first().center(), c.second().center());
    }

    public boolean isCentroidItsNearestPrototoype(Prototype p) {
        return this.centroid == this.set.nearestTo(p);
    }
}

