/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.io.IOException;
import javolution.lang.CharSet;
import javolution.lang.Text;
import javolution.lang.TextBuilder;
import javolution.realtime.ObjectFactory;
import javolution.realtime.RealtimeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextFormat<T> {
    protected TextFormat() {
    }

    public abstract Appendable format(T var1, Appendable var2) throws IOException;

    public abstract T parse(CharSequence var1, Cursor var2);

    public final Text format(T t) {
        try {
            TextBuilder textBuilder = TextBuilder.newInstance();
            this.format(t, textBuilder);
            return textBuilder.toText();
        }
        catch (IOException iOException) {
            throw new Error();
        }
    }

    public final T parse(CharSequence charSequence) {
        Cursor cursor = Cursor.newInstance();
        T t = this.parse(charSequence, cursor);
        if (cursor.getIndex() != charSequence.length()) {
            throw new IllegalArgumentException("Parsing of " + charSequence + " incomplete (terminated at index: " + cursor.getIndex() + ")");
        }
        cursor.recycle();
        return t;
    }

    public static final class Cursor
    extends RealtimeObject {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            public Object create() {
                return new Cursor();
            }
        };
        private int _index;

        private Cursor() {
        }

        public static Cursor newInstance() {
            Cursor cursor = (Cursor)FACTORY.object();
            cursor._index = 0;
            return cursor;
        }

        public int getIndex() {
            return this._index;
        }

        public void setIndex(int n) {
            this._index = n;
        }

        public boolean skip(CharSet charSet, CharSequence charSequence) {
            int n = charSequence.length();
            while (this._index < n) {
                if (!charSet.contains(charSequence.charAt(this._index))) {
                    return true;
                }
                ++this._index;
            }
            return false;
        }

        public void increment() {
            ++this._index;
        }

        public void increment(int n) {
            this._index += n;
        }

        public void recycle() {
            super.recycle();
        }
    }
}

