/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.util.range;

import net.sf.jclec.IConfigure;
import net.sf.jclec.util.random.IRandGen;
import net.sf.jclec.util.range.Closure;
import net.sf.jclec.util.range.IRange;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Interval
implements IRange,
IConfigure {
    private static final long serialVersionUID = 4742142066614454991L;
    protected double left;
    protected double right;
    protected Closure closure;

    public Interval() {
    }

    public Interval(double left, double right, Closure closure) {
        this.setClosure(closure);
        this.setLeft(left);
        this.setRight(right);
    }

    public final Closure getClosure() {
        return this.closure;
    }

    public final void setClosure(Closure closure) {
        this.closure = closure;
    }

    public final double getLeft() {
        return this.left;
    }

    public final void setLeft(double left) {
        this.left = left;
    }

    public final double getRight() {
        return this.right;
    }

    public final void setRight(double right) {
        this.right = right;
    }

    public boolean contains(double value) {
        switch (this.closure) {
            case OpenOpen: {
                return value > this.left && value < this.right;
            }
            case OpenClosed: {
                return value > this.left && value <= this.right;
            }
            case ClosedOpen: {
                return value >= this.left && value < this.right;
            }
            case ClosedClosed: {
                return value >= this.left && value <= this.right;
            }
        }
        return false;
    }

    public double efWidth() {
        return this.efRight() - this.efLeft();
    }

    public double getRandom(IRandGen randgen) {
        return randgen.uniform(this.efLeft(), this.efRight());
    }

    public double nearestOf(double value) {
        double red;
        if (this.contains(value)) {
            return value;
        }
        double lefv = this.efLeft();
        double refv = this.efRight();
        double led = Math.abs(value - lefv);
        if (led < (red = Math.abs(value - refv))) {
            return lefv;
        }
        return refv;
    }

    public double scale(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("\"value\" must be between 0.0 and 1.0");
        }
        double lefv = this.efLeft();
        double refv = this.efRight();
        return lefv + value * (refv - lefv);
    }

    public double unscale(double value) {
        if (!this.contains(value)) {
            throw new IllegalArgumentException("\"value\" must belong to this interval");
        }
        double lefv = this.efLeft();
        double refv = this.efRight();
        return (value - lefv) / (refv - lefv);
    }

    public void configure(Configuration configuration) {
        Closure closure;
        double left = configuration.getDouble("[@left]");
        this.setLeft(left);
        double right = configuration.getDouble("[@right]");
        this.setRight(right);
        String closureString = configuration.getString("[@closure]", "closed-closed");
        if (closureString.equals("closed-closed")) {
            closure = Closure.ClosedClosed;
        } else if (closureString.equals("open-open")) {
            closure = Closure.OpenOpen;
        } else if (closureString.equals("closed-open")) {
            closure = Closure.ClosedOpen;
        } else if (closureString.equals("open-closed")) {
            closure = Closure.OpenClosed;
        } else {
            throw new ConfigurationRuntimeException("Illegal value for interval closure");
        }
        this.setClosure(closure);
    }

    public boolean equals(Object other) {
        if (other instanceof Interval) {
            Interval cother = (Interval)other;
            return this.closure == cother.closure && this.left == cother.left && this.right == cother.right;
        }
        return false;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this);
        tsb.append((Object)this.closure);
        tsb.append("left", this.left);
        tsb.append("right", this.right);
        return tsb.toString();
    }

    private final double efLeft() {
        switch (this.closure) {
            case OpenOpen: 
            case OpenClosed: {
                return this.left + Double.MIN_VALUE;
            }
            case ClosedOpen: 
            case ClosedClosed: {
                return this.left;
            }
        }
        return 0.0;
    }

    private final double efRight() {
        switch (this.closure) {
            case OpenOpen: 
            case ClosedOpen: {
                return this.right - Double.MIN_VALUE;
            }
            case OpenClosed: 
            case ClosedClosed: {
                return this.right;
            }
        }
        return 0.0;
    }
}

