/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.util.random;

import net.sourceforge.jclec.util.random.IRandGen;

public abstract class AbstractRandGen
implements IRandGen {
    protected Double BMoutput;

    protected AbstractRandGen() {
    }

    @Override
    public void raw(double[] d, int n) {
        int i = 0;
        while (i < n) {
            d[i] = this.raw();
            ++i;
        }
    }

    @Override
    public final void raw(double[] d) {
        this.raw(d, d.length);
    }

    @Override
    public final int choose(int hi) {
        return this.choose(1, hi);
    }

    @Override
    public int choose(int lo, int hi) {
        int value = lo + (int)((double)(hi - lo) * this.raw());
        if (value > hi) {
            value = hi;
        }
        return value;
    }

    @Override
    public final boolean coin() {
        return this.raw() <= 0.5;
    }

    @Override
    public final boolean coin(double p) {
        return this.raw() <= p;
    }

    @Override
    public final double uniform(double lo, double hi) {
        return lo + (hi - lo) * this.raw();
    }

    @Override
    public final double gaussian() {
        double y;
        double x;
        double r;
        if (this.BMoutput != null) {
            double out = this.BMoutput;
            this.BMoutput = null;
            return out;
        }
        while ((r = (x = this.uniform(-1.0, 1.0)) * x + (y = this.uniform(-1.0, 1.0)) * y) >= 1.0) {
        }
        double z = Math.sqrt(-2.0 * Math.log(r) / r);
        this.BMoutput = new Double(x * z);
        return y * z;
    }

    @Override
    public final double gaussian(double sd) {
        return this.gaussian() * sd;
    }

    @Override
    public final double powlaw(double alpha, double cut) {
        return cut * Math.pow(this.raw(), 1.0 / (alpha + 1.0));
    }
}

