/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Hyperrectangles.RISE;

import java.util.StringTokenizer;
import keel.Algorithms.Hyperrectangles.Basic.HyperrectanglesAlgorithm;
import keel.Algorithms.Hyperrectangles.RISE.Rule;
import keel.Dataset.Attributes;
import org.core.Fichero;

public class RISE
extends HyperrectanglesAlgorithm {
    private int Q;
    private int S;
    int[] classVotes;
    Rule[] ruleset;

    public RISE(String script) {
        this.readDataFiles(script);
        this.name = "RISE";
        Rule.setQ(this.Q);
        Rule.setS(this.S);
        Rule.setSize(this.inputAtt);
        Rule.setAttributes(this.inputs);
        Rule.setNClasses(this.nClasses);
        for (int i = 0; i < this.inputAtt; ++i) {
            if (this.inputs[i].getType() == 0) {
                Rule.setNumValue(Attributes.getInputAttribute(i).getNumNominalValues(), i);
                continue;
            }
            Rule.setNumValue(1, i);
        }
        Rule.loadSVDMmatrix(this.trainData, this.trainOutput);
        this.classVotes = new int[this.nClasses];
        this.ruleset = new Rule[this.trainData.length];
        this.setInitialTime();
    }

    @Override
    protected void readParameters(String script) {
        String file = Fichero.leeFichero(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
        String line = fileLines.nextToken();
        StringTokenizer tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.Q = Integer.parseInt(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.S = Integer.parseInt(tokens.nextToken().substring(1));
    }

    public void getRules() {
        int i;
        for (i = 0; i < this.trainData.length; ++i) {
            this.ruleset[i] = new Rule(this.trainData[i], this.trainOutput[i]);
            this.computeLaplaceAcc(this.ruleset[i]);
        }
        boolean improvement = true;
        while (improvement) {
            improvement = false;
            for (i = 0; i < this.ruleset.length; ++i) {
                int j;
                int index = -1;
                double minDist = Double.MAX_VALUE;
                for (j = 0; j < this.trainData.length; ++j) {
                    double auxDist;
                    if (this.trainOutput[j] != this.ruleset[i].getOutput() || this.ruleset[i].inside(this.trainData[j]) || !((auxDist = this.ruleset[i].distance(this.trainData[j])) < minDist)) continue;
                    minDist = auxDist;
                    index = j;
                }
                if (index <= -1) continue;
                Rule aux = this.ruleset[i].clone();
                aux.mostSpecificGeneralization(this.trainData[index]);
                this.computeLaplaceAcc(aux);
                int points = 0;
                for (j = 0; j < this.trainData.length; ++j) {
                    double newDist = aux.distance(this.trainData[j]);
                    if (newDist != 0.0) continue;
                    points += this.tryClassification(j, i, aux);
                }
                if (points < 0) continue;
                improvement = true;
                this.ruleset[i] = aux.clone();
                boolean[] duplicates = new boolean[this.ruleset.length];
                int utilRule = 0;
                for (j = 0; j < this.ruleset.length; ++j) {
                    if (this.ruleset[j].equals(aux) && j != i) {
                        duplicates[j] = true;
                        continue;
                    }
                    duplicates[j] = false;
                    ++utilRule;
                }
                if (utilRule == this.ruleset.length) continue;
                Rule[] newset = new Rule[utilRule];
                int pointer = 0;
                for (j = 0; j < this.ruleset.length; ++j) {
                    if (duplicates[j]) continue;
                    newset[pointer] = this.ruleset[j].clone();
                    ++pointer;
                }
                this.ruleset = new Rule[utilRule];
                for (j = 0; j < this.ruleset.length; ++j) {
                    this.ruleset[j] = newset[j].clone();
                }
            }
        }
    }

    private int tryClassification(int instance, int oldRule, Rule aux) {
        int oldOutput = this.evaluate(this.trainData[instance]);
        Rule save = this.ruleset[oldRule].clone();
        this.ruleset[oldRule] = aux.clone();
        int newOutput = this.evaluate(this.trainData[instance]);
        this.ruleset[oldRule] = save.clone();
        if (oldOutput == this.trainOutput[instance]) {
            if (newOutput == this.trainOutput[instance]) {
                return 0;
            }
            return -1;
        }
        if (newOutput == this.trainOutput[instance]) {
            return 1;
        }
        return 0;
    }

    private void computeLaplaceAcc(Rule aux) {
        int pos = 0;
        for (int i = 0; i < this.trainData.length; ++i) {
            if (!aux.inside(this.trainData[i])) continue;
            ++pos;
        }
        double acc = ((double)pos + 1.0) / (double)(this.trainData.length + this.nClasses);
        aux.setLaplaceAcc(acc);
    }

    @Override
    protected int evaluate(double[] instance) {
        int i;
        int maxVotes = Integer.MIN_VALUE;
        double maxAcc = Double.MIN_VALUE;
        int selected = -1;
        double minDist = Double.MAX_VALUE;
        boolean draw = false;
        for (i = 0; i < this.ruleset.length; ++i) {
            if (this.ruleset[i].distance(instance) == minDist) {
                if (this.ruleset[i].getLaplaceAcc() > maxAcc) {
                    maxAcc = this.ruleset[i].getLaplaceAcc();
                    selected = i;
                    draw = false;
                }
                if (this.ruleset[i].getLaplaceAcc() == maxAcc) {
                    draw = true;
                }
            }
            if (!(this.ruleset[i].distance(instance) < minDist)) continue;
            minDist = this.ruleset[i].distance(instance);
            maxAcc = this.ruleset[i].getLaplaceAcc();
            selected = i;
            draw = false;
        }
        selected = this.ruleset[selected].getOutput();
        if (draw) {
            for (i = 0; i < this.nClasses; ++i) {
                this.classVotes[i] = 0;
            }
            for (i = 0; i < this.ruleset.length; ++i) {
                if (this.ruleset[i].distance(instance) != minDist || this.ruleset[i].getLaplaceAcc() != maxAcc) continue;
                int n = this.ruleset[i].getOutput();
                this.classVotes[n] = this.classVotes[n] + 1;
            }
            int max = -1;
            for (i = 0; i < this.nClasses; ++i) {
                if (maxVotes >= this.classVotes[i]) continue;
                max = this.classVotes[i];
                max = i;
            }
            selected = max;
        }
        return selected;
    }

    @Override
    protected int writeRules() {
        String text = "";
        text = text + "\n";
        for (int i = 0; i < this.ruleset.length; ++i) {
            text = text + "\n";
            text = text + this.ruleset[i];
        }
        this.ruleSetText = text;
        return this.ruleset.length;
    }
}

