/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF;

import java.io.IOException;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.BaseD;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.BaseR;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.Individuo;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.Poblacion;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.myDataset;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.parseParameters;
import org.core.Fichero;
import org.core.Randomize;

public class GFS_RB_MF {
    myDataset train;
    myDataset val;
    myDataset test;
    String outputTr;
    String outputTst;
    String ficheroBD;
    String ficheroBR;
    BaseD baseDatos;
    BaseR baseReglas;
    int populationSize;
    int nGenerations;
    int numEtiquetas;
    double crossProb;
    double mutProb;
    Individuo ind;
    private boolean somethingWrong = false;

    public GFS_RB_MF() {
    }

    public GFS_RB_MF(parseParameters parameters) {
        this.train = new myDataset();
        this.val = new myDataset();
        this.test = new myDataset();
        try {
            System.out.println("\nReading the training set: " + parameters.getTrainingInputFile());
            this.train.readRegressionSet(parameters.getTrainingInputFile(), true);
            System.out.println("\nReading the validation set: " + parameters.getValidationInputFile());
            this.val.readRegressionSet(parameters.getValidationInputFile(), false);
            System.out.println("\nReading the test set: " + parameters.getTestInputFile());
            this.test.readRegressionSet(parameters.getTestInputFile(), false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input data-sets: " + e);
            this.somethingWrong = true;
        }
        this.somethingWrong = this.somethingWrong || this.train.hasMissingAttributes();
        this.outputTr = parameters.getTrainingOutputFile();
        this.outputTst = parameters.getTestOutputFile();
        this.ficheroBD = parameters.getOutputFile(0);
        this.ficheroBR = parameters.getOutputFile(1);
        long semilla = Long.parseLong(parameters.getParameter(0));
        this.numEtiquetas = Integer.parseInt(parameters.getParameter(1));
        this.populationSize = Integer.parseInt(parameters.getParameter(2));
        while (this.populationSize % 2 != 0) {
            ++this.populationSize;
        }
        this.nGenerations = Integer.parseInt(parameters.getParameter(3));
        this.crossProb = Double.parseDouble(parameters.getParameter(4));
        this.mutProb = Double.parseDouble(parameters.getParameter(5));
        Randomize.setSeed(semilla);
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found, either the data-set has missing values.");
            System.err.println("Please remove the examples with missing data or apply a MV preprocessing.");
            System.err.println("Aborting the program");
        } else {
            this.baseDatos = new BaseD(this.numEtiquetas, this.train.getnVars(), this.train.devuelveRangos());
            this.baseReglas = new BaseR(this.baseDatos, this.train);
            Poblacion pobl = new Poblacion(this.populationSize, this.baseReglas, this.train);
            pobl.procesoGenetico(this.nGenerations, this.crossProb, this.mutProb);
            this.ind = pobl.getMejor();
            this.baseReglas.ajusta(this.ind);
            this.baseDatos.escribeFichero(this.ficheroBD);
            this.baseReglas.escribeFichero(this.ficheroBR);
            this.doOutput(this.val, this.outputTr);
            this.doOutput(this.test, this.outputTst);
            System.out.println("Algorithm Finished");
        }
    }

    private void doOutput(myDataset dataset, String filename) {
        String output = new String("");
        output = dataset.copyHeader();
        for (int i = 0; i < dataset.getnData(); ++i) {
            output = output + dataset.getOutputAsReal(i) + " " + this.regressionOutput(dataset.getExample(i)) + "\n";
        }
        Fichero.escribeFichero(filename, output);
    }

    private double regressionOutput(double[] example) {
        return this.baseReglas.FLC(example);
    }
}

