/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Instance_Based_Learning.JFKNN;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.FuzzyIBLAlgorithm;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.JFKNN.Triplet;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.ReportTool;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.Timer;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.Util;
import org.core.Files;

public class JFKNN
extends FuzzyIBLAlgorithm {
    private double[][] distances;
    private int trainInstances;
    private int testInstances;
    private int totalInstances;
    private int H;
    private double bestError;
    private double globalError;
    private Triplet[] tripletArray;
    private Triplet bestTriplet;
    private Triplet baseTriplet;
    private Triplet bestTripletPhase1;
    private double phase1Error;
    private Triplet bestTripletPhase2;
    private double phase2Error;
    private double[][] Vbase;

    @Override
    protected void readParameters(String script) {
        String file = Files.readFile(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
    }

    public JFKNN(String script) {
        this.readDataFiles(script);
        this.name = "Jozwik Fuzzy K-NN";
        this.trainInstances = this.trainData.length;
        this.testInstances = this.testData.length;
        this.totalInstances = this.trainInstances + this.testInstances;
        this.distances = new double[this.totalInstances][this.totalInstances];
        ReportTool.setOutputFile(this.outFile[2]);
    }

    public void generateModel() {
        int i;
        int i2;
        Timer.resetTime();
        for (i2 = 0; i2 < this.totalInstances; ++i2) {
            int index2;
            int j;
            int index1;
            this.distances[i2][i2] = 0.0;
            if (i2 < this.trainInstances) {
                index1 = i2;
                for (j = i2 + 1; j < this.totalInstances; ++j) {
                    if (j < this.trainInstances) {
                        index2 = j;
                        this.distances[i2][j] = Util.euclideanDistance(this.trainData[index1], this.trainData[index2]);
                        this.distances[j][i2] = this.distances[i2][j];
                        continue;
                    }
                    index2 = j - this.trainInstances;
                    this.distances[i2][j] = Util.euclideanDistance(this.trainData[index1], this.testData[index2]);
                    this.distances[j][i2] = this.distances[i2][j];
                }
                continue;
            }
            index1 = i2 - this.trainInstances;
            for (j = index1 + 1; j < this.testInstances; ++j) {
                index2 = j;
                this.distances[i2][j] = Util.euclideanDistance(this.testData[index1], this.testData[index2]);
                this.distances[j][i2] = this.distances[i2][j];
            }
        }
        this.bestTriplet = new Triplet(this.trainInstances, this.nClasses);
        this.bestTriplet.error = 1.0;
        this.bestTriplet.k = 0;
        for (i2 = 0; i2 < this.trainInstances; ++i2) {
            this.bestTriplet.w[i2][this.trainOutput[i2]] = 1.0;
        }
        this.baseTriplet = new Triplet(this.bestTriplet);
        this.tripletArray = new Triplet[this.trainInstances - 1];
        this.bestError = 1.0;
        this.H = 0;
        double partialBestError = 1.0;
        int partialIndex = -1;
        do {
            this.globalError = this.bestError;
            ++this.H;
            for (i = 0; i < this.trainInstances - 1; ++i) {
                this.tripletArray[i] = new Triplet(this.baseTriplet.w);
                this.tripletArray[i].k = i + 1;
            }
            for (i = 0; i < this.tripletArray.length; ++i) {
                this.leaveOneOutTriplet(this.tripletArray[i]);
                if (!(partialBestError > this.tripletArray[i].error)) continue;
                partialBestError = this.tripletArray[i].error;
                partialIndex = i;
            }
            if (this.bestError > partialBestError) {
                this.bestError = partialBestError;
                this.generateNewTriplets(this.tripletArray[partialIndex]);
            }
            System.out.println("Iteration number " + this.H + " Current Error: " + this.globalError + " Best Error: " + this.bestError);
        } while (this.globalError > this.bestError);
        this.phase1Error = this.globalError;
        this.Vbase = new double[this.testInstances][this.nClasses];
        this.VClassification(this.bestTriplet.w, this.bestTriplet.k);
        this.bestTripletPhase1 = new Triplet(this.bestTriplet);
        this.bestTriplet = new Triplet(this.totalInstances, this.nClasses);
        this.bestTriplet.error = 1.0;
        this.bestTriplet.k = 0;
        for (i = 0; i < this.trainInstances; ++i) {
            this.bestTriplet.w[i][this.trainOutput[i]] = 1.0;
        }
        for (i = 0; i < this.testInstances; ++i) {
            for (int j = 0; j < this.nClasses; ++j) {
                this.bestTriplet.w[i + this.trainInstances][j] = this.Vbase[i][j];
            }
        }
        this.baseTriplet = new Triplet(this.bestTriplet);
        this.tripletArray = new Triplet[this.totalInstances - 1];
        this.bestError = 1.0;
        this.H = 0;
        partialBestError = 1.0;
        partialIndex = -1;
        do {
            this.globalError = this.bestError;
            ++this.H;
            for (i = 0; i < this.totalInstances - 1; ++i) {
                this.tripletArray[i] = new Triplet(this.baseTriplet.w);
                this.tripletArray[i].k = i + 1;
            }
            for (i = 0; i < this.tripletArray.length; ++i) {
                this.leaveOneOutTripletSecond(this.tripletArray[i]);
                if (!(partialBestError > this.tripletArray[i].error)) continue;
                partialBestError = this.tripletArray[i].error;
                partialIndex = i;
            }
            if (this.bestError > partialBestError) {
                this.bestError = partialBestError;
                this.generateNewTripletsSecond(this.tripletArray[partialIndex]);
            }
            System.out.println("Iteration number " + this.H + " Current Error: " + this.globalError + " Best Error: " + this.bestError);
        } while (this.globalError > this.bestError);
        this.phase2Error = this.globalError;
        this.bestTripletPhase2 = new Triplet(this.bestTriplet);
        Timer.setModelTime();
        System.out.println(this.name + " " + this.relation + " Model " + Timer.getModelTime() + "s");
    }

    private void VClassification(double[][] memberships, int k) {
        for (int instance = 0; instance < this.testInstances; ++instance) {
            int j;
            int i;
            int[] nearestN = new int[k];
            double[] minDist = new double[k];
            for (i = 0; i < k; ++i) {
                nearestN[i] = 0;
                minDist[i] = Double.MAX_VALUE;
            }
            for (i = 0; i < this.trainData.length; ++i) {
                double dist = this.distances[i][this.trainInstances + instance];
                boolean stop = false;
                for (j = 0; j < k && !stop; ++j) {
                    if (!(dist < minDist[j])) continue;
                    for (int l = k - 1; l >= j + 1; --l) {
                        minDist[l] = minDist[l - 1];
                        nearestN[l] = nearestN[l - 1];
                    }
                    minDist[j] = dist;
                    nearestN[j] = i;
                    stop = true;
                }
            }
            Arrays.fill(this.Vbase[instance], 0.0);
            for (i = 0; i < nearestN.length; ++i) {
                for (j = 0; j < this.nClasses; ++j) {
                    double[] dArray = this.Vbase[instance];
                    int n = j;
                    dArray[n] = dArray[n] + memberships[nearestN[i]][j];
                }
            }
            int j2 = 0;
            while (j2 < this.nClasses) {
                double[] dArray = this.Vbase[instance];
                int n = j2++;
                dArray[n] = dArray[n] / (double)k;
            }
        }
    }

    private void generateNewTriplets(Triplet best) {
        this.bestTriplet = new Triplet(best);
        for (int i = 0; i < this.trainInstances; ++i) {
            for (int j = 0; j < this.nClasses; ++j) {
                this.baseTriplet.w[i][j] = (best.w[i][j] * (double)best.k + this.baseTriplet.w[i][j]) / ((double)best.k + 1.0);
            }
        }
    }

    private void generateNewTripletsSecond(Triplet best) {
        this.bestTriplet = new Triplet(best);
        for (int i = 0; i < this.totalInstances; ++i) {
            for (int j = 0; j < this.nClasses; ++j) {
                this.baseTriplet.w[i][j] = (best.w[i][j] * (double)best.k + this.baseTriplet.w[i][j]) / ((double)best.k + 1.0);
            }
        }
    }

    private void leaveOneOutTriplet(Triplet set) {
        int misses = 0;
        double[] selectedClasses = new double[this.nClasses];
        double[][] oldW = new double[this.trainInstances][this.nClasses];
        for (int i = 0; i < this.trainInstances; ++i) {
            System.arraycopy(set.w[i], 0, oldW[i], 0, oldW[i].length);
        }
        for (int instance = 0; instance < this.trainInstances; ++instance) {
            int j;
            int i;
            int[] nearestN = new int[set.k];
            double[] minDist = new double[set.k];
            for (i = 0; i < set.k; ++i) {
                nearestN[i] = 0;
                minDist[i] = Double.MAX_VALUE;
            }
            for (i = 0; i < this.trainData.length; ++i) {
                double dist = this.distances[i][instance];
                if (i == instance) continue;
                boolean stop = false;
                for (j = 0; j < set.k && !stop; ++j) {
                    if (!(dist < minDist[j])) continue;
                    for (int l = set.k - 1; l >= j + 1; --l) {
                        minDist[l] = minDist[l - 1];
                        nearestN[l] = nearestN[l - 1];
                    }
                    minDist[j] = dist;
                    nearestN[j] = i;
                    stop = true;
                }
            }
            Arrays.fill(selectedClasses, 0.0);
            for (i = 0; i < set.k; ++i) {
                for (j = 0; j < this.nClasses; ++j) {
                    int n = j;
                    selectedClasses[n] = selectedClasses[n] + oldW[nearestN[i]][j];
                }
            }
            double bestMembership = 0.0;
            int expectedOutput = -1;
            for (i = 0; i < this.nClasses; ++i) {
                double term;
                set.w[instance][i] = term = selectedClasses[i] / (double)set.k;
                if (!(term > bestMembership)) continue;
                bestMembership = term;
                expectedOutput = i;
            }
            int trueOutput = this.trainOutput[instance];
            if (trueOutput == expectedOutput) continue;
            ++misses;
        }
        set.error = (double)misses / (double)this.trainInstances;
    }

    private void leaveOneOutTripletSecond(Triplet set) {
        int misses = 0;
        double[] selectedClasses = new double[this.nClasses];
        double[][] oldW = new double[this.totalInstances][this.nClasses];
        for (int i = 0; i < this.totalInstances; ++i) {
            System.arraycopy(set.w[i], 0, oldW[i], 0, oldW[i].length);
        }
        for (int instance = 0; instance < this.totalInstances; ++instance) {
            int trueOutput;
            int j;
            int i;
            int[] nearestN = new int[set.k];
            double[] minDist = new double[set.k];
            for (i = 0; i < set.k; ++i) {
                nearestN[i] = 0;
                minDist[i] = Double.MAX_VALUE;
            }
            for (i = 0; i < this.totalInstances; ++i) {
                double dist = this.distances[i][instance];
                if (i == instance) continue;
                boolean stop = false;
                for (j = 0; j < set.k && !stop; ++j) {
                    if (!(dist < minDist[j])) continue;
                    for (int l = set.k - 1; l >= j + 1; --l) {
                        minDist[l] = minDist[l - 1];
                        nearestN[l] = nearestN[l - 1];
                    }
                    minDist[j] = dist;
                    nearestN[j] = i;
                    stop = true;
                }
            }
            Arrays.fill(selectedClasses, 0.0);
            for (i = 0; i < set.k; ++i) {
                for (j = 0; j < this.nClasses; ++j) {
                    int n = j;
                    selectedClasses[n] = selectedClasses[n] + oldW[nearestN[i]][j];
                }
            }
            double bestMembership = 0.0;
            int expectedOutput = -1;
            for (i = 0; i < this.nClasses; ++i) {
                double term;
                set.w[instance][i] = term = selectedClasses[i] / (double)set.k;
                if (!(term > bestMembership)) continue;
                bestMembership = term;
                expectedOutput = i;
            }
            if (instance >= this.trainInstances || (trueOutput = this.trainOutput[instance]) == expectedOutput) continue;
            ++misses;
        }
        set.error = (double)misses / (double)this.trainInstances;
    }

    private int predictClass(double[] classArray) {
        int output = -1;
        double membership = 0.0;
        for (int j = 0; j < this.nClasses; ++j) {
            if (!(membership < classArray[j])) continue;
            membership = classArray[j];
            output = j;
        }
        return output;
    }

    public void classifyTrain() {
        Timer.resetTime();
        this.classifyTrainSet();
        Timer.setTrainingTime();
        System.out.println(this.name + " " + this.relation + " Training " + Timer.getTrainingTime() + "s");
    }

    public void classifyTest() {
        Timer.resetTime();
        this.classifyTestSet();
        Timer.setTestTime();
        System.out.println(this.name + " " + this.relation + " Test " + Timer.getTestTime() + "s");
    }

    public void classifyTrainSet() {
        if (this.phase1Error <= this.phase2Error) {
            for (int i = 0; i < this.trainData.length; ++i) {
                this.trainPrediction[i] = this.predictClass(this.bestTripletPhase1.w[i]);
            }
        } else {
            for (int i = 0; i < this.trainData.length; ++i) {
                this.trainPrediction[i] = this.predictClass(this.bestTripletPhase2.w[i]);
            }
        }
    }

    public void classifyTestSet() {
        if (this.phase1Error <= this.phase2Error) {
            for (int i = 0; i < this.testData.length; ++i) {
                this.testPrediction[i] = this.predictClass(this.Vbase[i]);
            }
        } else {
            for (int i = 0; i < this.testData.length; ++i) {
                this.testPrediction[i] = this.predictClass(this.bestTripletPhase2.w[this.trainInstances + i]);
            }
        }
    }

    public void printReport() {
        this.writeOutput(this.outFile[0], this.trainOutput, this.trainPrediction);
        this.writeOutput(this.outFile[1], this.testOutput, this.testPrediction);
        ReportTool.setResults(this.trainOutput, this.trainPrediction, this.testOutput, this.testPrediction, this.nClasses);
        ReportTool.printReport();
    }
}

